/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.logging;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.aperi.common.ConfigParser;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class NativeLogManager {
    private static PrintWriter writer;
    public static final String CONFIG_FILENAME;
    public static final String SERVER_CONFIG;
    public static final String INS_CNAME = "Install";
    public static final String AGT_CNAME = "Agent";
    public static final String SRV_CNAME = "Server";
    public static final String INS_PREFIX = "ins";
    public static final String AGT_PREFIX = "agt";
    public static final String SRV_PREFIX = "srv";
    public static final String PREFIX = "traceAperiNative";
    public static final String LOG_EXT = ".log";
    public static final String AGT_TRC_FNAME = "traceAperiNativeAgent";
    public static final String SRV_TRC_FNAME = "traceAperiNativeServer";
    public static final String ENABLE_FLAG = "enableFlag";
    public static final String LEVEL = "level";
    public static final String FILENAME = "fileName";
    public static final String MAX_FILES = "maxFiles";
    public static final String MAX_FILE_SIZE = "maxFileSize";
    private static final int L_CODE = 0;
    private static final int MF_CODE = 1;
    private static final int MFS_CODE = 2;
    public static final String DEBUG_MIN = "DEBUG_MIN";
    public static final String DEBUG_MID = "DEBUG_MID";
    public static final String DEBUG_MAX = "DEBUG_MAX";
    public static final int MIN_MAX_FILES = 2;
    public static final int MAX_MAX_FILES = 100;
    public static final int MAX_FILES_INCREMENT = 1;
    public static final int MIN_MAX_FILE_SIZE = 128000;
    public static final int MAX_MAX_FILE_SIZE = 102400000;
    public static final int MAX_FILE_SIZE_INCREMENT = 128000;
    private static String installDebugLevel;
    private static String[][] configParms;

    static {
        CONFIG_FILENAME = "configuration" + File.separator + "nativelog.config";
        SERVER_CONFIG = "configuration" + File.separator + "server.config";
        String[][] stringArrayArray = new String[15][];
        String[] stringArray = new String[2];
        stringArray[0] = "agt.level";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[2];
        stringArray2[0] = "agt.maxFiles";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[2];
        stringArray3[0] = "agt.maxFileSize";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[2];
        stringArray4[0] = "srv.level";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[2];
        stringArray5[0] = "srv.maxFiles";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[2];
        stringArray6[0] = "srv.maxFileSize";
        stringArrayArray[5] = stringArray6;
        String[] stringArray7 = new String[2];
        stringArray7[0] = "impexp.level";
        stringArrayArray[6] = stringArray7;
        String[] stringArray8 = new String[2];
        stringArray8[0] = "impexp.maxFiles";
        stringArrayArray[7] = stringArray8;
        String[] stringArray9 = new String[2];
        stringArray9[0] = "impexp.maxFileSize";
        stringArrayArray[8] = stringArray9;
        String[] stringArray10 = new String[2];
        stringArray10[0] = "stpagt.level";
        stringArrayArray[9] = stringArray10;
        String[] stringArray11 = new String[2];
        stringArray11[0] = "stpagt.maxFiles";
        stringArrayArray[10] = stringArray11;
        String[] stringArray12 = new String[2];
        stringArray12[0] = "stpagt.maxFileSize";
        stringArrayArray[11] = stringArray12;
        String[] stringArray13 = new String[2];
        stringArray13[0] = "stpsrv.level";
        stringArrayArray[12] = stringArray13;
        String[] stringArray14 = new String[2];
        stringArray14[0] = "stpsrv.maxFiles";
        stringArrayArray[13] = stringArray14;
        String[] stringArray15 = new String[2];
        stringArray15[0] = "stpsrv.maxFileSize";
        stringArrayArray[14] = stringArray15;
        configParms = stringArrayArray;
    }

    public static native String getDefaultTraceLevel() throws LocalizableException;

    public static native String getDefaultTraceMaxFiles() throws LocalizableException;

    public static native String getDefaultTraceMaxFileSize() throws LocalizableException;

    private static native void initToolkit(String var0, String var1, String var2) throws LocalizableException;

    private static native void initTraceLogger(String var0, String var1) throws LocalizableException;

    private static void initToolkit(String string) throws LocalizableException {
        String string2;
        String string3;
        String string4;
        Properties properties;
        block4: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry(NativeLogManager.class.getName(), "initToolkit", "componentPrefix");
            }
            properties = new Properties();
            string4 = String.valueOf(string) + "." + LEVEL;
            string3 = String.valueOf(string) + "." + MAX_FILES;
            string2 = String.valueOf(string) + "." + MAX_FILE_SIZE;
            try {
                String string5 = String.valueOf(System.getProperty("user.dir")) + File.separator;
                String string6 = String.valueOf(string5) + CONFIG_FILENAME;
                properties.load(new FileInputStream(string6));
            }
            catch (IOException iOException) {
                if (!TraceLogger.enableTrace) break block4;
                TraceLogger.exception(NativeLogManager.class.getName(), "initToolkit", iOException);
            }
        }
        NativeLogManager.initToolkit(string.indexOf(INS_PREFIX) != -1 ? NativeLogManager.getConfigProperty(properties, string4, 0, NativeLogManager.getInstallTraceLevel()) : NativeLogManager.getConfigProperty(properties, string4, 0, NativeLogManager.getDefaultTraceLevel()), NativeLogManager.getConfigProperty(properties, string3, 1, NativeLogManager.getDefaultTraceMaxFiles()), NativeLogManager.getConfigProperty(properties, string2, 2, NativeLogManager.getDefaultTraceMaxFileSize()));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initToolkit");
        }
    }

    private static String getConfigProperty(Properties properties, String string, int n, String string2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getConfigProperty", "config, property, propertyCode, defaultValue");
        }
        String string3 = null;
        if (string.indexOf(INS_PREFIX) != -1) {
            if (NativeLogManager.getInstallTraceLevel() == DEBUG_MAX) {
                MessageLog.logMessage("GEN2009W", string, string2);
            }
            String string4 = string2;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "getConfigProperty", string4);
            }
            return string4;
        }
        string3 = properties.getProperty(string);
        if (string3 == null) {
            MessageLog.logMessage("GEN2009W", string, string2);
            String string5 = string2;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "getConfigProperty", string5);
            }
            return string5;
        }
        String string6 = NativeLogManager.checkValue(string, n, string3, string2);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getConfigProperty", string6);
        }
        return string6;
    }

    private static String checkValue(String string, int n, String string2, String string3) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "checkValue", "property, propertyCode, value, defaultValue");
        }
        String string4 = null;
        switch (n) {
            case 0: {
                string4 = NativeLogManager.checkLevelValue(string, string2, string3);
                break;
            }
            case 1: {
                string4 = NativeLogManager.checkMaxFilesValue(string, string2, string3);
                break;
            }
            case 2: {
                string4 = NativeLogManager.checkMaxFileSizeValue(string, string2, string3);
            }
        }
        String string5 = string4;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "checkValue", string5);
        }
        return string5;
    }

    private static String checkLevelValue(String string, String string2, String string3) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "checkLevelValue", "lProperty, lValue, defaultLValue");
        }
        if (string2.equals(DEBUG_MIN) || string2.equals(DEBUG_MID) || string2.equals(DEBUG_MAX)) {
            String string4 = string2;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "checkLevelValue", string4);
            }
            return string4;
        }
        MessageLog.logMessage("GEN2010W", string, string2, string3);
        String string5 = string3;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "checkLevelValue", string5);
        }
        return string5;
    }

    private static String checkMaxFilesValue(String string, String string2, String string3) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "checkMaxFilesValue", "mfProperty, mfValue, defaultMfValue");
        }
        try {
            int n = Integer.parseInt(string2);
            if (n >= 2 && n <= 100) {
                String string4 = string2;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(NativeLogManager.class.getName(), "checkMaxFilesValue", string4);
                }
                return string4;
            }
            MessageLog.logMessage("GEN2011W", string, string2, string3);
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(NativeLogManager.class.getName(), "checkMaxFilesValue", numberFormatException);
            }
            MessageLog.logMessage("GEN2010W", string, string2, string3);
        }
        String string5 = string3;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "checkMaxFilesValue", string5);
        }
        return string5;
    }

    private static String checkMaxFileSizeValue(String string, String string2, String string3) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "checkMaxFileSizeValue", "mfsProperty, mfsValue, defaultMfsValue");
        }
        try {
            int n = Integer.parseInt(string2);
            if (n >= 128000 && n <= 102400000) {
                String string4 = string2;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(NativeLogManager.class.getName(), "checkMaxFileSizeValue", string4);
                }
                return string4;
            }
            MessageLog.logMessage("GEN2011W", string, string2, string3);
        }
        catch (NumberFormatException numberFormatException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(NativeLogManager.class.getName(), "checkMaxFileSizeValue", numberFormatException);
            }
            MessageLog.logMessage("GEN2010W", string, string2, string3);
        }
        String string5 = string3;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "checkMaxFileSizeValue", string5);
        }
        return string5;
    }

    public static void reInitInstallTraceLogger(String string) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "reInitInstallTraceLogger", "directory");
        }
        NativeLogManager.setInstallTraceLevel(NativeLogManager.getInstallTraceLevel());
        NativeLogManager.initToolkit(INS_PREFIX);
        NativeLogManager.initTraceLogger(String.valueOf(string) + File.separator + PREFIX + INS_CNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, INS_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "reInitInstallTraceLogger");
        }
    }

    public static void initInstallTraceLogger(String string) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "initInstallTraceLogger", LEVEL);
        }
        System.loadLibrary("DataLog");
        NativeLogManager.setInstallTraceLevel(string);
        NativeLogManager.initToolkit(INS_PREFIX);
        NativeLogManager.initTraceLogger(String.valueOf(NativeLogManager.getInstallLogDirectory()) + PREFIX + INS_CNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, INS_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initInstallTraceLogger");
        }
    }

    private static void setInstallTraceLevel(String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "setInstallTraceLevel", LEVEL);
        }
        installDebugLevel = string != null ? string : DEBUG_MIN;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "setInstallTraceLevel");
        }
    }

    public static String getInstallTraceLevel() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getInstallTraceLevel", "");
        }
        if (installDebugLevel != null) {
            String string = installDebugLevel;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "getInstallTraceLevel", string);
            }
            return string;
        }
        String string = DEBUG_MIN;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getInstallTraceLevel", string);
        }
        return string;
    }

    public static void initAgentTraceLogger(String string) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "initAgentTraceLogger", "agentLogDirectory");
        }
        System.loadLibrary("DataLog");
        NativeLogManager.initToolkit(AGT_PREFIX);
        NativeLogManager.initTraceLogger(String.valueOf(string) + File.separator + AGT_TRC_FNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, AGT_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initAgentTraceLogger");
        }
    }

    private static String getAgentLogDirectory() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getAgentLogDirectory", "");
        }
        String string = String.valueOf(NativeLogManager.getServerLogDirectory()) + "/" + HardwareID.getLocalHostName();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getAgentLogDirectory", string);
        }
        return string;
    }

    public static void initServerTraceLogger() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "initServerTraceLogger", "");
        }
        System.loadLibrary("DataLog");
        NativeLogManager.initToolkit(SRV_PREFIX);
        NativeLogManager.initTraceLogger(String.valueOf(NativeLogManager.getServerLogDirectory()) + "/" + SRV_TRC_FNAME + NativeLogManager.getTimeDateStamp() + LOG_EXT, SRV_CNAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "initServerTraceLogger");
        }
    }

    private static String getTimeDateStamp() {
        String string;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getTimeDateStamp", "");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string2 = string = "_" + simpleDateFormat.format(new Date()) + "LOG";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getTimeDateStamp", string2);
        }
        return string2;
    }

    private static String getInstallLogDirectory() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getInstallLogDirectory", "");
        }
        String string = System.getProperty("java.io.tmpdir");
        string.replace('\\', '/');
        if (!string.substring(string.length() - 1).equals("/")) {
            string = String.valueOf(string) + "/";
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getInstallLogDirectory", string2);
        }
        return string2;
    }

    private static String getServerLogDirectory() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getServerLogDirectory", "");
        }
        String string = String.valueOf(System.getProperty("user.dir").replace('\\', '/')) + "/log";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getServerLogDirectory", string);
        }
        return string;
    }

    public static HashMap getTraceConfig() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getTraceConfig", "");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(LEVEL, NativeLogManager.getTraceLoggerProperty(LEVEL));
        hashMap.put(FILENAME, NativeLogManager.getTraceHandlerProperty(FILENAME));
        hashMap.put(MAX_FILES, NativeLogManager.getTraceHandlerProperty(MAX_FILES));
        hashMap.put(MAX_FILE_SIZE, NativeLogManager.getTraceHandlerProperty(MAX_FILE_SIZE));
        HashMap<String, String> hashMap2 = hashMap;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getTraceConfig", hashMap2);
        }
        return hashMap2;
    }

    public static void setTraceConfig(HashMap hashMap, String string) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "setTraceConfig", "traceConfig, requestCode");
        }
        HashMap hashMap2 = NativeLogManager.getTraceConfig();
        try {
            NativeLogManager.setTraceConfig((String)hashMap.get(LEVEL), (String)hashMap.get(MAX_FILES), (String)hashMap.get(MAX_FILE_SIZE));
            NativeLogManager.updateNativeLogConfig(hashMap, string);
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(NativeLogManager.class.getName(), "setTraceConfig", localizableException);
            }
            try {
                NativeLogManager.setTraceConfig((String)hashMap2.get(LEVEL), (String)hashMap2.get(MAX_FILES), (String)hashMap2.get(MAX_FILE_SIZE));
            }
            catch (LocalizableException localizableException2) {}
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(NativeLogManager.class.getName(), "setTraceConfig");
            }
            throw localizableException;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "setTraceConfig");
        }
    }

    private static void setTraceConfig(String string, String string2, String string3) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "setTraceConfig", "level, maxFiles, maxFileSize");
        }
        NativeLogManager.setTraceLoggerProperty(LEVEL, string);
        NativeLogManager.setTraceHandlerProperty(MAX_FILES, string2);
        NativeLogManager.setTraceHandlerProperty(MAX_FILE_SIZE, string3);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "setTraceConfig");
        }
    }

    public static String getTraceLoggerFilename() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "getTraceLoggerFilename", "");
        }
        String string = NativeLogManager.getTraceHandlerProperty(FILENAME);
        String string2 = string.replace('/', File.separatorChar);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "getTraceLoggerFilename", string2);
        }
        return string2;
    }

    public static void updateNativeLogConfig(HashMap hashMap, String string) throws LocalizableException {
        String string2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "updateNativeLogConfig", "traceConfig, requestCode");
        }
        if (string.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
            String string3 = Variables.homeDirectory;
            string2 = String.valueOf(string3) + File.separator + CONFIG_FILENAME;
        } else {
            string2 = CONFIG_FILENAME;
        }
        ConfigParser configParser = new ConfigParser(string2);
        try {
            try {
                configParser.readValues(configParms);
                writer = new PrintWriter(new BufferedWriter(new FileWriter(string2)));
                writer.println("# level: DEBUG_MIN || DEBUG_MID || DEBUG_MAX");
                writer.println("# maxFiles: >= 2 && <= 100");
                writer.println("# maxFileSize: >= 128000 && <= 102400000");
                writer.println();
                Boolean bl = (Boolean)hashMap.get(ENABLE_FLAG);
                String string4 = bl != false ? (String)hashMap.get(LEVEL) : DEBUG_MIN;
                String string5 = (String)hashMap.get(MAX_FILES);
                String string6 = (String)hashMap.get(MAX_FILE_SIZE);
                if (string.equals("org.eclipse.aperi.agent.svp.AgentSvp")) {
                    NativeLogManager.configParms[0][1] = string4;
                    NativeLogManager.configParms[1][1] = string5;
                    NativeLogManager.configParms[2][1] = string6;
                } else if (string.equals("org.eclipse.aperi.server.svp.ServerSvp")) {
                    NativeLogManager.configParms[3][1] = string4;
                    NativeLogManager.configParms[4][1] = string5;
                    NativeLogManager.configParms[5][1] = string6;
                }
                if (configParms[0][1] != null) {
                    NativeLogManager.printComponentValues(writer, AGT_CNAME, AGT_PREFIX, configParms[0][1], configParms[1][1], configParms[2][1]);
                }
                if (configParms[3][1] != null) {
                    NativeLogManager.printComponentValues(writer, SRV_CNAME, SRV_PREFIX, configParms[3][1], configParms[4][1], configParms[5][1]);
                }
            }
            catch (Exception exception) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(NativeLogManager.class.getName(), "updateNativeLogConfig", exception);
                }
                String string7 = MessageLog.getMessage("GEN2018E");
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit(NativeLogManager.class.getName(), "updateNativeLogConfig");
                }
                throw new LocalizableException(string7, null);
            }
        }
        finally {
            writer.close();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "updateNativeLogConfig");
        }
    }

    private static void printComponentValues(PrintWriter printWriter, String string, String string2, String string3, String string4, String string5) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "printComponentValues", "writer, name, prefix, lvl, maxfiles, maxfs");
        }
        printWriter.println("# " + string);
        Util.printKeyValuePair(printWriter, String.valueOf(string2) + "." + LEVEL, string3);
        Util.printKeyValuePair(printWriter, String.valueOf(string2) + "." + MAX_FILES, string4);
        Util.printKeyValuePair(printWriter, String.valueOf(string2) + "." + MAX_FILE_SIZE, string5);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "printComponentValues");
        }
    }

    public static String updateTraceLoggerFilename(String string) throws LocalizableException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "updateTraceLoggerFilename", "directory");
        }
        String string2 = NativeLogManager.getTraceHandlerProperty(FILENAME);
        File file = new File(string2);
        NativeLogManager.setTraceHandlerProperty(FILENAME, String.valueOf(string.replace('\\', '/')) + "/" + file.getName());
        String string3 = string2.replace('/', File.separatorChar);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "updateTraceLoggerFilename", string3);
        }
        return string3;
    }

    private static native String getTraceLoggerProperty(String var0) throws LocalizableException;

    private static native String getTraceHandlerProperty(String var0) throws LocalizableException;

    private static native void setTraceLoggerProperty(String var0, String var1) throws LocalizableException;

    private static native void setTraceHandlerProperty(String var0, String var1) throws LocalizableException;

    public static void executeTracePropertyTest() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(NativeLogManager.class.getName(), "executeTracePropertyTest", "");
        }
        try {
            HashMap hashMap = NativeLogManager.getTraceConfig();
            System.err.println("level:       " + hashMap.get(LEVEL));
            System.err.println("maxFiles:    " + hashMap.get(MAX_FILES));
            System.err.println("maxFileSize: " + hashMap.get(MAX_FILE_SIZE));
            System.err.println("fileName:    " + NativeLogManager.getTraceHandlerProperty(FILENAME));
            String string = hashMap.put(LEVEL, DEBUG_MAX);
            String string2 = hashMap.put(MAX_FILES, "10");
            String string3 = hashMap.put(MAX_FILE_SIZE, "1024000");
            NativeLogManager.setTraceConfig(hashMap, "org.eclipse.aperi.agent.svp.AgentSvp");
            hashMap = NativeLogManager.getTraceConfig();
            System.err.println("level:       " + hashMap.get(LEVEL));
            System.err.println("maxFiles:    " + hashMap.get(MAX_FILES));
            System.err.println("maxFileSize: " + hashMap.get(MAX_FILE_SIZE));
            hashMap.put(LEVEL, string);
            hashMap.put(MAX_FILES, string2);
            hashMap.put(MAX_FILE_SIZE, string3);
            NativeLogManager.setTraceConfig(hashMap, "org.eclipse.aperi.agent.svp.AgentSvp");
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception(NativeLogManager.class.getName(), "executeTracePropertyTest", localizableException);
            }
            localizableException.print();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(NativeLogManager.class.getName(), "executeTracePropertyTest");
        }
    }

    public static native void executeTraceMacroTest();
}

