/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL1;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2Other;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL0;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerOtherL1
extends ViewerOtherL0 {
    private static final boolean debug = false;
    public static final String SELECT_OTHER = "SELECT \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE FROM T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on \tOTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on \tOTHER.VENDOR_ID = VENDOR.VENDOR_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tTMP.ID = ? and \tTMP.PREFIX_ID = OTHER.PREFIX_ID and \tTMP.ENTITY_ID = OTHER.OTHER_ID ";
    public static final String SELECT_SWITCH_FROM_OTHER = "SELECT distinct \tTMP.PREFIX_ID OTHER_PREFIX_ID, \tTMP.ENTITY_ID OTHER_ID, \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3  FROM \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on    T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on  \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID, T_VIEW_VSWITCH2OTHER SWITCH2OTHER, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and     SWITCH2OTHER.OTHER_ID = TMP.ENTITY_ID and \t SWITCH2OTHER.OTHER_PREFIX_ID = TMP.PREFIX_ID and \t T_RES_SWITCH.PREFIX_ID = SWITCH2OTHER.SWITCH_PREFIX_ID and \t T_RES_SWITCH.SWITCH_ID = SWITCH2OTHER.SWITCH_ID ";
    public static final String SELECT_SANS_FROM_SWITCH_FROM_OTHER = "SELECT distinct \tSWITCH2FABRIC.PREFIX_ID, \tSWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2OTHER SWITCH2OTHER,T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \tT_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and    SWITCH2FABRIC.SWITCH_ID = SWITCH2OTHER.SWITCH_ID and    SWITCH2OTHER.OTHER_PREFIX_ID = TMP.PREFIX_ID and    SWITCH2OTHER.OTHER_ID = TMP.ENTITY_ID and \tTMP.ID = ?";
    public static final String SELECT_SWITCH2OTHER_FROM_OTHER = "SELECT distinct     SWITCH2OTHER.OTHER_PREFIX_ID,\t SWITCH2OTHER.OTHER_ID, \t SWITCH2OTHER.SWITCH_PREFIX_ID SWITCH_PREFIX_ID, \t SWITCH2OTHER.SWITCH_ID SWITCH_ID,     SWITCH2OTHER.PORT2PORT_ID PORT2PORT_ID,     SWITCH2OTHER.DETECTABLE DETECTABLE  FROM T_VIEW_VSWITCH2OTHER SWITCH2OTHER, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t SWITCH2OTHER.OTHER_ID = TMP.ENTITY_ID and \t SWITCH2OTHER.OTHER_PREFIX_ID = TMP.PREFIX_ID ";
    public static final String SELECT_SANS_FROM_OTHER = "SELECT \t OTHER2FABRIC.FABRIC_ID FABRIC_ID, \t OTHER2FABRIC.PREFIX_ID PREFIX_ID, \t OTHER2FABRIC.OTHER_ID OTHER_ID FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC WHERE     OTHER2FABRIC.PREFIX_ID= ? and     OTHER2FABRIC.OTHER_ID  = ? ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_OTHER = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VOTHER2PORT OTHER2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE    TMP.ID = ? and \tOTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and    OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and \tOTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_OTHER = "SELECT distinct    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM     T_RES_ZONE, T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE, T_RES_FABRIC FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t OTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and     OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and \t OTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and \t PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_OTHER = "SELECT DISTINCT     PORT2ZONE2.ZONE_ID ZONE_ID,     PORT2ZONE2.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     PORT.PORT_NUMBER FROM T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID left outer join T_RES_PORT PORT on  \t PORT2ZONE2.PORT_ID = PORT.PORT_ID, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE     TMP.ID = ? and \t OTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and \t OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and     OTHER2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID ";
    public static final String SELECT_ZSET2ZONE_FROM_OTHER = "SELECT DISTINCT     ZSET2ZONE.ZONE_ID,     ZSET2ZONE.ZSET_ID FROM T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZSET2ZONE ZSET2ZONE, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t OTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and     OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and \t OTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID";
    public static final String SELECT_ZSET_FROM_OTHER = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VOTHER2PORT OTHER2PORT, T_VIEW_PORT2ZSET PORT2ZSET,    T_RES_ZSET, T_RES_FABRIC FABRIC, T_RES_TMP_TOPOLOGY_ENTITY TMP WHERE \t TMP.ID = ? and \t OTHER2PORT.PREFIX_ID = TMP.PREFIX_ID and     OTHER2PORT.OTHER_ID = TMP.ENTITY_ID and \t OTHER2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";

    public GraphOther getOther(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphOther graphOther = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_OTHER);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2 = (Integer)resultSet.getObject("OTHER_ID");
                String string = (String)resultSet.getObject("PREFIX_ID");
                String string2 = String.valueOf(string) + n2;
                if (hashMap == null || hashMap.get(string2) == null) {
                    graphOther = new GraphOther(string2);
                    this.populator.populateOther(resultSet, graphOther);
                    graphModel.put(graphOther);
                    hashMap.put(string2, graphOther);
                    if (graphModel != null) {
                        graphModel.put(graphOther);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string2, graphOther);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getOther", "Duplicated Other entry:" + string2);
            }
        }
        finally {
            block18: {
                block17: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block17;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block18;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        return graphOther;
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        this.getSansFromSwitch(connection, graphModel, hashMap, new Object[]{new Integer(n)}, SELECT_SANS_FROM_SWITCH_FROM_OTHER);
    }

    public void getSansFromUnknown(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromUnknown(connection, graphModel, hashMap, new Object[]{string, new Integer(n)}, SELECT_SANS_FROM_OTHER);
    }

    public void getSwitchFromOther(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        Integer n2;
        String string;
        Integer n3;
        String string2;
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSwitch graphSwitch = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH_FROM_OTHER);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = (String)resultSet.getObject("OTHER_PREFIX_ID");
                n3 = (Integer)resultSet.getObject("OTHER_ID");
                string = (String)resultSet.getObject("PREFIX_ID");
                n2 = (Integer)resultSet.getObject("SWITCH_ID");
                object3 = String.valueOf(string2) + n3;
                object2 = (GraphOther)hashMap.get(object3);
                if (object2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerOtherL1.class.getName(), "getSwitchFromHost", "MIssing host");
                    continue;
                }
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "SWITCH_WWN is NULL");
                    continue;
                }
                object = String.valueOf(string) + n2;
                graphSwitch = (GraphSwitch)hashMap.get(object);
                if (graphSwitch != null) continue;
                graphSwitch = new GraphSwitch((String)object);
                this.populator.populateSwitch(resultSet, graphSwitch, true);
                if (graphModel != null) {
                    graphModel.put(graphSwitch);
                }
                if (hashMap == null) continue;
                hashMap.put(object, graphSwitch);
            }
        }
        finally {
            block36: {
                block35: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block35;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block36;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                }
            }
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2OTHER_FROM_OTHER);
            preparedStatement.setInt(1, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = (String)resultSet.getObject("OTHER_PREFIX_ID");
                n3 = (Integer)resultSet.getObject("OTHER_ID");
                string = (String)resultSet.getObject("SWITCH_PREFIX_ID");
                n2 = (Integer)resultSet.getObject("SWITCH_ID");
                object3 = (Integer)resultSet.getObject("PORT2PORT_ID");
                object2 = String.valueOf(string2) + n3;
                object = (GraphOther)hashMap.get(object2);
                if (object == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerOtherL1.class.getName(), "getSwitchFromHost", "MIssing host");
                    continue;
                }
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "SWITCH_WWN is NULL");
                    continue;
                }
                String string3 = String.valueOf(string) + n2;
                graphSwitch = (GraphSwitch)hashMap.get(string3);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromHost", "SWITCH not found");
                    continue;
                }
                String string4 = "port2port:" + string + n2 + ',' + string2 + n3 + ',' + object3;
                GraphSwitch2Other graphSwitch2Other = (GraphSwitch2Other)hashMap.get(string4);
                if (graphSwitch2Other != null) continue;
                graphSwitch2Other = new GraphSwitch2Other(string4);
                graphSwitch2Other.setOtherID((GraphOther.ID)((GraphEntity)object).getEntityID());
                graphSwitch2Other.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                this.populator.populatePort2Port(resultSet, graphSwitch2Other);
                graphModel.put(graphSwitch2Other);
                hashMap.put(string4, graphSwitch2Other);
            }
        }
        finally {
            block39: {
                block38: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block38;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block39;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                }
            }
        }
    }

    public void getZonesFromOther(Connection connection, GraphModel graphModel, HashMap hashMap, int n) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(connection, graphModel, hashMap, new Object[]{new Integer(n)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_OTHER, SELECT_ZONES_FROM_OTHER, SELECT_ZSET_FROM_OTHER, SELECT_ZSET2ZONE_FROM_OTHER, SELECT_ZONE2MEMBER_FROM_OTHER});
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelOtherL1 graphModelOtherL1 = null;
        GraphModel.MultiEntityID multiEntityID = (GraphModel.MultiEntityID)viewerRequest.getModelID();
        this.removeTmpHosts(connection, n);
        try {
            this.setTmpEntity(connection, multiEntityID.getChildFocusEntityIDs(), n);
            HashMap hashMap = new HashMap();
            Timestamp timestamp = viewerRequest.getTimestamp();
            Timestamp timestamp2 = null;
            if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
                graphModelOtherL1 = new GraphModelOtherL1((GraphModelOtherL1.ID)viewerRequest.getModelID());
                this.getOther(connection, graphModelOtherL1, hashMap, n);
                this.getSwitchFromOther(connection, graphModelOtherL1, hashMap, n);
                this.getSansFromSwitch(connection, graphModelOtherL1, hashMap, n);
                this.commit(connection);
                if (viewerRequest.getModelID().isNeedZoneData()) {
                    this.getZonesFromOther(connection, graphModelOtherL1, hashMap, n);
                    this.commit(connection);
                }
                graphModelOtherL1.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
                viewerResponse.addResponse(0, graphModelOtherL1);
            } else {
                viewerResponse.addResponse(0, null);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
            }
        }
        finally {
            this.removeTmpHosts(connection, n);
        }
    }
}

