/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.topo.model.GraphAssociation;
import org.eclipse.aperi.gui.topo.model.GraphEntity;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelOtherL2;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphFCPort2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphLun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Lun;
import org.eclipse.aperi.gui.topo.model.bean.GraphOther2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem;
import org.eclipse.aperi.gui.topo.model.bean.GraphSubsystem2Volume;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitch2FCPort;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume;
import org.eclipse.aperi.gui.topo.model.bean.GraphVolume2Lun;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerOtherL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL1;
import org.eclipse.aperi.server.guireq.topology.views.ViewerSubsystemL2;

public class ViewerOtherL2
extends ViewerOtherL1 {
    private static final boolean debug = false;
    public static final String SELECT_OTHER = "SELECT \tOTHER.PREFIX_ID PREFIX_ID, \tOTHER.OTHER_ID OTHER_ID, \tOTHER.DISPLAY_NAME DISPLAY_NAME, \tOTHER.PROPAGATED_STATUS PROPAGATED_STATUS, \tOTHER.DETECTABLE DETECTABLE, \tMODEL.MODEL_NAME MODEL, \tVENDOR.VENDOR_NAME VENDOR, \tOTHER.SERIAL_NUMBER SERIAL_NUMBER, \tOTHER.OTHER_TYPE DISPLAY_TYPE  FROM T_VIEW_VOTHER OTHER left outer join T_RES_MODEL MODEL on\tOTHER.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on\tOTHER.VENDOR_ID = VENDOR.VENDOR_ID WHERE     OTHER.OTHER_ID = ? and \t OTHER.PREFIX_ID = ?";
    public static final String SELECT_PORT_FROM_OTHER = "SELECT distinct     CASE WHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL and RTRIM(T_RES_PORT.DISPLAY_NAME) != '' THEN T_RES_PORT.DISPLAY_NAME \t\t  ELSE T_RES_PORT.NAME \t END DISPLAY_NAME,     T_RES_PORT.NAME || '+' || CAST(T_RES_PORT.NAME_FORMAT as CHAR) NATURAL_KEY, \t T_RES_PORT.PORT_ID PORT_ID, \t T_RES_PORT.NAME NAME, \t T_RES_PORT.NAME_FORMAT NAME_FORMAT, \t T_RES_PORT.PORT_NUMBER PORT_NUMBER, \t T_RES_PORT.TYPE TYPE, \t T_RES_PORT.PORT_SPEED PORT_SPEED, \t T_RES_PORT.DETECTABLE DETECTABLE, \t T_RES_PORT.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_PORT.CONSOLIDATED_STATUS CONSOLIDATED_STATUS FROM T_RES_PORT, T_VIEW_VOTHER2PORT OTHER2PORT WHERE     OTHER2PORT.OTHER_ID = ? and \t OTHER2PORT.PREFIX_ID = ? and \t T_RES_PORT.PORT_ID = OTHER2PORT.PORT_ID ";
    public static final String SELECT_PORT2PORT_FROM_OTHER = "SELECT \tOTHER2PORT2PORT.PORT_ID PORT_ID, \tOTHER2PORT2PORT.DETECTABLE DETECTABLE, \tOTHER2PORT2PORT.PORT_ID2 PORT_ID2, \t CASE \t\tWHEN T_RES_PORT.DISPLAY_NAME IS NOT NULL THEN T_RES_PORT.DISPLAY_NAME\t\tELSE T_RES_PORT.NAME \tEND PORT2_NAME, \tT_RES_PORT.PORT_NUMBER PORT_NUMBER, \tOTHER2PORT2PORT.PORT2PORT_ID PORT2PORT_ID,\tENTITY2PORT.PREFIX_ID,\tENTITY2PORT.ENTITY_ID  FROM    T_RES_PORT, (SELECT  \tPORT2PORT.PORT_ID2 PORT_ID, \tOTHER2PORT.OTHER_ID OTHER_ID, \tOTHER2PORT.PREFIX_ID PREFIX_ID, \tOTHER2PORT.PORT_ID PORT_ID2, \tPORT2PORT.DETECTABLE DETECTABLE,    PORT2PORT.PORT2PORT_ID PORT2PORT_ID FROM  T_VIEW_PORT2PORT PORT2PORT,T_VIEW_VOTHER2PORT OTHER2PORT WHERE     PORT2PORT.PORT_ID1 = OTHER2PORT.PORT_ID) OTHER2PORT2PORT, T_VIEW_ENTITY2PORT ENTITY2PORT WHERE     ENTITY2PORT.PORT_ID = T_RES_PORT.PORT_ID and \t T_RES_PORT.PORT_ID = OTHER2PORT2PORT.PORT_ID and     OTHER2PORT2PORT.OTHER_ID =? and \t OTHER2PORT2PORT.PREFIX_ID = ? ";
    public static final String SELECT_SWITCH_FROM_OTHER = "SELECT distinct \t T_RES_SWITCH.PREFIX_ID,     CASE WHEN T_RES_SWITCH.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.DISPLAY_NAME) != '' THEN T_RES_SWITCH.DISPLAY_NAME          WHEN T_RES_SWITCH.LOGICAL_NAME IS NOT NULL  and RTRIM(T_RES_SWITCH.LOGICAL_NAME) != '' THEN T_RES_SWITCH.LOGICAL_NAME \t\t  ELSE T_RES_SWITCH.SWITCH_WWN \t END DISPLAY_NAME,     T_RES_SWITCH.SWITCH_ID SWITCH_ID,     T_RES_SWITCH.LOGICAL_NAME LOGICAL_NAME,     T_RES_SWITCH.SWITCH_WWN SWITCH_WWN,     T_RES_SWITCH.SERIAL_NUMBER SERIAL_NUMBER,     T_RES_SWITCH.DESCRIPTION DESCRIPTION,     T_RES_SWITCH.IP_ADDRESS IP_ADDRESS,     T_RES_SWITCH.DOMAIN DOMAIN,     T_RES_SWITCH.VERSION VERSION,     MODEL.MODEL_NAME MODEL,     VENDOR.VENDOR_NAME VENDOR, \t T_RES_SWITCH.PARENT_SWITCH_WWN PARENT_SWITCH_WWN, \t T_RES_SWITCH.MGMT_URL_ADDR DEFAULT_MANAGER, \t T_RES_SWITCH.DETECTABLE DETECTABLE, \t T_RES_SWITCH.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t T_RES_SWITCH.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t T_RES_SWITCH.PROPAGATED_STATUS PROPAGATED_STATUS, \t T_RES_SWITCH.USER_ATTRIB1 USER_ATTRIB1, \t T_RES_SWITCH.USER_ATTRIB2 USER_ATTRIB2, \t T_RES_SWITCH.USER_ATTRIB3 USER_ATTRIB3  FROM \tT_VIEW_VSWITCH T_RES_SWITCH left outer join T_RES_MODEL MODEL on    T_RES_SWITCH.MODEL_ID = MODEL.MODEL_ID left outer join T_RES_VENDOR VENDOR on  \tT_RES_SWITCH.VENDOR_ID = VENDOR.VENDOR_ID, T_VIEW_VSWITCH2OTHER SWITCH2OTHER WHERE     SWITCH2OTHER.OTHER_ID = ? and \t SWITCH2OTHER.OTHER_PREFIX_ID = ? and \t T_RES_SWITCH.SWITCH_ID = SWITCH2OTHER.SWITCH_ID ";
    public static final String SELECT_SWITCH2OTHER_FROM_OTHER = "SELECT distinct \tSWITCH2OTHER.SWITCH_PREFIX_ID PREFIX_ID, \tSWITCH2OTHER.SWITCH_ID SWITCH_ID,    SWITCH2OTHER.SWITCH_PORT_ID PORT_ID FROM T_VIEW_VSWITCH2OTHER SWITCH2OTHER WHERE     SWITCH2OTHER.OTHER_ID = ? and \t SWITCH2OTHER.OTHER_PREFIX_ID = ? ";
    public static final String SELECT_FABRIC_FROM_ZONES_FROM_OTHER = "SELECT DISTINCT \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM T_VIEW_VOTHER2PORT OTHER2PORT,     T_VIEW_PORT2ZONE PORT2ZONE,  \t T_RES_ZONE, T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN WHERE    OTHER2PORT.PREFIX_ID = ? and    OTHER2PORT.OTHER_ID = ? and \tOTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and \tPORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \tT_RES_ZONE.FABRIC_WWN = T_RES_FABRIC.FABRIC_WWN";
    public static final String SELECT_ZONES_FROM_OTHER = "SELECT distinct    T_RES_ZONE.ZONE_ID ZONE_ID, \tT_RES_ZONE.ZONE_TYPE ZONE_TYPE, \tT_RES_ZONE.ACTIVE ACTIVE,\tT_RES_ZONE.ZONE_NAME ZONE_NAME, \tT_RES_ZONE.FABRIC_WWN FABRIC_WWN, \tT_RES_ZONE.DESCRIPTION DESCRIPTION,  \tT_RES_ZONE.ZONE_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM     T_RES_ZONE, T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE, T_RES_FABRIC FABRIC WHERE \t OTHER2PORT.PREFIX_ID = ? and     OTHER2PORT.OTHER_ID = ? and \t OTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and \t PORT2ZONE.ZONE_ID = T_RES_ZONE.ZONE_ID and \t T_RES_ZONE.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_ZONE2MEMBER_FROM_OTHER = "SELECT DISTINCT     PORT2ZONE2.ZONE_ID ZONE_ID,     PORT2ZONE2.PORT_ID PORT_ID,\t ENTITY_TO_PORT.TYPE, \t ENTITY_TO_PORT.PREFIX_ID, \t ENTITY_TO_PORT.ENTITY_ID, \t ENTITY_TO_PORT.DISPLAY_NAME, \t ENTITY_TO_PORT.PORT_DISPLAY_NAME, \t PORT2ZONE2.MEMBER_NAME, \t PORT2ZONE2.ZONE_MEMBER_ID,     ENTITY_TO_PORT.PORT_NUMBER FROM T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE1,T_VIEW_PORT2ZONE PORT2ZONE2 left outer join \t T_VIEW_ENTITY_TO_PORT ENTITY_TO_PORT on \t PORT2ZONE2.PORT_ID = ENTITY_TO_PORT.PORT_ID WHERE     OTHER2PORT.PREFIX_ID = ? and \t OTHER2PORT.OTHER_ID = ? and     OTHER2PORT.PORT_ID = PORT2ZONE1.PORT_ID and \t PORT2ZONE1.ZONE_ID = PORT2ZONE2.ZONE_ID ";
    public static final String SELECT_ZSET2ZONE_FROM_OTHER = "SELECT DISTINCT     ZSET2ZONE.ZONE_ID,     ZSET2ZONE.ZSET_ID FROM T_VIEW_VOTHER2PORT OTHER2PORT,T_VIEW_PORT2ZONE PORT2ZONE,    T_RES_ZSET2ZONE ZSET2ZONE WHERE \t OTHER2PORT.PREFIX_ID = ? and     OTHER2PORT.OTHER_ID = ? and \t OTHER2PORT.PORT_ID = PORT2ZONE.PORT_ID and     PORT2ZONE.ZONE_ID = ZSET2ZONE.ZONE_ID";
    public static final String SELECT_ZSET_FROM_OTHER = "SELECT DISTINCT    T_RES_ZSET.ZSET_ID, \tT_RES_ZSET.ACTIVE ACTIVE,\tT_RES_ZSET.ZSET_NAME ZSET_NAME, \tT_RES_ZSET.FABRIC_WWN FABRIC_WWN, \tT_RES_ZSET.DESCRIPTION DESCRIPTION,    T_RES_ZSET.ZSET_NAME DISPLAY_NAME , \tFABRIC.FABRIC_ID FROM T_VIEW_VOTHER2PORT OTHER2PORT, T_VIEW_PORT2ZSET PORT2ZSET,    T_RES_ZSET, T_RES_FABRIC FABRIC WHERE \t OTHER2PORT.PREFIX_ID = ? and     OTHER2PORT.OTHER_ID = ? and \t OTHER2PORT.PORT_ID = PORT2ZSET.PORT_ID and     PORT2ZSET.ZSET_ID = T_RES_ZSET.ZSET_ID and \t T_RES_ZSET.FABRIC_WWN = FABRIC.FABRIC_WWN ";
    public static final String SELECT_SANS_FROM_SWITCH_FROM_OTHER = "SELECT distinct \tSWITCH2FABRIC.PREFIX_ID, \tSWITCH2FABRIC.SWITCH_ID SWITCH_ID, \t\tT_RES_FABRIC.FABRIC_WWN FABRIC_WWN, \t\tCASE WHEN T_RES_FABRIC.DISPLAY_NAME IS NOT NULL AND RTRIM(T_RES_FABRIC.DISPLAY_NAME) != '' THEN T_RES_FABRIC.DISPLAY_NAME \t\t\tWHEN T_RES_FABRIC.NAME IS NOT NULL THEN RTRIM(T_RES_FABRIC.NAME) \t\t\tWHEN T_RES_FABRIC.SAN_WWN IS NOT NULL THEN RTRIM(T_RES_FABRIC.SAN_WWN) \t\t\tELSE T_RES_FABRIC.FABRIC_WWN \t\tEND DISPLAY_NAME, \t\tT_RES_FABRIC.FABRIC_ID FABRIC_ID, \t\tT_RES_FABRIC.NAME NAME, \t\tT_RES_FABRIC.ACTIVE ACTIVE, \t\tT_RES_FABRIC.IS_PHYSICAL IS_PHYSICAL, \t\tCASE WHEN PARENT.DISPLAY_NAME IS NOT NULL THEN PARENT.DISPLAY_NAME \t\t\tWHEN PARENT.SAN_WWN IS NOT NULL THEN RTRIM(PARENT.SAN_WWN) \t\t\tELSE PARENT.FABRIC_WWN \t\tEND PARENT_DISPLAY_NAME, \t\tT_RES_FABRIC.DETECTABLE DETECTABLE, \t\tT_RES_FABRIC.PROPAGATED_STATUS PROPAGATED_STATUS, \t\tT_RES_FABRIC.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_FABRIC.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_FABRIC.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_FABRIC.USER_ATTRIB3 USER_ATTRIB3 FROM     T_RES_FABRIC left outer join T_RES_FABRIC PARENT on \t T_RES_FABRIC.PARENT_FABRIC_WWN = PARENT.FABRIC_WWN, T_VIEW_VSWITCH2OTHER SWITCH2OTHER,T_VIEW_VSWITCH2FABRIC SWITCH2FABRIC  WHERE \tT_RES_FABRIC.FABRIC_ID = SWITCH2FABRIC.FABRIC_ID and    SWITCH2FABRIC.SWITCH_ID = SWITCH2OTHER.SWITCH_ID and    SWITCH2OTHER.OTHER_PREFIX_ID = ? and    SWITCH2OTHER.OTHER_ID = ?";
    public static final String SELECT_LUN_FROM_OTHER = "SELECT distinct       LUN2OTHER.SUBSYSTEM_ID,      LUN2OTHER.PREFIX_ID,       LUN2OTHER.OTHER_ID,       LUN2OTHER.DEVICE_LUN_ID DEVICE_LUN_ID,     LUN2OTHER.VOLUME_ID VOLUME_ID, \t LUN2OTHER.PATH   FROM   (SELECT DISTINCT    \t OTHER.PREFIX_ID PREFIX_ID,    \t OTHER.OTHER_ID OTHER_ID,    \t RTRIM(CAST(DATA_PATH.DEVICE_LUN_ID as CHAR(10))) PATH,    \t DATA_PATH.DEVICE_LUN_ID DEVICE_LUN_ID,    \t VOLUME.CONSOLIDATED_STATUS STATUS, \t DATA_PATH.VOLUME_ID VOLUME_ID,    \t DATA_PATH.SUBSYSTEM_ID SUBSYSTEM_ID FROM    \tT_RES_DATA_PATH DATA_PATH, T_RES_STORAGE_VOLUME VOLUME,     \tT_VIEW_VOTHER OTHER, T_VIEW_VOTHER2PORT OTHER2PORT WHERE    \tOTHER.PREFIX_ID = OTHER2PORT.PREFIX_ID and    \tOTHER.OTHER_ID = OTHER2PORT.OTHER_ID and    \tOTHER2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID and \tVOLUME.SVID = DATA_PATH.VOLUME_ID) LUN2OTHER WHERE  \t? = LUN2OTHER.PREFIX_ID and    ? = LUN2OTHER.OTHER_ID ";
    public static final String SELECT_ARRAYS_FROM_VOLUMES_FROM_OTHER = "SELECT distinct \t\tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID, \t\tT_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID SUBSYSTEM_ID, \t\tCASE WHEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME IS NOT NULL AND RTRIM(T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME) != '' THEN T_RES_STORAGE_SUBSYSTEM.USER_PROVIDED_NAME \t\t\t WHEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.DISPLAY_NAME \t\t\t ELSE T_RES_STORAGE_SUBSYSTEM.NAME \t\tEND  DISPLAY_NAME, \t\tT_RES_STORAGE_SUBSYSTEM.NAME || '+' || RTRIM(CAST(T_RES_STORAGE_SUBSYSTEM.NAME_FORMAT as CHAR(5))) NATURAL_KEY, \t\t(T_RES_STORAGE_SUBSYSTEM.ALLOCATED_CAPACITY*512) ALLOCATED_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.AVAILABLE_CAPACITY*512) AVAILABLE_CAPACITY, \t\t(T_RES_STORAGE_SUBSYSTEM.BACKEND_STORAGE_CAPACITY*512) BACKEND_STORAGE_CAPACITY, \t\tVENDOR.VENDOR_NAME VENDOR, \t\tMODEL.MODEL_NAME MODEL, \t\tT_RES_STORAGE_SUBSYSTEM.CACHE CACHE, \t\tT_RES_STORAGE_SUBSYSTEM.OS_TYPE OS_TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.TYPE TYPE, \t\tT_RES_STORAGE_SUBSYSTEM.IP_ADDRESS IP_ADDRESS, \t\tT_RES_STORAGE_SUBSYSTEM.CODE_LEVEL CODE_LEVEL,      CASE WHEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER IS NOT NULL THEN T_RES_STORAGE_SUBSYSTEM.SERIAL_NUMBER           ELSE T_RES_STORAGE_SUBSYSTEM.NAME      END  SERIAL_NUMBER, \t\tT_RES_STORAGE_SUBSYSTEM.DETECTABLE DETECTABLE, \t\tT_RES_STORAGE_SUBSYSTEM.OPERATIONAL_STATUS OPERATIONAL_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.CONSOLIDATED_STATUS CONSOLIDATED_STATUS, \t\tT_RES_STORAGE_SUBSYSTEM.PROPAGATED_STATUS PROPAGATED_STATUS,\t\tT_RES_STORAGE_SUBSYSTEM.ACCESS_INFO DEFAULT_MANAGER, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB1 USER_ATTRIB1, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB2 USER_ATTRIB2, \t\tT_RES_STORAGE_SUBSYSTEM.USER_ATTRIB3 USER_ATTRIB3 ,\tOTHER2PORT.PREFIX_ID OTHER_PREFIX_ID, \tOTHER2PORT.OTHER_ID, \tDATA_PATH.VOLUME_ID FROM \tT_RES_DATA_PATH DATA_PATH,   \tT_VIEW_VOTHER2PORT OTHER2PORT, T_VIEW_VSTORAGE_SUBSYSTEM T_RES_STORAGE_SUBSYSTEM left outer join T_RES_VENDOR VENDOR on  \tT_RES_STORAGE_SUBSYSTEM.VENDOR_ID = VENDOR.VENDOR_ID left outer join T_RES_MODEL MODEL on \tT_RES_STORAGE_SUBSYSTEM.MODEL_ID = MODEL.MODEL_ID WHERE \t? = OTHER2PORT.PREFIX_ID and \t? = OTHER2PORT.OTHER_ID and \tOTHER2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID and \tDATA_PATH.SUBSYSTEM_ID = T_RES_STORAGE_SUBSYSTEM.SUBSYSTEM_ID and \tT_RES_STORAGE_SUBSYSTEM.PREFIX_ID = 'subsystem:' ";
    public static final String SELECT_VOLUMES_FROM_OTHER = "SELECT distinct     OTHER2PORT.PREFIX_ID, \t OTHER2PORT.OTHER_ID OTHER_ID,     CASE WHEN T_RES_STORAGE_VOLUME.DISPLAY_NAME IS NOT NULL  and RTRIM(T_RES_STORAGE_VOLUME.DISPLAY_NAME) != '' THEN T_RES_STORAGE_VOLUME.DISPLAY_NAME \t\t  WHEN T_RES_STORAGE_VOLUME.SVID IS NOT NULL THEN CAST(T_RES_STORAGE_VOLUME.SVID as CHAR) \t END DISPLAY_NAME, T_RES_STORAGE_VOLUME.SVID SVID, T_RES_STORAGE_VOLUME.NAME || '+' || CAST(T_RES_STORAGE_VOLUME.NAME_FORMAT as CHAR) NATURAL_KEY, (T_RES_STORAGE_VOLUME.CAPACITY*512) CAPACITY, T_RES_STORAGE_VOLUME.POOL_ID POOL_ID, T_RES_STORAGE_VOLUME.FORMAT FORMAT, T_RES_STORAGE_VOLUME.IS_ASSIGNED IS_ASSIGNED, T_RES_STORAGE_VOLUME.USER_ATTRIB1 USER_ATTRIB1, T_RES_STORAGE_VOLUME.USER_ATTRIB2 USER_ATTRIB2, T_RES_STORAGE_VOLUME.USER_ATTRIB3 USER_ATTRIB3, T_RES_STORAGE_VOLUME.DETECTABLE DETECTABLE, T_RES_STORAGE_VOLUME.OPERATIONAL_STATUS OPERATIONAL_STATUS, T_RES_STORAGE_VOLUME.CONSOLIDATED_STATUS CONSOLIDATED_STATUS  FROM \tT_RES_DATA_PATH DATA_PATH,  \tT_VIEW_VOTHER2PORT OTHER2PORT, T_RES_STORAGE_VOLUME WHERE \t? = OTHER2PORT.PREFIX_ID and \t? = OTHER2PORT.OTHER_ID and \tOTHER2PORT.PORT_ID = DATA_PATH.INITIATOR_PORT_ID and    DATA_PATH.VOLUME_ID = T_RES_STORAGE_VOLUME.SVID ";

    public GraphOther getOther(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphOther graphOther = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_OTHER);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2 = (Integer)resultSet.getObject("OTHER_ID");
                String string2 = (String)resultSet.getObject("PREFIX_ID");
                String string3 = String.valueOf(string2) + n2;
                if (hashMap == null || hashMap.get(string3) == null) {
                    graphOther = new GraphOther(string3);
                    this.populator.populateOther(resultSet, graphOther);
                    graphModel.put(graphOther);
                    hashMap.put(string3, graphOther);
                    if (graphModel != null) {
                        graphModel.put(graphOther);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(string3, graphOther);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getOther", "Duplicated Other entry:" + string3);
            }
        }
        finally {
            block18: {
                block17: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block17;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block18;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSubsystem", sQLException);
                }
            }
        }
        return graphOther;
    }

    public void getPortFromOther(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        String string2;
        Object object;
        Object object2;
        Integer n2;
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphFCPort graphFCPort = null;
        String string3 = String.valueOf(string) + n;
        GraphOther graphOther = (GraphOther)hashMap.get(string3);
        if (graphOther == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "MIssing host");
            }
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_PORT_FROM_OTHER);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                n2 = (Integer)resultSet.getObject("PORT_ID");
                object2 = "Port:" + n2;
                if (hashMap == null || hashMap.get(object2) == null) {
                    graphFCPort = new GraphFCPort((String)object2);
                    this.populator.populatePort(resultSet, graphFCPort);
                    if (graphModel != null) {
                        graphModel.put(graphFCPort);
                    }
                    if (hashMap != null) {
                        hashMap.put(object2, graphFCPort);
                    }
                    if ((object = (GraphOther2FCPort)hashMap.get(string2 = "other2port:" + string + n + ',' + n2)) == null) {
                        object = new GraphOther2FCPort(string2);
                        ((GraphOther2FCPort)object).setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                        ((GraphOther2FCPort)object).setOtherID((GraphOther.ID)graphOther.getEntityID());
                        graphModel.put((GraphEntity)object);
                        hashMap.put(string2, object);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "Duplicated switch2port entry:" + string2);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "Duplicated port entry:" + (String)object2);
            }
        }
        finally {
            block40: {
                block39: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block39;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getPortFromOther", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block40;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getPortFromOther", sQLException);
                }
            }
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_PORT2PORT_FROM_OTHER);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GraphFCPort graphFCPort2;
                n2 = (Integer)resultSet.getObject("PORT_ID");
                object2 = (Integer)resultSet.getObject("PORT_ID2");
                string2 = (String)resultSet.getObject("PORT2_NAME");
                object = (String)resultSet.getObject("PORT_NUMBER");
                Integer n3 = (Integer)resultSet.getObject("PORT2PORT_ID");
                String string4 = (String)resultSet.getObject("PREFIX_ID");
                Integer n4 = (Integer)resultSet.getObject("ENTITY_ID");
                String string5 = "Port:" + n2;
                String string6 = "Port:" + object2;
                graphFCPort = (GraphFCPort)hashMap.get(string5);
                if (graphFCPort == null) {
                    graphFCPort = new GraphFCPort(string5);
                    graphFCPort.setDisplayName(string2);
                    graphFCPort.setPortNumber((String)object);
                    graphModel.put(graphFCPort);
                    hashMap.put(string5, graphFCPort);
                }
                if ((graphFCPort2 = (GraphFCPort)hashMap.get(string6)) == null) {
                    graphFCPort2 = new GraphFCPort(string6);
                    graphModel.put(graphFCPort2);
                    hashMap.put(string6, graphFCPort2);
                }
                if (graphFCPort2 != null && graphFCPort != null) {
                    String string7 = "port2port:" + string + n + ',' + string4 + n4 + ',' + n3;
                    GraphFCPort2FCPort graphFCPort2FCPort = (GraphFCPort2FCPort)hashMap.get(string7);
                    if (graphFCPort2FCPort == null) {
                        graphFCPort2FCPort = new GraphFCPort2FCPort(string7);
                        graphFCPort2FCPort.setFCPort1ID((GraphFCPort.ID)graphFCPort.getEntityID());
                        graphFCPort2FCPort.setFCPort2ID((GraphFCPort.ID)graphFCPort2.getEntityID());
                        this.populator.populatePort2Port(resultSet, graphFCPort2FCPort);
                        graphModel.put(graphFCPort2FCPort);
                        hashMap.put(string7, graphFCPort2FCPort);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "Duplicated port2port entry:" + string7);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getPortFromOther", "Missing port:" + string6);
            }
        }
        finally {
            block43: {
                block42: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block42;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getPortFromOther", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block43;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getPortFromOther", sQLException);
                }
            }
        }
    }

    public void getSwitchFromOther(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        Object object;
        Integer n2;
        String string2;
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        GraphSwitch graphSwitch = null;
        String string3 = String.valueOf(string) + n;
        GraphOther graphOther = (GraphOther)hashMap.get(string3);
        if (graphOther == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "MIssing host");
            }
            return;
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH_FROM_OTHER);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = (String)resultSet.getObject("PREFIX_ID");
                n2 = (Integer)resultSet.getObject("SWITCH_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "SWITCH_ID is NULL");
                    continue;
                }
                object = String.valueOf(string2) + n2;
                if (hashMap == null || hashMap.get(object) == null) {
                    graphSwitch = new GraphSwitch((String)object);
                    this.populator.populateSwitch(resultSet, graphSwitch, true);
                    if (graphModel != null) {
                        graphModel.put(graphSwitch);
                    }
                    if (hashMap == null) continue;
                    hashMap.put(object, graphSwitch);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "Duplicated Switch entry:" + (String)object);
            }
        }
        finally {
            block39: {
                block38: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block38;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitchFromOther", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block39;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitchFromOther", sQLException);
                }
            }
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_SWITCH2OTHER_FROM_OTHER);
            preparedStatement.setInt(1, n);
            preparedStatement.setString(2, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = (String)resultSet.getObject("PREFIX_ID");
                n2 = (Integer)resultSet.getObject("SWITCH_ID");
                object = (Integer)resultSet.getObject("PORT_ID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "SWITCH_ID is NULL");
                    continue;
                }
                String string4 = String.valueOf(string2) + n2;
                graphSwitch = (GraphSwitch)hashMap.get(string4);
                if (graphSwitch == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "Switch not found:" + string4);
                    continue;
                }
                String string5 = "Port:" + object;
                GraphFCPort graphFCPort = (GraphFCPort)hashMap.get(string5);
                if (graphFCPort != null) {
                    String string6 = "switch2fcport:" + n2 + ',' + object;
                    GraphSwitch2FCPort graphSwitch2FCPort = (GraphSwitch2FCPort)hashMap.get(string6);
                    if (graphSwitch2FCPort == null) {
                        graphSwitch2FCPort = new GraphSwitch2FCPort(string6);
                        graphSwitch2FCPort.setFCPortID((GraphFCPort.ID)graphFCPort.getEntityID());
                        graphSwitch2FCPort.setSwitchID((GraphSwitch.ID)graphSwitch.getEntityID());
                        graphModel.put(graphSwitch2FCPort);
                        hashMap.put(string6, graphSwitch2FCPort);
                        continue;
                    }
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "Duplicated switch2port entry:" + string6);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerServerL2.class.getName(), "getSwitchFromOther", "Missing port entry:" + string5);
            }
        }
        finally {
            block42: {
                block41: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block41;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitchFromOther", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block42;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitchFromOther", sQLException);
                }
            }
        }
    }

    public void getOther2VolumeFromOther(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        GraphEntity graphEntity;
        String string2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Integer n2;
        Integer n3;
        String string3;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_VOLUMES_FROM_OTHER);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string3 = (String)resultSet.getObject("PREFIX_ID");
                n3 = (Integer)resultSet.getObject("OTHER_ID");
                n2 = (Integer)resultSet.getObject("SVID");
                if (n2 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "NULL column field SWITCH_WWN from switch");
                    continue;
                }
                object4 = String.valueOf(string3) + n3;
                object3 = (GraphOther)hashMap.get(object4);
                if (object3 == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "host not found:" + (String)object4);
                    continue;
                }
                object2 = "volume:" + n2;
                object = (GraphVolume)hashMap.get(object2);
                if (object == null) {
                    object = new GraphVolume((String)object2);
                    this.populator.populateStorageVolume(resultSet, (GraphVolume)object);
                    hashMap.put(object2, object);
                    graphModel.put((GraphEntity)object);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + (String)object2);
                }
                string2 = "other2volume:" + (String)object4 + ',' + n2;
                if (hashMap.get(string2) == null) {
                    graphEntity = new GraphOther2Volume(string2);
                    ((GraphOther2Volume)graphEntity).setOtherID((GraphOther.ID)((GraphEntity)object3).getEntityID());
                    ((GraphOther2Volume)graphEntity).setVolumeID((GraphVolume.ID)((GraphEntity)object).getEntityID());
                    graphModel.put(graphEntity);
                    hashMap.put(string2, graphEntity);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + string2);
            }
        }
        finally {
            block43: {
                block42: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block42;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block43;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getHost2VolumeFromHost", sQLException);
                }
            }
        }
        try {
            preparedStatement = connection.prepareStatement(SELECT_ARRAYS_FROM_VOLUMES_FROM_OTHER);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                GraphAssociation graphAssociation;
                String string4;
                GraphVolume graphVolume;
                string3 = (String)resultSet.getObject("OTHER_PREFIX_ID");
                n3 = (Integer)resultSet.getObject("OTHER_ID");
                n2 = (Integer)resultSet.getObject("SUBSYSTEM_ID");
                object4 = (Integer)resultSet.getObject("VOLUME_ID");
                object3 = String.valueOf(string3) + n3;
                object2 = (GraphOther)hashMap.get(object3);
                if (object2 == null || n2 == null) continue;
                object = "subsystem:" + n2;
                string2 = "volume:" + object4;
                graphEntity = (GraphSubsystem)hashMap.get(object);
                if (graphEntity == null) {
                    graphEntity = new GraphSubsystem((String)object);
                    this.populator.populateSubsystem(resultSet, (GraphSubsystem)graphEntity);
                    hashMap.put(object, graphEntity);
                    graphModel.put(graphEntity);
                }
                if ((graphVolume = (GraphVolume)hashMap.get(string2)) != null) {
                    string4 = "subsystem2volume:" + n2 + ',' + object4;
                    graphAssociation = new GraphSubsystem2Volume(string4);
                    ((GraphSubsystem2Volume)graphAssociation).setSubsystemID((GraphSubsystem.ID)graphEntity.getEntityID());
                    ((GraphSubsystem2Volume)graphAssociation).setVolumeID((GraphVolume.ID)graphVolume.getEntityID());
                    hashMap.put(string4, graphAssociation);
                    graphModel.put(graphAssociation);
                } else if (TraceLogger.enableTrace) {
                    TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + (String)object);
                }
                string4 = "other2volume:" + (String)object3 + ',' + n2;
                if (hashMap.get(string4) == null) {
                    graphAssociation = new GraphOther2Volume(string4);
                    ((GraphOther2Volume)graphAssociation).setOtherID((GraphOther.ID)((GraphEntity)object2).getEntityID());
                    ((GraphOther2Volume)graphAssociation).setVolumeID((GraphVolume.ID)graphVolume.getEntityID());
                    graphModel.put(graphAssociation);
                    hashMap.put(string4, graphAssociation);
                    continue;
                }
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.traceMessage(1, ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "Duplicated :" + string4);
            }
        }
        finally {
            block46: {
                block45: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block45;
                        TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block46;
                    TraceLogger.exception(ViewerServerL2.class.getName(), "getSwitch", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL1.class.getName(), "getHost2VolumeFromHost", "");
        }
    }

    public void getLUNsFromOther(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getLUNsFromOther", "");
        }
        System.currentTimeMillis();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_LUN_FROM_OTHER);
            preparedStatement.setString(1, string);
            preparedStatement.setInt(2, n);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Integer n2 = (Integer)resultSet.getObject("VOLUME_ID");
                string = (String)resultSet.getObject("PREFIX_ID");
                Integer n3 = (Integer)resultSet.getObject("OTHER_ID");
                Integer n4 = (Integer)resultSet.getObject("DEVICE_LUN_ID");
                String string2 = (String)resultSet.getObject("PATH");
                String string3 = String.valueOf(string) + n3;
                String string4 = "(" + n2 + ',' + string3 + ',' + n4 + ")";
                String string5 = "lun:" + string4;
                GraphLun graphLun = new GraphLun(string5);
                if (n4 != null) {
                    try {
                        graphLun.setLunID(new Integer(n4));
                    }
                    catch (Exception exception) {}
                }
                graphLun.setDisplayName(string2);
                graphLun.setHealthStatus(GraphModelConstant.STATUS_NORMAL);
                GraphOther graphOther = (GraphOther)hashMap.get(string3);
                if (graphOther == null) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.traceMessage(1, ViewerSubsystemL2.class.getName(), "getLunsFromOther", "Other not found: " + string3);
                    continue;
                }
                graphModel.put(graphLun);
                hashMap.put(string5, graphLun);
                String string6 = "other2lun:" + string3 + ',' + string4;
                GraphOther2Lun graphOther2Lun = new GraphOther2Lun(string6);
                graphOther2Lun.setLunID((GraphLun.ID)graphLun.getEntityID());
                graphOther2Lun.setOtherID((GraphOther.ID)graphOther.getEntityID());
                graphModel.put(graphOther2Lun);
                hashMap.put(string6, graphOther2Lun);
                GraphVolume graphVolume = (GraphVolume)hashMap.get("volume:" + n2);
                if (graphVolume == null) continue;
                String string7 = "lun2volume:" + n2 + ',' + string4;
                GraphVolume2Lun graphVolume2Lun = new GraphVolume2Lun(string7);
                graphVolume2Lun.setLunID((GraphLun.ID)graphLun.getEntityID());
                graphVolume2Lun.setVolumeID((GraphVolume.ID)graphVolume.getEntityID());
                graphModel.put(graphVolume2Lun);
                hashMap.put(string7, graphVolume2Lun);
            }
        }
        finally {
            block22: {
                block21: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block21;
                        TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getLUNsFromOther", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block22;
                    TraceLogger.exception(ViewerSubsystemL2.class.getName(), "getLUNsFromSubsystem", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getLUNsFromSubsystem", "");
        }
    }

    public void getZonesFromOther(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getZonesFromEntitiesConnectedToEntity(connection, graphModel, hashMap, new Object[]{string, new Integer(n)}, new String[]{SELECT_FABRIC_FROM_ZONES_FROM_OTHER, SELECT_ZONES_FROM_OTHER, SELECT_ZSET_FROM_OTHER, SELECT_ZSET2ZONE_FROM_OTHER, SELECT_ZONE2MEMBER_FROM_OTHER});
    }

    public void getZonesFromEntitiesConnectedToOther(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
    }

    public void getSansFromSwitch(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromSwitch(connection, graphModel, hashMap, new Object[]{string, new Integer(n)}, SELECT_SANS_FROM_SWITCH_FROM_OTHER);
    }

    public void getSansFromUnknown(Connection connection, GraphModel graphModel, HashMap hashMap, String string, int n) throws SQLException {
        this.getSansFromUnknown(connection, graphModel, hashMap, new Object[]{string, new Integer(n)}, "SELECT \t OTHER2FABRIC.FABRIC_ID FABRIC_ID, \t OTHER2FABRIC.PREFIX_ID PREFIX_ID, \t OTHER2FABRIC.OTHER_ID OTHER_ID FROM T_VIEW_VOTHER2FABRIC OTHER2FABRIC WHERE     OTHER2FABRIC.PREFIX_ID= ? and     OTHER2FABRIC.OTHER_ID  = ? ");
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        String string;
        int n;
        String string2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerSubsystemL2.class.getName(), "getView", "");
        }
        GraphModelOtherL2 graphModelOtherL2 = null;
        GraphOther.ID iD = (GraphOther.ID)viewerRequest.getModelID().getFocusEntityID();
        String string3 = (String)iD.getID();
        HashMap hashMap = new HashMap();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if ((timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) && this.getOther(connection, graphModelOtherL2 = new GraphModelOtherL2((GraphModelOtherL2.ID)viewerRequest.getModelID()), hashMap, string2 = string3.substring(0, string3.indexOf(58) + 1), n = Integer.parseInt(string = string3.substring(string3.indexOf(58) + 1))) != null) {
            this.getPortFromOther(connection, graphModelOtherL2, hashMap, string2, n);
            this.getSwitchFromOther(connection, graphModelOtherL2, hashMap, string2, n);
            this.getSansFromSwitch(connection, (GraphModel)graphModelOtherL2, hashMap, string2, n);
            this.getOther2VolumeFromOther(connection, graphModelOtherL2, hashMap, string2, n);
            this.getLUNsFromOther(connection, graphModelOtherL2, hashMap, string2, n);
            this.commit(connection);
            if (viewerRequest.getModelID().isNeedZoneData()) {
                this.getZonesFromOther(connection, graphModelOtherL2, hashMap, string2, n);
                this.commit(connection);
            }
            graphModelOtherL2.setWithZoneData(false);
        }
        graphModelOtherL2.setWithZoneData(viewerRequest.getModelID().isNeedZoneData());
        viewerResponse.addResponse(0, graphModelOtherL2);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerSubsystemL2.class.getName(), "getView", "");
        }
    }
}

