/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.guireq.topology.views;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelOverview;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphFabricSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphOtherSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphStorageSummary;
import org.eclipse.aperi.gui.topo.model.bean.GraphSwitchSummary;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.server.guireq.topology.request.ViewerRequest;
import org.eclipse.aperi.server.guireq.topology.request.ViewerResponse;
import org.eclipse.aperi.server.guireq.topology.views.ViewerEntityPopulator;
import org.eclipse.aperi.server.guireq.topology.views.ViewerServerL2;

public class ViewerRoot {
    static boolean debug = false;
    protected ViewerEntityPopulator populator = new ViewerEntityPopulator();
    public static String SELECT_COUNT_ENTITIES = "  SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status is NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'switch' type,           MIN((case when SWITCH.DETECTABLE = 1 then SWITCH.PROPAGATED_STATUS WHEN SWITCH.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\tMAX((case when SWITCH.DETECTABLE = 1 then SWITCH.PROPAGATED_STATUS WHEN SWITCH.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS,           COUNT(SWITCH.SWITCH_ID) TOTAL,           COUNT(CASE WHEN SWITCH.PROPAGATED_STATUS > 0 and SWITCH.PROPAGATED_STATUS != 4 THEN SWITCH.SWITCH_ID WHEN SWITCH.DETECTABLE = 0 THEN SWITCH.SWITCH_ID else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_VIEW_VSWITCH SWITCH) TMP2   UNION   SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'san' type, MIN((case when FABRIC.DETECTABLE = 1 then FABRIC.PROPAGATED_STATUS WHEN FABRIC.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\t\t\t\tMAX((case when FABRIC.DETECTABLE = 1 then FABRIC.PROPAGATED_STATUS WHEN FABRIC.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(FABRIC.FABRIC_ID) TOTAL,           COUNT(CASE WHEN FABRIC.PROPAGATED_STATUS > 0 and FABRIC.PROPAGATED_STATUS != 4 THEN FABRIC.FABRIC_ID                          WHEN FABRIC.DETECTABLE = 0 THEN FABRIC.FABRIC_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_RES_FABRIC FABRIC) TMP2   UNION   SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'vsan' type, MIN((case when FABRIC.DETECTABLE = 1 then FABRIC.PROPAGATED_STATUS WHEN FABRIC.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\t\tMAX((case when FABRIC.DETECTABLE = 1 then FABRIC.PROPAGATED_STATUS WHEN FABRIC.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(FABRIC.FABRIC_ID) TOTAL,           COUNT(CASE WHEN FABRIC.PROPAGATED_STATUS > 0 and FABRIC.PROPAGATED_STATUS != 4 THEN FABRIC.FABRIC_ID                          WHEN FABRIC.DETECTABLE = 0 THEN FABRIC.FABRIC_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_RES_FABRIC FABRIC        WHERE \t\t\tFABRIC.PARENT_FABRIC_WWN IS NOT NULL) TMP2    UNION    SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'host' type, MIN((case when HOST.DETECTABLE = 1 then HOST.PROPAGATED_STATUS WHEN HOST.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\tMAX((case when HOST.DETECTABLE = 1 then HOST.PROPAGATED_STATUS WHEN HOST.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(HOST.COMPUTER_ID) TOTAL,           COUNT(CASE WHEN HOST.PROPAGATED_STATUS > 0 and HOST.PROPAGATED_STATUS != 4 THEN HOST.COMPUTER_ID                          WHEN HOST.DETECTABLE = 0 THEN HOST.COMPUTER_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_VIEW_VHOST HOST) TMP2    UNION    SELECT        TMP1.TYPE TYPE,        TMP1.TOTAL TOTAL,        TMP1.ABNORMAL ABNORMAL,        case            when TMP1.max_gui_status = 0 then 0            when TMP1.min_gui_status = 2 then 2            when TMP1.min_gui_status = 3 then 3            when TMP1.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT 'subsystem' TYPE, MIN(TMP2.MIN_GUI_STATUS) MIN_GUI_STATUS, MAX(TMP2.MAX_GUI_STATUS) MAX_GUI_STATUS, SUM(TMP2.TOTAL) TOTAL, SUM(TMP2.ABNORMAL) ABNORMAL        FROM        (SELECT           MIN((case when SUBSYSTEM.DETECTABLE = 1 then SUBSYSTEM.PROPAGATED_STATUS WHEN SUBSYSTEM.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\tMAX((case when SUBSYSTEM.DETECTABLE = 1 then SUBSYSTEM.PROPAGATED_STATUS WHEN SUBSYSTEM.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(SUBSYSTEM.SUBSYSTEM_ID) TOTAL,           COUNT(CASE WHEN SUBSYSTEM.PROPAGATED_STATUS > 0 and SUBSYSTEM.PROPAGATED_STATUS != 4 THEN SUBSYSTEM.SUBSYSTEM_ID                          WHEN SUBSYSTEM.DETECTABLE = 0 THEN SUBSYSTEM.SUBSYSTEM_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_VIEW_VSTORAGE_SUBSYSTEM SUBSYSTEM        UNION        SELECT           MIN((case when TAPE.DETECTABLE = 1 then TAPE.PROPAGATED_STATUS WHEN TAPE.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\tMAX((case when TAPE.DETECTABLE = 1 then TAPE.PROPAGATED_STATUS WHEN TAPE.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, 0 TOTAL, 0 ABNORMAL        FROM           T_RES_TAPE_LIBRARY TAPE        ) TMP2) TMP1    UNION    SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'tape' type, MIN((case when TAPE.DETECTABLE = 1 then TAPE.PROPAGATED_STATUS WHEN TAPE.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\t\tMAX((case when TAPE.DETECTABLE = 1 then TAPE.PROPAGATED_STATUS WHEN TAPE.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(TAPE.TAPE_LIBRARY_ID) TOTAL,            COUNT(CASE WHEN TAPE.PROPAGATED_STATUS > 0 and TAPE.PROPAGATED_STATUS != 4 THEN TAPE.TAPE_LIBRARY_ID                          WHEN TAPE.DETECTABLE = 0 THEN TAPE.TAPE_LIBRARY_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM           T_VIEW_VTAPE_LIBRARY TAPE) TMP2    UNION    SELECT        TMP2.TYPE TYPE,        TMP2.TOTAL TOTAL,        TMP2.ABNORMAL ABNORMAL,        case            when TMP2.max_gui_status = 0 then 0            when TMP2.min_gui_status = 2 then 2            when TMP2.min_gui_status = 3 then 3            when TMP2.min_gui_status iS NULL then CAST (NULL as INTEGER)            else 1        end PROPAGATED_STATUS    FROM        (SELECT           'other' type, MIN((case when OTHER.DETECTABLE = 1 then OTHER.PROPAGATED_STATUS WHEN OTHER.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MIN_GUI_STATUS, \t\t\t\tMAX((case when OTHER.DETECTABLE = 1 then OTHER.PROPAGATED_STATUS WHEN OTHER.DETECTABLE = 0 THEN 3 ELSE CAST(NULL as INTEGER) END)) MAX_GUI_STATUS, COUNT(OTHER.PREFIX_ID) TOTAL,            COUNT(CASE WHEN OTHER.PROPAGATED_STATUS > 0 and OTHER.PROPAGATED_STATUS != 4 THEN OTHER.OTHER_ID                          else CAST(NULL as INTEGER) END) ABNORMAL        FROM T_VIEW_VOTHER OTHER ) TMP2";

    public int getTotals(Connection connection, GraphModel graphModel) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerRoot.class.getName(), "getView", "");
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(SELECT_COUNT_ENTITIES);
            resultSet = preparedStatement.executeQuery();
            GraphFabricSummary graphFabricSummary = new GraphFabricSummary("SanL0");
            graphFabricSummary.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_FABRIC"));
            graphFabricSummary.setNumOfFabrics(new Integer(0));
            graphFabricSummary.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            graphFabricSummary.setNumOfAbnormalFabrics(new Integer(0));
            graphFabricSummary.setNumOfAbnormalVirtualFabrics(new Integer(0));
            graphFabricSummary.setNumOfVirtualFabrics(new Integer(0));
            GraphStorageSummary graphStorageSummary = new GraphStorageSummary("StorageL0");
            graphStorageSummary.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_STORAGE"));
            graphStorageSummary.setNumOfSubsystems(new Integer(0));
            graphStorageSummary.setNumOfTapeLibraries(new Integer(0));
            graphStorageSummary.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            graphStorageSummary.setNumOfAbnormalSubsystems(new Integer(0));
            graphStorageSummary.setNumOfAbnormalTapeLibraries(new Integer(0));
            GraphComputerSummary graphComputerSummary = new GraphComputerSummary("HostL0");
            graphComputerSummary.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_COMPUTER"));
            graphComputerSummary.setNumOfComputers(new Integer(0));
            graphComputerSummary.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            graphComputerSummary.setNumOfAbnormalComputers(new Integer(0));
            GraphOtherSummary graphOtherSummary = new GraphOtherSummary("Others");
            graphOtherSummary.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_OTHER"));
            graphOtherSummary.setNumOfOthers(new Integer(0));
            graphOtherSummary.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            graphOtherSummary.setNumOfAbnormalOthers(new Integer(0));
            GraphSwitchSummary graphSwitchSummary = new GraphSwitchSummary("Switches");
            graphSwitchSummary.setDisplayName(GuiUtil.getString("TOPO_LABEL_ENTITY_SWITCH"));
            graphSwitchSummary.setNumOfSwitches(new Integer(0));
            graphSwitchSummary.setHealthStatus(GraphModelConstant.STATUS_UNKNOWN);
            graphSwitchSummary.setNumOfAbnormalSwitches(new Integer(0));
            while (resultSet.next()) {
                int n = resultSet.getInt("TOTAL");
                String string = ((String)resultSet.getObject("TYPE")).trim();
                Integer n2 = (Integer)resultSet.getObject("PROPAGATED_STATUS");
                Integer n3 = (Integer)resultSet.getObject("ABNORMAL");
                Integer n4 = null;
                n4 = n2;
                Integer n5 = GraphModelConstant.STATUS_UNKNOWN;
                if (n4 != null) {
                    switch (n4) {
                        case 0: {
                            n5 = GraphModelConstant.STATUS_NORMAL;
                            break;
                        }
                        case 1: {
                            n5 = GraphModelConstant.STATUS_WARNING;
                            break;
                        }
                        case 2: {
                            n5 = GraphModelConstant.STATUS_CRITICAL;
                            break;
                        }
                        case 3: {
                            n5 = GraphModelConstant.STATUS_MISSING;
                        }
                    }
                }
                if ("san".equals(string)) {
                    graphFabricSummary.setNumOfFabrics(new Integer(n));
                    graphFabricSummary.setNumOfAbnormalFabrics(n3);
                    graphFabricSummary.setHealthStatus(n5);
                    continue;
                }
                if ("vsan".equals(string)) {
                    graphFabricSummary.setNumOfVirtualFabrics(new Integer(n));
                    graphFabricSummary.setNumOfAbnormalVirtualFabrics(n3);
                    continue;
                }
                if ("switch".equals(string)) {
                    graphSwitchSummary.setNumOfSwitches(new Integer(n));
                    graphSwitchSummary.setNumOfAbnormalSwitches(n3);
                    graphSwitchSummary.setHealthStatus(n5);
                    continue;
                }
                if ("host".equals(string)) {
                    graphComputerSummary.setNumOfComputers(new Integer(n));
                    graphComputerSummary.setHealthStatus(n5);
                    graphComputerSummary.setNumOfAbnormalComputers(n3);
                    continue;
                }
                if ("subsystem".equals(string)) {
                    graphStorageSummary.setNumOfSubsystems(new Integer(n));
                    graphStorageSummary.setNumOfAbnormalSubsystems(n3);
                    graphStorageSummary.setHealthStatus(n5);
                    continue;
                }
                if ("tape".equals(string)) {
                    graphStorageSummary.setNumOfTapeLibraries(new Integer(n));
                    graphStorageSummary.setNumOfAbnormalTapeLibraries(n3);
                    continue;
                }
                if (!"other".equals(string)) continue;
                graphOtherSummary.setNumOfOthers(new Integer(n));
                graphOtherSummary.setNumOfAbnormalOthers(n3);
                graphOtherSummary.setHealthStatus(n5);
            }
            graphModel.put(graphFabricSummary);
            graphModel.put(graphComputerSummary);
            graphModel.put(graphStorageSummary);
            graphModel.put(graphOtherSummary);
            graphModel.put(graphSwitchSummary);
        }
        finally {
            block31: {
                block30: {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!TraceLogger.enableTrace) break block30;
                        TraceLogger.exception(ViewerRoot.class.getName(), "getTotal", sQLException);
                    }
                }
                try {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    if (!TraceLogger.enableTrace) break block31;
                    TraceLogger.exception(ViewerRoot.class.getName(), "getTotal", sQLException);
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerRoot.class.getName(), "getTotal", "result=0");
        }
        return 0;
    }

    public void commit(Connection connection) {
        block2: {
            try {
                connection.commit();
            }
            catch (SQLException sQLException) {
                if (!TraceLogger.enableTrace) break block2;
                TraceLogger.exception(ViewerServerL2.class.getName(), "commit", sQLException);
            }
        }
    }

    public void getView(Connection connection, ViewerRequest viewerRequest, ViewerResponse viewerResponse) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(ViewerRoot.class.getName(), "getView", "");
        }
        GraphModelOverview graphModelOverview = new GraphModelOverview((GraphModelOverview.ID)viewerRequest.getModelID());
        new HashMap();
        System.currentTimeMillis();
        Timestamp timestamp = viewerRequest.getTimestamp();
        Timestamp timestamp2 = null;
        if (timestamp2 == null || timestamp == null || timestamp2.after(timestamp)) {
            this.getTotals(connection, graphModelOverview);
            this.commit(connection);
            graphModelOverview.setWithZoneData(true);
            viewerResponse.addResponse(0, graphModelOverview);
        } else {
            viewerResponse.addResponse(0, null);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(ViewerRoot.class.getName(), "getView", "");
        }
    }

    public static void main(String[] stringArray) {
    }
}

