/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmpagent.manager.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;

public class SqlUtil {
    public static String className = SqlUtil.class.getName();
    public static final String MESSAGE_NAME = "aperi.logger.message.SnmpAgentManager";
    public static final String TRACE_NAME = "aperi.logger.trace.SnmpAgentManager";
    public static String MSG_FILE = "org.eclipse.aperi.resources.SnmpAgentManager";

    public static DBResultSet getCapability(DBConnection dBConnection, String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            stringBuffer.append("(SCANNER.TYPE=" + SqlUtil.wrap(stringArray[0]));
            int n = 1;
            while (n < stringArray.length) {
                stringBuffer.append(" or SCANNER.TYPE=" + SqlUtil.wrap(stringArray[n]));
                ++n;
            }
            stringBuffer.append(") and ");
        } else {
            stringBuffer.append("(1=2) and ");
        }
        String string2 = "select                SCANNER.ENABLED,               SCANNER.TYPE as SCANNER from                T_RES_SCANNER as SCANNER where " + stringBuffer + "               SCANNER.AGENT_NAME=" + SqlUtil.wrap(string);
        return SqlUtil.executeQuery(dBConnection, string2);
    }

    private static String wrap(String string) {
        return string == null ? "null" : "'" + string + "'";
    }

    public static DBResultSet executeQuery(DBConnection dBConnection, String string) {
        try {
            DBResultSet dBResultSet = ComplexQuery.sqlQuery(dBConnection, string, new Hashtable());
            return dBResultSet;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public static boolean removeTarget(String string) {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        DBConnection dBConnection = ServiceUtils.getConnection();
        hashtable.put(IpTarget.getColumnInfo("IP_ADDRESS"), string);
        try {
            IpTarget ipTarget = IpTarget.retrieve(dBConnection, hashtable);
            if (ipTarget != null) {
                ipTarget.delete(dBConnection);
                dBConnection.commit();
            }
            hashtable.clear();
            hashtable.put(Scanner.getColumnInfo("AGENT_NAME"), string);
            Scanner scanner = Scanner.retrieve(dBConnection, hashtable);
            if (scanner != null) {
                scanner.delete(dBConnection);
                dBConnection.commit();
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        finally {
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static boolean setUseridPassword(String string, String string2, String string3) {
        block28: {
            IpTarget.IpTargetCursor ipTargetCursor;
            DBConnection dBConnection;
            block26: {
                dBConnection = ServiceUtils.getConnection();
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(IpTarget.getColumnInfo("IP_ADDRESS"), string);
                ipTargetCursor = null;
                ipTargetCursor = IpTarget.getCursor(dBConnection, hashtable, null);
                while (ipTargetCursor.next()) {
                    IpTarget ipTarget = ipTargetCursor.getObject();
                    ipTarget.setUserId(string2);
                    ipTarget.setPassword(string3);
                    ipTarget.update(dBConnection);
                }
                if (ipTargetCursor == null) break block26;
                try {
                    ipTargetCursor.close();
                }
                catch (SQLException sQLException) {}
            }
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {}
            }
            return true;
            catch (Exception exception) {
                block27: {
                    try {
                        exception.printStackTrace();
                        if (ipTargetCursor == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (ipTargetCursor != null) {
                            try {
                                ipTargetCursor.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        if (dBConnection != null) {
                            try {
                                dBConnection.commit();
                            }
                            catch (Exception exception2) {
                                exception2.printStackTrace();
                            }
                            try {
                                dBConnection.close();
                            }
                            catch (Exception exception3) {}
                        }
                        throw throwable;
                    }
                    try {
                        ipTargetCursor.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (dBConnection == null) break block28;
                try {
                    dBConnection.commit();
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
                try {
                    dBConnection.close();
                }
                catch (Exception exception5) {}
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean addTarget(String string, String string2, String string3, String string4) {
        DBConnection dBConnection = ServiceUtils.getConnection();
        IpTarget ipTarget = new IpTarget();
        try {
            ipTarget.setHostName(string);
            ipTarget.setIpAddress(string2);
            ipTarget.setUserId(string3);
            ipTarget.setPassword(string4);
            ipTarget.insert(dBConnection);
        }
        catch (Exception exception) {
            try {
                try {
                    ipTarget.update(dBConnection);
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    if (dBConnection == null) return false;
                    try {
                        dBConnection.commit();
                    }
                    catch (Exception exception3) {
                        exception3.printStackTrace();
                    }
                    try {
                        dBConnection.close();
                        return false;
                    }
                    catch (Exception exception4) {
                        return false;
                    }
                }
            }
            catch (Throwable throwable) {
                if (dBConnection == null) throw throwable;
                try {
                    dBConnection.commit();
                }
                catch (Exception exception5) {
                    exception5.printStackTrace();
                }
                try {
                    dBConnection.close();
                    throw throwable;
                }
                catch (Exception exception6) {}
                throw throwable;
            }
        }
        if (dBConnection == null) return true;
        try {
            dBConnection.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            dBConnection.close();
            return true;
        }
        catch (Exception exception) {}
        return true;
    }

    public static boolean updateCapability(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length > 0) {
            stringBuffer.append("case when ( ");
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(" OR ");
                }
                stringBuffer.append(" TYPE = " + SqlUtil.wrap(stringArray[n]));
                ++n;
            }
            stringBuffer.append(" ) then 1 else 0 end ");
        } else {
            stringBuffer.append("0 ");
        }
        String string2 = "update T_RES_SCANNER set    ENABLED = " + stringBuffer + "where " + "               AGENT_NAME=" + SqlUtil.wrap(string) + "       and     ENABLED != " + stringBuffer;
        return SqlUtil.updateQuery(string2);
    }

    /*
     * Loose catch block
     */
    public static boolean updateQuery(String string) {
        boolean bl;
        DBConnection dBConnection;
        block17: {
            dBConnection = ServiceUtils.getConnection();
            int n = ComplexQuery.sqlUpdate(dBConnection, string, new Hashtable());
            boolean bl2 = bl = n > 0;
            if (dBConnection == null) break block17;
            try {
                dBConnection.commit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                dBConnection.close();
            }
            catch (Exception exception) {}
        }
        return bl;
        catch (Exception exception) {
            block18: {
                try {
                    exception.printStackTrace();
                    if (dBConnection == null) break block18;
                }
                catch (Throwable throwable) {
                    if (dBConnection != null) {
                        try {
                            dBConnection.commit();
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                        try {
                            dBConnection.close();
                        }
                        catch (Exception exception3) {}
                    }
                    throw throwable;
                }
                try {
                    dBConnection.commit();
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
                try {
                    dBConnection.close();
                }
                catch (Exception exception5) {}
            }
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public static IpTarget getTarget(String string) {
        block18: {
            IpTarget ipTarget;
            DBConnection dBConnection;
            block17: {
                IpTarget ipTarget2;
                dBConnection = ServiceUtils.getConnection();
                Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                hashtable.put(IpTarget.getColumnInfo("IP_ADDRESS"), string);
                ipTarget = ipTarget2 = IpTarget.retrieve(dBConnection, hashtable);
                if (dBConnection == null) break block17;
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    dBConnection.close();
                }
                catch (Exception exception) {}
            }
            return ipTarget;
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                    if (dBConnection == null) break block18;
                }
                catch (Throwable throwable) {
                    if (dBConnection != null) {
                        try {
                            dBConnection.commit();
                        }
                        catch (Exception exception2) {
                            exception2.printStackTrace();
                        }
                        try {
                            dBConnection.close();
                        }
                        catch (Exception exception3) {}
                    }
                    throw throwable;
                }
                try {
                    dBConnection.commit();
                }
                catch (Exception exception4) {
                    exception4.printStackTrace();
                }
                try {
                    dBConnection.close();
                }
                catch (Exception exception5) {}
            }
        }
        return null;
    }

    public static IpTarget getTarget(String string, DBConnection dBConnection) {
        try {
            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
            hashtable.put(IpTarget.getColumnInfo("IP_ADDRESS"), string);
            IpTarget ipTarget = IpTarget.retrieve(dBConnection, hashtable);
            return ipTarget;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ArrayList getTargets(DBConnection dBConnection) {
        ArrayList<IpTarget> arrayList;
        block24: {
            arrayList = new ArrayList<IpTarget>();
            IpTarget.IpTargetCursor ipTargetCursor = null;
            try {
                try {
                    ipTargetCursor = IpTarget.getCursor(dBConnection, null, null);
                    while (ipTargetCursor.next()) {
                        arrayList.add(ipTargetCursor.getObject());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (ipTargetCursor != null) {
                        try {
                            ipTargetCursor.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (dBConnection != null) {
                        try {
                            dBConnection.commit();
                        }
                        catch (Exception exception2) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (ipTargetCursor != null) {
                    try {
                        ipTargetCursor.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (dBConnection != null) {
                    try {
                        dBConnection.commit();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (ipTargetCursor != null) {
                try {
                    ipTargetCursor.close();
                }
                catch (SQLException sQLException) {}
            }
            if (dBConnection != null) {
                try {
                    dBConnection.commit();
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }
}

