/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.xmsg.IMessageBundleSource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBundleManager
implements IRegistryChangeListener,
IDisposable {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PREFIX = "prefix";
    public static final String ATTR_SOURCE = "source";
    private SortedMap<Integer, Map<String, IMessageBundleSource>> bundleSourceCache;
    private String extensionPointId;
    private ReadWriteLock cacheLock;

    public MessageBundleManager(String string) {
        this.extensionPointId = string;
        this.bundleSourceCache = new TreeMap<Integer, Map<String, IMessageBundleSource>>();
        this.cacheLock = new ReentrantReadWriteLock(true);
    }

    public void initialize() {
        IExtensionRegistry iExtensionRegistry = RegistryFactory.getRegistry();
        if (iExtensionRegistry != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(this.extensionPointId);
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                try {
                    this.addSource(iConfigurationElementArray[n]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n;
            }
            iExtensionRegistry.addRegistryChangeListener((IRegistryChangeListener)this);
        } else if (System.getProperty("osgi.framework") != null) {
            throw new RuntimeException("Failed to obtain reference to extension registry.");
        }
    }

    public void dispose() {
        this.cacheLock.writeLock().lock();
        try {
            RegistryFactory.getRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
            for (Map<String, IMessageBundleSource> map : this.bundleSourceCache.values()) {
                for (IMessageBundleSource iMessageBundleSource : map.values()) {
                    try {
                        iMessageBundleSource.dispose();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                map.clear();
            }
            this.bundleSourceCache.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    public void registryChanged(IRegistryChangeEvent iRegistryChangeEvent) {
        IExtensionDelta[] iExtensionDeltaArray = iRegistryChangeEvent.getExtensionDeltas();
        int n = 0;
        while (n < iExtensionDeltaArray.length) {
            IExtension iExtension = iExtensionDeltaArray[n].getExtension();
            if (iExtension.getExtensionPointUniqueIdentifier().equals(this.extensionPointId)) {
                int n2;
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                if (iExtensionDeltaArray[n].getKind() == 1) {
                    n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        try {
                            this.addSource(iConfigurationElementArray[n2]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n2;
                    }
                } else if (iExtensionDeltaArray[n].getKind() == 2) {
                    n2 = 0;
                    while (n2 < iConfigurationElementArray.length) {
                        try {
                            this.removeSource(iConfigurationElementArray[n2]);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    private void addSource(IConfigurationElement iConfigurationElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            String string = iConfigurationElement.getAttribute(ATTR_PREFIX);
            if (string != null) {
                Map<String, IMessageBundleSource> map = this.getPrefixSourceMap(string.length());
                if (map.containsKey(string)) {
                    throw new RuntimeException("Message source named " + map.get(string) + " already registered under prefix " + string);
                }
                IMessageBundleSource iMessageBundleSource = (IMessageBundleSource)iConfigurationElement.createExecutableExtension(ATTR_SOURCE);
                if (iMessageBundleSource != null) {
                    map.put(string, iMessageBundleSource);
                }
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    private void removeSource(IConfigurationElement iConfigurationElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            Map<String, IMessageBundleSource> map;
            IMessageBundleSource iMessageBundleSource;
            String string = iConfigurationElement.getAttribute(ATTR_PREFIX);
            if (string != null && (iMessageBundleSource = (map = this.getPrefixSourceMap(string.length())).remove(string)) != null) {
                iMessageBundleSource.dispose();
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    private Map<String, IMessageBundleSource> getPrefixSourceMap(Integer n) {
        HashMap hashMap = (HashMap)this.bundleSourceCache.get(n);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.bundleSourceCache.put(n, hashMap);
        }
        return hashMap;
    }

    public ResourceBundle getBundle(String string) {
        return this.getBundle(string, null);
    }

    public ResourceBundle getBundle(String string, Locale locale) {
        IMessageBundleSource iMessageBundleSource = null;
        if (string != null) {
            this.cacheLock.readLock().lock();
            try {
                Integer[] integerArray = this.bundleSourceCache.keySet().toArray(new Integer[0]);
                int n = integerArray.length - 1;
                while (n >= 0) {
                    if (string.length() >= integerArray[n]) {
                        String string2 = string.substring(0, integerArray[n]);
                        iMessageBundleSource = this.getPrefixSourceMap(integerArray[n]).get(string2);
                        if (iMessageBundleSource != null) {
                            break;
                        }
                    }
                    --n;
                }
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
        }
        if (iMessageBundleSource != null) {
            return iMessageBundleSource.getResourceBundle(locale);
        }
        return null;
    }
}

