/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.mgr;

import com.ibm.log.mgr.ConfigChangeEvent;
import com.ibm.log.mgr.ConfigChangeListener;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.DataStoreConfig;
import com.ibm.log.util.LogUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public abstract class DataStoreSupport
implements DataStore {
    private static final String ROOT_NAME = "/";
    protected boolean initialized = false;
    private final DataStoreConfig root;
    private Hashtable fullConfig = new Hashtable();
    private Object configLock = new Object();
    private Object listenerLock = new Object();
    private Vector listeners = new Vector();

    public DataStoreSupport() {
        this.root = new DataStoreConfig();
        this.root.setProperty("name", ROOT_NAME);
        this.root.setLoadedFromDataStore(false);
        this.fullConfig.put(ROOT_NAME, this.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfig(DataStoreConfig dataStoreConfig) {
        DataStoreConfig dataStoreConfig2 = null;
        if (dataStoreConfig != null) {
            String string = dataStoreConfig.getProperty("name");
            if (string != null && !string.trim().equals("")) {
                Object object = this.configLock;
                synchronized (object) {
                    if (!this.fullConfig.containsKey(string)) {
                        this.fullConfig.put(string, dataStoreConfig);
                        dataStoreConfig2 = this.getParentConfig(dataStoreConfig);
                        dataStoreConfig.setParent(dataStoreConfig2);
                        Iterator iterator = dataStoreConfig2.getChildren();
                        while (iterator.hasNext()) {
                            DataStoreConfig dataStoreConfig3 = (DataStoreConfig)iterator.next();
                            if (this.getParentConfig(dataStoreConfig3) == dataStoreConfig2) continue;
                            iterator.remove();
                            dataStoreConfig.addChild(dataStoreConfig3);
                            dataStoreConfig3.setParent(dataStoreConfig);
                        }
                        dataStoreConfig2.addChild(dataStoreConfig);
                        this.notifyConfigChangeListeners(dataStoreConfig);
                    }
                }
            } else {
                String string2 = LogUtil.getLogMsg("ERR_BAD_PARM", string, String.valueOf(this.getClass().getName()) + ".addConfig");
                LogUtil.errorMsg(string2);
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".addConfig");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfig(DataStoreConfig dataStoreConfig) {
        if (dataStoreConfig != null) {
            String string = dataStoreConfig.getProperty("name");
            if (string != null && !string.trim().equals("")) {
                Object object = this.configLock;
                synchronized (object) {
                    if (this.fullConfig.containsKey(string)) {
                        this.fullConfig.remove(string);
                        DataStoreConfig dataStoreConfig2 = dataStoreConfig.getParent();
                        dataStoreConfig2.removeChild(dataStoreConfig);
                        Iterator iterator = dataStoreConfig.getChildren();
                        while (iterator.hasNext()) {
                            DataStoreConfig dataStoreConfig3 = (DataStoreConfig)iterator.next();
                            iterator.remove();
                            dataStoreConfig2.addChild(dataStoreConfig3);
                            dataStoreConfig3.setParent(dataStoreConfig2);
                        }
                        dataStoreConfig.setParent(null);
                    }
                }
            } else {
                String string2 = LogUtil.getLogMsg("ERR_BAD_PARM", string, String.valueOf(this.getClass().getName()) + ".removeConfig");
                LogUtil.errorMsg(string2);
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".removeConfig");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig(DataStoreConfig dataStoreConfig) {
        if (dataStoreConfig != null) {
            String string = dataStoreConfig.getProperty("name");
            if (string != null && !string.trim().equals("")) {
                Object object = this.configLock;
                synchronized (object) {
                    if (this.fullConfig.containsKey(string)) {
                        this.removeConfig(dataStoreConfig);
                        this.addConfig(dataStoreConfig);
                    }
                }
            } else {
                String string2 = LogUtil.getLogMsg("ERR_BAD_PARM", string, String.valueOf(this.getClass().getName()) + ".updateConfig");
                LogUtil.errorMsg(string2);
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".updateConfig");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getConfig() {
        Object object = this.configLock;
        synchronized (object) {
            return this.fullConfig.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreConfig getConfig(String string) {
        DataStoreConfig dataStoreConfig = null;
        if (string != null) {
            if (!string.trim().equals("")) {
                Object object = this.configLock;
                synchronized (object) {
                    dataStoreConfig = (DataStoreConfig)this.fullConfig.get(string);
                    if (dataStoreConfig == null) {
                        dataStoreConfig = new DataStoreConfig();
                        dataStoreConfig.setProperty("name", string);
                        this.addConfig(dataStoreConfig);
                    }
                }
            } else {
                String string2 = LogUtil.getLogMsg("ERR_BAD_PARM", string, String.valueOf(this.getClass().getName()) + ".getConfig(String)");
                LogUtil.errorMsg(string2);
            }
        } else {
            String string3 = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".getConfig(String)");
            LogUtil.errorMsg(string3);
        }
        return dataStoreConfig;
    }

    public boolean containsConfig(String string) {
        boolean bl = false;
        if (string != null && !string.trim().equals("")) {
            bl = this.fullConfig.containsKey(string);
        }
        return bl;
    }

    public abstract void saveConfig(boolean var1) throws Exception;

    public boolean isWriteable() {
        return false;
    }

    public DataStoreConfig getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataStoreConfig getParentConfig(DataStoreConfig dataStoreConfig) {
        boolean bl = false;
        DataStoreConfig dataStoreConfig2 = null;
        String string = dataStoreConfig.getProperty("name");
        Object object = this.configLock;
        synchronized (object) {
            while (!bl) {
                int n = string.lastIndexOf(46);
                if (n == -1) {
                    bl = true;
                    dataStoreConfig2 = this.getRoot();
                    continue;
                }
                dataStoreConfig2 = (DataStoreConfig)this.fullConfig.get(string = string.substring(0, n));
                if (dataStoreConfig2 == null) continue;
                bl = true;
            }
        }
        return dataStoreConfig2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigChangeListener(ConfigChangeListener configChangeListener) {
        if (configChangeListener != null) {
            Object object = this.listenerLock;
            synchronized (object) {
                if (!this.listeners.contains(configChangeListener)) {
                    this.listeners.add(configChangeListener);
                }
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".addConfigChangeListener");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigChangeListener(ConfigChangeListener configChangeListener) {
        if (configChangeListener != null) {
            Object object = this.listenerLock;
            synchronized (object) {
                if (this.listeners.contains(configChangeListener)) {
                    this.listeners.remove(configChangeListener);
                }
            }
        } else {
            String string = LogUtil.getLogMsg("ERR_NULL_PARM", String.valueOf(this.getClass().getName()) + ".removeConfigChangeListener");
            LogUtil.errorMsg(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getConfigChangeListeners() {
        Object object = this.listenerLock;
        synchronized (object) {
            return this.listeners.iterator();
        }
    }

    protected void notifyConfigChangeListeners(DataStoreConfig dataStoreConfig) {
        if (this.initialized) {
            Iterator iterator = this.getConfigChangeListeners();
            while (iterator.hasNext()) {
                ConfigChangeListener configChangeListener = (ConfigChangeListener)iterator.next();
                this.notifyAll(configChangeListener, dataStoreConfig);
            }
        }
    }

    private void notifyAll(ConfigChangeListener configChangeListener, DataStoreConfig dataStoreConfig) {
        ConfigChangeEvent configChangeEvent = new ConfigChangeEvent(this, dataStoreConfig);
        configChangeListener.configChange(configChangeEvent);
        Iterator iterator = dataStoreConfig.getChildren();
        while (iterator.hasNext()) {
            dataStoreConfig = (DataStoreConfig)iterator.next();
            this.notifyAll(configChangeListener, dataStoreConfig);
        }
    }
}

