/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.log.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ISO8601DateFormat
extends DateFormat {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int MILLIS_PER_SECOND = 1000;
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final int BEGIN_TIMEZONE_FIELD = 23;
    private static final int END_TIMEZONE_FIELD = 29;
    private final SimpleDateFormat formatHelper = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final TimeZone formatTimeZone = this.formatHelper.getTimeZone();
    private final GregorianCalendar formatTZCalendar = new GregorianCalendar(this.formatTimeZone);
    private final SimpleDateFormat parseHelper = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final DecimalFormat tzHFormat;
    private static final String TZ_SEPARATOR = ":";
    private final DecimalFormat tzMFormat;

    public ISO8601DateFormat() {
        this.parseHelper.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.tzHFormat = new DecimalFormat("+00;-00");
        this.tzMFormat = new DecimalFormat("00;00");
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = null;
        if (date != null && stringBuffer != null) {
            int n = this.getTZOffsetSeconds(date);
            int n2 = n / 3600;
            int n3 = n / 60 % 60;
            if (n3 < 0) {
                n3 = -n3;
            }
            stringBuffer2 = stringBuffer;
            this.formatHelper.format(date, stringBuffer2, fieldPosition);
            stringBuffer.append(this.tzHFormat.format(n2));
            stringBuffer.append(TZ_SEPARATOR);
            stringBuffer.append(this.tzMFormat.format(n3));
            if (fieldPosition != null && 17 == fieldPosition.getField()) {
                fieldPosition.setBeginIndex(23);
                fieldPosition.setEndIndex(29);
            }
        }
        return stringBuffer2;
    }

    private synchronized int getTZOffsetSeconds(Date date) {
        int n = this.formatTimeZone.getRawOffset();
        if (this.formatTimeZone.inDaylightTime(date)) {
            this.formatTZCalendar.setTime(date);
            n += this.formatTZCalendar.get(16);
        }
        return n / 1000;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        Date date = null;
        if (string != null && parsePosition != null) {
            int n = 0;
            date = this.parseHelper.parse(string, parsePosition);
            Number number = this.tzHFormat.parse(string, parsePosition);
            parsePosition.setIndex(parsePosition.getIndex() + 1);
            Number number2 = this.tzMFormat.parse(string, parsePosition);
            if (number != null) {
                n += number.intValue() * 3600000;
            }
            if (number2 != null) {
                n += number2.intValue() * 60000;
            }
            date.setTime(date.getTime() - (long)n);
        }
        return date;
    }
}

