/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.Activator;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.DeviceStatus;
import org.eclipse.aperi.common.api.ICIMOMMgmtService;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.common.dbaccess.CIMOMDbAccess;
import org.eclipse.aperi.common.identifier.ConversionUtil;
import org.eclipse.aperi.common.identifier.SubsystemId;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyManager;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerExecException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerRTException;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyHost;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyPort;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySubsystem;
import org.eclipse.aperi.infrastructure.database.objects.CimkeySwitch;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyTapeLibrary;
import org.eclipse.aperi.infrastructure.database.objects.CimkeyVolume;
import org.eclipse.aperi.infrastructure.database.objects.Cimom2namespace;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyHostTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyPortTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeySwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyTapeLibraryTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResElementProbeStatusTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.infrastructure.database.tables.TResSwitchTable;
import org.eclipse.aperi.infrastructure.database.tables.TResTapeLibraryTable;
import org.eclipse.aperi.infrastructure.history.detectability.ChangeDetection;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.smis.CIMDeviceStatus;
import org.eclipse.aperi.util.SRMCrypto;
import org.sblim.wbem.cim.CIMAuthenticationException;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMSecurityException;
import org.sblim.wbem.cim.CIMTransportException;
import org.sblim.wbem.client.CIMEnumeration;

public final class CIMOMManager
extends CIMOMDbAccess
implements ICIMOMMgmtService {
    private static CIMOMManager cCimomMgr = new CIMOMManager();
    private static Map stUsedCIMOMs = Collections.synchronizedMap(new HashMap());
    private static Set stPendingCIMOMDeletions = Collections.synchronizedSet(new HashSet());
    private static final String SLPDISCOVERYPROCESS_PARAMETER_DA = "DA";
    private static final String SLPDISCOVERYPROCESS_PARAMETER_DA_LOCAL = "local";
    private static final String SLPDISCOVERYPROCESS_PARAMETER_SCOPE = "SCOPE";
    private static final String SLPDISCOVERYPROCESS_PARAMETER_SCOPE_DEFAULT = "default";
    private static final String DBATTRIBUTEMAPPER = "DBAttributeMapper";
    private static final String DBATTRIBUTEMAPPER_SLP = "SLP";
    private static final String DBATTRIBUTEMAPPER_SLP_SCANID = "DummyScanID";
    private static final String TESTCONNECTIONTIMEOUT_NAME = "TESTCONNECTIONTIMEOUT";
    private static final int CIMOM_CHECK_OK = 0;
    private static final int CIMOM_CHECK_DUP = 1;
    private static final int CIMOM_CHECK_RES_ERR = 2;
    private static final int CIMOM_CHECK_URL_ERR = 3;
    private static final String PROCESSID_PREFIX = "S";
    public static final int DEVICE_UNKNOWN_UNCONFIGURED = -1;

    private CIMOMManager() {
    }

    public static CIMOMManager getCIMOMManager() {
        return cCimomMgr;
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, Boolean bl) throws ServerException {
        return this.discoverCIMOMs(stringArray, (boolean)bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult discoverCIMOMs(String[] stringArray, boolean bl) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"discoverCIMOMs", (Object[])new Object[]{stringArray, new Boolean(bl)});
        AsyncResult asyncResult = new AsyncResult(-1);
        try {
            Object object;
            Object object2;
            if (!bl) {
                try {
                    ParameterChecker.assertMandatoryParameter((int)1, (String)"pDAs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
                }
                catch (MissingParameterException missingParameterException) {
                    throw DiskMessageHelper.getServerException((String)"HWN020002E", (Object)missingParameterException.getMessage(), (Throwable)missingParameterException, (LogTraceHelper)logTraceHelper);
                }
            }
            if ((object2 = Activator._serviceHelper.bindLocal("DiscoverService")) == null) {
                throw DiskMessageHelper.getServerException((String)"HWN021807E", null, (LogTraceHelper)logTraceHelper);
            }
            IDiscover iDiscover = (IDiscover)object2;
            Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
            hashtable.put(SLPDISCOVERYPROCESS_PARAMETER_SCOPE, new String[]{SLPDISCOVERYPROCESS_PARAMETER_SCOPE_DEFAULT});
            if (!bl) {
                hashtable.put(SLPDISCOVERYPROCESS_PARAMETER_DA, stringArray);
            } else {
                logTraceHelper.traceInfo("local discovery was requested, add 'local' to DA array");
                object = null;
                int n = 0;
                if (stringArray != null) {
                    n = stringArray.length;
                    object = new String[n + 1];
                    int n2 = 0;
                    while (n2 < n) {
                        object[n2] = stringArray[n2];
                        ++n2;
                    }
                } else {
                    n = 0;
                    object = new String[n + 1];
                }
                object[n] = SLPDISCOVERYPROCESS_PARAMETER_DA_LOCAL;
                hashtable.put(SLPDISCOVERYPROCESS_PARAMETER_DA, (String[])object);
            }
            logTraceHelper.traceSvcEntry("Discover.slpDiscover", new Object[]{hashtable});
            object = iDiscover.discover("SLPDiscover", hashtable);
            asyncResult = iDiscover.getJobStatus((String)object);
            logTraceHelper.traceSvcReturn("Discover.slpDiscover jobid=" + (String)object, (Object)asyncResult.toString());
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            logTraceHelper.exit((Object)asyncResult);
            throw throwable;
        }
        {
            Object var11_14 = null;
        }
        logTraceHelper.exit((Object)asyncResult);
        return asyncResult;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMOM[] getCIMOMs() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getCIMOMs", null);
        CIMOM[] cIMOMArray = null;
        try {
            cIMOMArray = CIMOMManager.getCIMOMs(null);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            logTraceHelper.exit((Object)cIMOMArray);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        logTraceHelper.exit((Object)cIMOMArray);
        return cIMOMArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMOM[] getCIMOMsWithoutPW() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getCIMOMsWithoutPW", null);
        CIMOM[] cIMOMArray = null;
        try {
            cIMOMArray = CIMOMManager.getCIMOMs(null);
            int n = 0;
            while (n < cIMOMArray.length) {
                cIMOMArray[n].setPassword(null);
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit((Object)cIMOMArray);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit((Object)cIMOMArray);
        return cIMOMArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyCIMOMs(CIMOM[] cIMOMArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"modifyCIMOMs", (Object[])new Object[]{cIMOMArray});
        String[] stringArray = null;
        try {
            stringArray = this.persistCIMOMs(cIMOMArray, true, logTraceHelper);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit((Object)stringArray);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit((Object)stringArray);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] addCIMOMs(CIMOM[] cIMOMArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"addCIMOMs", (Object[])new Object[]{cIMOMArray});
        String[] stringArray = null;
        try {
            stringArray = this.persistCIMOMs(cIMOMArray, false, logTraceHelper);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit((Object)stringArray);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit((Object)stringArray);
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] persistCIMOMs(CIMOM[] var1_1, boolean var2_2, LogTraceHelper var3_3) throws ServerException {
        try {
            ParameterChecker.assertMandatoryParameter((int)1, (String)"pCimoms", (Object)var1_1, (LogTraceHelper)var3_3);
        }
        catch (MissingParameterException var4_4) {
            throw DiskMessageHelper.getServerException((String)"HWN020002E", (Object)var4_4.getMessage(), (LogTraceHelper)var3_3);
        }
        var4_5 = ServiceUtils.getConnection();
        if (var4_5 == null) {
            throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)var3_3);
        }
        var5_6 = var2_2 != false ? null : this.checkForDuplicateCIMOMs(var1_1, var4_5);
        var6_7 = var1_1.length;
        var7_8 = new String[var6_7];
        var8_9 = new Hashtable[var6_7];
        var9_10 = 0;
        while (true) {
            if (var9_10 >= var6_7) {
                var9_10 = 0;
                ** try [egrp 1[TRYBLOCK] [3 : 110->547)] { 
lbl18:
                // 1 sources

                break;
            }
            var8_9[var9_10] = this.extractAttributes(var1_1[var9_10]);
            ++var9_10;
        }
        {
            try {
                var9_10 = 0;
                while (var9_10 < var6_7) {
                    if (var2_2) ** GOTO lbl33
                    if (var5_6[var9_10] == 1) {
                        var7_8[var9_10] = var1_1[var9_10].getServiceUrl();
                    } else {
                        if (var5_6[var9_10] == 2) {
                            var4_5.rollback();
                            var7_8[var9_10] = null;
                            throw DiskMessageHelper.getServerException((String)"HWN021809E", (Object)var1_1[var9_10].getServiceUrl(), (LogTraceHelper)var3_3);
                        }
lbl33:
                        // 3 sources

                        if ((var10_11 = MapperRouter.getMapperRouter().findMapper("SLP", null, null, null)) == null) {
                            throw DiskMessageHelper.getServerException((String)"HWN021805E", (Object)"DBAttributeMapper", (LogTraceHelper)var3_3);
                        }
                        var11_13 = null;
                        var11_13 = var10_11.persist(var4_5, var8_9[var9_10], "DummyScanID");
                        if (var11_13 == null) {
                            var4_5.rollback();
                            var7_8[var9_10] = null;
                            throw DiskMessageHelper.getServerException((String)"HWN021806E", (Object)"DBAttributeMapper", (LogTraceHelper)var3_3);
                        }
                        var7_8[var9_10] = var1_1[var9_10].getServiceUrl();
                        var3_3.traceInfo("Database entity for " + var1_1[var9_10].getServiceUrl() + " was added");
                        var4_5.commit();
                        var12_15 = RegisteredCimom.getColumnInfo((String)"REG_CIMOM_ID");
                        v0 = var13_16 = var2_2 != false ? (Hashtable)var11_13.getUpdatedRows().get(RegisteredCimom.getTablename()) : (Hashtable)var11_13.getInsertedRows().get(RegisteredCimom.getTablename());
                        if (var13_16 != null) {
                            var14_17 = (String)var13_16.get(var12_15);
                            if (var2_2) {
                                ServiceUtils.getEventMonitorProxy().handleDevicePropertyChange("S" + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), var14_17, null, null);
                            } else {
                                ServiceUtils.getEventMonitorProxy().handleNewDevice("S" + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), var14_17);
                            }
                        }
                    }
                    ++var9_10;
                }
                ** GOTO lbl-1000
            }
            catch (SQLException var10_12) {
                var7_8[var9_10] = null;
                var3_3.traceError("Database entity for " + var1_1[var9_10].getServiceUrl() + " was not added because of " + var10_12.getMessage(), (Throwable)var10_12);
                try {
                    var4_5.rollback();
                    throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)var10_12.getMessage(), (Throwable)var10_12, (LogTraceHelper)var3_3);
                }
                catch (SQLException var11_14) {
                    throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)var11_14.getMessage(), (Throwable)var11_14, (LogTraceHelper)var3_3);
                }
            }
        }
lbl63:
        // 1 sources

        catch (Throwable var16_18) {
            var15_19 = null;
            try {
                var4_5.close();
                throw var16_18;
            }
            catch (SQLException var17_21) {
                throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)var17_21.getMessage(), (Throwable)var17_21, (LogTraceHelper)var3_3);
            }
        }
lbl-1000:
        // 1 sources

        {
            var15_20 = null;
        }
        try {}
        catch (SQLException var17_22) {
            throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)var17_22.getMessage(), (Throwable)var17_22, (LogTraceHelper)var3_3);
        }
        var4_5.close();
        return var7_8;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Hashtable extractAttributes(CIMOM cIMOM) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"extractAttributes", (Object[])new Object[]{cIMOM});
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            if (cIMOM.getServiceUrl() != null) {
                hashtable.put("template-url-syntax", cIMOM.getServiceUrl());
            }
            if (cIMOM.getHiName() != null) {
                hashtable.put("service-hi-name", cIMOM.getHiName());
            }
            if (cIMOM.getDescription() != null) {
                hashtable.put("service-hi-description", cIMOM.getDescription());
            }
            if (cIMOM.getProtocolVersion() != null) {
                hashtable.put("protocolversion", cIMOM.getProtocolVersion());
            }
            if (cIMOM.getInteropSchemaNamespace() != null) {
                hashtable.put("interopschemanamespace", cIMOM.getInteropSchemaNamespace());
            }
            if (cIMOM.getSoftwareLevel() != null) {
                hashtable.put("software_level", cIMOM.getSoftwareLevel());
            }
            if (cIMOM.getAuthenticationMechanism() != null) {
                hashtable.put("authentication_mechanism", cIMOM.getAuthenticationMechanism());
            }
            if (cIMOM.getUserId() != null) {
                hashtable.put("user_id", cIMOM.getUserId());
            }
            if (cIMOM.getPassword() != null) {
                try {
                    String string = SRMCrypto.encrypt((String)cIMOM.getPassword());
                    hashtable.put("password", string);
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("Failed to encrypt password due to " + exception.getMessage(), (Throwable)exception);
                }
            }
            if (cIMOM.getTrustStoreLocation() != null) {
                hashtable.put("trust_store_location", cIMOM.getTrustStoreLocation());
            }
            if (cIMOM.getTrustStorePassphrase() != null) {
                hashtable.put("trust_store_passphrase", cIMOM.getTrustStorePassphrase());
            }
            if (cIMOM.getDisplayName() != null) {
                hashtable.put("display_name", cIMOM.getDisplayName());
            }
            if (cIMOM.getSlpAttributes() != null) {
                hashtable.put("slp_attributes", cIMOM.getSlpAttributes());
            }
            if (cIMOM.getProtocol() != null) {
                hashtable.put("protocol", cIMOM.getProtocol());
            }
            if (cIMOM.getStatus() != null) {
                hashtable.put("status", Short.toString(cIMOM.getStatus().toID()));
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            logTraceHelper.exit(hashtable);
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        logTraceHelper.exit(hashtable);
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Boolean persistCIMOMStatus(CIMOM cIMOM) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"persistCIMOMStatus", (Object[])new Object[]{cIMOM});
        Boolean bl = Boolean.FALSE;
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"pCimom", (Object)cIMOM, (LogTraceHelper)logTraceHelper);
            }
            catch (MissingParameterException missingParameterException) {
                throw DiskMessageHelper.getServerException((String)"HWN020002E", (Object)missingParameterException.getMessage(), (Throwable)missingParameterException, (LogTraceHelper)logTraceHelper);
            }
            DBConnection dBConnection = ServiceUtils.getConnection();
            if (dBConnection == null) {
                throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)logTraceHelper);
            }
            CIMOMConnectionStatus cIMOMConnectionStatus = cIMOM.getStatus();
            String string = cIMOM.getServiceUrl();
            if (cIMOMConnectionStatus != null && string != null) {
                short s = this.getCIMOMStatusInDB(string);
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("template-url-syntax", string);
                hashtable.put("status", Short.toString(cIMOMConnectionStatus.toID()));
                IDBAttributeMapper iDBAttributeMapper = MapperRouter.getMapperRouter().findMapper(DBATTRIBUTEMAPPER_SLP, null, null, null);
                if (iDBAttributeMapper == null) {
                    throw DiskMessageHelper.getServerException((String)"HWN021805E", (Object)DBATTRIBUTEMAPPER, (LogTraceHelper)logTraceHelper);
                }
                try {
                    try {
                        MapperResult mapperResult = iDBAttributeMapper.persist(dBConnection, hashtable, DBATTRIBUTEMAPPER_SLP_SCANID);
                        if (mapperResult == null) {
                            bl = Boolean.FALSE;
                            logTraceHelper.traceError("Status for " + cIMOM.getServiceUrl() + " was not updated (no mapper result retrieved)", null);
                            dBConnection.rollback();
                            throw DiskMessageHelper.getServerException((String)"HWN021806E", (Object)DBATTRIBUTEMAPPER, (LogTraceHelper)logTraceHelper);
                        }
                        bl = Boolean.TRUE;
                        logTraceHelper.traceInfo("Status for " + cIMOM.getServiceUrl() + " was updated");
                        dBConnection.commit();
                        ColumnInfo columnInfo = RegisteredCimom.getColumnInfo((String)"REG_CIMOM_ID");
                        Hashtable hashtable2 = (Hashtable)mapperResult.getUpdatedRows().get(RegisteredCimom.getTablename());
                        if (hashtable2 != null && cIMOMConnectionStatus != CIMOMConnectionStatus.TIMEOUT && s != cIMOMConnectionStatus.toID()) {
                            int n;
                            int n2;
                            String string2 = (String)hashtable2.get(columnInfo);
                            if (cIMOMConnectionStatus == CIMOMConnectionStatus.SUCCESS) {
                                n2 = 0;
                                n = 1;
                            } else {
                                n2 = 1;
                                n = 0;
                            }
                            ServiceUtils.getEventMonitorProxy().handleDeviceStateChange(PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), string2, n2, n);
                        }
                    }
                    catch (SQLException sQLException) {
                        bl = Boolean.FALSE;
                        logTraceHelper.traceError("Status for " + cIMOM.getServiceUrl() + " was not updated due to " + sQLException.getMessage(), (Throwable)sQLException);
                        try {
                            dBConnection.rollback();
                        }
                        catch (SQLException sQLException2) {
                            throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)sQLException2.getMessage(), (Throwable)sQLException2, (LogTraceHelper)logTraceHelper);
                        }
                    }
                    Object var16_21 = null;
                }
                catch (Throwable throwable) {
                    Object var16_20 = null;
                    try {
                        dBConnection.close();
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)sQLException.getMessage(), (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                    }
                }
                try {}
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)sQLException.getMessage(), (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                }
                dBConnection.close();
            }
            Object var19_26 = null;
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            logTraceHelper.exit((Object)bl);
            throw throwable;
        }
        logTraceHelper.exit((Object)bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCIMOMs(String[] stringArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"deleteCIMOMs", (Object[])new Object[]{stringArray});
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"pCimomURLs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
            }
            catch (MissingParameterException missingParameterException) {
                throw DiskMessageHelper.getServerException((String)"HWN020002E", (Object)missingParameterException.getMessage(), (Throwable)missingParameterException, (LogTraceHelper)logTraceHelper);
            }
            new HashSet();
            int n = 0;
            while (true) {
                block16: {
                    if (n < stringArray.length) break block16;
                    this.cleanupPendingCIMOMDeletions();
                    break;
                }
                try {
                    boolean bl = false;
                    Map map = stUsedCIMOMs;
                    synchronized (map) {
                        if (!stUsedCIMOMs.containsKey(stringArray[n])) {
                            try {
                                this.processPendingCIMOMDeletion(stringArray[n]);
                            }
                            catch (Throwable throwable) {
                                bl = true;
                                stPendingCIMOMDeletions.add(stringArray[n]);
                            }
                        } else {
                            bl = true;
                            stPendingCIMOMDeletions.add(stringArray[n]);
                        }
                    }
                    if (bl) {
                        this.flagPendingCIMOMDeletion(stringArray[n]);
                    }
                }
                catch (Throwable throwable) {
                    logTraceHelper.traceError("Not able to delete CIMOM " + stringArray[n] + "because of :" + throwable.getMessage(), throwable);
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            logTraceHelper.exit((Object)"null");
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        logTraceHelper.exit((Object)"null");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private short getCIMOMStatusInDB(String string) throws ServerException {
        short s;
        LogTraceHelper logTraceHelper;
        block13: {
            logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getDBCIMOMStatus", (Object[])new Object[]{string});
            s = CIMOMConnectionStatus.UNKNOWN.toID();
            DBConnection dBConnection = null;
            try {
                try {
                    dBConnection = ServiceUtils.getConnection();
                    if (dBConnection == null) {
                        throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)logTraceHelper);
                    }
                    RegisteredCimom registeredCimom = new RegisteredCimom();
                    registeredCimom.setServiceUrl(string);
                    if (registeredCimom.retrieve(dBConnection)) {
                        s = registeredCimom.getStatus();
                        logTraceHelper.traceInfo("CIMOM " + string + " has persisted status with value of " + s);
                    } else {
                        logTraceHelper.traceInfo("No Database entity for CIMOM " + string + ". Nothing to do.");
                    }
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)sQLException.getMessage(), (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (Exception exception) {}
                }
                logTraceHelper.exit((Object)new Short(s));
                throw throwable;
            }
            {
                Object var6_9 = null;
                if (dBConnection == null) break block13;
            }
            try {}
            catch (Exception exception) {}
            dBConnection.close();
        }
        logTraceHelper.exit((Object)new Short(s));
        return s;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flagPendingCIMOMDeletion(String string) throws ServerException {
        LogTraceHelper logTraceHelper;
        block13: {
            logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"flagPendingCIMOMDeletion", (Object[])new Object[]{string});
            DBConnection dBConnection = null;
            try {
                try {
                    stPendingCIMOMDeletions.add(string);
                    dBConnection = ServiceUtils.getConnection();
                    if (dBConnection == null) {
                        throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)logTraceHelper);
                    }
                    RegisteredCimom registeredCimom = new RegisteredCimom();
                    registeredCimom.setServiceUrl(string);
                    if (registeredCimom.retrieve(dBConnection)) {
                        registeredCimom = new RegisteredCimom();
                        registeredCimom.setServiceUrl(string);
                        registeredCimom.setStatus(CIMOMConnectionStatus.PENDING_DELETION.toID());
                        registeredCimom.setStatusTimestamp(new Timestamp(System.currentTimeMillis()));
                        registeredCimom.update(dBConnection);
                        dBConnection.commit();
                        logTraceHelper.traceInfo("CIMOM " + string + " are set to PENDING_DELETION");
                    } else {
                        logTraceHelper.traceInfo("No Database entity for CIMOM " + string + ". Nothing to do.");
                    }
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)sQLException.getMessage(), (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (dBConnection != null) {
                    try {
                        dBConnection.close();
                    }
                    catch (Exception exception) {}
                }
                logTraceHelper.exit((Object)"null");
                throw throwable;
            }
            {
                Object var5_8 = null;
                if (dBConnection == null) break block13;
            }
            try {}
            catch (Exception exception) {}
            dBConnection.close();
        }
        logTraceHelper.exit((Object)"null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cleanupPendingCIMOMDeletions() {
        RegisteredCimom.RegisteredCimomCursor registeredCimomCursor;
        DBConnection dBConnection;
        LogTraceHelper logTraceHelper;
        block28: {
            block26: {
                block27: {
                    logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"processPendingCIMOMDeletion", null);
                    dBConnection = null;
                    registeredCimomCursor = null;
                    try {
                        try {
                            Iterator iterator;
                            dBConnection = ServiceUtils.getConnection();
                            if (dBConnection == null) {
                                Object var9_4 = null;
                                if (registeredCimomCursor == null) break block26;
                                break block27;
                            }
                            Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
                            hashtable.put(TResRegisteredCimomTable.getColumnInfo((String)"STATUS"), Short.toString(CIMOMConnectionStatus.PENDING_DELETION.toID()));
                            registeredCimomCursor = RegisteredCimom.getCursor((DBConnection)dBConnection, hashtable, null);
                            while (true) {
                                Object object;
                                if (!registeredCimomCursor.next()) {
                                    registeredCimomCursor.close();
                                    registeredCimomCursor = null;
                                    dBConnection.commit();
                                    object = new HashSet(stPendingCIMOMDeletions);
                                    iterator = object.iterator();
                                    break;
                                }
                                object = registeredCimomCursor.getObject().getServiceUrl();
                                stPendingCIMOMDeletions.add(object);
                            }
                            while (iterator.hasNext()) {
                                String string = (String)iterator.next();
                                Map map = stUsedCIMOMs;
                                synchronized (map) {
                                    if (!stUsedCIMOMs.containsKey(string)) {
                                        this.processPendingCIMOMDeletion(string);
                                    }
                                }
                            }
                            break block28;
                        }
                        catch (SQLException sQLException) {
                            logTraceHelper.traceError(sQLException.getMessage(), (Throwable)sQLException);
                            break block28;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_5 = null;
                        if (registeredCimomCursor != null) {
                            try {
                                registeredCimomCursor.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (dBConnection != null) {
                            try {
                                dBConnection.close();
                            }
                            catch (Exception exception) {}
                        }
                        logTraceHelper.exit((Object)"null");
                        throw throwable;
                    }
                }
                try {}
                catch (Exception exception) {}
                registeredCimomCursor.close();
            }
            if (dBConnection != null) {
                try {}
                catch (Exception exception) {}
                dBConnection.close();
            }
            logTraceHelper.exit((Object)"null");
            return;
        }
        Object var9_6 = null;
        if (registeredCimomCursor != null) {
            try {}
            catch (Exception exception) {}
            registeredCimomCursor.close();
        }
        if (dBConnection != null) {
            try {}
            catch (Exception exception) {}
            dBConnection.close();
        }
        logTraceHelper.exit((Object)"null");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPendingCIMOMDeletion(String string) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"processPendingCIMOMDeletion", (Object[])new Object[]{string});
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"pCimomURLs", (Object)string, (LogTraceHelper)logTraceHelper);
            }
            catch (MissingParameterException missingParameterException) {
                throw DiskMessageHelper.getServerException((String)"HWN020002E", (Object)missingParameterException.getMessage(), (Throwable)missingParameterException, (LogTraceHelper)logTraceHelper);
            }
            try {
                DBConnection dBConnection = ServiceUtils.getConnection();
                if (dBConnection == null) {
                    throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)logTraceHelper);
                }
                try {
                    try {
                        RegisteredCimom registeredCimom = new RegisteredCimom();
                        registeredCimom.setServiceUrl(string);
                        if (registeredCimom.retrieve(dBConnection)) {
                            ServiceUtils.getEventMonitorProxy().handleDeviceStateChange(PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString(), RegisteredCimom.getTablename(), new Integer(registeredCimom.getRegCimomId()).toString(), 1, 0);
                            int n = this.deleteNamespacesOfCimom(dBConnection, Integer.toString(registeredCimom.getRegCimomId()));
                            logTraceHelper.traceInfo("Related entities (namespaces and cimkeys) for CIMOM " + string + " deleted (" + Integer.toString(n) + " rows).");
                            if (registeredCimom.delete(dBConnection) > 0) {
                                logTraceHelper.traceInfo("Database entity for CIMOM " + string + " deleted");
                            } else {
                                logTraceHelper.traceWarning("Logic error. CIMOM entity was found on retrieve but not on delete.");
                            }
                            int[] nArray = this.markDevicesAsMissing(dBConnection);
                            logTraceHelper.traceInfo("Marked " + Integer.toString(nArray[0]) + " subsystems, " + Integer.toString(nArray[1]) + " tape libraries and " + Integer.toString(nArray[2]) + " switches as missing.");
                        } else {
                            logTraceHelper.traceInfo("No Database entity for CIMOM " + string + ". Nothing to do.");
                        }
                        dBConnection.commit();
                        stPendingCIMOMDeletions.remove(string);
                        stConcurrentAccess.remove(string);
                        stSaxParsing.remove(string);
                        logTraceHelper.traceInfo("CIMOM " + string + " deleted.");
                    }
                    catch (Exception exception) {
                        logTraceHelper.traceError("Failed to delete database entity for CIMOM" + string + ".Rolling back", (Throwable)exception);
                        dBConnection.rollback();
                        throw exception;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    dBConnection.close();
                    throw throwable;
                }
                {
                    Object var7_12 = null;
                    dBConnection.close();
                }
            }
            catch (Exception exception) {
                throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)exception.getMessage(), (Throwable)exception, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var9_15 = null;
        }
        logTraceHelper.exit(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int deleteNamespacesOfCimom(DBConnection dBConnection, String string) throws SQLException {
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>(2);
        hashtable.put(TResCimom2namespaceTable.getColumnInfo((String)"CIMOM_ID"), string);
        Cimom2namespace.Cimom2namespaceCursor cimom2namespaceCursor = Cimom2namespace.getCursor((DBConnection)dBConnection, hashtable, null);
        int n = 0;
        try {
            while (cimom2namespaceCursor.next()) {
                Cimom2namespace cimom2namespace = cimom2namespaceCursor.getObject();
                String string2 = Integer.toString(cimom2namespace.getCimNamespaceId());
                n += this.deleteCimKeysOfNamespace(dBConnection, string2);
                n += cimom2namespace.delete(dBConnection);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            cimom2namespaceCursor.close();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        cimom2namespaceCursor.close();
        return n;
    }

    private int[] markDevicesAsMissing(DBConnection dBConnection) throws SQLException {
        Object object;
        String string;
        Object object2;
        Object object3;
        Hashtable hashtable = new Hashtable(2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int[] nArray = new int[3];
        LinkedList linkedList = this.getMissingSubsystemIDs(dBConnection);
        if (!linkedList.isEmpty()) {
            object3 = this.convertLinkedListToCommaSeparatedString(linkedList);
            object2 = "UPDATE " + TResStorageSubsystemTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "SUBSYSTEM_ID" + " IN (" + (String)object3 + ")";
            nArray[0] = ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)object2, hashtable);
            hashMap.put(TResStorageSubsystemTable.getTablename(), linkedList);
        } else {
            nArray[0] = 0;
        }
        object3 = this.getMissingTapeLibraries(dBConnection);
        if (!((AbstractCollection)object3).isEmpty()) {
            object2 = this.convertLinkedListToCommaSeparatedString((LinkedList)object3);
            string = "UPDATE " + TResTapeLibraryTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "TAPE_LIBRARY_ID" + " IN (" + (String)object2 + ")";
            nArray[1] = ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)string, hashtable);
            hashMap.put(TResTapeLibraryTable.getTablename(), object3);
        } else {
            nArray[1] = 0;
        }
        object2 = this.getMissingSwitches(dBConnection);
        if (!((AbstractCollection)object2).isEmpty()) {
            string = this.convertLinkedListToCommaSeparatedString((LinkedList)object2);
            object = "UPDATE " + TResSwitchTable.getTablename() + " SET " + "DETECTABLE" + "=0 WHERE " + "SWITCH_ID" + " IN (" + string + ")";
            nArray[2] = ComplexQuery.sqlUpdate((DBConnection)dBConnection, (String)object, hashtable);
            hashMap.put(TResSwitchTable.getTablename(), object2);
        } else {
            nArray[2] = 0;
        }
        if (!hashMap.isEmpty()) {
            string = PROCESSID_PREFIX + CIMOMManager.getUniqueNumberString();
            object = new ChangeDetection(dBConnection);
            dBConnection.commit();
            object.complete(dBConnection, hashMap, string);
            ServiceUtils.getEventMonitorProxy().handleModelUpdate(string);
        }
        if (!dBConnection.getAutoCommit()) {
            dBConnection.commit();
        }
        return nArray;
    }

    private LinkedList getMissingTapeLibraries(DBConnection dBConnection) throws SQLException {
        String string = "SELECT TAPE_LIBRARY_ID FROM " + TResTapeLibraryTable.getTablename() + " WHERE (SELECT COUNT(*) FROM " + TResCimkeyTapeLibraryTable.getTablename() + " WHERE " + "TAPE_LIBRARY_ID" + "=" + TResTapeLibraryTable.getTablename() + "." + "TAPE_LIBRARY_ID" + ")=0";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string, null);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (dBResultSet.next()) {
            linkedList.add(dBResultSet.getString(1));
        }
        dBResultSet.close();
        return linkedList;
    }

    private LinkedList getMissingSwitches(DBConnection dBConnection) throws SQLException {
        String string = "SELECT ELEMENT_ID FROM " + TResElementProbeStatusTable.getTablename() + " WHERE " + "PROBE_FOUND" + "!=1 AND " + "ELEMENT_ID" + " IN (SELECT " + "SWITCH_ID" + " FROM " + TResSwitchTable.getTablename() + " WHERE (SELECT COUNT(*) FROM " + TResCimkeySwitchTable.getTablename() + " WHERE " + "SWITCH_WWN" + "=" + TResSwitchTable.getTablename() + "." + "SWITCH_WWN" + ")=0 )";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string, null);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (dBResultSet.next()) {
            linkedList.add(dBResultSet.getString(1));
        }
        dBResultSet.close();
        return linkedList;
    }

    private String convertLinkedListToCommaSeparatedString(LinkedList linkedList) {
        String string = "";
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            string = String.valueOf(string) + (String)iterator.next();
            string = String.valueOf(string) + ",";
        }
        if (string.indexOf(",") >= 0) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private LinkedList getMissingSubsystemIDs(DBConnection dBConnection) throws SQLException {
        String string = "SELECT SUBSYSTEM_ID FROM " + TResStorageSubsystemTable.getTablename() + " WHERE (SELECT COUNT(*) FROM " + TResCimkeySubsystemTable.getTablename() + " WHERE " + "SUBSYSTEM_ID" + "=" + TResStorageSubsystemTable.getTablename() + "." + "SUBSYSTEM_ID" + ")=0";
        DBResultSet dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string, null);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (dBResultSet.next()) {
            linkedList.add(dBResultSet.getString(1));
        }
        dBResultSet.close();
        return linkedList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int deleteCimKeysOfNamespace(DBConnection dBConnection, String string) throws SQLException {
        int n = 0;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>(2);
        hashtable.put(TResCimkeyHostTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), string);
        n += CimkeyHost.deletes((DBConnection)dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeyPortTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), string);
        n += CimkeyPort.deletes((DBConnection)dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeySwitchTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), string);
        n += CimkeySwitch.deletes((DBConnection)dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeyTapeLibraryTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), string);
        n += CimkeyTapeLibrary.deletes((DBConnection)dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeyVolumeTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), string);
        n += CimkeyVolume.deletes((DBConnection)dBConnection, hashtable);
        hashtable.clear();
        hashtable.put(TResCimkeySubsystemTable.getColumnInfo((String)"CIM_NAMESPACE_ID"), string);
        CimkeySubsystem.CimkeySubsystemCursor cimkeySubsystemCursor = CimkeySubsystem.getCursor((DBConnection)dBConnection, hashtable, null);
        try {
            while (cimkeySubsystemCursor.next()) {
                CimkeySubsystem cimkeySubsystem = cimkeySubsystemCursor.getObject();
                CapabilityData capabilityData = new CapabilityData();
                capabilityData.setCapabilityDataId(cimkeySubsystem.getCapabilityDataId());
                if (capabilityData.retrieve(dBConnection)) {
                    n += capabilityData.delete(dBConnection);
                }
                n += cimkeySubsystem.delete(dBConnection);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            cimkeySubsystemCursor.close();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        cimkeySubsystemCursor.close();
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cIMOMArray) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"testCIMOMConnection", (Object[])cIMOMArray);
        CIMOMConnectionStatus[] cIMOMConnectionStatusArray = null;
        try {
            cIMOMConnectionStatusArray = this.testCIMOMConnection(cIMOMArray, null).getCimomStatus();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit((Object)cIMOMConnectionStatusArray);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit((Object)cIMOMConnectionStatusArray);
        return cIMOMConnectionStatusArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] var1_1, CIMObjectPath var2_2) throws ServerException {
        var3_3 = LogTraceHelper.entry((Object)this, (String)"testCIMOMConnection", (Object[])var1_1);
        var4_4 = null;
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"pCimoms", (Object)var1_1, (LogTraceHelper)var3_3);
            }
            catch (MissingParameterException var5_5) {
                throw DiskMessageHelper.getServerException((String)"HWN020002E", (Object)var5_5.getMessage(), (Throwable)var5_5, (LogTraceHelper)var3_3);
            }
            var5_6 = var1_1.length;
            var6_7 = new CIMOMConnectionStatus[var5_6];
            var7_8 = new DeviceStatus[var5_6];
            var8_9 = 0;
            while (true) {
                if (var8_9 >= var5_6) {
                    var8_10 = DiskManagerConfigSvc.getLongConfigValue((String)"CIMOMManager.TestConnectionTimeout", (long)45000L);
                    var10_11 = DiskThreadManager.getExecutionGroup();
                    var11_12 = new Long[var5_6];
                    ** try [egrp 2[TRYBLOCK] [3 : 112->1089)] { 
lbl19:
                    // 1 sources

                    break;
                }
                var6_7[var8_9] = CIMOMConnectionStatus.UNCONFIGURED;
                var7_8[var8_9] = DeviceStatus.INVALID;
                ++var8_9;
            }
            {
                try {
                    var12_13 = 0;
                    while (true) {
                        if (var12_13 >= var5_6) {
                            var10_11.waitForCompletion(var8_10);
                            var12_13 = 0;
                            break;
                        }
                        var13_17 /* !! */  = null;
                        if (var2_2 == null) {
                            var13_17 /* !! */  = new Object[]{var1_1[var12_13]};
                            var11_12[var12_13] = var10_11.execute((Object)this, "testOneCIMOMConnection", var13_17 /* !! */ , var3_3);
                        } else {
                            var13_17 /* !! */  = new Object[]{var1_1[var12_13], var2_2};
                            var11_12[var12_13] = var10_11.execute((Object)this, "testOneDeviceConnection", var13_17 /* !! */ , var3_3);
                        }
                        ++var12_13;
                    }
                    while (var12_13 < var5_6) {
                        block44: {
                            block45: {
                                var13_17 /* !! */  = var10_11.getExecutionError(var11_12[var12_13]);
                                if (var13_17 /* !! */  != null) break block45;
                                var14_22 = var10_11.getExecutionResult(var11_12[var12_13]);
                                if (var14_22 instanceof CIMOMConnectionStatus) {
                                    var15_23 = (CIMOMConnectionStatus)var14_22;
                                    var3_3.traceInfo("test CIMOM connection thread " + var11_12[var12_13] + " returned CIMOMConnectionStatus " + var15_23.toString());
                                    var6_7[var12_13] = var15_23;
                                    break block44;
                                } else if (var14_22 instanceof DeviceStatus) {
                                    var15_23 = (DeviceStatus)var14_22;
                                    var3_3.traceInfo("test CIMOM connection thread " + var11_12[var12_13] + " returned device connection status " + var15_23.toString());
                                    var6_7[var12_13] = CIMOMConnectionStatus.SUCCESS;
                                    var7_8[var12_13] = var15_23;
                                }
                                break block44;
                            }
                            if (var13_17 /* !! */  instanceof CIMException) {
                                var14_22 = (CIMException)var13_17 /* !! */ ;
                                var15_23 = var13_17 /* !! */ .getCause();
                                if (var15_23 instanceof SSLHandshakeException || var15_23 instanceof SSLProtocolException) {
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible due to SSLHandshakeException or SSLProtocolException. " + "This exception might be due to an invalid SLP registration, e.g. \"http\" instead of \"https\".", var15_23);
                                    var6_7[var12_13] = CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR;
                                } else {
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible due to a non-SSLCIM Exception", var15_23);
                                    var16_24 = var14_22.getParams();
                                    var17_25 = var14_22.getID();
                                    if (var17_25 != null && var17_25.equals("CIM_ERR_ACCESS_DENIED")) {
                                        var3_3.traceInfo(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible due to an invalid username or password.");
                                        var6_7[var12_13] = CIMOMConnectionStatus.LOGIN_FAILED;
                                    } else if (var17_25 != null && var17_25.indexOf("CMMOM0104E") != -1) {
                                        var3_3.traceInfo(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible for one of the following reasons: " + "The SLP registration is invalid (port or IP is wrong), " + "The machine where the CIMOM is running is down, " + "The CIMOM service is not running, " + "The firewall is misconfigured.");
                                        var6_7[var12_13] = CIMOMConnectionStatus.TIMEOUT;
                                    } else if (var16_24 != null && var16_24.length != 0) {
                                        var18_26 = 0;
                                        while (var18_26 < var16_24.length) {
                                            var19_27 = var16_24[var18_26];
                                            if (var19_27.toString().indexOf("CMMOM0026E") != -1) {
                                                var3_3.traceInfo(String.valueOf(var1_1[var12_13].getServiceUrl()) + " not accessible due to an invalid SLP registration. " + "In this case the SLP attribute identifying the CIM namespace seems to be wrong. " + "The namespace that was reported via SLP oder set via cmd line options is: " + var1_1[var12_13].getInteropSchemaNamespace());
                                                var6_7[var12_13] = CIMOMConnectionStatus.SSL_REGISTRATION_INVALID;
                                            } else {
                                                var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " unexpected error case parameter " + var19_27.toString(), var15_23);
                                            }
                                            ++var18_26;
                                        }
                                    }
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " unexpected error case ", var15_23);
                                }
                            } else if (var13_17 /* !! */  instanceof DiskManagerTimeoutException) {
                                if (var2_2 == null) {
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " EnumInstances call on CIM client timed out: " + var13_17 /* !! */ .toString(), (Throwable)var13_17 /* !! */ );
                                } else {
                                    var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " EnumerateInstanceNames call on CIM client timed out: " + var13_17 /* !! */ .toString(), (Throwable)var13_17 /* !! */ );
                                }
                                var6_7[var12_13] = CIMOMConnectionStatus.TIMEOUT;
                            } else {
                                var3_3.traceError(String.valueOf(var1_1[var12_13].getServiceUrl()) + " Internal error: " + var13_17 /* !! */ .toString(), (Throwable)var13_17 /* !! */ );
                                var6_7[var12_13] = CIMOMConnectionStatus.UNKNOWN;
                            }
                        }
                        ++var12_13;
                    }
                    ** GOTO lbl-1000
                }
                catch (DiskManagerTimeoutException var12_14) {
                    var3_3.traceError("Internal error: DiskManagerTimeoutException, whole ExecutionGroup timed out", (Throwable)var12_14);
                    var13_18 = 0;
                }
                while (var13_18 < var5_6) {
                    var6_7[var13_18] = CIMOMConnectionStatus.TIMEOUT;
                    ++var13_18;
                }
                ** GOTO lbl-1000
                catch (DiskManagerExecException var12_15) {
                    var3_3.traceError("Internal error: DiskManagerExecException in ExecutionGroupFramework", (Throwable)var12_15);
                    var13_19 = 0;
                }
                while (var13_19 < var5_6) {
                    var6_7[var13_19] = CIMOMConnectionStatus.UNKNOWN;
                    ++var13_19;
                }
            }
lbl116:
            // 1 sources

            catch (Throwable var21_28) {
                var20_29 = null;
                var10_11.clear();
                throw var21_28;
            }
lbl-1000:
            // 3 sources

            {
                var20_30 = null;
            }
            var10_11.clear();
            var4_4 = new CimomAndDeviceStatus(var6_7, var7_8);
            var12_16 = 0;
            while (var12_16 < var5_6) {
                var13_21 = CIMOMManager.getCIMOMs((String[])new String[]{var1_1[var12_16].getServiceUrl()});
                if (var13_21.length != 0) {
                    if (var13_21[0].matches(var1_1[var12_16])) {
                        var1_1[var12_16].setStatus(var6_7[var12_16]);
                        if (!this.persistCIMOMStatus(var1_1[var12_16]).booleanValue()) {
                            var3_3.traceError("Failed to update cimom status in database entity", null);
                        }
                    } else {
                        var3_3.traceInfo("Skipped to update cimom status due to attribute mismatch for " + var1_1[var12_16].getServiceUrl());
                    }
                }
                ++var12_16;
            }
        }
        catch (Throwable var23_31) {
            var22_32 = null;
            var3_3.exit(var4_4);
            throw var23_31;
        }
        {
            var22_33 = null;
        }
        var3_3.exit((Object)var4_4);
        return var4_4;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMOMConnectionStatus testOneCIMOMConnection(CIMOM var1_1) throws CIMException, DiskManagerTimeoutException {
        var2_2 = CIMOMConnectionStatus.UNCONFIGURED;
        var3_3 = LogTraceHelper.entry((Object)this, (String)"testOneCIMOMConnection", (Object[])new Object[]{var1_1});
        var4_4 = null;
        try {
            var5_5 = var1_1.getServiceUrl();
            var6_6 = var1_1.getInteropSchemaNamespace();
            var3_3.traceInfo("Getting CIM client");
            var7_7 = CIMClientPool.getClient((String)var1_1.getUserId(), (String)var1_1.getPassword(), (String)var1_1.getServiceUrl(), (String)var6_6);
            try {
                try {
                    try {
                        var4_4 = (CIMEnumeration)var7_7.enumerateInstanceNames(new CIMObjectPath("CIM_RegisteredProfile"), var3_3);
                        var2_2 = CIMOMConnectionStatus.SUCCESS;
                    }
                    catch (Throwable var9_8) {
                        var8_11 = null;
                        if (var4_4 == null) throw var9_8;
                        var4_4.close();
                        var4_4 = null;
                        throw var9_8;
                    }
                    {
                        var8_12 = null;
                        if (var4_4 != null) {
                            var4_4.close();
                            var4_4 = null;
                        }
                    }
                }
                catch (CIMSecurityException var8_13) {
                    var3_3.traceError("Exception received while trying to connect to " + var5_5 + " due to " + var8_13.getMessage(), (Throwable)var8_13);
                    var2_2 = CIMOMConnectionStatus.SSL_REGISTRATION_INVALID;
                }
                catch (CIMTransportException var8_14) {
                    block39: {
                        var3_3.traceError("Exception received while trying to connect to " + var5_5 + " due to " + var8_14.getMessage(), (Throwable)var8_14);
                        if (var8_14.getDescription().indexOf("Unauthorized") == -1) break block39;
                        var2_2 = CIMOMConnectionStatus.LOGIN_FAILED;
                        ** GOTO lbl-1000
                    }
                    var2_2 = CIMOMConnectionStatus.REFUSED;
                }
                catch (CIMAuthenticationException var8_15) {
                    var3_3.traceError("Exception received while trying to connect to " + var5_5 + " due to " + var8_15.getMessage(), (Throwable)var8_15);
                    var2_2 = CIMOMConnectionStatus.LOGIN_FAILED;
                }
                catch (DiskManagerRTException var8_16) {
                    block43: {
                        block42: {
                            block41: {
                                block40: {
                                    var3_3.traceError("Exception received while trying to connect to " + var5_5 + " due to " + var8_16.getMessage(), (Throwable)var8_16);
                                    if (var8_16.getMessage().indexOf("InvocationTargetException") == -1) break block40;
                                    try {
                                        try {
                                            var4_4 = (CIMEnumeration)var7_7.enumerateInstanceNames(new CIMObjectPath("CIM_ComputerSystem"), var3_3);
                                            var2_2 = CIMOMConnectionStatus.SUCCESS;
                                        }
                                        catch (Exception var9_9) {
                                            var3_3.traceError("Did not find CIM_ComputerSystem in namespace " + var6_6 + " for CIMOM " + var5_5 + " because of " + var8_16.getMessage(), (Throwable)var9_9);
                                            var2_2 = CIMOMConnectionStatus.UNKNOWN;
                                        }
                                    }
                                    catch (Throwable var11_19) {
                                        var10_21 = null;
                                        if (var4_4 == null) throw var11_19;
                                        try {
                                            var4_4.close();
                                            throw var11_19;
                                        }
                                        catch (Exception v0) {}
                                        throw var11_19;
                                    }
                                    {
                                        var10_22 = null;
                                        if (var4_4 != null) {
                                            try {}
                                            catch (Exception v1) {}
                                            var4_4.close();
                                        }
                                        ** GOTO lbl-1000
                                    }
                                }
                                if (var8_16.getMessage().indexOf("EXT_ERR_UNABLE_TO_CONNECT") == -1) break block41;
                                var2_2 = CIMOMConnectionStatus.REFUSED;
                                ** GOTO lbl-1000
                            }
                            if (var8_16.getMessage().indexOf("EXT_ERR_TIME_OUT") == -1) break block42;
                            var2_2 = CIMOMConnectionStatus.TIMEOUT;
                            ** GOTO lbl-1000
                        }
                        if (var8_16.getMessage().indexOf("EXT_ERR_NO_CIMOM") == -1 && var8_16.getMessage().indexOf("EXT_ERR_UNKNOWN_SERVER") == -1) break block43;
                        var2_2 = CIMOMConnectionStatus.UNCONFIGURED;
                        ** GOTO lbl-1000
                    }
                    var2_2 = CIMOMConnectionStatus.UNKNOWN;
                }
                catch (CIMException var8_17) {
                    block47: {
                        block46: {
                            block45: {
                                block44: {
                                    var3_3.traceError("Did not find CIM_RegisteredProfile in namespace " + var6_6 + " for CIMOM " + var5_5 + " because of " + var8_17.getMessage() + " - now testing for computer system", (Throwable)var8_17);
                                    if (var8_17.getID().indexOf("CIM_ERR_NOT_FOUND") == -1 && var8_17.getID().indexOf("CIM_ERR_INVALID_CLASS") == -1) break block44;
                                    try {
                                        try {
                                            var4_4 = (CIMEnumeration)var7_7.enumerateClassNames(new CIMObjectPath("CIM_ComputerSystem"), var3_3);
                                            var2_2 = CIMOMConnectionStatus.SUCCESS;
                                        }
                                        catch (CIMException var9_10) {
                                            var3_3.traceError("Did not find CIM_ComputerSystem in namespace " + var6_6 + " for CIMOM " + var5_5 + " because of " + var8_17.getMessage(), (Throwable)var9_10);
                                            var2_2 = CIMOMConnectionStatus.UNKNOWN;
                                        }
                                    }
                                    catch (Throwable var11_20) {
                                        var10_23 = null;
                                        if (var4_4 == null) throw var11_20;
                                        try {
                                            var4_4.close();
                                            throw var11_20;
                                        }
                                        catch (Exception v2) {}
                                        throw var11_20;
                                    }
                                    {
                                        var10_24 = null;
                                        if (var4_4 != null) {
                                            try {}
                                            catch (Exception v3) {}
                                            var4_4.close();
                                        }
                                        ** GOTO lbl-1000
                                    }
                                }
                                if (var8_17.toString().indexOf("CIM_ERR_NAMESPACE_NOT_IN_MANAGER") == -1 && var8_17.toString().indexOf("CIM_ERR_INVALID_NAMESPACE") == -1) break block45;
                                var2_2 = CIMOMConnectionStatus.INVALID_NAMESPACE;
                                ** GOTO lbl-1000
                            }
                            if (var8_17.toString().indexOf("challenge") == -1) break block46;
                            var2_2 = CIMOMConnectionStatus.LOGIN_FAILED;
                            ** GOTO lbl-1000
                        }
                        if (var8_17.toString().indexOf("TIME_OUT") == -1) break block47;
                        var2_2 = CIMOMConnectionStatus.TIMEOUT;
                        ** GOTO lbl-1000
                    }
                    var2_2 = CIMOMConnectionStatus.UNKNOWN;
                }
                catch (Exception var8_18) {
                    var3_3.traceError("Exception received while trying to connect to " + var5_5 + " due to " + var8_18.getMessage(), (Throwable)var8_18);
                    var2_2 = CIMOMConnectionStatus.UNKNOWN;
                }
            }
            catch (Throwable var13_25) {
                var12_26 = null;
                if (var7_7 == null) throw var13_25;
                try {
                    CIMClientPool.returnClient((CIMClientWrapper)var7_7);
                    throw var13_25;
                }
                catch (CIMException var14_28) {
                    var3_3.traceError("Failed to close CIMClientWrapper in testOneCIMOMConnection due to " + var14_28.getMessage(), (Throwable)var14_28);
                }
                throw var13_25;
            }
lbl-1000:
            // 19 sources

            {
                var12_27 = null;
                if (var7_7 != null) {
                    ** try [egrp 13[TRYBLOCK] [18 : 905->913)] { 
lbl147:
                    // 1 sources

                    CIMClientPool.returnClient((CIMClientWrapper)var7_7);
lbl149:
                    // 1 sources

                    catch (CIMException var14_29) {
                        var3_3.traceError("Failed to close CIMClientWrapper in testOneCIMOMConnection due to " + var14_29.getMessage(), (Throwable)var14_29);
                    }
                }
            }
        }
        catch (Throwable var16_30) {
            var15_31 = null;
            var3_3.exit((Object)var2_2);
            throw var16_30;
        }
        {
            var15_32 = null;
        }
        var3_3.exit((Object)var2_2);
        return var2_2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeviceStatus testOneDeviceConnection(CIMOM var1_1, CIMObjectPath var2_2) throws CIMException, DiskManagerTimeoutException {
        block11: {
            var3_3 = LogTraceHelper.entry((Object)this, (String)"testOneDeviceConnection", (Object[])new Object[]{var1_1, var2_2});
            var4_4 = null;
            var5_5 = null;
            try {
                var5_5 = DeviceStatus.INVALID;
                var6_6 = var1_1.getServiceUrl();
                var7_7 = var2_2.getNameSpace();
                if (var7_7 == null || var7_7.trim().length() == 0) {
                    var7_7 = var1_1.getInteropSchemaNamespace();
                }
                var3_3.traceInfo("Testing device status for CIMOM " + var6_6 + " in namespace " + var7_7);
                var3_3.traceInfo("Getting CIM client");
                var4_4 = CIMClientPool.getClient((String)var1_1.getUserId(), (String)var1_1.getPassword(), (String)var6_6, (String)var7_7);
                var3_3.traceInfo("Get instance for COP: " + var2_2);
                var8_8 = var4_4.getInstance(var2_2, false, true, false, var3_3);
                if (var8_8 != null) {
                    var3_3.traceInfo("Getting OperationalStatus property for " + var2_2);
                    var9_9 = var8_8.getProperty("OperationalStatus");
                    if (var9_9 != null) {
                        var3_3.traceInfo("Getting value of OperationalStatus property for " + var2_2);
                        var5_5 = new CIMDeviceStatus(var9_9);
                    }
                }
            }
            catch (Throwable var11_10) {
                var10_11 = null;
                if (var4_4 != null) {
                    try {
                        CIMClientPool.returnClient(var4_4);
                    }
                    catch (CIMException var12_13) {
                        var3_3.traceError("Failed to close CIMClientWrapper in testOneCIMOMConnection due to " + var12_13.getMessage(), (Throwable)var12_13);
                    }
                }
                var3_3.exit((Object)var5_5);
                throw var11_10;
            }
            {
                var10_12 = null;
                if (var4_4 == null) break block11;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 246->254)] { 
lbl38:
            // 1 sources

            CIMClientPool.returnClient((CIMClientWrapper)var4_4);
            break block11;
lbl40:
            // 1 sources

            catch (CIMException var12_14) {
                var3_3.traceError("Failed to close CIMClientWrapper in testOneCIMOMConnection due to " + var12_14.getMessage(), (Throwable)var12_14);
            }
        }
        var3_3.exit((Object)var5_5);
        return var5_5;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result testDeviceStatus(String string, String string2) {
        Result result;
        LogTraceHelper logTraceHelper;
        block37: {
            Result result2;
            block33: {
                logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"testDeviceStatus", (Object[])new Object[]{string, string2});
                result = new Result();
                try {
                    try {
                        ParameterChecker.assertMandatoryParameter((int)1, (String)"pServiceURL", (Object)string, (LogTraceHelper)logTraceHelper);
                        ParameterChecker.assertMandatoryParameter((int)2, (String)"pDeviceID", (Object)string2, (LogTraceHelper)logTraceHelper);
                    }
                    catch (MissingParameterException missingParameterException) {
                        String string3;
                        logTraceHelper.traceError("Missing parameter ", (Throwable)missingParameterException);
                        switch (missingParameterException.getParameterNumber()) {
                            case 1: {
                                string3 = "pServiceURL";
                                break;
                            }
                            case 2: {
                                string3 = "pDeviceID";
                                break;
                            }
                            default: {
                                string3 = "unknown";
                            }
                        }
                        result.setSRMMessage("HWN020002E", new String[]{string3});
                        result.setRc(10030);
                        Result result3 = result;
                        Object var27_11 = null;
                        logTraceHelper.exit((Object)result);
                        return result3;
                    }
                    DBConnection dBConnection = ServiceUtils.getConnection();
                    if (dBConnection == null) {
                        result.setSRMMessage("HWN021800E", new String[0]);
                        result.setRc(10030);
                        result2 = result;
                        Object var27_12 = null;
                        break block33;
                    }
                    int n = string2.indexOf("+");
                    boolean bl = n > -1;
                    RegisteredCimom registeredCimom = null;
                    StorageSubsystem storageSubsystem = null;
                    int n2 = 0;
                    CimkeySubsystem cimkeySubsystem = null;
                    CimkeySwitch cimkeySwitch = null;
                    Vector vector = null;
                    try {
                        try {
                            int n3;
                            int n4;
                            try {
                                registeredCimom = new RegisteredCimom();
                                registeredCimom.setServiceUrl(string);
                                registeredCimom.retrieve(dBConnection);
                                n4 = registeredCimom.getRegCimomId();
                            }
                            catch (SQLException sQLException) {
                                logTraceHelper.traceError("Unable to retrieve RegisteredCimom for " + string, (Throwable)sQLException);
                                result.setSRMMessage("HWN021801E", new String[0]);
                                result.setRc(10030);
                                throw sQLException;
                            }
                            if (bl) {
                                String string4 = string2.substring(0, n);
                                n3 = Short.valueOf(string2.substring(string2.indexOf("+") + 1, string2.length())).shortValue();
                                try {
                                    storageSubsystem = new StorageSubsystem();
                                    storageSubsystem.setName(string4);
                                    storageSubsystem.setNameFormat((short)n3);
                                    storageSubsystem.retrieve(dBConnection);
                                    n2 = storageSubsystem.getSubsystemId();
                                }
                                catch (SQLException sQLException) {
                                    logTraceHelper.traceError("Unable to retrieve StorageSubsystem for " + string2, (Throwable)sQLException);
                                    result.setSRMMessage("HWN021504E", new String[]{string2});
                                    result.setRc(10030);
                                    throw sQLException;
                                }
                            }
                            vector = this.getNamespacesForServiceUrl(logTraceHelper, string);
                            int n5 = 0;
                            while (n5 < vector.size()) {
                                block34: {
                                    CIMOMConnectionStatus cIMOMConnectionStatus;
                                    block38: {
                                        String string5 = (String)vector.get(n5);
                                        try {
                                            Cimom2namespace cimom2namespace = new Cimom2namespace();
                                            cimom2namespace.setCimomId(n4);
                                            cimom2namespace.setNamespace(string5);
                                            cimom2namespace.retrieve(dBConnection);
                                            n3 = cimom2namespace.getCimNamespaceId();
                                        }
                                        catch (SQLException sQLException) {
                                            if (n5 == vector.size() - 1) {
                                                logTraceHelper.traceError("Unable to retrieve Cimom2namespace for CIMOM ID" + n4 + " and namespace " + string5, (Throwable)sQLException);
                                                result.setSRMMessage("HWN021802E", new String[0]);
                                                result.setRc(10030);
                                                throw sQLException;
                                            }
                                            logTraceHelper.traceError("Unable to retrieve Cimom2namespace for CIMOM ID" + n4 + " and namespace " + string5, (Throwable)sQLException);
                                            break block34;
                                        }
                                        try {
                                            if (bl) {
                                                cimkeySubsystem = new CimkeySubsystem();
                                                cimkeySubsystem.setSubsystemId(n2);
                                                cimkeySubsystem.setCimNamespaceId(n3);
                                                cimkeySubsystem.retrieve(dBConnection);
                                            } else {
                                                cimkeySwitch = new CimkeySwitch();
                                                cimkeySwitch.setSwitchWwn(string2);
                                                cimkeySwitch.setCimNamespaceId(n3);
                                                cimkeySwitch.retrieve(dBConnection);
                                            }
                                        }
                                        catch (SQLException sQLException) {
                                            if (n5 == vector.size() - 1) {
                                                logTraceHelper.traceError("Unable to retrieve Cimkey data for device " + string2 + " and CimNamespace ID " + n3, (Throwable)sQLException);
                                                result.setSRMMessage("HWN021802E", new String[0]);
                                                result.setRc(10030);
                                                throw sQLException;
                                            }
                                            logTraceHelper.traceError("Unable to retrieve Cimkey data for device " + string2 + " and CimNamespace ID " + n3, (Throwable)sQLException);
                                            break block34;
                                        }
                                        logTraceHelper.traceInfo("Testing device status for device with ID" + string2 + " thru CIMOM " + string + " in namespace " + string5);
                                        CIMOM[] cIMOMArray = CIMOMManager.getCIMOMs((String[])new String[]{string});
                                        CIMObjectPath cIMObjectPath = bl ? ExternalKeyManager.getCIMObjectPath((CimkeySubsystem)cimkeySubsystem, (String)string5) : ExternalKeyManager.getCIMObjectPath((CimkeySwitch)cimkeySwitch, (String)string5);
                                        CimomAndDeviceStatus cimomAndDeviceStatus = this.testCIMOMConnection(cIMOMArray, cIMObjectPath);
                                        cIMOMConnectionStatus = cimomAndDeviceStatus.getCimomStatus(0);
                                        DeviceStatus deviceStatus = cimomAndDeviceStatus.getDeviceStatus(0);
                                        if (!cIMOMConnectionStatus.isSuccess()) break block38;
                                        result.setSRMMessage("HWN021811I", new String[]{string2, string, deviceStatus.getStatusString()});
                                        result.setRc(0);
                                        break;
                                    }
                                    result.setSRMMessage("HWN021812E", new String[]{string2, string, cIMOMConnectionStatus.toString()});
                                    result.setRc(10030);
                                }
                                ++n5;
                            }
                        }
                        catch (SQLException sQLException) {
                            Result result4 = result;
                            Object var24_39 = null;
                            try {
                                dBConnection.close();
                            }
                            catch (SQLException sQLException2) {
                            }
                            Object var27_13 = null;
                            logTraceHelper.exit((Object)result);
                            return result4;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var24_40 = null;
                        try {}
                        catch (SQLException sQLException) {}
                        dBConnection.close();
                        throw throwable;
                        throw throwable;
                    }
                    {
                        Object var24_41 = null;
                        try {}
                        catch (SQLException sQLException) {}
                        dBConnection.close();
                    }
                    break block37;
                }
                catch (Throwable throwable) {
                    Object var27_14 = null;
                    logTraceHelper.exit((Object)result);
                    throw throwable;
                }
            }
            logTraceHelper.exit((Object)result);
            return result2;
        }
        Object var27_15 = null;
        logTraceHelper.exit((Object)result);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector getNamespacesForServiceUrl(LogTraceHelper logTraceHelper, String string) {
        Vector<String> vector = new Vector<String>();
        DBConnection dBConnection = ServiceUtils.getConnection();
        if (dBConnection == null) {
            throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)logTraceHelper);
        }
        String string2 = "select C2N.NAMESPACE from T_RES_CIMOM2NAMESPACE as C2N where C2N.CIMOM_ID IN (select RC.REG_CIMOM_ID from T_RES_REGISTERED_CIMOM as RC where RC.SERVICE_URL = '" + string + "'" + ")";
        DBResultSet dBResultSet = null;
        try {
            try {
                dBResultSet = ComplexQuery.sqlQuery((DBConnection)dBConnection, (String)string2, new Hashtable());
                while (true) {
                    block10: {
                        if (dBResultSet.next()) break block10;
                        dBConnection.commit();
                        break;
                    }
                    vector.add(dBResultSet.getString(1));
                }
            }
            catch (Exception exception) {
                logTraceHelper.traceError("Unable to retrieve namespaces for CIMOM" + string + " due to " + exception.getMessage(), (Throwable)exception);
                throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)exception.getMessage(), (Throwable)exception, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                dBConnection.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                logTraceHelper.traceError("Unable to close database connection due to " + sQLException.getMessage(), (Throwable)sQLException);
            }
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (SQLException sQLException) {
            logTraceHelper.traceError("Unable to close database connection due to " + sQLException.getMessage(), (Throwable)sQLException);
            return vector;
        }
        dBConnection.close();
        return vector;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getCIMOMIDs() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getCIMOMIDs", null);
        Object[] objectArray = null;
        try {
            DBConnection dBConnection = ServiceUtils.getConnection();
            if (dBConnection == null) {
                throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)logTraceHelper);
            }
            Vector<String> vector = new Vector<String>();
            RegisteredCimom.RegisteredCimomCursor registeredCimomCursor = null;
            try {
                try {
                    registeredCimomCursor = RegisteredCimom.getCursor((DBConnection)dBConnection, null, null);
                    if (registeredCimomCursor == null) {
                        throw DiskMessageHelper.getServerException((String)"HWN021801E", null, (LogTraceHelper)logTraceHelper);
                    }
                    while (registeredCimomCursor.next()) {
                        RegisteredCimom registeredCimom = registeredCimomCursor.getObject();
                        if (registeredCimom == null) {
                            throw DiskMessageHelper.getServerException((String)"HWN021801E", null, (LogTraceHelper)logTraceHelper);
                        }
                        if (registeredCimom.getStatus() != CIMOMConnectionStatus.PENDING_DELETION.toID()) {
                            vector.add(registeredCimom.getServiceUrl());
                            logTraceHelper.traceInfo("CIMOM ID " + registeredCimom.getServiceUrl() + " was retrieved");
                            continue;
                        }
                        logTraceHelper.traceInfo("CIMOM ID " + registeredCimom.getServiceUrl() + " was skipped because of deletion pending");
                    }
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)sQLException.getMessage(), (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (registeredCimomCursor != null) {
                        registeredCimomCursor.close();
                    }
                    dBConnection.close();
                    throw throwable;
                }
                catch (SQLException sQLException) {
                    throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)sQLException.getMessage(), (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
                }
            }
            {
                Object var7_10 = null;
            }
            try {}
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021802E", (Object)sQLException.getMessage(), (Throwable)sQLException, (LogTraceHelper)logTraceHelper);
            }
            if (registeredCimomCursor != null) {
                registeredCimomCursor.close();
            }
            dBConnection.close();
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            logTraceHelper.exit((Object)objectArray);
            throw throwable;
        }
        {
            Object var10_15 = null;
        }
        logTraceHelper.exit((Object)objectArray);
        return objectArray;
    }

    public AsyncResult discoverDevicesFromCIMOM(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        AsyncResult asyncResult;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"discoverDevicesFromCIMOM", (Object[])new Object[]{stringArray});
        Object var3_3 = null;
        try {
            Object object = Activator._serviceHelper.bindLocal("DiscoverService");
            if (object == null) {
                throw DiskMessageHelper.getServerException((String)"HWN021807E", null, (LogTraceHelper)logTraceHelper);
            }
            IDiscover iDiscover = (IDiscover)object;
            ParameterChecker.assertMandatoryParameter((int)1, (String)"CimomIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            AsyncResult asyncResult2 = new AsyncResult(0, -1);
            hashtable.put("CIMOMID_PARAM", stringArray);
            hashtable.put("Type", "ToplevelALL");
            logTraceHelper.traceSvcEntry("DiscoverServise.discover", new Object[]{hashtable});
            String string = iDiscover.discover("dispatchDiscoveryProcess", hashtable);
            logTraceHelper.traceSvcReturn("DiscoverServise.discover", (Object)string);
            asyncResult = asyncResult2 = iDiscover.getJobStatus(string);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logTraceHelper.exit(var3_3);
            throw throwable;
        }
        logTraceHelper.exit(var3_3);
        return asyncResult;
    }

    private int[] checkForDuplicateCIMOMs(CIMOM[] cIMOMArray, DBConnection dBConnection) {
        int[] nArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"checkForDuplicateCIMOMs", (Object[])new Object[]{cIMOMArray, dBConnection});
        int[] nArray2 = new int[cIMOMArray.length];
        try {
            CIMOM[] cIMOMArray2 = this.getCIMOMs();
            String string = null;
            String string2 = null;
            int n = 0;
            while (n < cIMOMArray.length) {
                try {
                    string = cIMOMArray[n].getServiceUrl();
                    string2 = String.valueOf(this.parseHost(string)) + ":" + this.parsePort(string);
                    if (string2.indexOf("null") > -1) {
                        nArray2[n] = 2;
                    } else {
                        int n2 = 0;
                        while (n2 < cIMOMArray2.length) {
                            if (cIMOMArray2[n2].getServiceUrl().indexOf(string2) > -1) {
                                nArray2[n] = 1;
                                break;
                            }
                            ++n2;
                        }
                        cIMOMArray[n].setServiceUrl(this.replaceHost(string, string2));
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    logTraceHelper.traceError(unknownHostException.getMessage(), (Throwable)unknownHostException);
                    nArray2[n] = 2;
                }
                ++n;
            }
            nArray = nArray2;
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            logTraceHelper.exit((Object)nArray2);
            throw throwable;
        }
        logTraceHelper.exit((Object)nArray2);
        return nArray;
    }

    private String parsePort(String string) {
        int n = string.indexOf("://");
        int n2 = string.indexOf(58, n + 1);
        if (n2 == -1 || n2 == string.length() - 1) {
            return null;
        }
        return string.substring(n2 + 1);
    }

    private String parseHost(String string) throws UnknownHostException {
        int n = string.indexOf("://");
        int n2 = string.indexOf(58, n + 1);
        if (n == -1 || n2 == -1 || n2 == string.length() - 1) {
            return null;
        }
        String string2 = string.substring(n + 3, n2);
        return InetAddress.getByName(string2).getHostAddress();
    }

    private String replaceHost(String string, String string2) {
        int n = string.indexOf("://");
        int n2 = string.indexOf(58, n + 1);
        if (n == -1 || n2 == -1 || n2 == string.length() - 1) {
            return null;
        }
        return String.valueOf(string.substring(0, n)) + "://" + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerCIMOMUsage(String string) {
        LogTraceHelper logTraceHelper;
        block12: {
            block11: {
                logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"registerCIMOMUsage", (Object[])new Object[]{string});
                try {
                    try {
                        block14: {
                            block13: {
                                if (string == null) break block13;
                                if (string.length() != 0) break block14;
                            }
                            Object var5_3 = null;
                            break block11;
                        }
                        Map map = stUsedCIMOMs;
                        synchronized (map) {
                            Integer n = (Integer)stUsedCIMOMs.get(string);
                            if (n == null) {
                                stUsedCIMOMs.put(string, new Integer(1));
                            } else {
                                n = new Integer(n + 1);
                                stUsedCIMOMs.put(string, n);
                            }
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        logTraceHelper.traceError("Exception with CIMOM " + string + ": " + throwable.getMessage(), throwable);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    logTraceHelper.exit((Object)"null");
                    throw throwable;
                }
            }
            logTraceHelper.exit((Object)"null");
            return;
        }
        Object var5_5 = null;
        logTraceHelper.exit((Object)"null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deRegisterCIMOMUsage(String string) {
        LogTraceHelper logTraceHelper;
        block13: {
            block12: {
                logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"registerCIMOMUsage", (Object[])new Object[]{string});
                try {
                    try {
                        int n;
                        block15: {
                            block14: {
                                if (string == null) break block14;
                                if (string.length() != 0) break block15;
                            }
                            Object var6_3 = null;
                            break block12;
                        }
                        Map map = stUsedCIMOMs;
                        synchronized (map) {
                            Integer n2 = (Integer)stUsedCIMOMs.get(string);
                            if (n2 == null) throw new Exception("Usage Count for CIMOM " + string + " not found!");
                            n = n2 - 1;
                            if (n == 0) {
                                stUsedCIMOMs.remove(string);
                            } else {
                                stUsedCIMOMs.put(string, new Integer(n));
                            }
                        }
                        if (n == 0 && stPendingCIMOMDeletions.contains(string)) {
                            this.processPendingCIMOMDeletion(string);
                        }
                        break block13;
                    }
                    catch (Throwable throwable) {
                        logTraceHelper.traceError("Exception with CIMOM " + string + ": " + throwable.getMessage(), throwable);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    logTraceHelper.exit((Object)"null");
                    throw throwable;
                }
            }
            logTraceHelper.exit((Object)"null");
            return;
        }
        Object var6_5 = null;
        logTraceHelper.exit((Object)"null");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getCIMOMtoDevices(String string) throws RemoteException, ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"getCIMOMtoDevices", (Object[])new Object[]{string});
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        DBConnection dBConnection = null;
        try {
            try {
                ParameterChecker.assertMandatoryParameter((int)1, (String)"pCimomURLs", (Object)string, (LogTraceHelper)logTraceHelper);
                dBConnection = ServiceUtils.getConnection();
                if (dBConnection == null) {
                    throw DiskMessageHelper.getServerException((String)"HWN021800E", null, (LogTraceHelper)logTraceHelper);
                }
                int n = ExternalKeyManager.getCIMOM((String)string, (DBConnection)dBConnection).getRegCimomId();
                Cimom2namespace[] cimom2namespaceArray = ExternalKeyManager.getCimom2namespace((int)n, (DBConnection)dBConnection);
                SubsystemId subsystemId = null;
                ArrayList arrayList2 = new ArrayList();
                int n2 = 0;
                while (true) {
                    if (n2 >= cimom2namespaceArray.length) break;
                    arrayList2.addAll(ExternalKeyManager.getCimKeySubsystem((int)cimom2namespaceArray[n2].getCimNamespaceId(), (DBConnection)dBConnection));
                    ++n2;
                }
                String[] stringArray = new String[arrayList2.size()];
                int n3 = 0;
                while (true) {
                    if (n3 >= arrayList2.size()) break;
                    subsystemId = new SubsystemId(((CimkeySubsystem)arrayList2.get(n3)).getName(), ((CimkeySubsystem)arrayList2.get(n3)).getNameFormat());
                    stringArray[n3] = ConversionUtil.convertSubsystemIdToString((SubsystemId)subsystemId);
                    ++n3;
                }
                ArrayList arrayList3 = new ArrayList();
                int n4 = 0;
                while (true) {
                    if (n4 >= cimom2namespaceArray.length) break;
                    arrayList3.addAll(ExternalKeyManager.getCimkeyTapeLibrary((int)cimom2namespaceArray[n4].getCimNamespaceId(), (DBConnection)dBConnection));
                    ++n4;
                }
                String[] stringArray2 = new String[arrayList3.size()];
                int n5 = 0;
                while (true) {
                    if (n5 >= arrayList3.size()) break;
                    subsystemId = new SubsystemId(((CimkeyTapeLibrary)arrayList3.get(n5)).getName(), ((CimkeyTapeLibrary)arrayList3.get(n5)).getNameFormat());
                    stringArray2[n5] = ConversionUtil.convertSubsystemIdToString((SubsystemId)subsystemId);
                    ++n5;
                }
                ArrayList arrayList4 = new ArrayList();
                int n6 = 0;
                while (true) {
                    if (n6 >= cimom2namespaceArray.length) break;
                    arrayList4.addAll(ExternalKeyManager.getCimkeySwitch((int)cimom2namespaceArray[n6].getCimNamespaceId(), (DBConnection)dBConnection));
                    ++n6;
                }
                String[] stringArray3 = new String[arrayList4.size()];
                int n7 = 0;
                while (true) {
                    if (n7 >= arrayList4.size()) break;
                    stringArray3[n7] = ((CimkeySwitch)arrayList4.get(n7)).getSwitchWwn();
                    ++n7;
                }
                n7 = 0;
                while (true) {
                    if (n7 >= stringArray.length) break;
                    arrayList.add(new String[]{"Subsystem", stringArray[n7]});
                    ++n7;
                }
                n7 = 0;
                while (true) {
                    if (n7 >= stringArray2.length) {
                        n7 = 0;
                        break;
                    }
                    arrayList.add(new String[]{"TapeLibrary", stringArray2[n7]});
                    ++n7;
                }
                while (n7 < stringArray3.length) {
                    arrayList.add(new String[]{"Switch", stringArray3[n7]});
                    ++n7;
                }
            }
            catch (MissingParameterException missingParameterException) {
                throw DiskMessageHelper.getServerException((String)"HWN020002E", (Object)missingParameterException.getMessage(), (Throwable)missingParameterException, (LogTraceHelper)logTraceHelper);
            }
            catch (EntityNotFoundException entityNotFoundException) {
                throw DiskMessageHelper.getServerException((String)"HWN021504E", (Object)entityNotFoundException.getID(), (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var15_23 = null;
            try {
                if (dBConnection != null) {
                    dBConnection.close();
                }
            }
            catch (SQLException sQLException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
            }
            logTraceHelper.exit(arrayList);
            throw throwable;
        }
        {
            Object var15_24 = null;
        }
        try {}
        catch (SQLException sQLException) {
            throw DiskMessageHelper.getServerException((String)"HWN021503E", (Object)sQLException.getMessage(), (LogTraceHelper)logTraceHelper);
        }
        if (dBConnection != null) {
            dBConnection.close();
        }
        logTraceHelper.exit(arrayList);
        return arrayList;
    }
}

