/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;

public class DiskExpiringEventQueue {
    private LinkedList cQueue = new LinkedList();
    private int cCapacity = Integer.MAX_VALUE;
    private long cExpirationPeriod = 60000L;

    public DiskExpiringEventQueue() {
    }

    public DiskExpiringEventQueue(int n, long l) {
        this.cCapacity = n;
        this.cExpirationPeriod = l;
    }

    public synchronized void shutdown() {
        this.cQueue.clear();
    }

    public synchronized void add(CIMIndicationEvent cIMIndicationEvent) {
        this.cQueue.add(new Entry(cIMIndicationEvent));
        if (this.cQueue.size() > this.cCapacity) {
            this.cQueue.removeFirst();
        }
        this.notifyAll();
    }

    public synchronized CIMIndicationEvent remove() throws InterruptedException {
        if (!this.cQueue.isEmpty()) {
            return ((Entry)this.cQueue.removeFirst()).getEvent();
        }
        this.wait();
        return this.remove();
    }

    public synchronized boolean isEmpty() {
        return this.cQueue.isEmpty();
    }

    public synchronized int size() {
        return this.cQueue.size();
    }

    public int capacity() {
        return this.cCapacity;
    }

    public synchronized void expire() {
        long l = System.currentTimeMillis() - this.cExpirationPeriod;
        while (!this.cQueue.isEmpty()) {
            if (((Entry)this.cQueue.getFirst()).getTimestamp() < l) {
                this.cQueue.removeFirst();
                continue;
            }
            return;
        }
    }

    public synchronized boolean contains(CIMIndicationEvent cIMIndicationEvent) {
        this.expire();
        ListIterator listIterator = this.cQueue.listIterator();
        while (listIterator.hasNext()) {
            if (!((Entry)listIterator.next()).getEvent().equals(cIMIndicationEvent)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean contains(CIMIndicationEvent cIMIndicationEvent, Comparator comparator) {
        this.expire();
        ListIterator listIterator = this.cQueue.listIterator();
        while (listIterator.hasNext()) {
            if (comparator.compare(((Entry)listIterator.next()).getEvent(), cIMIndicationEvent) != 0) continue;
            return true;
        }
        return false;
    }

    private static class Entry {
        private CIMIndicationEvent cEvent;
        private long cTimestamp;

        public Entry(CIMIndicationEvent cIMIndicationEvent) {
            this.cEvent = cIMIndicationEvent;
            this.cTimestamp = System.currentTimeMillis();
        }

        public CIMIndicationEvent getEvent() {
            return this.cEvent;
        }

        public void setEvent(CIMIndicationEvent cIMIndicationEvent) {
            this.cEvent = cIMIndicationEvent;
        }

        public long getTimestamp() {
            return this.cTimestamp;
        }

        public void setTimestamp(long l) {
            this.cTimestamp = l;
        }
    }
}

