/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.control;

import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.data.ControlConstants;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;

public class ControlService
implements IService {
    static ILogger msgLogger;
    static ILogger traceLogger;
    static final String className;
    private Status status = null;
    public static final String SERVICE_NAME = "ControlService";
    private ControlEngine ce = null;

    static {
        Class<?> clazz;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.control.ControlService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
    }

    public ControlService() {
        msgLogger = ControlConstants.msgLogger;
        traceLogger = ControlConstants.traceLogger;
        String string = SERVICE_NAME;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, string);
        }
        this.status = new Status(5, 3);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    public boolean startup() {
        String string = "startup";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        boolean bl = false;
        this.status.setRunStatus(9);
        this.ce = ControlEngine.getInstance();
        if (this.ce != null) {
            bl = true;
            this.status.setRunStatus(8);
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Failed to obtain reference to the zone controller.  Fabric Access Service failed to start properly");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public boolean shutdown() {
        String string = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        boolean bl = false;
        if (this.ce != null) {
            this.ce.shutdown();
        }
        this.ce = null;
        bl = true;
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return bl;
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("ControlService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("ControlService_Description");
    }

    public Status getStatus() {
        return new Status(5, 8);
    }

    public String getVersion() {
        return "5.0.0";
    }

    public String getDescription() {
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, "getDescription");
        }
        String string = "Provides access to control functions such as zone control, and storage configuration.";
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, "getDescription");
        }
        return string;
    }

    public Hashtable getRoleMap() {
        Hashtable hashtable = new Hashtable();
        return hashtable;
    }
}

