/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.common.UpTimeReport;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableLongExt;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputerUpTimeAdjuster
extends CustomReportDataAdjuster {
    private GuiReportReq grr;
    private Comparator sorter;
    private UpTimeReport[] tableData;
    private MutableLong[] mLong;
    private MutableLongExt[] mLongExt;
    private MutableInteger[] mInteger;
    private Date[] mDate;
    public String[] colNames;
    private int name1Col = -1;
    private int name2Col = -1;
    private int[] rendererArray;
    private boolean batch;
    public static final int PERCENT_COL = 0;
    public static final int REBOOT_COL = 1;
    private static final int DOWN_TIME_COL = 2;
    private static final int AVG_DOWN_TIME_COL = 3;
    private static final int START_TIME_COL = 4;
    private static final int END_TIME_COL = 5;
    private static final String[] COL_LABELS = new String[]{MessageLog.getMessageNoID("STG4071L"), MessageLog.getMessageNoID("STG4088L"), MessageLog.getMessageNoID("STG4086L"), MessageLog.getMessageNoID("STG4089L"), MessageLog.getMessageNoID("STG4078L"), MessageLog.getMessageNoID("STG4079L")};
    public static final byte PERCENT_SCALE = 3;
    private static final int TEN_RAISED_PERCENT_SCALE = 1000;
    private String[] statTypeValues;
    private static final int N_STATISTIC_TYPES = 5;

    public ComputerUpTimeAdjuster(GuiReportReq guiReportReq) {
        super(guiReportReq);
        this.grr = guiReportReq;
        this.frozenColumns = 1;
        switch (guiReportReq.reportSubtype) {
            case 12: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 82: {
                this.sorter = new OneNameSorter();
                this.frozenColumns = 1;
                this.name2Col = -1;
                this.name1Col = -2;
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1136L");
                break;
            }
            case 28: {
                this.sorter = new HistorySorter();
                this.colNames = new String[COL_LABELS.length + 2];
                this.colNames[0] = MessageLog.getMessageNoID("STG1102L");
                break;
            }
            case 13: {
                this.sorter = new TwoNameSorter();
                this.name1Col = -2;
                this.frozenColumns = 2;
                this.colNames = new String[COL_LABELS.length + 2];
                this.colNames[0] = MessageLog.getMessageNoID("STG0021L");
                this.colNames[1] = MessageLog.getMessageNoID("STG1103L");
                break;
            }
            case 14: {
                this.sorter = new OneNameSorter();
                this.colNames = new String[COL_LABELS.length + 1];
                this.colNames[0] = MessageLog.getMessageNoID("STG1104L");
                break;
            }
            case 15: {
                this.frozenColumns = 0;
                this.colNames = new String[COL_LABELS.length];
            }
        }
        System.arraycopy(COL_LABELS, 0, this.colNames, this.frozenColumns, COL_LABELS.length);
        if (guiReportReq.reportSubtype == 28) {
            this.colNames[this.colNames.length - 1] = MessageLog.getMessageNoID("STG1214L");
            this.statTypeValues = new String[5];
            this.statTypeValues[0] = MessageLog.getMessageNoID("STG4094L");
            this.statTypeValues[1] = MessageLog.getMessageNoID("STG4095L");
            this.statTypeValues[2] = MessageLog.getMessageNoID("STG4096L");
            this.statTypeValues[3] = this.statTypeValues[1];
            this.statTypeValues[4] = this.statTypeValues[2];
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[this.frozenColumns + 0] = 2;
        this.rendererArray[this.frozenColumns + 1] = 5;
        this.rendererArray[this.frozenColumns + 2] = 3;
        this.rendererArray[this.frozenColumns + 3] = 3;
        this.rendererArray[this.frozenColumns + 4] = 1;
        this.rendererArray[this.frozenColumns + 5] = 1;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.adjustInit(objectArray, bl);
        this.adjustData();
        if (this.sorter != null) {
            Arrays.sort(this.tableData, this.sorter);
        }
    }

    public void adjustInit(Object[] objectArray, boolean bl) {
        this.batch = bl;
        this.tableData = (UpTimeReport[])objectArray;
        int n = this.tableData.length;
        this.mDate = new Date[n];
        this.mInteger = new MutableInteger[n];
        this.mLong = new MutableLong[n];
        this.mLongExt = new MutableLongExt[n];
        int n2 = 0;
        while (n2 < n) {
            this.mDate[n2] = new Date();
            this.mInteger[n2] = new MutableInteger();
            this.mLong[n2] = new MutableLong();
            this.mLongExt[n2] = new MutableLongExt();
            ++n2;
        }
    }

    public void adjustData() {
        int n = this.tableData.length;
        int n2 = 0;
        while (n2 < n) {
            UpTimeReport upTimeReport = this.tableData[n2];
            long l = upTimeReport.crUpTime + (long)upTimeReport.chDownTime;
            upTimeReport.crUpTimePercent = Math.min(100000, (int)((double)upTimeReport.crUpTime / (double)l * 100000.0));
            if (upTimeReport.chPowerCycles > 0) {
                upTimeReport.crAvgDownTime = upTimeReport.chDownTime / upTimeReport.chPowerCycles;
            }
            if (!(this.batch || this.grr.reportSubtype != 12 && this.grr.reportSubtype != 28)) {
                upTimeReport.crName1 = GuiUtil.getComputer((int)upTimeReport.crID).gcTSName;
            }
            ++n2;
        }
    }

    public int getNumberRows() {
        return this.tableData.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getScale() {
        return 1000;
    }

    public String getSuffix() {
        return " %";
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        int n = 0;
        while (n < this.tableData.length) {
            UpTimeReport upTimeReport = this.tableData[n];
            HistChartProcessor.addLegend(this.grr, upTimeReport.crName1, upTimeReport.getCrName2(), upTimeReport.crID);
            ++n;
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] nArray = new int[this.tableData.length];
        int n = 0;
        while (n < this.tableData.length) {
            UpTimeReport upTimeReport = this.tableData[n];
            nArray[n] = upTimeReport.crID;
            ++n;
        }
        return nArray;
    }

    public Object getArray() {
        return this.tableData;
    }

    public Object getCellData(int n, int n2) {
        if ((n2 -= this.frozenColumns) == this.name1Col) {
            return this.tableData[n].crName1;
        }
        if (n2 == this.name2Col) {
            return this.tableData[n].getCrName2();
        }
        if (n2 == 0) {
            this.mInteger[n].value = this.tableData[n].crUpTimePercent;
            return this.mInteger[n];
        }
        if (n2 == 1) {
            this.mLong[n].value = this.tableData[n].chPowerCycles;
            return this.mLong[n];
        }
        if (n2 == 2) {
            this.mLongExt[n].value = this.tableData[n].chDownTime;
            return this.mLongExt[n];
        }
        if (n2 == 3) {
            this.mLongExt[n].value = this.tableData[n].crAvgDownTime;
            return this.mLongExt[n];
        }
        if (n2 == 4) {
            this.mDate[n].setTime(this.tableData[n].chMonitorStart);
            return this.mDate[n];
        }
        if (n2 == 5) {
            this.mDate[n].setTime(this.tableData[n].chMonitorEnd);
            return this.mDate[n];
        }
        return this.statTypeValues[this.tableData[n].chStatisticType];
    }

    private class OneNameSorter
    implements Comparator {
        private OneNameSorter() {
        }

        public int compare(Object object, Object object2) {
            UpTimeReport upTimeReport = (UpTimeReport)object;
            UpTimeReport upTimeReport2 = (UpTimeReport)object2;
            return upTimeReport.crName1.compareTo(upTimeReport2.crName1);
        }
    }

    private class TwoNameSorter
    implements Comparator {
        private TwoNameSorter() {
        }

        public int compare(Object object, Object object2) {
            UpTimeReport upTimeReport = (UpTimeReport)object;
            UpTimeReport upTimeReport2 = (UpTimeReport)object2;
            int n = upTimeReport.crName1.compareTo(upTimeReport2.crName1);
            if (n != 0) {
                return n;
            }
            return upTimeReport.getCrName2().compareTo(upTimeReport2.getCrName2());
        }
    }

    private class HistorySorter
    implements Comparator {
        private HistorySorter() {
        }

        public int compare(Object object, Object object2) {
            UpTimeReport upTimeReport = (UpTimeReport)object;
            UpTimeReport upTimeReport2 = (UpTimeReport)object2;
            if (upTimeReport.chMonitorStart > upTimeReport2.chMonitorStart) {
                return 1;
            }
            if (upTimeReport.chMonitorStart < upTimeReport2.chMonitorStart) {
                return -1;
            }
            if (upTimeReport.chMonitorEnd > upTimeReport2.chMonitorEnd) {
                return 1;
            }
            if (upTimeReport.chMonitorEnd < upTimeReport2.chMonitorEnd) {
                return -1;
            }
            return 0;
        }
    }
}

