/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.gui.DiscoveryAlertEditor;
import org.eclipse.aperi.TStorm.gui.SnmpCommunitiesEditor;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.gui.AbstractAlertEditor;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiscoveryCreateOrEdit
implements CreateOrEdit,
GuiRequestor,
ChangeListener {
    private static final int SCHEDULE_TAB = 0;
    private static final int ALERT_TAB = 1;
    private static final int OPTIONS_TAB = 2;
    private CreateOrEditDDI DDI;
    private CreateHeaderPanel createHeaderPanel;
    private JTabbedPane tabs;
    private JSgcScheduleCreateWhenData scheduleEditor;
    private AbstractAlertEditor alertEditor;
    private JCheckBox skipWorkstations;
    private SnmpCommunitiesEditor communities;

    public DiscoveryCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.DDI = createOrEditDDI;
        this.DDI.showEnabled = true;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr";
    }

    public CreateHeader getData() {
        this.scheduleEditor.getData();
        ProbePing probePing = (ProbePing)this.createHeaderPanel.getData();
        probePing.pbAlert = this.alertEditor.getData();
        probePing.pbAllComputers = !this.skipWorkstations.isSelected();
        probePing.pbSnmpCommunities = this.communities.getData();
        return probePing;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        ScheduleHeader scheduleHeader = (ScheduleHeader)createHeader;
        this.DDI.exceptionTabIndex = 0;
        this.scheduleEditor.validate(scheduleHeader);
        this.DDI.exceptionTabIndex = 1;
        this.alertEditor.validateData();
    }

    public void showTab(int n) {
        this.tabs.setSelectedIndex(n);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
        guiMain.setSaveAsActionEnabled(false, false);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void replace(CreateHeader createHeader) {
        this.DDI.setDescription("");
        this.createHeaderPanel.replace(createHeader);
        this.scheduleEditor.replace((ScheduleHeader)createHeader);
    }

    private void create(ProbePing probePing) {
        this.createHeaderPanel = new CreateHeaderPanel(probePing, this, this.DDI);
        this.scheduleEditor = new JSgcScheduleCreateWhenData(32, this.DDI);
        JPanel jPanel = this.scheduleEditor.build(probePing);
        this.alertEditor = probePing.pbAlert == null ? new DiscoveryAlertEditor(31) : new DiscoveryAlertEditor(probePing.pbAlert);
        this.tabs = new JTabbedPane();
        this.tabs.setFont(BaseTree.boldFont);
        String string = MessageLog.getMessageNoID("GUI8222L");
        this.tabs.addTab(string, jPanel);
        string = MessageLog.getMessageNoID("STG4036L");
        this.tabs.addTab(string, this.alertEditor.getComponent());
        string = MessageLog.getMessageNoID("STG3255L");
        this.skipWorkstations = new JCheckBox(string, null);
        GuiUtil.setAccessible(this.skipWorkstations, string, string);
        this.skipWorkstations.setSelected(!probePing.pbAllComputers);
        JComponent jComponent = new JPanel(new BorderLayout());
        string = MessageLog.getMessageNoID("STG3256L");
        jComponent.setBorder(GuiUtil.getBorder(string));
        jComponent.add(Box.createHorizontalStrut(10), "West");
        jComponent.add((Component)this.skipWorkstations, "Center");
        jComponent.add(Box.createHorizontalStrut(10), "East");
        jComponent.add(Box.createVerticalStrut(10), "South");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.communities = new SnmpCommunitiesEditor(probePing.pbSnmpCommunities);
        if (DiscoveryCreateOrEdit.guiMain.getUserPrefs().administrator) {
            jPanel2.add((Component)jComponent, gridBagConstraints);
            jComponent = this.communities.getComponent();
            gridBagConstraints.weightx = 0.0;
        }
        jPanel2.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add(Box.createVerticalStrut(1), gridBagConstraints);
        string = MessageLog.getMessageNoID("STG3175L");
        this.tabs.addTab(string, jPanel2);
        this.tabs.setSelectedIndex(this.DDI.tabIndex);
        this.tabs.addChangeListener(this);
        this.createHeaderPanel.add((Component)this.tabs, "Center");
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.gettingFocus();
    }

    private void submitRetrieve() {
        ProbePing probePing = new ProbePing(32);
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiDiscoveryHndlr", probePing);
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    public void build(int n) {
        this.submitRetrieve();
    }

    public void build(CreateHeader createHeader) {
        this.create((ProbePing)createHeader);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        ProbePing probePing = (ProbePing)response.responseData;
        this.DDI.oldCreateHeader = (CreateHeader)probePing.clone();
        this.create(probePing);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.DDI.tabIndex = this.tabs.getSelectedIndex();
    }

    public String getHelpID(int n) {
        switch (n) {
            case 0: {
                return "adm_dsc_whentorun";
            }
            case 1: {
                return "adm_dsc_alert";
            }
            case 2: {
                return "adm_dsc_windowsoptions";
            }
        }
        return null;
    }
}

