/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryJobDDI;
import org.eclipse.aperi.TStorm.gui.EditableObjectHistoryNode;
import org.eclipse.aperi.TStorm.gui.EditableObjectNode;
import org.eclipse.aperi.TStorm.gui.HistoryHelper;
import org.eclipse.aperi.TStorm.gui.NameListToTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableObjectLabel
extends BaseTreeNode
implements GuiRequestor,
ActionListener,
ObjectChangeListener,
NameListToTreeNode {
    private static final String NEW = "N";
    private static final String REFRESH = "R";
    private String label;
    short objectType;
    short resourceType;
    short qualifier;
    String objectLabelID;
    String objectLabel;
    Class editorClass;
    private boolean checkQualifiers;
    private boolean hasKids;
    private boolean neverRefreshed;
    protected JMenuItem newMenu = new JMenuItem();
    private JMenuItem refreshMenu = new JMenuItem();
    private int adminType = 5;

    public EditableObjectLabel(String string, String string2, short s, Class clazz, short s2, short s3, boolean bl) {
        this(string, string2, s, clazz, s2, s3, bl, 5);
    }

    public EditableObjectLabel(String string, String string2, short s, Class clazz, short s2, short s3, boolean bl, int n) {
        this.adminType = n;
        this.objectType = s;
        this.checkQualifiers = s2 != -1;
        this.resourceType = this.checkQualifiers ? s2 : (short)0;
        this.qualifier = s3;
        this.editorClass = clazz;
        this.objectLabelID = string;
        this.objectLabel = Util.getString(this.objectLabelID);
        Object[] objectArray = new Object[]{this.objectLabel};
        this.newMenu.setText(MessageLog.getMessageNoID("GUI2013L", objectArray));
        this.newMenu.setActionCommand(NEW);
        this.newMenu.addActionListener(this);
        boolean bl2 = false;
        switch (n) {
            case 4: {
                bl2 = this.capabilities.isAnyAdmin();
                break;
            }
            case 1: {
                bl2 = this.capabilities.isDataAdmin();
                break;
            }
            case 2: {
                bl2 = this.capabilities.isDiskAdmin();
                break;
            }
            case 3: {
                bl2 = this.capabilities.isFabricAdmin();
                break;
            }
            case 5: {
                bl2 = this.capabilities.isAperiAdmin();
                break;
            }
            case 6: {
                bl2 = this.capabilities.isTapeAdmin();
                break;
            }
            default: {
                bl2 = this.capabilities.isAperiAdmin();
            }
        }
        if (!bl2) {
            this.newMenu.setEnabled(false);
        }
        this.refreshMenu.setText(MessageLog.getMessageNoID("ADG0003L"));
        this.refreshMenu.setActionCommand(REFRESH);
        this.refreshMenu.addActionListener(this);
        this.setUserObject(Util.getString(string2));
        ChangeManager.addListener(this, this.objectType);
        this.hasKids = bl;
        this.neverRefreshed = true;
    }

    public EditableObjectLabel(String string, String string2, short s, Class clazz, boolean bl) {
        this(string, string2, s, clazz, -1, 0, bl, 5);
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.showPopupMenu(this.createPopup(), mouseEvent);
    }

    public JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = this.getPopupMenu();
        jPopupMenu.add(this.newMenu);
        jPopupMenu.add(this.refreshMenu);
        return jPopupMenu;
    }

    public static Request makeRequest(short s, short s2, short s3) {
        Request request = new Request();
        GuiRequest.computerList(request);
        GuiListReq guiListReq = (GuiListReq)request.requestData;
        guiListReq.listRequested = 10000 + s;
        guiListReq.resourceType = s2;
        guiListReq.qualifier = s3;
        return request;
    }

    public static Request makeRequest(short s) {
        return EditableObjectLabel.makeRequest(s, (short)0, (short)0);
    }

    private void sendRequest() {
        Request request = null;
        request = EditableObjectLabel.makeRequest(this.objectType, this.resourceType, this.qualifier);
        GuiClient.doRequest(this, request);
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.neverRefreshed) {
            this.sendRequest();
        }
    }

    public BaseTreeNode makeChild(NameList nameList) {
        return new EditableObjectNode(nameList, this, this.hasKids, this.adminType);
    }

    public int getKey(NameList nameList) {
        return nameList.nlID;
    }

    public static void refresh(BaseTreeNode baseTreeNode, Response response, NameListToTreeNode nameListToTreeNode) {
        MutableInteger mutableInteger;
        BaseTreeNode baseTreeNode2;
        NameList nameList = GuiUtil.sortNameList((NameList)response.responseData);
        int n = Integer.MIN_VALUE;
        TreePath treePath = BaseTree.pBaseTree.getSelectionPath();
        BaseTreeNode baseTreeNode3 = treePath != null ? (BaseTreeNode)treePath.getLastPathComponent() : null;
        HashMap<MutableInteger, DataDisplayInfo> hashMap = new HashMap<MutableInteger, DataDisplayInfo>();
        BaseTreeNode[] baseTreeNodeArray = new BaseTreeNode[baseTreeNode.getChildCount()];
        int n2 = 0;
        Enumeration<TreeNode> enumeration = baseTreeNode.children();
        while (enumeration.hasMoreElements()) {
            baseTreeNode2 = (BaseTreeNode)enumeration.nextElement();
            NameList nameList2 = (NameList)baseTreeNode2.getUserObject();
            nameList2.nlName = Util.getTranslatedName(nameList2.nlName);
            mutableInteger = new MutableInteger(nameListToTreeNode.getKey(nameList2));
            hashMap.put(mutableInteger, baseTreeNode2.ddi);
            if (baseTreeNode2 == baseTreeNode3) {
                n = mutableInteger.value;
            }
            baseTreeNodeArray[n2] = baseTreeNode2;
            ++n2;
        }
        n2 = 0;
        while (n2 < baseTreeNodeArray.length) {
            BaseTree.MyTree.removeNodeFromParent(baseTreeNodeArray[n2]);
            ++n2;
        }
        baseTreeNode3 = null;
        mutableInteger = new MutableInteger();
        n2 = 0;
        while (nameList != null) {
            DataDisplayInfo dataDisplayInfo;
            nameList.nlName = Util.getTranslatedName(nameList.nlName);
            if (nameListToTreeNode instanceof HistoryHelper && ((HistoryHelper)nameListToTreeNode).getTreeNode() instanceof EditableObjectNode) {
                nameList.nlInfo = ((EditableObjectNode)((HistoryHelper)nameListToTreeNode).getTreeNode()).element.nlInfo;
            }
            baseTreeNode2 = nameListToTreeNode.makeChild(nameList);
            mutableInteger.value = nameListToTreeNode.getKey(nameList);
            if (mutableInteger.value == n) {
                baseTreeNode3 = baseTreeNode2;
            }
            if ((dataDisplayInfo = (DataDisplayInfo)hashMap.get(mutableInteger)) != null) {
                if (dataDisplayInfo instanceof EditableObjectHistoryJobDDI && baseTreeNode2 instanceof EditableObjectHistoryNode) {
                    ((EditableObjectHistoryJobDDI)dataDisplayInfo).element = ((EditableObjectHistoryNode)baseTreeNode2).element;
                }
                baseTreeNode2.ddi = dataDisplayInfo;
                dataDisplayInfo.treeNode = baseTreeNode2;
            }
            BaseTree.MyTree.insertNodeInto(baseTreeNode2, baseTreeNode, n2);
            ++n2;
            nameList = nameList.nlNext;
        }
        if (baseTreeNode3 != null) {
            BaseTree.pBaseTree.reselect(baseTreeNode3);
        }
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        this.neverRefreshed = false;
        EditableObjectLabel.refresh(this, response, this);
    }

    CreateOrEditDDI makeDDI() {
        CreateOrEditDDI createOrEditDDI = new CreateOrEditDDI();
        if (this.checkQualifiers) {
            createOrEditDDI.nlID2 = this.resourceType;
            createOrEditDDI.nlID3 = this.qualifier;
        }
        return createOrEditDDI;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        if (string == REFRESH) {
            this.sendRequest();
        } else if (string == NEW) {
            object = this.makeDDI();
            ((CreateOrEditDDI)object).treeNode = this;
            ((CreateOrEditDDI)object).buildEditor(this.editorClass, this.objectType);
        }
        object = GuiManager.getGuiManager().getGuiMain();
        object.getBaseTree().requestFocus();
    }

    private MutableTreeNode find(int n) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        boolean bl = true;
        Enumeration<TreeNode> enumeration = this.children();
        while (bl && enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            NameList nameList = (NameList)defaultMutableTreeNode.getUserObject();
            if (nameList.nlID != n) continue;
            bl = false;
        }
        if (bl) {
            defaultMutableTreeNode = null;
        }
        return defaultMutableTreeNode;
    }

    private void addInRightPlace(MutableTreeNode mutableTreeNode, NameList nameList) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        int n = 0;
        Enumeration<TreeNode> enumeration = this.children();
        int n2 = 1;
        while (n2 > 0 && enumeration.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            NameList nameList2 = (NameList)defaultMutableTreeNode.getUserObject();
            n2 = nameList.nlName.compareTo(nameList2.nlName);
            ++n;
        }
        if (n2 == 0) {
            defaultMutableTreeNode.setUserObject(nameList);
        } else {
            if (n2 < 0) {
                --n;
            }
            BaseTree.MyTree.insertNodeInto(mutableTreeNode, this, n);
        }
    }

    public void changeOccurred(int n, NameList nameList) {
        switch (n) {
            case 1: {
                BaseTreeNode baseTreeNode;
                if (this.checkQualifiers && (nameList.nlID2 != this.resourceType || nameList.nlID3 != this.qualifier)) break;
                BaseTreeNode baseTreeNode2 = this.makeChild(nameList);
                this.addInRightPlace(baseTreeNode2, nameList);
                DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
                if (dataDisplayInfo.treeNode != null) {
                    dataDisplayInfo.treeNode.ddi = null;
                }
                dataDisplayInfo.treeNode = baseTreeNode = baseTreeNode2;
                baseTreeNode.ddi = dataDisplayInfo;
                BaseTree.pBaseTree.reselect(baseTreeNode, true);
                break;
            }
            case 0: {
                MutableTreeNode mutableTreeNode = this.find(nameList.nlID);
                if (mutableTreeNode == null) break;
                BaseTree.MyTree.removeNodeFromParent(mutableTreeNode);
                mutableTreeNode.setUserObject(nameList);
                this.addInRightPlace(mutableTreeNode, nameList);
                break;
            }
            case -1: {
                MutableTreeNode mutableTreeNode = this.find(nameList.nlID);
                if (mutableTreeNode == null) break;
                BaseTree.MyTree.removeNodeFromParent(mutableTreeNode);
            }
        }
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        defaultTreeCellRenderer.setIcon(NameListTreeCellRenderer.iconForType(this.objectType));
        defaultTreeCellRenderer.setFont(BaseTree.boldFont);
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
    }
}

