/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Date;
import org.eclipse.aperi.TStorm.gui.BaseAlertLogTableData;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertLogDetailPanel;
import org.eclipse.aperi.gui.AlertLogTable;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.server.guireq.AlertLogReq;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExternalAlertLogTableData
extends BaseAlertLogTableData {
    private static final int ACTIVE_COLUMN = 0;
    private static final int EXTERNAL_COLUMN = 1;
    private static final int OBJ_TYPE_COLUMN = 2;
    private static final int OBJ_NAME_COLUMN = 3;
    private static final int CONDITION_COLUMN = 4;
    private static final int FIRST_LOGGED_COLUMN = 5;
    private static final int LAST_LOGGED_COLUMN = 6;
    private static final int N_VIOLATIONS_COLUMN = 7;
    private static final int CREATOR_COLUMN = 8;
    private static final int NAME_COLUMN = 9;
    private static final int SCRIPT_NAME_COLUMN = 10;
    private static final int N_COLUMNS = 11;
    private static final String[] msgIDs;
    private boolean hasObjectNameColumn = true;
    private boolean hasObjectTypeColumn = true;
    private int[] hiddenColumns;

    static {
        String[] stringArray = new String[11];
        stringArray[1] = "STG2707L";
        stringArray[2] = "GUI2021L";
        stringArray[3] = "GUI2022L";
        stringArray[4] = "GUI2023L";
        stringArray[5] = "GUI2024L";
        stringArray[6] = "GUI2025L";
        stringArray[7] = "GUI2026L";
        stringArray[8] = "GUI2027L";
        stringArray[9] = "GUI2028L";
        stringArray[10] = "GUI2069L";
        msgIDs = stringArray;
    }

    public ExternalAlertLogTableData(AlertLogTable alertLogTable, ExtAlertLog[] extAlertLogArray, AlertLogReq alertLogReq) {
        super(alertLogTable, extAlertLogArray);
        this.columnNames = new String[11];
        this.columnNames[0] = " ";
        int n = 1;
        while (n < 11) {
            this.columnNames[n] = n != 3 || this.hasObjectTypeColumn || !this.hasObjectNameColumn ? MessageLog.getMessageNoID(msgIDs[n]) : CreateOrEditDDI.getObjectTypeName(alertLogReq.objectType);
            ++n;
        }
    }

    public Object getTableDataItem(int n, int n2) {
        ExtAlertLog extAlertLog = this.array[n];
        Object object = null;
        switch (n2) {
            case 0: {
                object = this.byteToObject(n, extAlertLog.alState);
                break;
            }
            case 1: {
                object = extAlertLog.alComputer;
                break;
            }
            case 2: {
                if (extAlertLog.getAlObjectName() == null) break;
                object = CreateOrEditDDI.getObjectTypeName(extAlertLog.alResourceType);
                break;
            }
            case 3: {
                object = extAlertLog.getAlObjectName();
                break;
            }
            case 4: {
                object = MessageLog.getMessageNoID(AlertConditionManager.getConditionMessageId(extAlertLog.alAlertCondition));
                break;
            }
            case 5: {
                object = new Date(extAlertLog.alFirstAlertTime);
                break;
            }
            case 6: {
                object = new Date(extAlertLog.alLastAlertTime);
                break;
            }
            case 7: {
                object = this.intToObject(n, extAlertLog.alAlertCount);
                break;
            }
            case 8: {
                object = extAlertLog.alCreator;
                break;
            }
            case 9: {
                object = extAlertLog.getAlName();
                break;
            }
            case 10: {
                if (Util.isEmpty(extAlertLog.alScriptLogFile)) break;
                object = extAlertLog.alScriptName;
            }
        }
        if (object == null) {
            object = AlertLogDDI.notApplicableText;
        }
        return object;
    }

    public static void addResourceDescription(ExtAlertLog extAlertLog, AlertLogDetailPanel alertLogDetailPanel) {
        String string;
        if (extAlertLog.alResourceType >= 0 && (string = CreateOrEditDDI.getObjectTypeName(extAlertLog.alResourceType)) != null) {
            alertLogDetailPanel.addPair(string, extAlertLog.getAlObjectName());
        }
    }

    public void hideColumns(MegaTable megaTable) {
        int[] nArray = new int[3];
        int n = 0;
        this.hiddenColumns = null;
        if (!this.hasObjectTypeColumn) {
            megaTable.setColumnHidden(2, true);
            nArray[n] = 2;
            ++n;
            if (!this.hasObjectNameColumn) {
                megaTable.setColumnHidden(3, true);
                nArray[n] = 3;
                ++n;
            }
        }
        if (n > 0) {
            this.hiddenColumns = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.hiddenColumns[n2] = nArray[n2];
                ++n2;
            }
        }
    }

    public int getNumberColumns() {
        return 11;
    }

    public int[] getRenderers() {
        int[] nArray = new int[11];
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[7] = 5;
        return nArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }
}

