/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSGroupEditor;
import org.eclipse.aperi.TStorm.gui.FSGroupSelectorHelper;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.ChangeManager;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class FSGroupCreateOrEdit
implements CreateOrEdit,
GuiRequestor,
Runnable {
    private CreateHeaderPanel createHeaderPanel;
    private CreateOrEditDDI DDI;
    private TreeSelector selector;
    private FSGroupEditor editor;

    public FSGroupCreateOrEdit(CreateOrEditDDI createOrEditDDI) {
        this.DDI = createOrEditDDI;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
    }

    public CreateHeader getData() {
        GroupDefinition groupDefinition = (GroupDefinition)this.createHeaderPanel.getData();
        groupDefinition.members = FSGroupSelectorHelper.getSelectedFilesystems(this.selector);
        return groupDefinition;
    }

    public void validate(CreateHeader createHeader) throws GeneralException {
        GroupDefinition groupDefinition = (GroupDefinition)createHeader;
        if (groupDefinition.members == null) {
            String string = MessageLog.getMessageNoTS("STG3139E", null);
            throw new GeneralException(string);
        }
    }

    private void create(GroupDefinition groupDefinition) {
        this.createHeaderPanel = new CreateHeaderPanel(groupDefinition, this, this.DDI);
        this.editor = new FSGroupEditor(groupDefinition.members, this, false);
    }

    public void run() {
        this.selector = this.editor.selector;
        this.editor = null;
        this.createHeaderPanel.add((Component)this.selector, "Center");
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
    }

    public void replace(CreateHeader createHeader) {
        this.createHeaderPanel.replace(createHeader);
        NameList nameList = new NameList();
        nameList.nlInfo = (short)2;
        ChangeManager.signalChange(100, nameList);
    }

    private void submitRetrieve(int n) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        request.flags = (byte)5;
        request.userName = GuiUtil.getUserName();
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.ID = n;
        groupDefinition.groupType = (short)2;
        groupDefinition.members = null;
        request.requestData = groupDefinition;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        GroupDefinition groupDefinition = new GroupDefinition();
        groupDefinition.groupType = (short)2;
        this.create(groupDefinition);
        this.DDI.oldCreateHeader = (CreateHeader)groupDefinition.clone();
    }

    public void build(int n) {
        if (n > 0) {
            this.submitRetrieve(n);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        this.create((GroupDefinition)createHeader);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int n) {
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        GroupDefinition groupDefinition = (GroupDefinition)response.responseData;
        this.DDI.oldCreateHeader = (CreateHeader)groupDefinition.clone();
        this.create(groupDefinition);
    }

    public String getHelpID(int n) {
        return "mogr10";
    }
}

