/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.gui.VolumeGroupTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolumeGroupTreeLabel
extends BaseTreeNode
implements GuiRequestor {
    public NameList computer;
    public Rank rank;

    public VolumeGroupTreeLabel(NameList nameList) {
        String string;
        switch (nameList.nlID2) {
            case 2: {
                string = "STG6100L";
                break;
            }
            case 21: {
                string = "STG4502L";
                break;
            }
            case 8: {
                string = "SAG0031L";
                break;
            }
            case 25: 
            case 27: {
                string = "STG6213L";
                break;
            }
            default: {
                string = "STG6209L";
            }
        }
        this.setUserObject(MessageLog.getMessageNoID(string));
        this.computer = nameList;
    }

    public VolumeGroupTreeLabel(NameList nameList, Rank rank) {
        String string;
        switch (nameList.nlID2) {
            case 2: {
                string = "STG6100L";
                break;
            }
            case 21: {
                string = "STG4502L";
                break;
            }
            case 8: {
                string = "SAG0031L";
                break;
            }
            case 25: 
            case 27: {
                string = "STG6213L";
                break;
            }
            default: {
                string = "STG6209L";
            }
        }
        this.setUserObject(MessageLog.getMessageNoID(string));
        this.computer = nameList;
        this.rank = rank;
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.getChildCount() == 0) {
            Request request = new Request();
            if (this.rank != null) {
                GuiRequest.volumegroupList(request, this.rank.rankVolGroupID, this.getQualifier(), this.rank.rankID, this.computer.nlID);
            } else {
                GuiRequest.volumegroupList(request, this.computer.nlID, this.getQualifier());
            }
            GuiClient.doRequest(this, request);
        }
    }

    public void handleResponse(short s, Response response) {
        NameList nameList = (NameList)response.responseData;
        while (nameList != null) {
            if (nameList.nlName == null || nameList.nlName.trim().length() == 0) {
                nameList.nlName = GuiUtil.getString("GUI5004L");
            }
            this.add(this.makeNode(nameList));
            nameList = nameList.nlNext;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
    }

    protected BaseTreeNode makeNode(NameList nameList) {
        return new VolumeGroupTreeNode(this.computer, nameList);
    }

    protected int getQualifier() {
        return -1;
    }
}

