/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.server.guireq;

import java.io.Serializable;
import org.eclipse.aperi.TStorm.server.guireq.GuiInfoReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiSelectionReq;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;

public class GuiRequest {
    public static Request newRequest(String string, Serializable serializable) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "newRequest", "requestSubType, requestData");
        }
        Request request = new Request();
        GuiRequest.guiRequest(request);
        request.subType = string;
        request.requestData = serializable;
        Request request2 = request;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "newRequest", request2);
        }
        return request2;
    }

    private static void guiRequest(Request request) {
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.flags = (byte)4;
    }

    public static void computerList(Request request) {
        GuiRequest.computerList(request, false);
    }

    public static void computerList(Request request, boolean bl) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 1;
        guiListReq.excludeNAS = bl;
        request.requestData = guiListReq;
    }

    public static void computerInfo(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 1;
        guiInfoReq.objectID = n;
        request.requestData = guiInfoReq;
    }

    public static void clusterInfo(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 22;
        guiInfoReq.objectID = n;
        request.requestData = guiInfoReq;
    }

    public static void selectionList(Request request) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiSelectionHndlr";
        request.requestData = new GuiSelectionReq();
    }

    public static void controllerList(Request request, int n, short s) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 2;
        guiListReq.computerID = n;
        guiListReq.qualifier = s;
        request.requestData = guiListReq;
    }

    public static void controllerList(Request request, int n) {
        GuiRequest.controllerList(request, n, (short)0);
    }

    public static void volumegroupList(Request request, int n, int n2, int n3, int n4) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 10;
        guiListReq.vgID = n;
        guiListReq.rankID = n3;
        guiListReq.groupID = n2;
        guiListReq.computerID = n4;
        request.requestData = guiListReq;
    }

    public static void volumegroupList(Request request, int n, int n2) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 10;
        guiListReq.computerID = n;
        guiListReq.groupID = n2;
        request.requestData = guiListReq;
    }

    public static void rankList(Request request, int n, int n2) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 14;
        guiListReq.computerID = n;
        guiListReq.controllerID = n2;
        request.requestData = guiListReq;
    }

    public static void diskList(Request request, int n, int n2, short s) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 3;
        guiListReq.computerID = n;
        guiListReq.controllerID = n2;
        guiListReq.qualifier = s;
        request.requestData = guiListReq;
    }

    public static void diskList(Request request, int n, int n2) {
        GuiRequest.diskList(request, n, n2, (short)0);
    }

    public static void diskInfo(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 2;
        guiInfoReq.objectID = n;
        request.requestData = guiInfoReq;
    }

    public static void lunInfo(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 18;
        guiInfoReq.objectID = n;
        request.requestData = guiInfoReq;
    }

    public static void diskProbeInfo(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 3;
        guiInfoReq.objectID = n;
        request.requestData = guiInfoReq;
    }

    public static void diskHistory(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 4;
        guiInfoReq.objectID = n;
        request.requestData = guiInfoReq;
    }

    public static void logicalVolumeList(Request request, int n, int n2) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 4;
        guiListReq.computerID = n;
        guiListReq.diskID = n2;
        request.requestData = guiListReq;
    }

    public static void logicalVolumeInfo(Request request, int n, int n2) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 5;
        guiInfoReq.objectID = n;
        guiInfoReq.computerID = n2;
        request.requestData = guiInfoReq;
    }

    public static void exportList(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 6;
        guiListReq.computerID = n;
        request.requestData = guiListReq;
    }

    public static void exportInfo(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 6;
        guiInfoReq.objectID = n;
        request.requestData = guiInfoReq;
    }

    public static void groupList(Request request, short s) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 10000 + s;
        request.requestData = guiListReq;
    }

    public static void filesystemList(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 10003;
        guiListReq.groupID = n;
        request.requestData = guiListReq;
    }

    public static void filesystemInfo(Request request, int n) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiInfoHndlr";
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 7;
        guiInfoReq.objectID = n;
        request.requestData = guiInfoReq;
    }

    public static void nasTreeList(Request request) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 8;
        request.requestData = guiListReq;
    }

    public static void nasFsList(Request request) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 9;
        request.requestData = guiListReq;
    }

    public static void manNasList(Request request) {
        GuiRequest.guiRequest(request);
        request.subType = "org.eclipse.aperi.server.handler.gui.GuiListHndlr";
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 13;
        request.requestData = guiListReq;
    }

    public static Request makeDiskArrayInfoRequest(int n) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "makeDiskArrayInfoRequest", "diskArrayID");
        }
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 19;
        guiInfoReq.objectID = n;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr", guiInfoReq);
        GuiRequest.guiRequest(request);
        Request request2 = request;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "makeDiskArrayInfoRequest", request2);
        }
        return request2;
    }

    public static Request makeLogicalUnitRequest(int n, int n2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "makeLogicalUnitRequest", "diskArrayID, lunID");
        }
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 20;
        guiInfoReq.objectID = n2;
        guiInfoReq.computerID = n;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr", guiInfoReq);
        GuiRequest.guiRequest(request);
        Request request2 = request;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "makeLogicalUnitRequest", request2);
        }
        return request2;
    }

    public static Request makeVolumeGroupInfoRequest(int n, int n2) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "makeVolumeGroupInfoRequest", "volgroupID");
        }
        GuiInfoReq guiInfoReq = new GuiInfoReq();
        guiInfoReq.objectType = 21;
        guiInfoReq.objectID = n;
        guiInfoReq.computerID = n2;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiInfoHndlr", guiInfoReq);
        GuiRequest.guiRequest(request);
        Request request2 = request;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.TStorm.server.guireq.GuiRequest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "makeVolumeGroupInfoRequest", request2);
        }
        return request2;
    }
}

