/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.backend;

import org.eclipse.aperi.backend.LogFileReader;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.ReadLogRequest;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.LocalizableException;

public class JobLogFileReader
extends LogFileReader {
    protected MutableInteger open(ReadLogRequest readLogRequest, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.JobLogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "open", "requestData, response");
        }
        LogFilePos logFilePos = readLogRequest.position;
        if (logFilePos.offset < 0L && readLogRequest.direction == 1) {
            logFilePos.offset = 0L;
        }
        int n = -1;
        try {
            n = this.openFile(readLogRequest.name, (int)logFilePos.offset);
            if (logFilePos.offset < 0L) {
                logFilePos.offset = this.getFilePosition(n);
            }
        }
        catch (LocalizableException localizableException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.JobLogFileReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "open", localizableException);
            }
            Object[] objectArray = localizableException.getParameters();
            objectArray[objectArray.length - 1] = readLogRequest.name;
            response.errorMessage = localizableException.getMessage();
            response.status = (short)12;
        }
        if (n < 0) {
            MutableInteger mutableInteger = null;
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.backend.JobLogFileReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "open", mutableInteger);
            }
            return mutableInteger;
        }
        MutableInteger mutableInteger = new MutableInteger(n);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.JobLogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "open", mutableInteger);
        }
        return mutableInteger;
    }

    protected int read(MutableInteger mutableInteger, LogFilePos logFilePos, ReadLogRequest readLogRequest, ReadLogResponse readLogResponse, Response response) {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.JobLogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "read", "handle, pos, rq, rd, response");
        }
        int n = this.basicRead(mutableInteger.value, logFilePos, readLogRequest, readLogResponse.lineArray, 0, response);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.backend.JobLogFileReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "read", n);
        }
        return n;
    }

    protected boolean setPosition(MutableInteger mutableInteger, ReadLogRequest readLogRequest, LogFilePos logFilePos) {
        this.setFilePosition(mutableInteger.value, (int)logFilePos.offset);
        return true;
    }
}

