/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.constants.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantFieldUtil {
    public static SortedSet<Byte> getByteValues(Class clazz) {
        TreeSet<Byte> treeSet = new TreeSet<Byte>();
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (ConstantFieldUtil.isConstant(fieldArray[n]) && fieldArray[n].getType().equals(Byte.TYPE)) {
                try {
                    treeSet.add(fieldArray[n].getByte(null));
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public static SortedSet<Short> getShortValues(Class clazz) {
        TreeSet<Short> treeSet = new TreeSet<Short>();
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (ConstantFieldUtil.isConstant(fieldArray[n]) && fieldArray[n].getType().equals(Short.TYPE)) {
                try {
                    treeSet.add(fieldArray[n].getShort(null));
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public static SortedSet<Integer> getIntegerValues(Class clazz) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (ConstantFieldUtil.isConstant(fieldArray[n]) && fieldArray[n].getType().equals(Integer.TYPE)) {
                try {
                    treeSet.add(fieldArray[n].getInt(null));
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public static SortedSet<Long> getLongValues(Class clazz) {
        TreeSet<Long> treeSet = new TreeSet<Long>();
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (ConstantFieldUtil.isConstant(fieldArray[n]) && fieldArray[n].getType().equals(Long.TYPE)) {
                try {
                    treeSet.add(fieldArray[n].getLong(null));
                }
                catch (Exception exception) {}
            }
            ++n;
        }
        return Collections.unmodifiableSortedSet(treeSet);
    }

    public static SortedSet<String> getStringValues(Class clazz) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (ConstantFieldUtil.isConstant(fieldArray[n])) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                if (fieldArray[n].getType().equals(clazz2)) {
                    try {
                        treeSet.add(String.valueOf(fieldArray[n].get(null)));
                    }
                    catch (Exception exception) {}
                }
            }
            ++n;
        }
        return Collections.unmodifiableSortedSet(treeSet);
    }

    private static boolean isConstant(Field field) {
        int n = field.getModifiers();
        return Modifier.isPublic(n) && Modifier.isStatic(n) && Modifier.isFinal(n);
    }
}

