/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.MapPool;
import org.sblim.wbem.cim.CIMException;

public final class CIMClientPool
extends MapPool {
    private static CIMClientPool stSingletonInstance = null;
    private List cReturnQueue = new LinkedList();
    private ClientVerifier cVerifier = new ClientVerifier();

    static {
        stSingletonInstance = new CIMClientPool();
    }

    private CIMClientPool() {
        super(DiskManagerConfigSvc.getIntConfigValue("CIMClientWrapper.PoolSize", 50));
        this.cVerifier.start();
    }

    private static CIMClientPool get() {
        return stSingletonInstance;
    }

    public static CIMClientWrapper getClient(String string, String string2, String string3, String string4) throws CIMException {
        CIMClientWrapper cIMClientWrapper = (CIMClientWrapper)CIMClientPool.get().getClearInstance(CIMClientWrapper.generateKey(string, string2, string3, string4));
        if (cIMClientWrapper != null) {
            cIMClientWrapper.initializeInstance(string, string2, string3, string4);
            return cIMClientWrapper;
        }
        return new CIMClientWrapper(string, string2, string3, string4, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void returnClient(CIMClientWrapper cIMClientWrapper) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry("CIMClientPool", "returnClient", new Object[]{cIMClientWrapper});
        try {
            logTraceHelper.traceHigh("CIMClient Wrapper ObjectID: " + cIMClientWrapper.getAddress() + " ThreadName: " + Thread.currentThread().getName());
            cIMClientWrapper.releaseInstance();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var2_4 = null;
            logTraceHelper.exit(null);
            return;
        }
    }

    private static void retClientInt(CIMClientWrapper cIMClientWrapper) {
        if (cIMClientWrapper.testConnection()) {
            System.out.println("Test connection successful");
            if (CIMClientPool.get().cVerifier.cContinue) {
                if (!CIMClientPool.get().returnInst(cIMClientWrapper)) {
                    System.out.println("not added to pool");
                    cIMClientWrapper.releaseInstance();
                }
            } else {
                System.out.println("verifier shutting down");
                cIMClientWrapper.releaseInstance();
            }
        } else {
            System.out.println("Test connection not successful");
            cIMClientWrapper.releaseInstance();
        }
    }

    public static void shutdown() {
        CIMClientPool.get().cVerifier.cContinue = false;
        CIMClientPool.get().cVerifier.interrupt();
        CIMClientPool.get().clear();
    }

    private class ClientVerifier
    extends Thread {
        private boolean cContinue = true;

        private ClientVerifier() {
            super("DiskManager CIMClientPool ClientVerifier");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CIMClientWrapper cIMClientWrapper = null;
            while (this.cContinue) {
                List list = CIMClientPool.this.cReturnQueue;
                synchronized (list) {
                    while (CIMClientPool.this.cReturnQueue.isEmpty()) {
                        try {
                            CIMClientPool.this.cReturnQueue.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        if (this.cContinue) continue;
                        return;
                    }
                    cIMClientWrapper = (CIMClientWrapper)CIMClientPool.this.cReturnQueue.remove(0);
                }
                CIMClientPool.retClientInt(cIMClientWrapper);
            }
        }
    }
}

