/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.DiskReportingHelper;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.ConfigData;

public class ParameterHelper {
    public static Long[] convertToLong(long[] lArray) {
        Long[] longArray = null;
        try {
            if (lArray != null) {
                longArray = new Long[lArray.length];
                int n = 0;
                while (n < lArray.length) {
                    longArray[n] = new Long(lArray[n]);
                    ++n;
                }
            }
        }
        catch (Exception exception) {}
        return longArray;
    }

    public static int getPortFromServiceUrl(String string) {
        int n = -1;
        if (!ParameterHelper.isValidServiceUrl(string)) {
            return n;
        }
        int n2 = string.lastIndexOf(":");
        String string2 = string.substring(n2 + 1);
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return n;
    }

    public static String hashtableToString(Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = null;
        Object var3_3 = null;
        if (hashtable != null && !hashtable.isEmpty()) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                var3_3 = hashtable.get(string);
                stringBuffer.append(String.valueOf(string) + " :");
                if (var3_3 instanceof String[]) {
                    stringBuffer.append(ParameterHelper.stringArrayToString(var3_3));
                    stringBuffer.append(" ,");
                    continue;
                }
                if (var3_3 instanceof String) {
                    stringBuffer.append((String)var3_3);
                    stringBuffer.append(" ,");
                    continue;
                }
                if (var3_3 instanceof Boolean) {
                    stringBuffer.append((Object)var3_3);
                    stringBuffer.append(" ,");
                    continue;
                }
                stringBuffer.append("No supported object");
            }
        }
        return stringBuffer.toString();
    }

    public static String intArrayToString(int[] nArray) {
        String string = "";
        try {
            if (nArray != null && nArray.length != 0) {
                int n = 0;
                while (n < nArray.length) {
                    string = String.valueOf(string) + nArray[n] + ", ";
                    ++n;
                }
                string = string.substring(0, string.length() - 2);
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public static String longArrayToString(long[] lArray) {
        String string = "";
        try {
            if (lArray != null && lArray.length != 0) {
                int n = 0;
                while (n < lArray.length) {
                    string = String.valueOf(string) + lArray[n] + ", ";
                    ++n;
                }
                string = string.substring(0, string.length() - 2);
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public static String stringArrayToString(String[] stringArray) {
        String string = "";
        try {
            if (stringArray != null && stringArray.length != 0) {
                int n = 0;
                while (n < stringArray.length) {
                    string = String.valueOf(string) + stringArray[n] + ", ";
                    ++n;
                }
                string = string.substring(0, string.length() - 2);
            }
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }

    public boolean isValidIP(String string) {
        char[] cArray = string.toCharArray();
        char c = '.';
        char c2 = '-';
        char c3 = '_';
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isLetterOrDigit(cArray[n]) && cArray[n] != c && cArray[n] != c2 && cArray[n] != c3) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static String getIpFromServiceUrl(String string) {
        if (!ParameterHelper.isValidServiceUrl(string)) {
            return null;
        }
        int n = string.indexOf(":");
        int n2 = string.lastIndexOf(":");
        String string2 = string.substring(n + 3, n2 - 1);
        return string2;
    }

    public static boolean isValidServiceUrl(String string) {
        boolean bl = false;
        if (string.indexOf(":") != string.lastIndexOf(":") && string.startsWith("http") && string.indexOf("//") > 0 && string.lastIndexOf(":") == string.length() - 4) {
            bl = true;
        }
        return bl;
    }

    public static int[] convertTointArray(String string) {
        int[] nArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            nArray[n] = Integer.parseInt(string2);
            ++n;
        }
        return nArray;
    }

    public static String[] convertToStringArray(String string) {
        String[] stringArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static final ConfigData readConfigData(DBConnection dBConnection, String string, LogTraceHelper logTraceHelper) {
        ConfigData configData = null;
        try {
            if (dBConnection != null && string != null) {
                configData = new ConfigData();
                configData.setAttribute(string);
                boolean bl = configData.retrieve(dBConnection);
                if (!bl) {
                    configData = null;
                }
            }
        }
        catch (SQLException sQLException) {
            logTraceHelper.traceInfo("No retrieved parameter " + string + " from ConfigData ");
        }
        return configData;
    }

    public static boolean listContainsStringIgnoreCase(List list, String string) {
        if (list != null && string != null) {
            int n = 0;
            while (n < list.size()) {
                if (list.get(n).toString().equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPortIgnoreCase(String var0, DBConnection var1_1) throws EntityNotFoundException {
        block14: {
            try {
                v0 = Class.forName("org.eclipse.aperi.disk.common.util.ParameterHelper");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            var2_2 = LogTraceHelper.entry(v0.getName(), "getPortIgnoreCase", new Object[]{var0, var1_1});
            var3_3 = null;
            try {
                try {
                    try {
                        v2 = Class.forName("org.eclipse.aperi.infrastructure.database.objects.Port");
                    }
                    catch (ClassNotFoundException v3) {
                        throw new NoClassDefFoundError(v3.getMessage());
                    }
                    var4_4 = DiskReportingHelper.getColumnInfo(v2, "NAME", var2_2);
                    var5_6 = "SELECT " + var4_4.getName() + " FROM " + var4_4.getTableName() + " WHERE UPPER(" + var4_4.getName() + ") = UPPER('" + var0 + "')";
                    var6_7 = var1_1.getConnection().createStatement();
                    var7_8 = var6_7.executeQuery(var5_6);
                    if (!var7_8.next()) {
                        var7_8.close();
                        throw new EntityNotFoundException(null, var0);
                    }
                    var3_3 = (String)var7_8.getObject(var4_4.getName());
                    var7_8.close();
                }
                catch (SQLException var4_5) {
                    var2_2.traceError("Internal error: SQLException", var4_5);
                    throw DiskMessageHelper.getServerException("HWN021503E", null, var4_5, var2_2);
                }
            }
            catch (Throwable var9_9) {
                var8_10 = null;
                try {
                    var1_1.commit();
                }
                catch (Exception var10_12) {
                    var2_2.traceError("Internal error exception during commit", var10_12);
                }
                var2_2.exit(var3_3);
                throw var9_9;
            }
            {
                var8_11 = null;
            }
            ** try [egrp 4[TRYBLOCK] [5 : 246->253)] { 
lbl41:
            // 1 sources

            var1_1.commit();
            break block14;
lbl43:
            // 1 sources

            catch (Exception var10_13) {
                var2_2.traceError("Internal error exception during commit", var10_13);
            }
        }
        var2_2.exit(var3_3);
        return var3_3;
    }
}

