/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import javax.swing.JComponent;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.AlertProductManager;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.gui.AlertLogTable;
import org.eclipse.aperi.gui.AlertManager;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.AlertLogReq;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.server.guireq.UserPreferences;
import org.eclipse.aperi.xmsg.MessageLog;

public class AlertLogDDI
extends DataDisplayInfo
implements GuiRequestor {
    public static String notApplicableText = MessageLog.getMessageNoID("GUI2020L");
    AlertLogReq requestData;
    boolean[] productMask;
    private AlertLogTable table;

    public static String alertsDirectedTo() {
        Object[] objectArray = new Object[]{GuiUtil.getUserName()};
        return MessageLog.getMessageNoID("GUI2041L", objectArray);
    }

    private void finishInitByNameList(NameList nameList) {
        boolean bl = true;
        short s = nameList.nlInfo;
        if (s == 20) {
            this.requestData.alertID = nameList.nlID;
        } else {
            this.requestData.objectType = s;
            if (nameList.nlID > 0) {
                this.requestData.objectID = nameList.nlID;
                bl = false;
            }
        }
        this.setDescription(s, nameList.nlName, bl, nameList.nlID2);
    }

    public AlertLogDDI(NameList nameList) {
        this.commonInit();
        if (nameList instanceof AlertNameList) {
            AlertNameList alertNameList = (AlertNameList)nameList;
            this.requestData.productCode = alertNameList.nlProductID;
            this.requestData.subProductCode = alertNameList.nlSubProductID;
        }
        this.finishInitByNameList(nameList);
    }

    public AlertLogDDI(short s, byte by, boolean[] blArray) {
        this.commonInit();
        this.requestData.productCode = s;
        this.requestData.subProductCode = by;
        this.setDescription((short)20, null, true, -1);
        this.productMask = blArray;
    }

    public AlertLogDDI(short s, byte by) {
        this(s, by, null);
    }

    public AlertLogDDI(short s) {
        this(s, -1);
    }

    public AlertLogDDI(NameList nameList, short s, byte by, boolean[] blArray) {
        this.commonInit();
        this.requestData.productCode = s;
        this.requestData.subProductCode = by;
        this.productMask = blArray;
        this.finishInitByNameList(nameList);
    }

    public AlertLogDDI(NameList nameList, short s, byte by) {
        this(nameList, s, by, null);
    }

    public AlertLogDDI(short s, boolean bl) {
        this(s, bl, null);
    }

    public AlertLogDDI(short s, boolean bl, boolean[] blArray) {
        short s2;
        this.commonInit();
        this.productMask = blArray;
        this.requestData.productCode = s;
        short s3 = s2 = s > 0 ? s : (short)0;
        if (bl) {
            this.requestData.displayActive = 1;
            super.setDescription(AlertLogDDI.alertsDirectedTo());
            this.helpID = AlertProductManager.getAlertLogUserHelp(s2);
        } else {
            this.requestData.displayActive = (byte)2;
            super.setDescription(MessageLog.getMessageNoID("GUI2042L"));
            this.helpID = AlertProductManager.getAlertLogActiveHelp(s2);
        }
    }

    private void commonInit() {
        this.displayInScrollPane = false;
        this.requestData = new AlertLogReq();
        this.requestData.productCode = (short)-2;
        this.requestData.objectType = (short)-1;
        this.requestData.objectID = -1;
        this.requestData.alertID = -1;
        this.requestData.subProductCode = (byte)-1;
    }

    private void setDescription(short s, String string, boolean bl, int n) {
        String string2;
        Object[] objectArray;
        if (bl) {
            objectArray = new Object[]{ResourceTypeManager.getAlertLogLabel(s)};
            string2 = MessageLog.getMessageNoID("GUI2018L", objectArray);
        } else {
            if (s == 3) {
                string = GuiUtil.formatFilesystem(GuiUtil.getComputer((int)n).gcTSName, string);
            }
            objectArray = CreateOrEditDDI.getObjectTypeName(s);
            Object[] objectArray2 = new Object[]{objectArray, string};
            string2 = MessageLog.getMessageNoID("GUI0049L", objectArray2);
        }
        objectArray = new Object[]{string2};
        super.setDescription(MessageLog.getMessageNoID("GUI2019L", objectArray));
        if (string == null && s == 20) {
            short s2 = this.requestData.productCode > 0 ? this.requestData.productCode : (short)0;
            this.helpID = AlertProductManager.getAlertLogActiveHelp(s2);
        } else {
            this.helpID = ResourceTypeManager.getAlertLogHelp(s);
        }
    }

    public void reDisplay() {
        if (this.panel != null) {
            this.show();
        } else {
            this.submitRequest();
        }
    }

    public void submitRequest() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.ServerSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.server.AlertLogHndlr";
        request.flags = (byte)4;
        request.requestData = this.requestData;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        if (this.table == null) {
            this.table = new AlertLogTable(this);
        }
        ExtAlertLog[][] extAlertLogArray = (ExtAlertLog[][])response.responseData;
        int n = 0;
        while (n < extAlertLogArray.length) {
            ExtAlertLog[] extAlertLogArray2 = extAlertLogArray[n];
            int n2 = 0;
            while (n2 < extAlertLogArray2.length) {
                ExtAlertLog extAlertLog = extAlertLogArray2[n2];
                if (extAlertLog.alComputer == null) {
                    extAlertLog.alComputer = extAlertLog.alComputerID <= 0 ? notApplicableText : GuiUtil.getComputer((int)extAlertLog.alComputerID).gcTSName;
                }
                ++n2;
            }
            ++n;
        }
        this.panel = (JComponent)this.table.getComponent(extAlertLogArray);
        this.show();
    }

    public void goingAway() {
        if (this.table != null) {
            this.table.nullReferences();
        }
        this.table = null;
    }

    public void panelToBeNulled() {
        this.table = null;
    }

    public static void showLoginAlerts() {
        if (!AlertManager.anyToDisplayAtLogin()) {
            return;
        }
        UserPreferences userPreferences = guiMain.getUserPrefs();
        boolean bl = userPreferences.showLoginAlerts != 2;
        AlertLogDDI alertLogDDI = new AlertLogDDI(-1, bl);
        ((DataDisplayInfo)alertLogDDI).reDisplay();
    }
}

