/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.NodeMap;
import org.eclipse.aperi.gui.PrintPreviewable;
import org.eclipse.aperi.gui.TSRMTreeLabel;

public class BaseTree
extends JTree
implements PrintPreviewable {
    public static DefaultTreeModel MyTree;
    public static BaseTreeNode root;
    public static BaseTree pBaseTree;
    public static BaseTreeNode selectedNode;
    public static BaseTreeNode popupNode;
    public static TreePath selectedPath;
    public static Font plainFont;
    public static Font boldFont;
    private static Font monospaceFont;
    private boolean collapsingBranch = false;
    private boolean reSelectNode = false;
    private boolean vetoSelection = false;
    private static BaseTreeNode printingSubNode;
    private int maxPageNumber = 0;
    private int maxCharWidth = 0;
    private PageFormat pageFormat = null;
    private ArrayList visibleNodes;
    private int startPoint = 0;

    static {
        selectedNode = null;
        popupNode = null;
        selectedPath = null;
    }

    public BaseTree() {
        pBaseTree = this;
        plainFont = this.getFont().deriveFont(0);
        boldFont = this.getFont().deriveFont(1);
        printingSubNode = root = new TSRMTreeLabel();
        MyTree = new DefaultTreeModel(root, true);
        this.setModel(MyTree);
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new BaseTreeCellRenderer());
        BaseTreeWillExpand baseTreeWillExpand = new BaseTreeWillExpand();
        this.addTreeWillExpandListener(baseTreeWillExpand);
        BaseTreeExpanded baseTreeExpanded = new BaseTreeExpanded();
        this.addTreeExpansionListener(baseTreeExpanded);
        BaseTreeSelection baseTreeSelection = new BaseTreeSelection();
        this.addTreeSelectionListener(baseTreeSelection);
        BaseTreeMouse baseTreeMouse = new BaseTreeMouse();
        this.addMouseListener(baseTreeMouse);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public static void setPrintableSubTree(BaseTreeNode baseTreeNode) {
        printingSubNode = baseTreeNode;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > this.maxPageNumber) {
            return 1;
        }
        this.pageFormat = pageFormat;
        graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics.setColor(BaseTree.printingSubNode.nodeColor);
        int n2 = (int)pageFormat.getImageableWidth();
        int n3 = (int)pageFormat.getImageableHeight();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        this.maxCharWidth = fontMetrics.getMaxAdvance();
        this.visibleNodes = new ArrayList();
        this.maxPageNumber = 0;
        monospaceFont = new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize());
        this.startPoint = this.getPathBounds((TreePath)new TreePath((Object[])BaseTree.printingSubNode.getPath())).y;
        this.calculatePagesRequired(printingSubNode, n2, n3 -= fontMetrics.getHeight() * 6);
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        while (n5 < this.visibleNodes.size()) {
            NodeMap nodeMap = (NodeMap)this.visibleNodes.get(n5);
            if (nodeMap.getPageIndex() == n) {
                bl = true;
                this.printTreeNode(nodeMap.getNode(), graphics, n4, n, this.pageFormat);
                n4 += this.getPathBounds((TreePath)new TreePath((Object[])nodeMap.getNode().getPath())).height;
            }
            ++n5;
        }
        if (bl) {
            return 0;
        }
        return 1;
    }

    private void printTreeNode(BaseTreeNode baseTreeNode, Graphics graphics, int n, int n2, PageFormat pageFormat) {
        graphics.setFont(boldFont);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (n2 == 0) {
            graphics.drawString(String.valueOf(PrintPreviewable.CREATED_BY) + " " + GuiUtil.getUserName() + "     " + PrintPreviewable.PRINTED_ON + " " + Util.formatDateTime(new Date()), 0, fontMetrics.getAscent());
        }
        graphics.drawString(printingSubNode.toString(), 0, fontMetrics.getHeight() * 2);
        n += fontMetrics.getHeight() * 4;
        graphics.setColor(baseTreeNode.nodeColor);
        graphics.setFont(monospaceFont);
        String string = "  ";
        if (baseTreeNode.getAllowsChildren()) {
            string = this.isExpanded(new TreePath(baseTreeNode.getPath())) ? "- " : "+ ";
        }
        graphics.drawString(string, this.maxCharWidth * baseTreeNode.getLevel(), n);
        fontMetrics = graphics.getFontMetrics();
        int n3 = (int)fontMetrics.getStringBounds(string, graphics).getWidth() + this.maxCharWidth * baseTreeNode.getLevel();
        graphics.setFont(this.getFont());
        fontMetrics = graphics.getFontMetrics();
        graphics.drawString(baseTreeNode.toString(), n3, n);
        graphics.drawString(Util.getString("LABEL_PAGE_X_OF_Y", Integer.toString(n2 + 1), Integer.toString(this.getNumberOfPages())), 0, (int)(pageFormat.getImageableHeight() - (double)fontMetrics.getHeight()));
    }

    private void calculatePagesRequired(BaseTreeNode baseTreeNode, int n, int n2) {
        this.visibleNodes.add(new NodeMap(baseTreeNode, this.maxPageNumber));
        if (baseTreeNode.getAllowsChildren() && pBaseTree.isExpanded(new TreePath(baseTreeNode.getPath()))) {
            baseTreeNode.getChildCount();
            Enumeration<TreeNode> enumeration = baseTreeNode.children();
            while (enumeration.hasMoreElements()) {
                BaseTreeNode baseTreeNode2 = (BaseTreeNode)enumeration.nextElement();
                int n3 = this.getPathBounds((TreePath)new TreePath((Object[])baseTreeNode2.getPath())).y;
                int n4 = this.getPathBounds((TreePath)new TreePath((Object[])baseTreeNode2.getPath())).height;
                int n5 = n3 + n4;
                if (n5 - this.startPoint > n2) {
                    ++this.maxPageNumber;
                    this.startPoint = this.getPathBounds((TreePath)new TreePath((Object[])baseTreeNode2.getPath())).y;
                }
                if (baseTreeNode2.getChildCount() > 0) {
                    this.calculatePagesRequired(baseTreeNode2, n, n2);
                    continue;
                }
                this.visibleNodes.add(new NodeMap(baseTreeNode2, this.maxPageNumber));
            }
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return true;
    }

    public void collapseBranch(BaseTreeNode baseTreeNode) {
        BaseTreeNode baseTreeNode2;
        this.collapsingBranch = true;
        Enumeration<TreeNode> enumeration = baseTreeNode.depthFirstEnumeration();
        while ((baseTreeNode2 = (BaseTreeNode)enumeration.nextElement()) != null) {
            this.collapsePath(new TreePath(baseTreeNode2.getPath()));
        }
        this.collapsingBranch = false;
        if (baseTreeNode == root) {
            root.expand(null);
            MyTree.nodeStructureChanged(root);
        }
    }

    private void reselect(TreePath treePath, boolean bl, BaseTreeNode baseTreeNode) {
        if (bl && !this.isVisible(treePath)) {
            treePath = null;
        }
        this.reSelectNode = true;
        this.setSelectionPath(treePath);
        if (!bl) {
            this.scrollPathToVisible(treePath);
        }
        this.reSelectNode = false;
        selectedNode = baseTreeNode;
        selectedPath = treePath;
    }

    private void reselect(TreePath treePath, BaseTreeNode baseTreeNode) {
        this.reselect(treePath, true, baseTreeNode);
    }

    public void reselect(BaseTreeNode baseTreeNode, boolean bl) {
        if (baseTreeNode == null) {
            this.setSelectionRow(0);
        } else {
            this.reselect(new TreePath(baseTreeNode.getPath()), bl, baseTreeNode);
        }
    }

    public void reselect(BaseTreeNode baseTreeNode) {
        this.reselect(baseTreeNode, true);
    }

    public void newTree() {
        root.removeAllChildren();
        root.expandBranch(1);
        this.setVisible(true);
    }

    public void setScale(int n) {
    }

    public int fitToPage(PageFormat pageFormat) {
        return 100;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
    }

    public int getNumberOfPages() {
        return this.maxPageNumber + 1;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        return this.pageFormat;
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    private class BaseTreeWillExpand
    implements TreeWillExpandListener {
        private BaseTreeWillExpand() {
        }

        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
            ((BaseTreeNode)treeExpansionEvent.getPath().getLastPathComponent()).expand(treeExpansionEvent);
        }

        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
            ((BaseTreeNode)treeExpansionEvent.getPath().getLastPathComponent()).collapse(treeExpansionEvent);
            if (treeExpansionEvent.getPath().isDescendant(BaseTree.this.getSelectionPath())) {
                BaseTree.this.vetoSelection = true;
            }
        }
    }

    private class BaseTreeExpanded
    implements TreeExpansionListener {
        private BaseTreeExpanded() {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            BaseTreeNode baseTreeNode = null;
            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getCurrent();
            if (dataDisplayInfo != null) {
                baseTreeNode = dataDisplayInfo.treeNode;
            }
            if (baseTreeNode != null) {
                TreePath treePath = new TreePath(baseTreeNode.getPath());
                if (treeExpansionEvent.getPath().isDescendant(treePath)) {
                    BaseTree.this.reselect(treePath, baseTreeNode);
                }
            }
        }
    }

    private class BaseTreeSelection
    implements TreeSelectionListener {
        private BaseTreeSelection() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            BaseTreeNode baseTreeNode = (BaseTreeNode)BaseTree.this.getLastSelectedPathComponent();
            if (baseTreeNode != null && !BaseTree.this.reSelectNode) {
                TreePath treePath;
                boolean bl;
                boolean bl2 = false;
                if (BaseTree.this.vetoSelection || BaseTree.this.collapsingBranch) {
                    bl = false;
                    BaseTree.this.vetoSelection = false;
                } else {
                    baseTreeNode.select(treeSelectionEvent);
                    bl = baseTreeNode.selectable;
                    if (!bl) {
                        bl2 = baseTreeNode.getAllowsChildren();
                    }
                }
                if (!bl) {
                    treePath = treeSelectionEvent.getOldLeadSelectionPath();
                    BaseTree.this.reselect(treePath, baseTreeNode);
                } else {
                    selectedNode = baseTreeNode;
                    selectedPath = treeSelectionEvent.getNewLeadSelectionPath();
                }
                if (bl2) {
                    treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    if (BaseTree.this.isExpanded(treePath)) {
                        BaseTree.this.collapsePath(treePath);
                    } else {
                        BaseTree.this.expandPath(treePath);
                    }
                }
            }
        }
    }

    private class BaseTreeMouse
    extends MouseAdapter {
        private BaseTreeMouse() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.checkPopup(mouseEvent);
        }

        private void checkPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger() && BaseTree.this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY()) > -1) {
                BaseTreeNode baseTreeNode;
                TreePath treePath = BaseTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                popupNode = baseTreeNode = (BaseTreeNode)treePath.getLastPathComponent();
                baseTreeNode.showPopupMenu(mouseEvent);
            }
        }
    }

    private class BaseTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            this.setIcon(null);
            this.setFont(plainFont);
            ((BaseTreeNode)object).render(this, (BaseTree)jTree, bl, bl2, bl3, n, bl4);
            return this;
        }
    }
}

