/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;

public final class Capabilities {
    public static final int DATA_ADMIN = 1;
    public static final int DISK_ADMIN = 2;
    public static final int FABRIC_ADMIN = 3;
    public static final int ANY_ADMIN = 4;
    public static final int APERI_ADMIN = 5;
    public static final int TAPE_ADMIN = 6;
    public static final int NUM_ADMINS = 7;
    public static final String[] roleNames = new String[]{" ", Util.getString("LABEL_DATA_ADMIN"), Util.getString("LABEL_DISK_ADMIN"), Util.getString("LABEL_FABRIC_ADMIN"), " ", Util.getString("LABEL_APERI_ADMIN"), Util.getString("LABEL_TAPE_ADMIN")};
    private boolean aperi_superuser;
    private boolean aperi_admin;
    private boolean aperi_data_admin;
    private boolean aperi_data_op;
    private boolean aperi_fabric_admin;
    private boolean aperi_fabric_op;
    private boolean aperi_disk_admin;
    private boolean aperi_disk_op;
    private boolean aperi_tape_admin;
    private boolean aperi_tape_op;
    private boolean aperi_any_admin;

    public Capabilities(int n, int n2, boolean bl) {
        this.aperi_superuser = RoleChecker.isUserInRole(n, RoleChecker.SUPERUSER);
        this.aperi_admin = RoleChecker.isUserInRole(n, RoleChecker.APERI_ADMIN);
        this.aperi_data_admin = RoleChecker.isUserInRole(n, RoleChecker.DATA_ADMIN);
        this.aperi_data_op = RoleChecker.isUserInRole(n, RoleChecker.DATA_VIEWER);
        this.aperi_fabric_admin = RoleChecker.isUserInRole(n, RoleChecker.FABRIC_ADMIN);
        this.aperi_fabric_op = RoleChecker.isUserInRole(n, RoleChecker.FABRIC_VIEWER);
        this.aperi_disk_admin = RoleChecker.isUserInRole(n, RoleChecker.DISK_ADMIN);
        this.aperi_disk_op = RoleChecker.isUserInRole(n, RoleChecker.DISK_VIEWER);
        this.aperi_tape_admin = RoleChecker.isUserInRole(n, RoleChecker.TAPE_ADMIN);
        this.aperi_tape_op = RoleChecker.isUserInRole(n, RoleChecker.TAPE_VIEWER);
        this.aperi_any_admin = this.aperi_superuser || this.aperi_admin || this.aperi_fabric_admin || this.aperi_data_admin || this.aperi_disk_admin || this.aperi_tape_admin;
    }

    public boolean isSuperuser() {
        return this.aperi_superuser;
    }

    public boolean isAperiAdmin() {
        return this.aperi_admin;
    }

    public boolean isDataAdmin() {
        return this.aperi_data_admin;
    }

    public boolean isDataOp() {
        return this.aperi_data_op;
    }

    public boolean isFabricAdmin() {
        return this.aperi_fabric_admin;
    }

    public boolean isFabricOp() {
        return this.aperi_fabric_op;
    }

    public boolean isDiskAdmin() {
        return this.aperi_disk_admin;
    }

    public boolean isDiskOp() {
        return this.aperi_disk_op;
    }

    public boolean isTapeAdmin() {
        return this.aperi_tape_admin;
    }

    public boolean isTapeOp() {
        return this.aperi_tape_op;
    }

    public boolean isAnyAdmin() {
        return this.aperi_any_admin;
    }

    public boolean adminCapable(int n) {
        boolean bl = false;
        switch (n) {
            case 4: {
                bl = this.isAnyAdmin();
                break;
            }
            case 1: {
                bl = this.isDataAdmin();
                break;
            }
            case 2: {
                bl = this.isDiskAdmin();
                break;
            }
            case 3: {
                bl = this.isFabricAdmin();
                break;
            }
            case 5: {
                bl = this.isAperiAdmin();
            }
        }
        return bl;
    }
}

