/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.eclipse.aperi.xmsg.MessageLog;

public class DragEnabledTree
extends JTree
implements MouseListener,
MouseMotionListener,
KeyListener {
    private DropListener dropListener;
    private boolean inDrag;
    private Point offsetToMouse;
    private Rectangle dragSourceBounds;
    private static TreeSelectionModel dragSelectionModel;
    private TreeSelectionModel savedSelectionModel;
    private Cursor savedCursor;
    private TreePath sourceParentPath;
    private TreePath dragSourcePath;
    private TreePath dragTargetPath;
    private int row;
    private JLayeredPane layeredPane;
    private JLabel dragSourceComponent;
    private Object dragSource;
    private Object dragTarget;
    private int cursorState;
    public static final int NORMAL_CURSOR = -1;
    public static final int DRAG_CURSOR = 0;
    public static final int MOVE = 1;
    public static final int COPY = 2;
    public static final int N_DRAG_CURSORS = 3;
    private static Cursor[] cursorArray;
    private static final String[] cursorPaths;
    private static final String[] cursorNames;

    static {
        Class<?> clazz;
        dragSelectionModel = new DefaultTreeSelectionModel();
        cursorPaths = new String[]{"images/drag_crsr.gif", "images/move_crsr.gif", "images/copy_crsr.gif"};
        cursorNames = new String[]{"org.eclipse.aperi.drag", "org.eclipse.aperi.move", "org.eclipse.aperi.copy"};
        cursorArray = new Cursor[3];
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point point = new Point(7, 5);
        try {
            clazz = Class.forName("org.eclipse.aperi.gui.DragEnabledTree");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Class<?> clazz2 = clazz;
        int n = 0;
        while (n < 3) {
            URL uRL = clazz2.getResource(cursorPaths[n]);
            Image image = toolkit.getImage(uRL);
            DragEnabledTree.cursorArray[n] = toolkit.createCustomCursor(image, point, cursorNames[n]);
            ++n;
        }
    }

    private void ctorHelper(DropListener dropListener) {
        this.dropListener = dropListener;
        this.inDrag = false;
        this.dragSource = null;
        this.dragTarget = null;
        this.offsetToMouse = new Point(0, 0);
        this.dragSourceComponent = new JLabel();
        this.cursorState = -1;
        this.addMouseListener(this);
    }

    public DragEnabledTree(DropListener dropListener, TreeNode treeNode) {
        super(treeNode);
        this.ctorHelper(dropListener);
    }

    public DragEnabledTree(DropListener dropListener) {
        this.ctorHelper(dropListener);
    }

    public DragEnabledTree(DropListener dropListener, TreeModel treeModel) {
        super(treeModel);
        this.ctorHelper(dropListener);
    }

    private TreePath getPathForEvent(MouseEvent mouseEvent, Point point) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.row = this.getRowForLocation(n, n2);
        TreePath treePath = this.getPathForRow(this.row);
        if (treePath == null) {
            return null;
        }
        Rectangle rectangle = this.getPathBounds(treePath);
        if (rectangle == null) {
            return null;
        }
        if (!rectangle.contains(n, n2)) {
            return null;
        }
        if (point != null) {
            point.setLocation(n - rectangle.x, n2 - rectangle.y);
            this.dragSourceBounds = rectangle;
        }
        return treePath;
    }

    public TreePath getPathForEvent(MouseEvent mouseEvent) {
        return this.getPathForEvent(mouseEvent, null);
    }

    private void setCursorState(int n) {
        int n2 = 3;
        int cfr_ignored_0 = n & n2;
        int n3 = (n & 1) != 0 ? ((n & 2) != 0 ? 0 : 1) : ((n & 2) != 0 ? 2 : 0);
        if (n3 != this.cursorState) {
            this.cursorState = n3;
            this.setCursor(cursorArray[n3]);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (mouseEvent.getClickCount() > 1) {
            return;
        }
        this.dragSourcePath = this.getPathForEvent(mouseEvent, this.offsetToMouse);
        if (this.dragSourcePath == null) {
            return;
        }
        this.layeredPane = this.getRootPane().getLayeredPane();
        this.sourceParentPath = this.dragSourcePath.getParentPath();
        this.savedSelectionModel = this.getSelectionModel();
        this.setSelectionModel(dragSelectionModel);
        this.dragSource = this.dragSourcePath.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.dragSource;
        JLabel jLabel = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, this.dragSource, false, false, !defaultMutableTreeNode.getAllowsChildren(), this.row, false);
        this.dragSourceComponent.setText(jLabel.getText());
        this.dragSourceComponent.setIcon(jLabel.getIcon());
        this.dragSourceComponent.setHorizontalAlignment(jLabel.getHorizontalAlignment());
        this.dragSourceComponent.setVerticalAlignment(jLabel.getVerticalAlignment());
        this.dragSourceComponent.setFont(jLabel.getFont());
        this.dragTarget = null;
        this.setSelectionPath(this.dragSourcePath);
        this.savedCursor = this.getCursor();
        this.cursorState = -1;
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.inDrag = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        boolean bl = this.inDrag;
        this.inDrag = false;
        if (!bl) {
            return;
        }
        this.removeMouseMotionListener(this);
        this.removeKeyListener(this);
        this.setCursor(this.savedCursor);
        this.setSelectionModel(this.savedSelectionModel);
        if (this.dragTarget != null) {
            if (this.cursorState != 1 && this.cursorState != 2) {
                String string = MessageLog.getMessageNoID("GUI0101T", null);
                String string2 = MessageLog.getMessageNoID("GUI0102M", null);
                String string3 = MessageLog.getMessageNoID("GUI0103L", null);
                String string4 = MessageLog.getMessageNoID("GUI0104L", null);
                Object[] objectArray = new Object[]{string3, string4};
                int n = JOptionPane.showOptionDialog(this, string2, string, 0, 3, null, objectArray, objectArray[0]);
                this.cursorState = n == 0 ? 1 : 2;
            }
            this.dropListener.dropped(this, this.dragSourcePath, this.dragTargetPath, this.cursorState);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        TreePath[] treePathArray;
        this.setCursorState(mouseEvent.getModifiers());
        int n = mouseEvent.getX() - this.offsetToMouse.x;
        int n2 = mouseEvent.getY() - this.offsetToMouse.y;
        Rectangle rectangle = new Rectangle(this.dragSourceBounds);
        this.dragSourceBounds.x = n;
        this.dragSourceBounds.y = n2;
        this.dragSourceComponent.setBounds(this.dragSourceBounds);
        rectangle = rectangle.union(this.dragSourceBounds);
        this.repaint(rectangle);
        TreePath treePath = this.getPathForEvent(mouseEvent);
        Object object = treePath != null ? treePath.getLastPathComponent() : null;
        if (this.dragTarget != null && object != this.dragTarget) {
            this.removeSelectionPath(this.dragTargetPath);
        }
        if (this.dragSourcePath.isDescendant(treePath)) {
            object = null;
        }
        if (object != null && !(treePathArray = (TreePath[])object).getAllowsChildren()) {
            object = null;
        }
        if (this.sourceParentPath != null && this.sourceParentPath.equals(treePath)) {
            object = null;
        }
        if (object == null) {
            this.dragTarget = null;
        }
        if (object == this.dragTarget) {
            return;
        }
        this.dragTargetPath = treePath;
        this.dragTarget = object;
        treePathArray = new TreePath[]{treePath, this.dragSourcePath};
        this.setSelectionPaths(treePathArray);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if (n2 == 17) {
            n |= 2;
        } else if (n2 == 16) {
            n |= 1;
        }
        this.setCursorState(n);
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        if (n2 == 17) {
            n &= 0xFFFFFFFD;
        } else if (n2 == 16) {
            n &= 0xFFFFFFFE;
        }
        this.setCursorState(n);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.inDrag) {
            SwingUtilities.paintComponent(graphics, this.dragSourceComponent, this.layeredPane, this.dragSourceBounds);
        }
    }

    public static interface DropListener {
        public void dropped(DragEnabledTree var1, TreePath var2, TreePath var3, int var4);
    }
}

