/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.eclipse.aperi.TStorm.gui.PrimitiveConditionEditor;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScriptDefinitionDialog
extends JDialog
implements ActionListener {
    private static String title = MessageLog.getMessageNoID("GUI2074L");
    private static final String OK = "K";
    private static final String CANCEL = "X";
    protected AlertDefinition alertDef;
    protected Container pane;
    protected GridBagConstraints c;
    private NameList computers;
    private JComboBox computersCombo;
    private JTextField scriptNameField;
    static IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ScriptDefinitionDialog(AlertDefinition alertDefinition, NameList nameList) {
        super(guiMain.getFrame(), title, true);
        this.alertDef = alertDefinition;
        if (!AlertConditionManager.hasSourceAgent(this.alertDef.aldCondition)) {
            this.computers = nameList;
        } else {
            this.computers = new NameList();
            this.computers.nlID = 0;
            this.computers.nlName = MessageLog.getMessageNoID("GUI2075L");
            this.computers.nlNext = nameList;
        }
    }

    protected void addFootnote() {
    }

    protected String getSpecialParm(int n) {
        return "(null)";
    }

    private void listParameters() {
        String[] stringArray = AlertConditionManager.getScriptParameterStringIdList(this.alertDef.aldCondition);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n <= stringArray.length) {
            stringBuffer.setLength(0);
            stringBuffer.append('$');
            stringBuffer.append(String.valueOf(n));
            stringBuffer.append(" = ");
            String string = stringArray[n - 1];
            string = string != null ? MessageLog.getMessageNoID(string) : this.getSpecialParm(n);
            stringBuffer.append(string);
            JLabel jLabel = new JLabel(stringBuffer.toString());
            jLabel.setForeground(Color.black);
            if (n == stringArray.length) {
                this.c.weighty = 1.0;
            }
            this.pane.add((Component)jLabel, this.c);
            ++n;
        }
        this.addFootnote();
    }

    public void show() {
        DefaultComboBoxModel<NameList> defaultComboBoxModel = new DefaultComboBoxModel<NameList>();
        NameList nameList = this.computers;
        NameList nameList2 = null;
        while (this.computers != null) {
            defaultComboBoxModel.addElement(this.computers);
            if (this.computers.nlID == this.alertDef.aldScriptComputerID) {
                nameList2 = this.computers;
            }
            this.computers = this.computers.nlNext;
        }
        if (nameList2 == null) {
            nameList2 = nameList;
        }
        defaultComboBoxModel.setSelectedItem(nameList2);
        this.computersCombo = new TComboBox((ComboBoxModel)defaultComboBoxModel);
        this.scriptNameField = TTextField.newTTextField(this.alertDef.aldScriptName, 10, 64, false, true);
        JPanel jPanel = new JPanel(new GridBagLayout());
        String string = MessageLog.getMessageNoID("GUI2077L");
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(BaseTree.boldFont);
        GuiUtil.setAccessibleLabel(jLabel, this.scriptNameField, "MNEMONIC_SCRIPTNAME", MessageLog.getMessageNoID("GUI2077L"), "DESCRIPTION_SCRIPTNAME");
        this.c = new GridBagConstraints();
        this.c.insets.right = 2;
        this.c.insets.left = 2;
        this.c.insets.bottom = 8;
        this.c.anchor = 13;
        jPanel.add((Component)jLabel, this.c);
        this.c.gridwidth = 0;
        this.c.anchor = 17;
        jPanel.add((Component)this.scriptNameField, this.c);
        string = MessageLog.getMessageNoID("GUI2078L");
        jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(BaseTree.boldFont);
        this.c.insets.bottom = 0;
        this.c.anchor = 13;
        this.c.gridwidth = 1;
        this.c.gridheight = 0;
        jPanel.add((Component)jLabel, this.c);
        this.c.anchor = 17;
        this.c.gridwidth = 0;
        jPanel.add((Component)this.computersCombo, this.c);
        this.pane = this.getContentPane();
        this.pane.setLayout(new GridBagLayout());
        this.c.gridheight = 1;
        this.c.insets.left = 6;
        this.c.insets.right = 6;
        this.c.insets.top = 15;
        this.c.insets.bottom = 6;
        this.c.fill = 2;
        this.c.anchor = 10;
        this.pane.add((Component)jPanel, this.c);
        Color color = this.pane.getBackground();
        PrimitiveConditionEditor.HorizontalSeparator horizontalSeparator = new PrimitiveConditionEditor.HorizontalSeparator(color);
        this.c.weightx = 1.0;
        this.c.insets.top = 10;
        this.c.insets.bottom = 0;
        this.pane.add((Component)horizontalSeparator, this.c);
        string = MessageLog.getMessageNoID("GUI2079L");
        jLabel = new JLabel(string);
        jLabel.setForeground(Color.black);
        jLabel.setFont(BaseTree.boldFont);
        this.c.insets.top = 6;
        this.c.weightx = 0.0;
        this.c.fill = 0;
        this.c.anchor = 18;
        this.pane.add((Component)jLabel, this.c);
        this.c.insets.left = 40;
        this.c.insets.right = 6;
        this.c.insets.top = 0;
        this.c.insets.bottom = 0;
        this.listParameters();
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.c.insets.left = 6;
        this.c.insets.right = 6;
        this.c.insets.top = 12;
        this.c.insets.bottom = 10;
        this.c.anchor = 10;
        horizontalSeparator = new PrimitiveConditionEditor.HorizontalSeparator(color);
        this.pane.add((Component)horizontalSeparator, this.c);
        string = MessageLog.getMessageNoID("GUI0113L");
        JButton jButton = new JButton(string);
        jButton.setActionCommand(OK);
        GuiUtil.setAccessible(jButton, jButton.getText(), jButton.getText());
        jButton.addActionListener(this);
        jButton.setEnabled(!Util.isEmpty(this.alertDef.aldScriptName));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(10));
        string = MessageLog.getMessageNoID("GUI0114L");
        JButton jButton2 = new JButton(string);
        jButton2.setActionCommand(CANCEL);
        GuiUtil.setAccessible(jButton2, jButton2.getText(), jButton2.getText());
        jButton2.addActionListener(this);
        jPanel.add(jButton2);
        jPanel.add(Box.createHorizontalStrut(10));
        string = MessageLog.getMessageNoID("GUI0072L");
        JButton jButton3 = new JButton(string);
        jButton3.setMnemonic(GuiUtil.getMnemonic("MNEMONIC_HELP"));
        GuiUtil.setAccessible(jButton3, jButton3.getText(), jButton3.getText());
        jButton3.addActionListener(Help.getDisplayHelpFromSource());
        jPanel.add(jButton3);
        this.c.insets.left = 0;
        this.c.insets.right = 0;
        this.c.insets.top = 10;
        this.c.insets.bottom = 15;
        this.c.fill = 0;
        this.c.gridheight = 0;
        this.pane.add((Component)jPanel, this.c);
        this.getRootPane().setDefaultButton(jButton);
        this.pack();
        GuiUtil.centerDialog(this);
        string = AlertConditionManager.getScriptHelpId(this.alertDef.aldCondition);
        Help.setHelpID(jButton3, string);
        Help.setHelpID(this.getRootPane(), string);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        super.show();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == OK) {
            NameList nameList = (NameList)this.computersCombo.getSelectedItem();
            this.alertDef.aldScriptComputerID = nameList.nlID;
            this.alertDef.aldScriptName = this.scriptNameField.getText();
        }
        this.dispose();
    }
}

