/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SizeLimitedDocument
extends PlainDocument {
    private int maxLength;
    private boolean isNumber;

    public SizeLimitedDocument(int n, boolean bl) {
        this.isNumber = bl;
        this.maxLength = n;
    }

    public void setMaxSize(int n) {
        this.maxLength = n;
        int n2 = this.getLength();
        if (n2 > n) {
            try {
                this.remove(0, n2);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string != null && string.length() > 0) {
            if (n == 0 && string.charAt(0) == ' ') {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (string.length() + this.getLength() > this.maxLength) {
                Toolkit.getDefaultToolkit().beep();
                if (this.maxLength - this.getLength() < string.length()) {
                    string = string.substring(0, this.maxLength - this.getLength());
                } else {
                    return;
                }
            }
            if (this.isNumber) {
                int n2 = string.length() - 1;
                while (n2 >= 0) {
                    if (!Character.isDigit(string.charAt(n2))) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    --n2;
                }
            }
        }
        super.insertString(n, string, attributeSet);
    }
}

