/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.OutOfBandFabricAgentDDI;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.OutOfBandFabricAgentInfo;
import org.eclipse.aperi.xmsg.MessageLog;

public class OutOfBandFabricAgentTreeNode
extends AgentTreeNode
implements GuiRequestor,
ActionListener {
    private String node_name;
    private String node_ip;
    private int node_state;
    private JPopupMenu popup;
    private static String checkMenuItemString;
    private static String viewLogMenuItemString;
    private static String removeMenuItemString;
    private static String refreshMenuItemString;
    private OutOfBandFabricAgentDDI addi;

    public OutOfBandFabricAgentTreeNode(Object object, String string, byte by) {
        super(object, 0, by);
        this.node_name = (String)object;
        this.node_ip = string;
        this.node_state = by;
        this.setUserObject(object);
        this.setAllowsChildren(false);
    }

    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, BaseTree baseTree, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        switch (this.node_state) {
            case 1: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateUpIcon());
                break;
            }
            case 0: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateDownIcon());
                break;
            }
            default: {
                defaultTreeCellRenderer.setIcon(IconFactory.getStateDefectedIcon());
            }
        }
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        this.popup = this.getPopupMenu();
        checkMenuItemString = FabricGuiUtil.getString("FabricOutOfBand_Check");
        JMenuItem jMenuItem = new JMenuItem(checkMenuItemString);
        jMenuItem.setActionCommand(checkMenuItemString);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(true);
        this.popup.add(jMenuItem);
        removeMenuItemString = MessageLog.getMessageNoID("ADG0262L");
        JMenuItem jMenuItem2 = new JMenuItem(removeMenuItemString);
        jMenuItem2.setToolTipText(MessageLog.getMessageNoID("ADG0263T"));
        jMenuItem2.setActionCommand(removeMenuItemString);
        jMenuItem2.addActionListener(this);
        jMenuItem2.setEnabled(this.capabilities.isAperiAdmin());
        this.popup.add(jMenuItem2);
        refreshMenuItemString = MessageLog.getMessageNoID("ADG0003L");
        JMenuItem jMenuItem3 = new JMenuItem(refreshMenuItemString);
        jMenuItem3.setToolTipText(MessageLog.getMessageNoID("ADG0004T"));
        jMenuItem3.setActionCommand(refreshMenuItemString);
        jMenuItem3.addActionListener(this);
        jMenuItem3.setEnabled(true);
        this.popup.add(jMenuItem3);
        super.showPopupMenu(this.popup, mouseEvent);
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = (OutOfBandFabricAgentInfo)response.responseData;
            switch (outOfBandFabricAgentInfo.request_type) {
                case 4: {
                    this.setNodeIconBasedOnStatusFromServer(outOfBandFabricAgentInfo.status);
                    if (outOfBandFabricAgentInfo.status == 2) {
                        String string = MessageLog.getMessageNoID("ADG0294M", this.node_name);
                        JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                        break;
                    }
                    String string = String.valueOf(this.node_name) + " " + FabricGuiUtil.getInbandFabricAgentStatusString(outOfBandFabricAgentInfo.status);
                    JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                    break;
                }
                case 3: {
                    BaseTree.MyTree.removeNodeFromParent(this);
                    if (this.ddi == null) break;
                    this.ddi.remove();
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        String string = actionEvent.getActionCommand();
        if (string.equals(checkMenuItemString)) {
            object2 = new Request();
            ((Request)object2).typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            ((Request)object2).serviceName = RequestTypeManager.getInternalName(((Request)object2).typeCode);
            ((Request)object2).subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
            ((Request)object2).userName = GuiUtil.getUserName();
            ((Request)object2).requestData = object = new OutOfBandFabricAgentInfo();
            ((Request)object2).flags = (byte)4;
            ((OutOfBandFabricAgentInfo)object).request_type = 4;
            ((OutOfBandFabricAgentInfo)object).hostname = this.node_name;
            ((OutOfBandFabricAgentInfo)object).ipaddress = this.node_ip;
            GuiClient.doRequest(this, (Request)object2);
        }
        if (string.equals(viewLogMenuItemString)) {
            JOptionPane.showMessageDialog(guiMain.getFrame(), FabricGuiUtil.getString("FabricOutOfBand_ViewLog"));
        }
        if (string.equals(removeMenuItemString)) {
            object2 = Util.getString("CONFIRM_DELETE", this.node_name);
            object = MessageLog.getMessageNoID("ADG0262L");
            int n = JOptionPane.showConfirmDialog(guiMain.getFrame(), object2, (String)object, 0, 2);
            if (n == 0) {
                Request request = new Request();
                request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
                request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
                request.subType = "org.eclipse.aperi.server.handler.gui.fabric.OutOfBandFabricAgentHandler";
                request.userName = GuiUtil.getUserName();
                OutOfBandFabricAgentInfo outOfBandFabricAgentInfo = new OutOfBandFabricAgentInfo();
                outOfBandFabricAgentInfo.hostname = this.node_name;
                outOfBandFabricAgentInfo.ipaddress = this.node_ip;
                outOfBandFabricAgentInfo.request_type = 3;
                request.requestData = outOfBandFabricAgentInfo;
                request.flags = (byte)4;
                GuiClient.doRequest(this, request);
            }
        } else if (string.equals(refreshMenuItemString)) {
            if (this.ddi != null) {
                this.ddi.fileClose();
            }
            this.refresh();
        }
    }

    private void refresh() {
        if (this.ddi == null) {
            this.addi = new OutOfBandFabricAgentDDI(this.node_name, this.node_ip);
            this.ddi = this.addi;
            this.ddi.treeNode = this;
            this.ddi.setDescription(String.valueOf(MessageLog.getMessageNoID("ADG0201L")) + ":  " + this.getUserObject());
        }
        this.ddi.reDisplay();
    }

    public void select(TreeSelectionEvent treeSelectionEvent) {
        this.refresh();
    }

    public void setNodeIconBasedOnStatusFromServer(int n) {
        this.node_state = n == 2 ? 1 : (n == 3 ? 0 : -1);
        BaseTree.MyTree.nodeChanged(this);
    }
}

