/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin.agent;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.LogViewerDDI;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.agent.AgentListDDI;
import org.eclipse.aperi.gui.admin.agent.AgentListPanel;
import org.eclipse.aperi.gui.admin.agent.DataAgentListDDI;
import org.eclipse.aperi.gui.admin.agent.InbandFabricAgentTableModel;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.InbandFabricAgentInfo;
import org.eclipse.aperi.xmsg.MessageLog;

public class InbandFabricAgentListPanel
extends AgentListPanel {
    private JButton viewLogButton = null;
    private JButton checkButton = null;
    private JButton deleteButton = null;

    public InbandFabricAgentListPanel(AgentListDDI agentListDDI) {
        super(agentListDDI);
    }

    protected JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        String string = Util.getString("FabricInBand_Check");
        String string2 = Util.getString("FabricInBand_ViewLog");
        String string3 = MessageLog.getMessageNoID("ADG0262L");
        this.viewLogButton = this.getButton(string2);
        this.checkButton = this.getButton(string);
        this.deleteButton = this.getButton(string3);
        this.deleteButton.setToolTipText(MessageLog.getMessageNoID("ADG0263T"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.viewLogButton);
        jPanel2.add(this.checkButton);
        jPanel2.add(this.deleteButton);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    void disableAllButtons() {
        this.viewLogButton.setEnabled(false);
        this.checkButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
    }

    void chooseButtons(Object object) {
        boolean bl;
        boolean bl2 = bl = object instanceof Vector && ((Vector)object).size() > 1;
        if (!bl) {
            byte by = object instanceof Vector ? ((NameList)((Vector)object).get((int)0)).nlState : ((NameList)object).nlState;
            boolean bl3 = by == 1;
            this.checkButton.setEnabled(true);
            this.viewLogButton.setEnabled(bl3);
        } else {
            this.checkButton.setEnabled(false);
            this.viewLogButton.setEnabled(false);
        }
        this.deleteButton.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        actionEvent.getActionCommand();
        int[] nArray = this.getTable().getSelectedRows();
        NameList[] nameListArray = new NameList[nArray.length];
        int n = 0;
        while (n < nameListArray.length) {
            nameListArray[n] = (NameList)this.getDDI().elementAt(nArray[n]);
            ++n;
        }
        if (object == this.checkButton) {
            this.checkAgent(nameListArray);
        } else if (object == this.deleteButton) {
            this.shutdownAgent(nameListArray);
        } else if (object == this.viewLogButton) {
            AgentTreeNode agentTreeNode = (AgentTreeNode)((DataAgentListDDI)this.getDDI()).getTreeNode(nameListArray[0], false, false);
            new LogViewer(nameListArray[0].nlID, (BaseTreeNode)agentTreeNode, LogViewerDDI.AGENT_INBAND);
        } else if (object == this.refreshNowButton) {
            this.getDDI().getData();
        }
    }

    private void checkAgent(NameList[] nameListArray) {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
        request.userName = GuiUtil.getUserName();
        InbandFabricAgentInfo inbandFabricAgentInfo = new InbandFabricAgentInfo();
        request.requestData = inbandFabricAgentInfo;
        request.flags = (byte)4;
        inbandFabricAgentInfo.request_type = 3;
        inbandFabricAgentInfo.hostname = nameListArray[0].nlName;
        inbandFabricAgentInfo.hostId = nameListArray[0].nlID;
        GuiClient.doRequest(new ActionResponseHandler(nameListArray), request);
    }

    private void shutdownAgent(NameList[] nameListArray) {
        String string;
        String[] stringArray;
        ArrayList<NameList> arrayList = new ArrayList<NameList>();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        int n = 0;
        while (n < nameListArray.length) {
            if (nameListArray[n].nlState == 0) {
                arrayList.add(nameListArray[n]);
                treeSet.add(nameListArray[n].nlName);
            } else {
                stringArray = new String[]{nameListArray[n].nlName, FabricGuiUtil.getInbandFabricAgentStatusString(nameListArray[n].nlState), FabricGuiUtil.getInbandFabricAgentStatusString(0)};
                string = Util.getString("FMSG_InBand_RemoveInvalidState", stringArray);
                treeSet2.add(string);
            }
            ++n;
        }
        String string2 = MessageLog.getMessageNoID("ADG0262L");
        stringArray = FabricGuiUtil.getString("FabricInBand_RemoveErrorTitle");
        string = GuiUtil.getString("CONFIRM_DELETE_MULTIPLE");
        String string3 = GuiUtil.getString("CONFIRM_DELETE_MULTIPLE_ERR");
        JList<String> jList = new JList<String>(treeSet.toArray(new String[treeSet.size()]));
        JList<String> jList2 = new JList<String>(treeSet2.toArray(new String[treeSet2.size()]));
        int n2 = treeSet.size() < 4 ? treeSet.size() : 4;
        int n3 = treeSet2.size() < 4 ? treeSet2.size() : 4;
        jList.setVisibleRowCount(n2);
        jList2.setVisibleRowCount(n3);
        JScrollPane jScrollPane = new JScrollPane(jList);
        JScrollPane jScrollPane2 = new JScrollPane(jList2);
        if (treeSet.isEmpty()) {
            if (treeSet2.isEmpty()) {
                return;
            }
            JOptionPane.showMessageDialog(guiMain.getFrame(), new Object[]{string3, jScrollPane2}, (String)stringArray, 0, null);
            return;
        }
        int n4 = treeSet2.isEmpty() ? JOptionPane.showOptionDialog(guiMain.getFrame(), new Object[]{string, jScrollPane}, string2, 2, 2, null, null, null) : JOptionPane.showOptionDialog(guiMain.getFrame(), new Object[]{string, jScrollPane, string3, jScrollPane2}, string2, 2, 2, null, null, null);
        if (n4 == 0) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.fabric.InBandFabricAgentHandler";
            request.userName = GuiUtil.getUserName();
            InbandFabricAgentInfo[] inbandFabricAgentInfoArray = new InbandFabricAgentInfo[arrayList.size()];
            int n5 = 0;
            while (n5 < arrayList.size()) {
                inbandFabricAgentInfoArray[n5] = new InbandFabricAgentInfo();
                NameList nameList = (NameList)arrayList.get(n5);
                inbandFabricAgentInfoArray[n5].request_type = 2;
                inbandFabricAgentInfoArray[n5].hostId = nameList.nlID;
                ++n5;
            }
            request.requestData = arrayList.size() == 1 ? inbandFabricAgentInfoArray[0] : inbandFabricAgentInfoArray;
            request.flags = (byte)4;
            GuiClient.doRequest(new ActionResponseHandler(arrayList.toArray(new NameList[arrayList.size()])), request);
        }
    }

    private InbandFabricAgentTableModel getTableModel() {
        return (InbandFabricAgentTableModel)this.getDDI().getTableModel();
    }

    private class ActionResponseHandler
    implements GuiRequestor {
        NameList[] agents;

        public ActionResponseHandler(NameList[] nameListArray) {
            this.agents = nameListArray;
        }

        public void handleResponse(short s, Response response) {
            if (s == 0) {
                InbandFabricAgentInfo inbandFabricAgentInfo = response.responseData instanceof InbandFabricAgentInfo ? (InbandFabricAgentInfo)response.responseData : ((InbandFabricAgentInfo[])response.responseData)[0];
                switch (inbandFabricAgentInfo.request_type) {
                    case 3: {
                        this.agents[0].nlState = (byte)inbandFabricAgentInfo.status;
                        if (inbandFabricAgentInfo.status == 1) {
                            String string = MessageLog.getMessageNoID("ADG0294M", this.agents[0].nlName);
                            JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                        } else {
                            String string = String.valueOf(this.agents[0].nlName) + " " + FabricGuiUtil.getInbandFabricAgentStatusString(inbandFabricAgentInfo.status);
                            JOptionPane.showMessageDialog(guiMain.getFrame(), string, MessageLog.getMessageNoID("ADG0295T"), 1);
                        }
                        InbandFabricAgentListPanel.this.getTableModel().refreshAgent(this.agents[0]);
                        break;
                    }
                    case 2: {
                        InbandFabricAgentListPanel.this.getTableModel().removeAgents(this.agents);
                        int n = 0;
                        while (n < this.agents.length) {
                            InbandFabricAgentListPanel.this.getDDI().getTreeNode(this.agents[n], false, true);
                            ++n;
                        }
                        break block0;
                    }
                }
            } else if (s == 12 && response != null && response.responseData != null) {
                InbandFabricAgentInfo inbandFabricAgentInfo = response.responseData instanceof InbandFabricAgentInfo ? (InbandFabricAgentInfo)response.responseData : ((InbandFabricAgentInfo[])response.responseData)[0];
                if (inbandFabricAgentInfo.request_type == 3 && inbandFabricAgentInfo.message_status == 2) {
                    InbandFabricAgentListPanel.this.getDDI().getData();
                }
            }
        }
    }
}

