/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.Capabilities;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.disk.common.DiskGuiTable;
import org.eclipse.aperi.gui.disk.common.TableCapacityRenderer;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUICapabilityData;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;
import org.eclipse.aperi.gui.disk.system.SubsystemTableModel;
import org.eclipse.aperi.gui.disk.volume.CreateVDiskWizard;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeWizard;
import org.eclipse.aperi.gui.disk.volume.VDiskDDI;
import org.eclipse.aperi.gui.disk.volume.VolumeDDI;
import org.eclipse.aperi.request.Response;

public class SubsystemListPanel
extends JPanel
implements TJCTableMouseInterface,
ActionListener {
    private static final String ACTION_VIEW_DETAILS = Util.getString("DISK_VIEW_DETAILS_SUBSYS_LABEL");
    private SubsystemDDI theSSDDI;
    private GUIStorageSubsystem sys;
    private DiskGuiTable table = new DiskGuiTable();
    private SubsystemTableModel tableModel;
    private JButton launchButton = null;
    private JButton createButton = null;
    private JButton createVolButton = null;
    private JButton vdiskButton = null;
    private JButton createVdiskButton = null;
    private JButton removeSubsysButton = null;
    private JButton volButton = null;
    private boolean dblClick = false;
    private static TableCellRenderer drillDownRenderer = new DrillDownRenderer();
    private static TableCellRenderer capacityRenderer = new TableCapacityRenderer();
    private JDialog wizardDialog = null;
    private CreateVolumeWizard crvol = null;
    private JPanel tablePanel = GuiUtil.getPanel();
    private JPanel pb = new JPanel();
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();
    private Capabilities capabilities = this.guiMain.getCapabilities();
    private static ElementManagerHelperInterface elementManagerHelper = new ElementManagerHelperInterface(){

        public String extractGUID(Object object) {
            return "subsystem:" + ((GUIStorageSubsystem)object).getInternalId();
        }

        public String extractDefaultElementManager(Object object) {
            return ((GUIStorageSubsystem)object).getElementManager();
        }

        public String extractDisplayName(Object object) {
            return ((GUIStorageSubsystem)object).getName();
        }
    };

    public SubsystemListPanel(SubsystemDDI subsystemDDI) {
        this.theSSDDI = subsystemDDI;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.volButton = new JButton(Util.getString("DISK_VOLUMES_SUBSYS_BUTTON"));
        this.volButton.setEnabled(false);
        this.volButton.addActionListener(this);
        GuiUtil.setAccessible(this.volButton, this.volButton.getText(), this.volButton.getText());
        this.createButton = new JButton(Util.getString("DISK_CREATEVOLUMES_BUTTON"));
        this.createButton.setEnabled(false);
        this.createButton.addActionListener(this);
        GuiUtil.setAccessible(this.createButton, this.createButton.getText(), this.createButton.getText());
        this.vdiskButton = new JButton(Util.getString("DISK_VDISK_BUTTON"));
        this.vdiskButton.setEnabled(false);
        this.vdiskButton.addActionListener(this);
        GuiUtil.setAccessible(this.vdiskButton, this.vdiskButton.getText(), this.vdiskButton.getText());
        this.createVdiskButton = new JButton(Util.getString("DISK_CREATEVDISK_BUTTON"));
        this.createVdiskButton.setEnabled(false);
        this.createVdiskButton.addActionListener(this);
        GuiUtil.setAccessible(this.createVdiskButton, this.createVdiskButton.getText(), this.createVdiskButton.getText());
        this.removeSubsysButton = new JButton(Util.getString("DISK_REMOVESUBSYS_BUTTON"));
        this.removeSubsysButton.setEnabled(false);
        this.removeSubsysButton.addActionListener(this);
        GuiUtil.setAccessible(this.removeSubsysButton, this.removeSubsysButton.getText(), this.removeSubsysButton.getText());
        this.launchButton = new JButton(Util.getString("DISK_LAUNCHELEMENTMGR_BUTTON"));
        this.launchButton.setEnabled(false);
        this.launchButton.addActionListener(this);
        GuiUtil.setAccessible(this.launchButton, this.launchButton.getText(), this.launchButton.getText());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.add(this.volButton);
        jPanel2.add(this.createButton);
        jPanel2.add(this.vdiskButton);
        jPanel2.add(this.createVdiskButton);
        jPanel2.add(this.removeSubsysButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        jPanel3.add(this.launchButton);
        this.pb.setLayout(new BorderLayout());
        this.pb.add((Component)jPanel2, "North");
        this.pb.add((Component)jPanel3, "South");
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBorder(new TitledBorder(Util.getString("DISK_STORAGESUBSYS_LABEL")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.buildTable();
        this.tablePanel.add((Component)this.table, gridBagConstraints);
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)this.pb, "North");
        jPanel.add((Component)this.tablePanel, "Center");
        return this;
    }

    public boolean select(int n, int n2) {
        boolean bl = true;
        if (this.dblClick) {
            this.dblClick = false;
            bl = false;
        }
        return bl;
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        if (n < 0 || n2 < 0) {
            return;
        }
        int n5 = this.table.getPointedRow(n4);
        this.table.setSelectedRows(n5, n5);
        this.selectionChanged(true);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = jPopupMenu.add(ACTION_VIEW_DETAILS);
        jMenuItem.setActionCommand(ACTION_VIEW_DETAILS);
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(true);
        jPopupMenu.show(component, n3, n4);
        jPopupMenu.requestFocus();
    }

    public void selectionChanged(boolean bl) {
        if (this.tableModel.getNumRows() == 0) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        try {
            if (nArray.length > 0 && nArray[0] != -1) {
                this.sys = (GUIStorageSubsystem)this.theSSDDI.getSubsystems().elementAt(nArray[0]);
                if (this.sys.getCapabilityData() == null) {
                    DiskDataAccessor.getInstance().getStorageSubsystemCapabilities(new GuiRequestor(){

                        public void handleResponse(short s, Response response) {
                            if (s <= 4) {
                                GUICapabilityData gUICapabilityData = (GUICapabilityData)response.responseData;
                                if (gUICapabilityData != null) {
                                    SubsystemListPanel.this.sys.setCapabilities(gUICapabilityData);
                                }
                                SubsystemListPanel.this.chooseButtons();
                            }
                        }
                    }, this.sys.getId());
                }
                this.chooseButtons();
            } else {
                this.disableAllButtons();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.disableAllButtons();
            return;
        }
    }

    public void disableAllButtons() {
        this.volButton.setEnabled(false);
        this.createButton.setEnabled(false);
        this.removeSubsysButton.setEnabled(false);
        this.createVdiskButton.setEnabled(false);
        this.vdiskButton.setEnabled(false);
        this.launchButton.setEnabled(false);
    }

    public void chooseButtons() {
        if (this.sys.getType() == 4) {
            if (this.sys.isVolumeCreationSupported() && this.capabilities.isDiskAdmin() && this.sys.getCapabilityData() != null && this.sys.isDetectable()) {
                this.createVdiskButton.setEnabled(true);
            } else {
                this.createVdiskButton.setEnabled(false);
            }
            this.vdiskButton.setEnabled(true);
            this.volButton.setEnabled(false);
            this.createButton.setEnabled(false);
        } else {
            if (this.sys.isVolumeCreationSupported() && this.capabilities.isDiskAdmin() && this.sys.getCapabilityData() != null && this.sys.isDetectable()) {
                this.createButton.setEnabled(true);
            } else {
                this.createButton.setEnabled(false);
            }
            this.volButton.setEnabled(true);
            this.createVdiskButton.setEnabled(false);
            this.vdiskButton.setEnabled(false);
        }
        if (this.capabilities.isDiskAdmin()) {
            this.removeSubsysButton.setEnabled(true);
        } else {
            this.removeSubsysButton.setEnabled(false);
        }
        this.launchButton.setEnabled(ElementManagerManager.getInstance().hasElementManager(this.sys, this.getElementManagerHelper()));
    }

    public void doubleClick(int n, int n2) {
        this.dblClick = true;
        this.theSSDDI.showDetails(n);
    }

    public void showDefaultChart(int n) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        int[] nArray = this.table.getSelectedRows();
        GUIStorageSubsystem[] gUIStorageSubsystemArray = new GUIStorageSubsystem[nArray.length];
        int n = 0;
        while (n < gUIStorageSubsystemArray.length) {
            gUIStorageSubsystemArray[n] = (GUIStorageSubsystem)this.theSSDDI.getSubsystems().elementAt(nArray[n]);
            ++n;
        }
        if (object == this.volButton) {
            VolumeDDI volumeDDI = new VolumeDDI(gUIStorageSubsystemArray[0]);
            ((DataDisplayInfo)volumeDDI).reDisplay();
        } else if (object == this.createButton) {
            this.openCreateVolumeWizard(gUIStorageSubsystemArray);
        } else if (object == this.createVdiskButton) {
            this.openCreateVdiskWizard(gUIStorageSubsystemArray);
        } else if (object == this.removeSubsysButton) {
            this.openSubsysDelete(gUIStorageSubsystemArray);
        } else if (object == this.launchButton) {
            this.openElementManager(gUIStorageSubsystemArray);
        } else if (string.equals(ACTION_VIEW_DETAILS)) {
            int[] nArray2 = this.table.getSelectedRows();
            if (nArray2.length > 0) {
                this.theSSDDI.showDetails(nArray2[0]);
            }
        } else if (object == this.vdiskButton) {
            VDiskDDI vDiskDDI = new VDiskDDI(gUIStorageSubsystemArray[0]);
            ((DataDisplayInfo)vDiskDDI).reDisplay();
        }
    }

    public void openSubsysDelete(GUIStorageSubsystem[] gUIStorageSubsystemArray) {
        int n = JOptionPane.showConfirmDialog(this, Util.getString("DISK_SUBSYSTEMS_DELETE_LABEL", gUIStorageSubsystemArray[0].getDeviceId()), Util.getString("DISK_SUBSYSTEMS_DELETE_TITLE"), 1);
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                DiskDataAccessor.getInstance().deleteStorageSubsystems(new GuiRequestor(){

                    public void handleResponse(short s, Response response) {
                        if (s <= 4) {
                            int[] nArray = SubsystemListPanel.this.table.getSelectedRows();
                            GUIStorageSubsystem[] gUIStorageSubsystemArray = new GUIStorageSubsystem[nArray.length];
                            int n = 0;
                            while (n < gUIStorageSubsystemArray.length) {
                                gUIStorageSubsystemArray[n] = (GUIStorageSubsystem)SubsystemListPanel.this.theSSDDI.getSubsystems().elementAt(nArray[n]);
                                ++n;
                            }
                            DataDisplayInfo dataDisplayInfo = DataDisplayInfo.getRoot();
                            int n2 = 0;
                            while (dataDisplayInfo != null) {
                                if (dataDisplayInfo.getDescription() == Util.getString("DISK_VOLUMES_LABEL")) {
                                    n2 = ((VolumeDDI)dataDisplayInfo).subsystem.getInternalId();
                                } else if (dataDisplayInfo.getDescription() == Util.getString("DISK_VDISKS_LABEL")) {
                                    n2 = ((VDiskDDI)dataDisplayInfo).subsystem.getInternalId();
                                }
                                if (n2 == gUIStorageSubsystemArray[0].getInternalId()) {
                                    dataDisplayInfo.remove();
                                }
                                dataDisplayInfo = dataDisplayInfo.getNext();
                            }
                            SubsystemListPanel.this.theSSDDI.nullOutPanel();
                            SubsystemListPanel.this.theSSDDI.reDisplay();
                        }
                    }
                }, new String[]{gUIStorageSubsystemArray[0].getId()}, new String[]{String.valueOf(gUIStorageSubsystemArray[0].getInternalId())});
            }
        }
    }

    public void openCreateVolumeWizard(GUIStorageSubsystem[] gUIStorageSubsystemArray) {
        this.crvol = new CreateVolumeWizard(gUIStorageSubsystemArray[0]);
        this.wizardDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_VOLUME_WIZARD_TITLE", gUIStorageSubsystemArray[0].getDeviceId()), true);
        this.wizardDialog.getContentPane().add(this.crvol);
        this.wizardDialog.setResizable(false);
        this.wizardDialog.pack();
        GuiUtil.centerDialog(this.wizardDialog);
        this.wizardDialog.setDefaultCloseOperation(0);
        this.wizardDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SubsystemListPanel.this.crvol.cancel();
            }
        });
        this.wizardDialog.show();
    }

    public void openCreateVdiskWizard(GUIStorageSubsystem[] gUIStorageSubsystemArray) {
        CreateVDiskWizard createVDiskWizard = new CreateVDiskWizard(gUIStorageSubsystemArray[0]);
        new JFrame();
        JDialog jDialog = new JDialog(this.guiMain.getFrame(), Util.getString("DISK_VDISK_WIZARD_TITLE", gUIStorageSubsystemArray[0].getDeviceId()), true);
        jDialog.getContentPane().add(createVDiskWizard);
        jDialog.setResizable(false);
        jDialog.pack();
        GuiUtil.centerDialog(jDialog);
        jDialog.show();
    }

    public void openElementManager(GUIStorageSubsystem[] gUIStorageSubsystemArray) {
        ElementManagerManager.getInstance().launchElementManager(gUIStorageSubsystemArray[0], this.getElementManagerHelper());
    }

    public void buildTable() {
        Class<?> clazz;
        Class<?> clazz2;
        this.table.setMouseListener(this);
        this.tableModel = new SubsystemTableModel(this.theSSDDI);
        try {
            clazz2 = Class.forName("javax.swing.JLabel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz2, drillDownRenderer);
        try {
            clazz = Class.forName("java.lang.Double");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.table.setCellRenderer(clazz, capacityRenderer);
        this.table.setFrozenColumns(1);
        this.table.setRowIcon(10, true);
        this.table.setSelectionPolicy(0);
        this.table.setBaseTableModel(this.tableModel);
        this.table.sortByColumn(0, 1);
        this.selectionChanged(true);
        this.table.updateUI();
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return elementManagerHelper;
    }

    private static class DrillDownRenderer
    extends DefaultTableCellRenderer {
        private DrillDownRenderer() {
        }

        public void setValue(Object object) {
            String string = ((JLabel)object).getText();
            this.setText(string);
            this.setVerticalAlignment(1);
            this.setHorizontalAlignment(10);
            Icon icon = ((JLabel)object).getIcon();
            this.setIcon(icon);
        }
    }
}

