/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.system;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.TCloseTabPane;
import org.eclipse.aperi.gui.TabCloseListener;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.system.SubsystemDDI;
import org.eclipse.aperi.gui.disk.system.SubsystemDetailsPanel;
import org.eclipse.aperi.gui.disk.system.SubsystemListPanel;

public class SubsystemPanel
extends JPanel
implements FocusListener,
TabCloseListener {
    private SubsystemDDI theDDI = null;
    public TCloseTabPane tabs = null;
    private SubsystemListPanel listPanel = null;
    private SubsystemDetailsPanel detailsPanel = null;
    private Vector veAllTabs = new Vector();

    public SubsystemPanel(SubsystemDDI subsystemDDI) {
        this.theDDI = subsystemDDI;
    }

    public Vector getAllTabs() {
        return this.veAllTabs;
    }

    public JComponent getComponent() {
        this.setLayout(new BorderLayout());
        if (this.tabs == null) {
            this.tabs = new TCloseTabPane(1);
            this.tabs.setFont(BaseTree.boldFont);
            this.tabs.addFocusListener(this);
            if (this.theDDI.getSubsystemInternalId() == -1) {
                this.listPanel = new SubsystemListPanel(this.theDDI);
                String string = Util.getString("DISK_STORAGESUBSYS_LABEL");
                this.tabs.addTab(string, this.listPanel.getComponent(), string, false);
            } else {
                this.showDetails(this.theDDI.getSubsystem(), false);
            }
            this.add((Component)this.tabs, "Center");
        }
        return this;
    }

    public void showDetails(GUIStorageSubsystem gUIStorageSubsystem, boolean bl) {
        boolean bl2 = false;
        String string = Util.getString("DISK_DETAILS_LABEL", gUIStorageSubsystem.getDeviceId());
        int n = 0;
        while (n < this.tabs.getTabCount()) {
            if (this.tabs.getTitleAt(n).equals(string)) {
                this.tabs.setSelectedComponent(this.tabs.getComponent(n));
                bl2 = true;
            }
            ++n;
        }
        if (!bl2) {
            this.detailsPanel = new SubsystemDetailsPanel(gUIStorageSubsystem, this.theDDI);
            this.tabs.addTab(string, this.detailsPanel.getComponent(), string, bl, this);
            this.tabs.setSelectedComponent(this.detailsPanel);
            this.veAllTabs.addElement(this.detailsPanel);
        }
    }

    public void refreshPanel() {
        if (this.listPanel != null) {
            this.listPanel.buildTable();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.listPanel != null) {
            this.listPanel.selectionChanged(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean closeTab(int n) {
        SubsystemDetailsPanel subsystemDetailsPanel = (SubsystemDetailsPanel)this.tabs.getComponentAt(n);
        subsystemDetailsPanel.changesPending(true);
        this.veAllTabs.removeElement(subsystemDetailsPanel);
        return true;
    }
}

