/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.WizardPage;
import org.eclipse.aperi.gui.common.model.GUIEntity;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.FormattedTextFieldVerifier;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.volume.CreateVolumeWizard;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class CreateVolumeSetCharacteristicsStep
extends WizardPage
implements ActionListener {
    private JLabel titleLabel = null;
    private JLabel descLabel = null;
    private JLabel raidLevelLabel = null;
    private JLabel volumeSizeLabel = null;
    private JLabel unitsLabel = null;
    private JLabel availableArraysLabel = null;
    private JLabel volumeQuantityLabel = null;
    private JLabel volumeNameLabel = null;
    private JLabel volumePrefixLabel = null;
    private JComboBox raidLevelComboBox = new JComboBox();
    private JSpinner volumeSizeSpinner = null;
    private JComboBox unitsComboBox = null;
    private JDialog wizardDialog = null;
    private JSpinner volumeQuantitySpinner = null;
    private JComboBox availableArraysComboBox = new JComboBox();
    private JButton nextButton = null;
    private JTextField volumeNameTextField = null;
    private JFormattedTextField volumeQuantityTextField = new JFormattedTextField();
    private JFormattedTextField volumeSizeTextField = new JFormattedTextField();
    private int minSpinnerValue = 1;
    private int maxQuantitySpinnerValue = 255;
    private long minSizeSpinnerValue = 1L;
    private long maxSizeSpinnerValue = Long.MAX_VALUE;
    private int spinnerStep = 1;
    private long minSize = 1L;
    private long maxSize = 0L;
    private long[] volumeSize = new long[2];
    private CreateVolumeWizard cvWizard = null;
    private String subSystemID = null;
    private int width = 0;
    private int height = 0;
    private boolean isHelpSet = false;
    private GUIStorageSubsystem subSystem = null;
    protected DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
    private SpinnerNumberModel volumeQModel = null;
    private boolean isVolumeSizeRangeRetrieved = true;
    private boolean isArrayRetrieved = false;
    private NumberFormat numFormat;
    private String volumeName = null;
    private String[] volumeIDs;
    private String raidLevel = new String();
    private String units = null;
    private String volumeQuantity = null;
    private String selectedArray = null;
    private Vector raidArrayESS = null;
    private HashMap aArrays = new HashMap();
    private Vector arrayStrings = new Vector();
    private HashMap raidArray = new HashMap();
    private HashMap arrayForRAID = new HashMap();
    private String[] unitsArray = new String[]{Util.getString("DISK_KB"), Util.getString("DISK_MB"), Util.getString("DISK_GB")};

    public CreateVolumeSetCharacteristicsStep(int n, GUIStorageSubsystem gUIStorageSubsystem) {
        super(n);
        this.setName("CreateVolumeSetCharacteristicsStep");
        this.subSystem = gUIStorageSubsystem;
        this.subSystemID = this.subSystem.getId();
        this.getPreviousButton().setEnabled(false);
        this.getFinishButton().setEnabled(false);
        this.nextButton = this.getNextButton();
        Container container = this.getContentPane();
        container.add(this.create());
        this.setUpHelp(DiskConstants.DISK_CREATE_VOLUME_SET_CHARACTERISTICS);
    }

    public Object next() {
        return "CreateVolumeSelectHostPortsStep";
    }

    public JPanel create() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.titleLabel = new JLabel(Util.getString("DISK_VOLUME_CHARACTERISTICS_LABEL"));
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel2.add(this.titleLabel);
        jPanel2.add(Box.createHorizontalGlue());
        Font font = this.titleLabel.getFont();
        GuiUtil.setAccessible(this.titleLabel, this.titleLabel.getText(), this.titleLabel.getText());
        this.titleLabel.setFont(font.deriveFont(1));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.descLabel = new JLabel(Util.getString("DISK_VOLUME_CHARACTERISTICS_DESC_LABEL"));
        this.descLabel.setAlignmentX(0.0f);
        this.descLabel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        jPanel3.add(this.descLabel);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add(jPanel3);
        GridBagPanel gridBagPanel = new GridBagPanel();
        this.raidLevelLabel = new JLabel(Util.getString("DISK_RAIDLEVEL_LABEL"));
        this.raidLevelComboBox.addActionListener(this);
        this.height = this.raidLevelComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.raidLevelComboBox.setMinimumSize(new Dimension(100, this.height));
        this.raidLevelComboBox.setMaximumSize(new Dimension(100, this.height));
        this.raidLevelComboBox.setPreferredSize(new Dimension(100, this.height));
        this.raidLevelLabel.setAlignmentY(0.5f);
        gridBagPanel.add((JComponent)this.raidLevelLabel, 23);
        gridBagPanel.add(this.raidLevelComboBox);
        gridBagPanel.add((JComponent)new JLabel(), 0, 1, 2);
        gridBagPanel.newRow();
        GuiUtil.setAccessibleLabel(this.raidLevelLabel, this.raidLevelComboBox, "", this.raidLevelLabel.getText(), this.raidLevelLabel.getText());
        int n = this.subSystem.getType();
        this.availableArraysLabel = n == 3 || n == 2 ? new JLabel(Util.getString("DISK_VOLUME_AVAILABLE_EXTENT_POOLS_LABEL")) : new JLabel(Util.getString("DISK_VOLUME_AVAILABLE_ARRAYS_LABEL"));
        this.availableArraysComboBox.addActionListener(this);
        this.height = this.availableArraysComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.availableArraysComboBox.setMinimumSize(new Dimension(100, this.height));
        this.availableArraysComboBox.setMaximumSize(new Dimension(100, this.height));
        this.availableArraysComboBox.setPreferredSize(new Dimension(100, this.height));
        gridBagPanel.add(this.availableArraysLabel);
        gridBagPanel.add(this.availableArraysComboBox);
        gridBagPanel.add((JComponent)new JLabel(), 0, 1, 2);
        gridBagPanel.newRow();
        GuiUtil.setAccessibleLabel(this.availableArraysLabel, this.availableArraysComboBox, "", this.availableArraysLabel.getText(), this.availableArraysLabel.getText());
        this.volumeQuantityLabel = new JLabel(Util.getString("DISK_VOLUME_QUANTITY_LABEL"));
        this.maxQuantitySpinnerValue = (int)this.subSystem.getCapabilityData().getNumVolumesSupported();
        this.getVolumesQuantity();
        this.volumeQModel = new SpinnerNumberModel(this.minSpinnerValue, this.minSpinnerValue, this.maxQuantitySpinnerValue, this.spinnerStep);
        this.volumeQuantitySpinner = new JSpinner(this.volumeQModel);
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.volumeQuantitySpinner.getEditor();
        this.volumeQuantityTextField = numberEditor.getTextField();
        this.volumeQuantityTextField.setInputVerifier(new FormattedTextFieldVerifier());
        this.width = this.volumeQModel.getMaximum().toString().length() * this.volumeQuantitySpinner.getFontMetrics(this.getFont()).charWidth(0) + 20;
        this.height = this.volumeQuantitySpinner.getFontMetrics(this.getFont()).getHeight() + 5;
        this.volumeQuantitySpinner.setMinimumSize(new Dimension(this.width, this.height));
        this.volumeQuantitySpinner.setPreferredSize(new Dimension(this.width, this.height));
        this.volumeQuantitySpinner.setMaximumSize(new Dimension(this.width * 2, this.height));
        gridBagPanel.add(this.volumeQuantityLabel);
        gridBagPanel.add(this.volumeQuantitySpinner);
        gridBagPanel.add((JComponent)new JLabel(), 0, 1, 2);
        gridBagPanel.newRow();
        GuiUtil.setAccessibleLabel(this.volumeQuantityLabel, this.volumeQuantitySpinner, "", this.volumeQuantityLabel.getText(), this.volumeQuantityLabel.getText());
        JPanel jPanel4 = new JPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.5;
        jPanel4.setLayout(new GridBagLayout());
        this.volumeSizeLabel = new JLabel(Util.getString("DISK_VOLUME_SIZE_LABEL"));
        this.volumeQModel = new SpinnerNumberModel(this.minSizeSpinnerValue, this.minSizeSpinnerValue, this.maxSizeSpinnerValue, (double)this.spinnerStep);
        this.volumeSizeSpinner = new JSpinner(this.volumeQModel);
        JSpinner.NumberEditor numberEditor2 = (JSpinner.NumberEditor)this.volumeSizeSpinner.getEditor();
        this.volumeSizeTextField = numberEditor2.getTextField();
        this.volumeSizeTextField.setInputVerifier(new FormattedTextFieldVerifier());
        this.volumeSizeSpinner.setPreferredSize(new Dimension(85, this.volumeSizeSpinner.getFontMetrics(this.getFont()).getHeight() + 5));
        this.volumeSizeSpinner.setEnabled(false);
        this.volumeSizeLabel.setAlignmentY(0.5f);
        gridBagPanel.add(this.volumeSizeLabel);
        jPanel4.add((Component)this.volumeSizeSpinner, gridBagConstraints);
        GuiUtil.setAccessibleLabel(this.volumeSizeLabel, this.volumeSizeSpinner, "", this.volumeSizeLabel.getText(), this.volumeSizeLabel.getText());
        gridBagPanel.add(jPanel4);
        gridBagPanel.add((JComponent)new JLabel(), 0, 1, 2);
        gridBagPanel.newRow();
        this.unitsLabel = new JLabel(Util.getString("DISK_UNITS_LABEL"));
        this.unitsComboBox = new JComboBox<String>(this.unitsArray);
        this.unitsComboBox.addActionListener(this);
        this.width = this.unitsArray[2].length() * this.unitsComboBox.getFontMetrics(this.getFont()).charWidth(0) + 38;
        this.height = this.unitsComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
        this.unitsComboBox.setPreferredSize(new Dimension(this.width, this.height));
        this.unitsComboBox.setSelectedIndex(2);
        this.unitsLabel.setAlignmentY(0.5f);
        gridBagConstraints.gridx = 1;
        jPanel4.add((Component)this.unitsLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        jPanel4.add((Component)this.unitsComboBox, gridBagConstraints);
        GuiUtil.setAccessibleLabel(this.unitsLabel, this.unitsComboBox, "", this.unitsLabel.getText(), this.unitsLabel.getText());
        this.volumeNameLabel = new JLabel(Util.getString("DISK_NAME_LABEL"));
        this.volumePrefixLabel = new JLabel(Util.getString("DISK_VDISK_PREFIX_LABEL"));
        PlainDocument plainDocument = new PlainDocument(){

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                if (string != null && string.length() + this.getLength() <= 15) {
                    super.insertString(n, string, attributeSet);
                }
            }
        };
        this.volumeNameTextField = new JTextField(plainDocument, "", 15);
        this.width = 16 * this.volumeNameTextField.getFontMetrics(this.getFont()).charWidth(0) + 2;
        this.height = this.volumeNameTextField.getFontMetrics(this.getFont()).getHeight() + 5;
        this.volumeNameTextField.setMinimumSize(new Dimension(this.width, this.height));
        this.volumeNameTextField.setPreferredSize(new Dimension(this.width, this.height));
        this.volumeNameTextField.setMaximumSize(new Dimension(this.width * 2, this.height));
        this.volumeNameTextField.setAlignmentX(0.0f);
        gridBagPanel.add(this.volumeNameLabel);
        JPanel jPanel5 = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 23;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 10);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.weightx = 0.5;
        jPanel5.setLayout(new GridBagLayout());
        gridBagPanel.add(jPanel5);
        gridBagPanel.add((JComponent)new JLabel(), 0, 1, 2);
        gridBagPanel.newRow();
        jPanel5.add((Component)this.volumeNameTextField, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        jPanel5.add((Component)this.volumePrefixLabel, gridBagConstraints2);
        GuiUtil.setAccessibleLabel(this.volumeNameLabel, this.volumeNameTextField, "", this.volumeNameLabel.getText(), this.volumeNameLabel.getText());
        gridBagPanel.add((JComponent)new JLabel(), 1);
        jPanel.add(gridBagPanel);
        this.getAvailableArrays();
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Object object3 = null;
        if (actionEvent == null) {
            return;
        }
        object3 = actionEvent.getSource();
        if (object3 == null) {
            return;
        }
        if (object3.equals(this.raidLevelComboBox)) {
            object2 = (String)this.raidLevelComboBox.getSelectedItem();
            this.raidLevelComboBox.setPreferredSize(new Dimension(70, this.raidLevelComboBox.getHeight()));
            this.getArraysForRAID((String)object2);
            if (this.arrayStrings.size() > 0) {
                object = this.arrayStrings.iterator();
                int n = 0;
                while (object.hasNext()) {
                    int n2 = object.next().toString().length();
                    if (n2 <= n) continue;
                    n = n2;
                }
                this.width = n;
                this.availableArraysComboBox.setSelectedIndex(0);
            } else {
                this.width = 20;
            }
            this.width *= this.availableArraysComboBox.getFontMetrics(this.getFont()).charWidth(0);
            this.height = this.availableArraysComboBox.getFontMetrics(this.getFont()).getHeight() + 5;
            this.availableArraysComboBox.setPreferredSize(new Dimension(this.width, this.height));
        }
        if (object3.equals(this.availableArraysComboBox) && this.availableArraysComboBox.getSelectedItem() != null && (object2 = (GUIStoragePool)this.aArrays.get(this.availableArraysComboBox.getSelectedItem().toString())) != null) {
            object = String.valueOf(((GUIEntity)object2).getId());
            String string = String.valueOf(this.subSystem.getId());
            this.enableControls(false);
            this.diskAccessor.getVolumeSizeRange(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    CreateVolumeSetCharacteristicsStep.this.isVolumeSizeRangeRetrieved = false;
                    if (s <= 4 && response != null) {
                        CreateVolumeSetCharacteristicsStep.this.volumeSize = (long[])response.responseData;
                        CreateVolumeSetCharacteristicsStep.this.minSize = CreateVolumeSetCharacteristicsStep.this.volumeSize[0];
                        CreateVolumeSetCharacteristicsStep.this.maxSize = CreateVolumeSetCharacteristicsStep.this.volumeSize[1];
                    }
                    if (CreateVolumeSetCharacteristicsStep.this.maxSize == 0L) {
                        CreateVolumeSetCharacteristicsStep.this.maxSize = Long.MAX_VALUE;
                    }
                    if (CreateVolumeSetCharacteristicsStep.this.minSize == 0L) {
                        CreateVolumeSetCharacteristicsStep.this.minSize = 1L;
                    }
                    CreateVolumeSetCharacteristicsStep.this.isVolumeSizeRangeRetrieved = true;
                    CreateVolumeSetCharacteristicsStep.this.enableControls(true);
                }
            }, string, (String)object);
        }
    }

    public JDialog getWizardDialog() {
        CreateVolumeWizard createVolumeWizard = (CreateVolumeWizard)this.getParent();
        JDialog jDialog = (JDialog)createVolumeWizard.getParent().getParent().getParent().getParent();
        return jDialog;
    }

    public boolean nextBegin() {
        this.raidLevel = (String)this.raidLevelComboBox.getModel().getSelectedItem();
        new String();
        String string = new String();
        GUIStoragePool gUIStoragePool = null;
        new Vector();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        BevelBorder bevelBorder = (BevelBorder)this.volumeSizeTextField.getBorder();
        if (bevelBorder != null && bevelBorder.getHighlightOuterColor().equals(Color.RED)) {
            return false;
        }
        BevelBorder bevelBorder2 = (BevelBorder)this.volumeQuantityTextField.getBorder();
        if (bevelBorder2 != null && bevelBorder2.getHighlightOuterColor().equals(Color.RED)) {
            return false;
        }
        Object object = this.availableArraysComboBox.getSelectedItem();
        if (object != null) {
            string = object.toString();
        }
        if (string != null && this.aArrays.size() > 0) {
            gUIStoragePool = (GUIStoragePool)this.aArrays.get(string);
        }
        this.volumeQuantity = this.volumeQuantitySpinner.getModel().getValue().toString();
        Double d = new Double(this.volumeSizeSpinner.getModel().getValue().toString());
        l2 = l = d.longValue();
        l = GUIEntityUtil.convertStorageCapacity(l, this.unitsComboBox.getSelectedIndex() + 1, 0);
        long l4 = 0L;
        long l5 = Long.parseLong(this.volumeQuantity);
        if (gUIStoragePool == null) {
            (new String[1])[0] = this.availableArraysLabel.getText();
            String string2 = Util.getString("DMSG_DISK_VOLUME_SELECT_STORAGE_POOL");
            JOptionPane.showMessageDialog(this, string2, this.availableArraysLabel.getText(), 0);
            return false;
        }
        l4 = gUIStoragePool.getUnusedCapacity();
        if (l < this.minSize) {
            float f = GUIEntityUtil.convertStorageCapacityDecimal(this.minSize, 0, this.unitsComboBox.getSelectedIndex() + 1, 2);
            String[] stringArray = new String[]{String.valueOf(f) + " " + (String)this.unitsComboBox.getModel().getSelectedItem()};
            String string3 = Util.getString("DMSG_DISK_VOLUME_MIN_SIZE", stringArray);
            JOptionPane.showMessageDialog(this, string3, Util.getString("DISK_VOLUME_SIZE_LABEL"), 0);
            return false;
        }
        l3 = this.maxSize;
        if (l3 > l4) {
            l3 = l4;
        }
        float f = GUIEntityUtil.convertStorageCapacityDecimal(l3 /= l5, 0, 3, 2);
        String string4 = this.unitsArray[2];
        if (f < 1.0f) {
            f = GUIEntityUtil.convertStorageCapacityDecimal(l3, 0, 2, 2);
            string4 = this.unitsArray[1];
        }
        if (l > l3) {
            this.maxSizeSpinnerValue = GUIEntityUtil.convertStorageCapacity(l3, 0, this.unitsComboBox.getSelectedIndex() + 1);
            String[] stringArray = new String[]{String.valueOf(String.valueOf(f)) + " " + string4};
            String string5 = Util.getString("DMSG_DISK_VOLUME_MAX_SIZE", stringArray);
            JOptionPane.showMessageDialog(this, string5, Util.getString("DISK_VOLUME_SIZE_LABEL"), 0);
            return false;
        }
        this.units = (String)this.unitsComboBox.getModel().getSelectedItem();
        this.volumeName = this.volumeNameTextField.getText();
        this.cvWizard = (CreateVolumeWizard)this.getParent();
        this.cvWizard.addVolumeData(Util.getString("DISK_RAIDLEVEL_LABEL"), this.raidLevel);
        this.cvWizard.addVolumeData(Util.getString("DISK_VOLUME_AVAILABLE_ARRAYS_LABEL"), gUIStoragePool);
        this.cvWizard.addVolumeData(Util.getString("DISK_VOLUME_QUANTITY_LABEL"), this.volumeQuantity);
        this.cvWizard.addVolumeData(Util.getString("DISK_VOLUME_SIZE_LABEL"), String.valueOf(l2));
        this.cvWizard.addVolumeData(Util.getString("DISK_UNITS_LABEL"), this.units);
        this.cvWizard.addVolumeData(Util.getString("DISK_NAME_LABEL"), this.volumeName);
        this.raidLevel = new String();
        return true;
    }

    private void enableControls(boolean bl) {
        bl = this.isArrayRetrieved && this.isVolumeSizeRangeRetrieved && bl;
        this.raidLevelComboBox.setEnabled(bl);
        this.availableArraysComboBox.setEnabled(bl);
        this.nextButton.setEnabled(bl);
        if (this.volumeSizeSpinner != null) {
            this.volumeSizeSpinner.setEnabled(bl);
        }
        this.unitsComboBox.setEnabled(bl);
        this.volumeQuantitySpinner.setEnabled(bl);
        this.volumeNameTextField.setEnabled(bl);
    }

    private void getAvailableArrays() {
        this.enableControls(false);
        this.isArrayRetrieved = false;
        this.diskAccessor.getStoragePoolsBySubsytstem(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                CreateVolumeSetCharacteristicsStep.this.aArrays = new HashMap();
                CreateVolumeSetCharacteristicsStep.this.raidArray = new HashMap();
                GUIStoragePool gUIStoragePool = null;
                Vector<GUIStoragePool> vector = new Vector<GUIStoragePool>();
                Vector<Object> vector2 = new Vector();
                Vector<GUIStoragePool> vector3 = new Vector<GUIStoragePool>();
                int n = -1;
                if (s <= 4) {
                    HashMap hashMap;
                    if (response != null && (hashMap = (HashMap)response.responseData) != null) {
                        int n2;
                        Vector<Integer> vector4 = new Vector<Integer>();
                        Iterator<Object> iterator = hashMap.values().iterator();
                        while (iterator.hasNext()) {
                            gUIStoragePool = (GUIStoragePool)iterator.next();
                            vector.add(gUIStoragePool);
                            n = gUIStoragePool.getRaidLevel();
                            Integer n3 = new Integer(n);
                            if (vector4.contains(n3)) continue;
                            vector4.add(n3);
                        }
                        Collections.sort(vector4);
                        iterator = vector4.iterator();
                        int n4 = 0;
                        String string = new String();
                        while (iterator.hasNext()) {
                            n = (Integer)iterator.next();
                            if (n == 77) {
                                if (CreateVolumeSetCharacteristicsStep.this.raidArray.get(Util.getString("DISK_MIXED_LABEL")) == null) {
                                    CreateVolumeSetCharacteristicsStep.this.raidArray.put(Util.getString("DISK_MIXED_LABEL"), String.valueOf(n));
                                    CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.addItem(Util.getString("DISK_MIXED_LABEL"));
                                }
                            } else if (n == 99) {
                                if (CreateVolumeSetCharacteristicsStep.this.raidArray.get(MessageLog.getMessageNoID("GUI0129T")) == null) {
                                    CreateVolumeSetCharacteristicsStep.this.raidArray.put(MessageLog.getMessageNoID("GUI0129T"), String.valueOf(n));
                                    CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.addItem(MessageLog.getMessageNoID("GUI0129T"));
                                }
                            } else if (CreateVolumeSetCharacteristicsStep.this.raidArray.get(Util.getString("DISK_RAID_LABEL", String.valueOf(n))) == null) {
                                CreateVolumeSetCharacteristicsStep.this.raidArray.put(Util.getString("DISK_RAID_LABEL", String.valueOf(n)), String.valueOf(n));
                                CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.addItem(Util.getString("DISK_RAID_LABEL", String.valueOf(n)));
                            }
                            if ((n2 = string.length()) <= n4) continue;
                            n4 = n2;
                        }
                        CreateVolumeSetCharacteristicsStep.this.width = n4;
                        CreateVolumeSetCharacteristicsStep createVolumeSetCharacteristicsStep = CreateVolumeSetCharacteristicsStep.this;
                        createVolumeSetCharacteristicsStep.width = createVolumeSetCharacteristicsStep.width * CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.getFontMetrics(CreateVolumeSetCharacteristicsStep.this.getFont()).charWidth(0);
                        CreateVolumeSetCharacteristicsStep.this.height = CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.getFontMetrics(CreateVolumeSetCharacteristicsStep.this.getFont()).getHeight() + 5;
                        CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.setPreferredSize(new Dimension(CreateVolumeSetCharacteristicsStep.this.width, CreateVolumeSetCharacteristicsStep.this.height));
                        vector2 = new Vector(CreateVolumeSetCharacteristicsStep.this.raidArray.values());
                        n2 = 0;
                        while (n2 < vector2.size()) {
                            n = Integer.parseInt(vector2.get(n2).toString());
                            vector3 = new Vector();
                            int n5 = 0;
                            while (n5 < vector.size()) {
                                gUIStoragePool = (GUIStoragePool)vector.get(n5);
                                if (n == gUIStoragePool.getRaidLevel()) {
                                    vector3.add(gUIStoragePool);
                                }
                                ++n5;
                            }
                            if (CreateVolumeSetCharacteristicsStep.this.arrayForRAID.get(String.valueOf(n)) == null) {
                                CreateVolumeSetCharacteristicsStep.this.arrayForRAID.put(String.valueOf(n), vector3);
                            }
                            ++n2;
                        }
                    }
                    CreateVolumeSetCharacteristicsStep.this.isArrayRetrieved = true;
                }
                CreateVolumeSetCharacteristicsStep.this.enableControls(true);
                if (CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.getModel().getSize() > 0) {
                    CreateVolumeSetCharacteristicsStep.this.raidLevelComboBox.setSelectedIndex(0);
                }
            }
        }, this.subSystemID);
    }

    private int getVolumesQuantity() {
        this.diskAccessor.getVolumeIdsBySubsystem(new GuiRequestor(){

            public void handleResponse(short s, Response response) {
                if (s <= 4 && response != null) {
                    CreateVolumeSetCharacteristicsStep.this.volumeIDs = (String[])response.responseData;
                    CreateVolumeSetCharacteristicsStep createVolumeSetCharacteristicsStep = CreateVolumeSetCharacteristicsStep.this;
                    createVolumeSetCharacteristicsStep.maxQuantitySpinnerValue = createVolumeSetCharacteristicsStep.maxQuantitySpinnerValue - CreateVolumeSetCharacteristicsStep.this.volumeIDs.length;
                    ((SpinnerNumberModel)CreateVolumeSetCharacteristicsStep.this.volumeQuantitySpinner.getModel()).setMaximum(new Integer(CreateVolumeSetCharacteristicsStep.this.maxQuantitySpinnerValue));
                }
            }
        }, this.subSystemID);
        return this.maxQuantitySpinnerValue;
    }

    private void getArraysForRAID(String string) {
        GUIStoragePool gUIStoragePool = null;
        int n = -1;
        int n2 = -1;
        new String();
        float f = -1.0f;
        Vector vector = new Vector();
        String string2 = new String();
        this.arrayStrings = new Vector();
        Vector<String> vector2 = new Vector<String>();
        String string3 = (String)this.raidArray.get(string);
        vector = (Vector)this.arrayForRAID.get(string3);
        if (vector == null) {
            return;
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            gUIStoragePool = (GUIStoragePool)vector.get(n3);
            string2 = this.unitsArray[2];
            f = GUIEntityUtil.convertStorageCapacityDecimal(gUIStoragePool.getUnusedCapacity(), 0, 3, 2);
            if (f < 1.0f) {
                f = GUIEntityUtil.convertStorageCapacityDecimal(gUIStoragePool.getUnusedCapacity(), 0, 2, 2);
                string2 = this.unitsArray[1];
            }
            if ((n = this.subSystem.getType()) == 0 || n == 2 || n == 3) {
                n2 = 0;
            }
            if (n2 == -1 || gUIStoragePool.getFormat() == n2) {
                String string4 = gUIStoragePool.getDeviceId();
                if (vector2.contains(string4) || string4.length() == 0) {
                    vector2.add(string4);
                    string4 = String.valueOf(string4) + " (" + gUIStoragePool.getInstanceId() + ")" + " ( " + f + " " + string2 + " )";
                } else {
                    vector2.add(string4);
                    string4 = String.valueOf(string4) + " ( " + f + " " + string2 + " )";
                }
                this.aArrays.put(string4, gUIStoragePool);
                this.arrayStrings.add(string4);
            }
            ++n3;
        }
        if (this.arrayStrings.size() <= 0) {
            this.arrayStrings.add(Util.getString("DISK_NO_DATA_LABEL"));
        }
        Collections.sort(this.arrayStrings);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(this.arrayStrings);
        this.availableArraysComboBox.setModel(defaultComboBoxModel);
    }
}

