/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.disk.volume;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.disk.common.DiskConstants;
import org.eclipse.aperi.gui.disk.common.model.DiskDataAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.volume.VolumeDetailsPanel;
import org.eclipse.aperi.gui.disk.volume.VolumeListPanel;
import org.eclipse.aperi.gui.disk.volume.VolumePanel;
import org.eclipse.aperi.request.Response;

public class VolumeDDI
extends DataDisplayInfo
implements ActionListener {
    private VolumePanel mainPanel;
    private HashMap hmapVolofSS;
    public GUIStorageSubsystem subsystem;
    protected DiskDataAccessor diskAccessor = DiskDataAccessor.getInstance();
    private Vector volumes = new Vector();
    IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public VolumeDDI(GUIStorageSubsystem gUIStorageSubsystem) {
        this.setDescription(Util.getString("DISK_VOLUMES_LABEL"));
        this.displayInScrollPane = true;
        this.subsystem = gUIStorageSubsystem;
    }

    public String getHelpID() {
        Component component = this.mainPanel.tabs.getSelectedComponent();
        if (component instanceof VolumeListPanel) {
            return DiskConstants.DISK_LIST_VOLUMES;
        }
        if (component instanceof VolumeDetailsPanel) {
            return DiskConstants.DISK_VOLUMES_DETAILS;
        }
        return "welcome_gettingstarted";
    }

    public void getVolumes(String string, int n) {
        if (n == 0) {
            this.diskAccessor.getVolumesBySubsystem(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    if (s <= 4) {
                        VolumeDDI.this.hmapVolofSS = (HashMap)response.responseData;
                        VolumeDDI.this.volumes.removeAllElements();
                        VolumeDDI.this.volumes = new Vector(VolumeDDI.this.hmapVolofSS.values());
                    }
                    ((VolumeDDI)VolumeDDI.this).mainPanel.listPanel.buildtable();
                }
            }, this.subsystem.getId());
        } else if (n == 1) {
            this.diskAccessor.getVolumesByStoragePool(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    if (s <= 4) {
                        VolumeDDI.this.hmapVolofSS = (HashMap)response.responseData;
                        VolumeDDI.this.volumes.removeAllElements();
                        VolumeDDI.this.volumes = new Vector(VolumeDDI.this.hmapVolofSS.values());
                    }
                    ((VolumeDDI)VolumeDDI.this).mainPanel.listPanel.buildtable();
                }
            }, this.subsystem.getId(), string);
        } else if (n == 2) {
            this.diskAccessor.getVolumesByHost(new GuiRequestor(){

                public void handleResponse(short s, Response response) {
                    if (s <= 4) {
                        VolumeDDI.this.hmapVolofSS = (HashMap)response.responseData;
                        VolumeDDI.this.volumes.removeAllElements();
                        VolumeDDI.this.volumes = new Vector(VolumeDDI.this.hmapVolofSS.values());
                    }
                    ((VolumeDDI)VolumeDDI.this).mainPanel.listPanel.buildtable();
                }
            }, this.subsystem.getId(), string);
        } else if (n == 3) {
            this.volumes.removeAllElements();
            this.mainPanel.listPanel.buildtable();
        }
    }

    public void reDisplay() {
        this.buildPanel();
        this.showAndAddListeners();
    }

    public void buildPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new VolumePanel(this);
        }
        this.panel = this.mainPanel.getComponent();
    }

    private void showAndAddListeners() {
        this.show();
        this.guiMain.setSaveActionEnabled(false, false);
    }

    public void panelToBeNulled() {
        this.mainPanel = null;
    }

    public void losingFocus() {
    }

    public boolean isEditable() {
        return false;
    }

    public boolean changesPending() {
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    void showDetails(int n) {
        GUIVolume gUIVolume = (GUIVolume)this.volumes.elementAt(n);
        this.mainPanel.showDetails(gUIVolume);
    }

    public GUIVolume getRowDataAt(int n) {
        GUIVolume gUIVolume = (GUIVolume)this.volumes.elementAt(n);
        return gUIVolume;
    }

    public int getRowCount() {
        return this.volumes.size();
    }
}

