/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.fabric.details;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.common.ElementManagerHelperInterface;
import org.eclipse.aperi.gui.common.ElementManagerManager;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.gui.fabric.details.ElemMgrHlprObj;
import org.eclipse.aperi.gui.fabric.details.LabeledDetailsPanel;
import org.eclipse.aperi.server.guireq.fabric.details.GuiDetailsReq;

class DetailsSubPanel
extends LabeledDetailsPanel
implements ActionListener {
    private JButton buLaunch;
    private JButton buSet;
    private JButton buReset;
    JLabel statusLabel;
    SwitchElementManagerHelper elementManagerHelper;
    ElemMgrHlprObj dummy;

    public DetailsSubPanel(String string, String string2) {
        super(string, string2);
        this.dummy = new ElemMgrHlprObj();
    }

    public DetailsSubPanel(String string, String string2, Insets insets, boolean bl) {
        super(string, string2, insets, bl);
        this.elementManagerHelper = null;
    }

    protected JPanel makeDetailPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)super.makeDetailPanel(), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        this.buLaunch = new JButton(Util.getString("DISK_LAUNCH_ELEMENT_MANAGER_LABEL"));
        this.buLaunch.setEnabled(false);
        this.buLaunch.addActionListener(this);
        GuiUtil.setAccessible(this.buLaunch, this.buLaunch.getText(), this.buLaunch.getText());
        jPanel2.add(this.buLaunch);
        this.buSet = new JButton(Util.getString("DISK_SET_LAUNCHELEMENTMGR_BUTTON"));
        this.buSet.setEnabled(false);
        this.buSet.addActionListener(this);
        GuiUtil.setAccessible(this.buSet, this.buSet.getText(), this.buSet.getText());
        jPanel2.add(this.buSet);
        this.buReset = new JButton(Util.getString("DISK_RESET_LAUNCHELEMENTMGR_BUTTON"));
        this.buReset.setEnabled(false);
        GuiUtil.setAccessible(this.buReset, this.buReset.getText(), this.buReset.getText());
        this.buReset.addActionListener(this);
        jPanel2.add(this.buReset);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)new JLabel(" "), "North");
        jPanel3.add((Component)jPanel2, "South");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    public void displayDataInPanel(GuiDetailsReq guiDetailsReq) {
        if (guiDetailsReq != null) {
            this.dataInDb = guiDetailsReq;
            this.elementManagerHelper = new SwitchElementManagerHelper();
            this.buLaunch.setEnabled(true);
            this.buSet.setEnabled(true);
            this.buReset.setEnabled(true);
        }
        super.displayDataInPanel(guiDetailsReq);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buLaunch) {
            if (this.getElementManagerHelper() != null) {
                ElementManagerManager.getInstance().launchElementManager(this.dummy, this.getElementManagerHelper());
            }
        } else if (actionEvent.getSource() == this.buSet) {
            if (this.getElementManagerHelper() != null) {
                ElementManagerManager.getInstance().setElementManagerDialog(this.dummy, this.getElementManagerHelper());
            }
        } else if (actionEvent.getSource() == this.buReset) {
            if (this.getElementManagerHelper() != null) {
                ElementManagerManager.getInstance().deleteElementManager(this.dummy, this.getElementManagerHelper());
            }
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private ElementManagerHelperInterface getElementManagerHelper() {
        return this.elementManagerHelper;
    }

    protected JComponent createFieldValueComponent(String string) {
        if (string.equals("FabricDetails_State")) {
            this.statusLabel = new JLabel("");
            return this.statusLabel;
        }
        return super.createFieldValueComponent(string);
    }

    public void setFieldValue(JComponent jComponent, Object object) {
        if (jComponent == this.statusLabel) {
            Integer n = new Integer((String)object);
            JLabel jLabel = FabricGuiUtil.getConsolidatedStateLabel(n);
            this.statusLabel.setText(jLabel.getText());
            this.statusLabel.setIcon(jLabel.getIcon());
        } else {
            super.setFieldValue(jComponent, object);
        }
    }

    protected JLabel getFieldLabel(String string) {
        if (string.equals("FabricDetails_State")) {
            return new JLabel(Util.getString("DISK_STATE_LABEL"));
        }
        if (string.equals("FabricDetails_ManagementAddress")) {
            return new JLabel(Util.getString("DISK_MANAGEMENT_ADDRESS_LABEL"));
        }
        return super.getFieldLabel(string);
    }

    private class SwitchElementManagerHelper
    implements ElementManagerHelperInterface {
        private SwitchElementManagerHelper() {
        }

        public String extractGUID(Object object) {
            if (DetailsSubPanel.this.dataInDb != null && DetailsSubPanel.this.dataInDb.data != null) {
                return "switch:" + DetailsSubPanel.this.entityID;
            }
            return "";
        }

        public String extractDefaultElementManager(Object object) {
            if (DetailsSubPanel.this.dataInDb != null && DetailsSubPanel.this.dataInDb.data != null) {
                return "" + DetailsSubPanel.this.dataInDb.data.get("FabricDetails_ManagementAddress");
            }
            return "";
        }

        public String extractDisplayName(Object object) {
            if (DetailsSubPanel.this.dataInDb != null && DetailsSubPanel.this.dataInDb.data != null) {
                return "" + DetailsSubPanel.this.dataInDb.data.get("FabricDetails_Label");
            }
            return "";
        }
    }
}

