/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.tape.mediachangers;

import javax.swing.JLabel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.tape.common.model.GUIMediaChanger;
import org.eclipse.aperi.gui.tape.mediachangers.MediaChangersDDI;

public class MediaChangersTableModel
extends BaseTableModel {
    private MediaChangersDDI aDDI;
    public static final String[] COL_NAMES = new String[]{Util.getString("TAPE_MEDIA_CHANGER_LABEL"), Util.getString("TAPE_STATE_LABEL"), Util.getString("TAPE_MEDIA_FLIP_SUPPORTED"), Util.getString("TAPE_WWNN_LABEL"), Util.getString("TAPE_FIRMWARE_LABEL")};
    private static final int LIB_MEDIACHANGER = 0;
    private static final int LIB_STATE = 1;
    private static final int LIB_MEDIA = 2;
    private static final int LIB_WWPN = 3;
    private static final int LIB_FIRMWARE = 4;

    MediaChangersTableModel(MediaChangersDDI mediaChangersDDI) {
        this.aDDI = mediaChangersDDI;
        this.columnNames = COL_NAMES;
        this.rowCount = this.aDDI.getMediaChangers().size();
    }

    public Object getTableDataItem(int n, int n2) {
        GUIMediaChanger gUIMediaChanger = (GUIMediaChanger)this.aDDI.getMediaChangers().elementAt(n);
        switch (n2) {
            case 0: {
                return gUIMediaChanger.getName();
            }
            case 1: {
                JLabel jLabel = GUIEntityUtil.getEntityStateLabel(gUIMediaChanger);
                return jLabel;
            }
            case 2: {
                if (!gUIMediaChanger.isMediaFlipSupported()) {
                    return Util.getString("TAPE_NO_LABEL");
                }
                return Util.getString("TAPE_YES_LABEL");
            }
            case 3: {
                return gUIMediaChanger.getWwpn();
            }
            case 4: {
                return gUIMediaChanger.getVersion();
            }
        }
        return "";
    }
}

