/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.gui.topo.model.GraphGroupKey;
import org.eclipse.aperi.gui.topo.model.GraphGroupingUtilities;
import org.eclipse.aperi.gui.topo.model.GraphModel;
import org.eclipse.aperi.gui.topo.model.GraphModelConstant;
import org.eclipse.aperi.gui.topo.model.GraphModelUtilities;
import org.eclipse.aperi.gui.topo.model.GraphScopedType;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputer;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup;
import org.eclipse.aperi.gui.topo.model.bean.GraphComputerGroup2Computer;

public class GraphModelComputerL0
extends GraphModel {
    private static final long serialVersionUID = 8782393314465056565L;
    public static final GraphScopedType COMPUTERGROUP = new GraphScopedType(GraphComputerGroup.TYPE, GraphModelConstant.SCOPE_NULL);

    public GraphModelComputerL0(ID iD) {
        super(iD);
    }

    protected void initGroupByCapabilities() {
        int n = GraphGroupingUtilities.GROUPBY_HEALTH + GraphGroupingUtilities.GROUPBY_UDP1 + GraphGroupingUtilities.GROUPBY_UDP2 + GraphGroupingUtilities.GROUPBY_UDP3 + GraphGroupingUtilities.GROUPBY_COMPUTERBYOS;
        Integer n2 = new Integer(n);
        this.groupByCapabilitiesH.put(COMPUTERGROUP, n2);
    }

    public void applyGrouping(Hashtable hashtable) {
        this.groupFocusComputer(hashtable);
    }

    private void groupFocusComputer(Hashtable hashtable) {
        Comparable comparable;
        this.removeAll(GraphComputerGroup.TYPE);
        this.removeAll(GraphComputerGroup2Computer.TYPE);
        Vector vector = new Vector();
        Enumeration enumeration = this.enumerate(GraphComputer.TYPE);
        while (enumeration.hasMoreElements()) {
            comparable = (GraphComputer)enumeration.nextElement();
            vector.add(comparable);
        }
        comparable = (Integer)hashtable.get(COMPUTERGROUP);
        Hashtable hashtable2 = GraphGroupingUtilities.applyGrouping(vector, (Integer)comparable, this);
        Enumeration enumeration2 = hashtable2.keys();
        while (enumeration2.hasMoreElements()) {
            GraphGroupKey graphGroupKey = (GraphGroupKey)enumeration2.nextElement();
            vector = (Vector)hashtable2.get(graphGroupKey);
            String string = graphGroupKey.getID();
            GraphComputerGroup graphComputerGroup = new GraphComputerGroup(string);
            GraphComputerGroup.ID iD = (GraphComputerGroup.ID)graphComputerGroup.getEntityID();
            graphComputerGroup.setDisplayName(graphGroupKey.getLabel());
            graphComputerGroup.setHealthStatus(GraphModelUtilities.aggregateHealthStatus(vector));
            graphComputerGroup.setSortingValue(graphGroupKey);
            graphComputerGroup.setGroupKey(graphGroupKey);
            this.put(graphComputerGroup);
            int n = 0;
            while (n < vector.size()) {
                GraphComputer graphComputer = (GraphComputer)vector.elementAt(n);
                GraphComputer.ID iD2 = (GraphComputer.ID)graphComputer.getEntityID();
                GraphComputerGroup2Computer graphComputerGroup2Computer = new GraphComputerGroup2Computer(iD.getID() + "+" + iD2.getID());
                graphComputerGroup2Computer.setComputerGroupID(iD);
                graphComputerGroup2Computer.setComputerID(iD2);
                this.put(graphComputerGroup2Computer);
                ++n;
            }
        }
    }

    public void applyFiltering(int n) {
        Enumeration enumeration = this.enumerate(GraphComputerGroup.TYPE);
        while (enumeration.hasMoreElements()) {
            GraphComputerGroup graphComputerGroup = (GraphComputerGroup)enumeration.nextElement();
            GraphComputerGroup.ID iD = (GraphComputerGroup.ID)graphComputerGroup.getEntityID();
            int n2 = 0;
            int n3 = 0;
            Enumeration enumeration2 = this.associator(GraphComputerGroup2Computer.TYPE, iD);
            while (enumeration2.hasMoreElements()) {
                GraphComputer graphComputer = (GraphComputer)enumeration2.nextElement();
                ++n2;
                Boolean bl = n == 0 ? Boolean.FALSE : (GraphModelUtilities.isAbnormal(graphComputer) ? Boolean.FALSE : Boolean.TRUE);
                graphComputer.setIsFilterable(bl);
                if (bl.booleanValue()) continue;
                ++n3;
            }
            graphComputerGroup.setNumOfComputers(new Integer(n2));
            graphComputerGroup.setNumOfAbnormalComputers(new Integer(n3));
            graphComputerGroup.setIsFilterable(n3 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public static class ID
    extends GraphModel.ID {
        private static final long serialVersionUID = -84968618329483991L;

        public ID() {
            super("ComputerL0", null);
        }
    }
}

