/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.topo.widget;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.topo.widget.ControllerApp;
import org.eclipse.aperi.gui.topo.widget.TopoLayoutUtilities;
import org.eclipse.aperi.gui.topo.widget.TopoSetting;

public class JTopoDialogRefreshSetting
extends JDialog {
    private JComboBox refreshCB;

    public JTopoDialogRefreshSetting(Frame frame, ControllerApp controllerApp) {
        super(frame, GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_TITLE"), true);
        TopoSetting topoSetting = controllerApp.getTopoSetting();
        int n = topoSetting.getRefreshRate();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        this.setResizable(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        TopoLayoutUtilities.VerticalGridLayout verticalGridLayout = new TopoLayoutUtilities.VerticalGridLayout(3);
        verticalGridLayout.setHorizontalAlignment(4);
        verticalGridLayout.setSpacing(5);
        jPanel2.setLayout(verticalGridLayout);
        jPanel.add((Component)jPanel2, "Center");
        JLabel jLabel = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_MSG1"));
        jPanel2.add(jLabel);
        JLabel jLabel2 = new JLabel("" + n);
        jPanel2.add(jLabel2);
        JLabel jLabel3 = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_UNIT"));
        jPanel2.add(jLabel3);
        JLabel jLabel4 = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_MSG2"));
        jPanel2.add(jLabel4);
        this.refreshCB = new JComboBox();
        this.refreshCB.addItem("1");
        this.refreshCB.addItem("2");
        this.refreshCB.addItem("3");
        this.refreshCB.addItem("4");
        this.refreshCB.addItem("5");
        this.refreshCB.addItem("10");
        this.refreshCB.addItem("15");
        this.refreshCB.addItem("20");
        this.refreshCB.addItem("30");
        this.refreshCB.addItem("45");
        this.refreshCB.addItem("60");
        jPanel2.add(this.refreshCB);
        JLabel jLabel5 = new JLabel(GuiUtil.getString("TOPO_LABEL_DIALOG_REFRESH_UNIT"));
        jPanel2.add(jLabel5);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(new EmptyBorder(10, 2, 2, 2));
        TopoLayoutUtilities.HorizontalLayout horizontalLayout = new TopoLayoutUtilities.HorizontalLayout();
        horizontalLayout.setHorizontalJustify(4);
        jPanel3.setLayout(horizontalLayout);
        jPanel.add((Component)jPanel3, "South");
        JButton jButton = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_OK"));
        jButton.addActionListener(new PostAction(controllerApp));
        jPanel3.add(jButton);
        JButton jButton2 = new JButton(GuiUtil.getString("TOPO_LABEL_COMMON_CANCEL"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTopoDialogRefreshSetting.this.dispose();
            }
        });
        jPanel3.add(jButton2);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private class PostAction
    implements ActionListener {
        private ControllerApp controllerApp;

        public PostAction(ControllerApp controllerApp) {
            this.controllerApp = controllerApp;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TopoSetting topoSetting = this.controllerApp.getTopoSetting();
            String string = (String)JTopoDialogRefreshSetting.this.refreshCB.getSelectedItem();
            if (string != null) {
                int n = Integer.parseInt(string);
                topoSetting.setRefreshRate(n);
                int n2 = n * 60;
                this.controllerApp.getBackend().setTimeout(n2);
            }
            JTopoDialogRefreshSetting.this.dispose();
        }
    }
}

