/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.identity;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.NestableException;

public class MainframeLinuxHWID {
    public static boolean underVM;
    private static final String PROC_CPUINFO = "/proc/cpuinfo";
    private static final long MIN_VM_IDENT = 0xFF0000000000L;
    private static final String CPINT = "cpint";
    private static final String PROC_DEVICES = "/proc/devices";
    private static final String SLASH_DEV = "/dev";
    private static final String QUERY_USERID = "QUERY USERID";
    private static final String[] cpuIdentTags;
    private static final int[] cpuIdentFieldNumbers;
    private static final String[] devSymLinks;
    private static final int[] devFileMinorNumbers;

    static {
        cpuIdentTags = new String[]{"version", "identification", "machine"};
        cpuIdentFieldNumbers = new int[]{2, 5, 8};
        String[] stringArray = new String[4];
        stringArray[1] = "cpcmd";
        stringArray[2] = "cpact";
        stringArray[3] = "cpmon";
        devSymLinks = stringArray;
        int[] nArray = new int[4];
        nArray[1] = 8;
        nArray[2] = 76;
        nArray[3] = 220;
        devFileMinorNumbers = nArray;
    }

    private static native boolean isModuleLoaded(String var0) throws LocalizableException;

    private static native void mknod(String var0, int var1, int var2, boolean var3) throws LocalizableException;

    private static native void makeSymbolicLink(String var0, String var1) throws LocalizableException;

    private static native String issueCPCmd(String var0) throws LocalizableException;

    private static long getCPUID() throws LocalizableException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "getCPUID", "");
        }
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(PROC_CPUINFO);
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz2.getName(), "getCPUID", iOException);
                try {
                    clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "getCPUID");
            }
            throw new NestableException("GEN0029E", null, iOException);
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        NestableException nestableException = null;
        String string = null;
        try {
            while ((string = bufferedReader.readLine()) != null && !string.startsWith("processor ")) {
            }
        }
        catch (IOException iOException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception(clazz.getName(), "getCPUID", iOException);
            }
            Object[] objectArray = new Object[]{PROC_CPUINFO};
            nestableException = new NestableException("GEN0133E", objectArray, iOException);
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
        if (nestableException != null) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "getCPUID");
            }
            throw nestableException;
        }
        bufferedReader = null;
        fileReader = null;
        if (string == null) {
            Object[] objectArray = new Object[]{PROC_CPUINFO};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "getCPUID");
            }
            throw new LocalizableException("GEN0135E", objectArray);
        }
        List list = Util.splitLine(string, 0);
        int n = list.size();
        if (n < 11) {
            Object[] objectArray = new Object[]{string, "11"};
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exit(clazz.getName(), "getCPUID");
            }
            throw new LocalizableException("GEN0202E", objectArray);
        }
        String[] stringArray = new String[n];
        list.toArray(stringArray);
        n = 0;
        while (n < cpuIdentTags.length) {
            int n2 = cpuIdentFieldNumbers[n];
            if (!stringArray[n2].equals(cpuIdentTags[n])) {
                Object[] objectArray = new Object[]{string, new Integer(n2), cpuIdentTags[n]};
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit(clazz.getName(), "getCPUID");
                }
                throw new LocalizableException("GEN0203E", objectArray);
            }
            ++n;
        }
        long[] lArray = new long[3];
        n = 0;
        while (n < lArray.length) {
            int n3 = cpuIdentFieldNumbers[n] + 2;
            String string2 = stringArray[n3];
            if (string2.endsWith(",")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            try {
                lArray[n] = Long.parseLong(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exception(clazz.getName(), "getCPUID", numberFormatException);
                }
                Object[] objectArray = new Object[]{string, new Integer(n3)};
                if (TraceLogger.enableTrace) {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    TraceLogger.exit(clazz.getName(), "getCPUID");
                }
                throw new LocalizableException("GEN0204E", objectArray);
            }
            ++n;
        }
        long l = lArray[0] << 40 | lArray[1] << 16 | lArray[2];
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "getCPUID", l);
        }
        return l;
    }

    /*
     * Exception decompiling
     */
    private static String getVMUser() throws LocalizableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [43[UNCONDITIONALDOLOOP]], but top level block is 12[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void query(HardwareID hardwareID) throws LocalizableException {
        byte[] byArray;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry(clazz.getName(), "query", "hardwareID");
        }
        String string = null;
        long l = MainframeLinuxHWID.getCPUID();
        boolean bl = underVM = l >= 0xFF0000000000L;
        if (underVM) {
            string = MainframeLinuxHWID.getVMUser();
        }
        int n = 10;
        if (string == null) {
            byArray = null;
        } else {
            byArray = string.getBytes();
            n += byArray.length;
        }
        byte[] byArray2 = new byte[n];
        byArray2[0] = 83;
        byArray2[1] = 51;
        byArray2[2] = 57;
        byArray2[3] = 48;
        int n2 = 0;
        while (n2 < 6) {
            byArray2[4 + n2] = (byte)l;
            l >>= 8;
            ++n2;
        }
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 10, byArray.length);
        }
        hardwareID.hardwareID = byArray2;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.identity.MainframeLinuxHWID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit(clazz.getName(), "query");
        }
    }
}

