/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.database.objects;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.DBCursor;
import org.eclipse.aperi.infrastructure.database.DBQueryAssistant;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.Normalizer;
import org.eclipse.aperi.infrastructure.database.tables.TResStoragePoolTable;

public class StoragePool
extends TResStoragePoolTable {
    private String m_ClassNameId_str;

    public void setClassName(String string) {
        this.m_ClassNameId_str = string;
    }

    public String getClassName() {
        return this.m_ClassNameId_str;
    }

    public static StoragePoolCursor getCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
        return new StoragePoolCursor(dBConnection, hashtable, vector);
    }

    public StoragePool() {
        this.clear();
    }

    public StoragePool(int n, long l, long l2, short s, double d, int n2, short s2, int n3, int n4, long l3, short s3, String string, String string2, int n5, short s4, int n6, short s5, int n7, short s6, long l4, long l5, Timestamp timestamp, Timestamp timestamp2, short s7, int n8, short s8, short s9, String string3, String string4, String string5, Timestamp timestamp3, String string6, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, String string7, short s10, short s11) {
        this.clear();
        this.m_PoolId = n;
        this.m_TotalManagedSpace = l;
        this.m_RemainingManagedSpace = l2;
        this.m_Primordial = s;
        this.m_Capacity = d;
        this.m_ExtentSize = n2;
        this.m_NativeStatus = s2;
        this.m_NumberOfBackendVolumes = n3;
        this.m_NumberOfStorageVolumes = n4;
        this.m_TotalAvailableSpace = l3;
        this.m_ElementType = s3;
        this.m_RaidLevel = string;
        this.m_InstanceId = string2;
        this.m_SubsystemId = n5;
        this.m_VolGroupType = s4;
        this.m_Lss = n6;
        this.m_Config = s5;
        this.m_DiskGroupId = n7;
        this.m_Format = s6;
        this.m_SurfacedLunCap = l4;
        this.m_UnsurfacedLunCap = l5;
        this.m_DiscoveredTime = timestamp;
        this.m_LastProbeTime = timestamp2;
        this.m_Detectable = s7;
        this.m_OperationalStatus = n8;
        this.m_ConsolidatedStatus = s8;
        this.m_PropagatedStatus = s9;
        this.m_UserAttrib1 = string3;
        this.m_UserAttrib2 = string4;
        this.m_UserAttrib3 = string5;
        this.m_UpdateTimestamp = timestamp3;
        this.m_Name = string6;
        this.m_DataRedundancyMin = n9;
        this.m_DataRedundancyMax = n10;
        this.m_DataRedundancyDef = n11;
        this.m_PckRedundancyMin = n12;
        this.m_PckRedundancyMax = n13;
        this.m_PckRedundancyDef = n14;
        this.m_DeltaResMin = n15;
        this.m_DeltaResMax = n16;
        this.m_DeltaResDef = n17;
        this.m_DisplayName = string7;
        this.m_RankGroup = s10;
        this.m_ClassNameId = s11;
    }

    private void setNonKeyValues(Hashtable hashtable) {
        if (this.m_PoolId != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("POOL_ID"), String.valueOf(this.m_PoolId));
        }
        if (this.m_TotalManagedSpace != Long.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("TOTAL_MANAGED_SPACE"), String.valueOf(this.m_TotalManagedSpace));
        }
        if (this.m_RemainingManagedSpace != Long.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("REMAINING_MANAGED_SPACE"), String.valueOf(this.m_RemainingManagedSpace));
        }
        if (this.m_Primordial != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("PRIMORDIAL"), String.valueOf(this.m_Primordial));
        }
        if (this.m_Capacity != Double.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("CAPACITY"), String.valueOf(this.m_Capacity));
        }
        if (this.m_ExtentSize != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("EXTENT_SIZE"), String.valueOf(this.m_ExtentSize));
        }
        if (this.m_NativeStatus != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("NATIVE_STATUS"), String.valueOf(this.m_NativeStatus));
        }
        if (this.m_NumberOfBackendVolumes != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("NUMBER_OF_BACKEND_VOLUMES"), String.valueOf(this.m_NumberOfBackendVolumes));
        }
        if (this.m_NumberOfStorageVolumes != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("NUMBER_OF_STORAGE_VOLUMES"), String.valueOf(this.m_NumberOfStorageVolumes));
        }
        if (this.m_TotalAvailableSpace != Long.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("TOTAL_AVAILABLE_SPACE"), String.valueOf(this.m_TotalAvailableSpace));
        }
        if (this.m_ElementType != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("ELEMENT_TYPE"), String.valueOf(this.m_ElementType));
        }
        if (this.m_RaidLevel != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("RAID_LEVEL"), this.m_RaidLevel);
        }
        if (this.m_VolGroupType != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("VOL_GROUP_TYPE"), String.valueOf(this.m_VolGroupType));
        }
        if (this.m_Lss != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("LSS"), String.valueOf(this.m_Lss));
        }
        if (this.m_Config != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("CONFIG"), String.valueOf(this.m_Config));
        }
        if (this.m_DiskGroupId != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DISK_GROUP_ID"), String.valueOf(this.m_DiskGroupId));
        }
        if (this.m_Format != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("FORMAT"), String.valueOf(this.m_Format));
        }
        if (this.m_SurfacedLunCap != Long.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("SURFACED_LUN_CAP"), String.valueOf(this.m_SurfacedLunCap));
        }
        if (this.m_UnsurfacedLunCap != Long.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("UNSURFACED_LUN_CAP"), String.valueOf(this.m_UnsurfacedLunCap));
        }
        if (this.m_DiscoveredTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DISCOVERED_TIME"), this.m_DiscoveredTime);
        }
        if (this.m_LastProbeTime != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("LAST_PROBE_TIME"), this.m_LastProbeTime);
        }
        if (this.m_Detectable != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DETECTABLE"), String.valueOf(this.m_Detectable));
        }
        if (this.m_OperationalStatus != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("OPERATIONAL_STATUS"), String.valueOf(this.m_OperationalStatus));
        }
        if (this.m_ConsolidatedStatus != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("CONSOLIDATED_STATUS"), String.valueOf(this.m_ConsolidatedStatus));
        }
        if (this.m_PropagatedStatus != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("PROPAGATED_STATUS"), String.valueOf(this.m_PropagatedStatus));
        }
        if (this.m_UserAttrib1 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("USER_ATTRIB1"), this.m_UserAttrib1);
        }
        if (this.m_UserAttrib2 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("USER_ATTRIB2"), this.m_UserAttrib2);
        }
        if (this.m_UserAttrib3 != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("USER_ATTRIB3"), this.m_UserAttrib3);
        }
        if (this.m_UpdateTimestamp != DBConstants.INVALID_TIMESTAMP_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("UPDATE_TIMESTAMP"), this.m_UpdateTimestamp);
        }
        if (this.m_Name != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("NAME"), this.m_Name);
        }
        if (this.m_DataRedundancyMin != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DATA_REDUNDANCY_MIN"), String.valueOf(this.m_DataRedundancyMin));
        }
        if (this.m_DataRedundancyMax != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DATA_REDUNDANCY_MAX"), String.valueOf(this.m_DataRedundancyMax));
        }
        if (this.m_DataRedundancyDef != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DATA_REDUNDANCY_DEF"), String.valueOf(this.m_DataRedundancyDef));
        }
        if (this.m_PckRedundancyMin != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("PCK_REDUNDANCY_MIN"), String.valueOf(this.m_PckRedundancyMin));
        }
        if (this.m_PckRedundancyMax != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("PCK_REDUNDANCY_MAX"), String.valueOf(this.m_PckRedundancyMax));
        }
        if (this.m_PckRedundancyDef != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("PCK_REDUNDANCY_DEF"), String.valueOf(this.m_PckRedundancyDef));
        }
        if (this.m_DeltaResMin != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DELTA_RES_MIN"), String.valueOf(this.m_DeltaResMin));
        }
        if (this.m_DeltaResMax != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DELTA_RES_MAX"), String.valueOf(this.m_DeltaResMax));
        }
        if (this.m_DeltaResDef != Integer.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DELTA_RES_DEF"), String.valueOf(this.m_DeltaResDef));
        }
        if (this.m_DisplayName != DBConstants.INVALID_STRING_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("DISPLAY_NAME"), this.m_DisplayName);
        }
        if (this.m_RankGroup != Short.MIN_VALUE) {
            hashtable.put(StoragePool.getColumnInfo("RANK_GROUP"), String.valueOf(this.m_RankGroup));
        }
    }

    public boolean insert(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(dBConnection, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htColsAndValues.put(StoragePool.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htColsAndValues.put(StoragePool.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htColsAndValues.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        this.setNonKeyValues(this.htColsAndValues);
        return DBQueryAssistant.performInsert("T_RES_STORAGE_POOL", dBConnection, this.htColsAndValues);
    }

    public boolean insert(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (hashtable.get(StoragePool.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        if (hashtable.get(StoragePool.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        if (hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        return DBQueryAssistant.performInsert("T_RES_STORAGE_POOL", dBConnection, hashtable);
    }

    public int update(DBConnection dBConnection) throws SQLException {
        this.htColsAndValues.clear();
        this.htWhereClause.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(dBConnection, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        this.setNonKeyValues(this.htColsAndValues);
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_POOL", dBConnection, this.htColsAndValues, this.htWhereClause);
    }

    public int update(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (hashtable.get(StoragePool.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(StoragePool.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(StoragePool.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("INSTANCE_ID"), hashtable.get(StoragePool.getColumnInfo("INSTANCE_ID")));
        if (hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_POOL", dBConnection, hashtable, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection) throws SQLException {
        this.htWhereClause.clear();
        if (this.m_ClassNameId_str != null) {
            this.m_ClassNameId = Normalizer.ClassNameGetID(dBConnection, this.m_ClassNameId_str);
        }
        if (this.m_SubsystemId == Integer.MIN_VALUE) {
            throw new SQLException("ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("SUBSYSTEM_ID"), String.valueOf(this.m_SubsystemId));
        if (this.m_InstanceId == DBConstants.INVALID_STRING_VALUE) {
            throw new SQLException("ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("INSTANCE_ID"), this.m_InstanceId);
        if (this.m_ClassNameId == Short.MIN_VALUE) {
            throw new SQLException("ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(this.m_ClassNameId));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_POOL", dBConnection, this.htWhereClause);
    }

    public int delete(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        this.htWhereClause.clear();
        if (hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (hashtable.get(StoragePool.getColumnInfo("SUBSYSTEM_ID")) == null) {
            throw new SQLException(" ERROR: key SUBSYSTEM_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("SUBSYSTEM_ID"), hashtable.get(StoragePool.getColumnInfo("SUBSYSTEM_ID")));
        if (hashtable.get(StoragePool.getColumnInfo("INSTANCE_ID")) == null) {
            throw new SQLException(" ERROR: key INSTANCE_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("INSTANCE_ID"), hashtable.get(StoragePool.getColumnInfo("INSTANCE_ID")));
        if (hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) == null) {
            throw new SQLException(" ERROR: key CLASS_NAME_ID not found");
        }
        this.htWhereClause.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")));
        if (this.htWhereClause.size() == 0) {
            throw new SQLException("Method does not work as no primary keys are specified for this table");
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_POOL", dBConnection, this.htWhereClause);
    }

    /*
     * Exception decompiling
     */
    public boolean retrieve(DBConnection var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 227->230)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static StoragePool retrieve(DBConnection var0, Hashtable var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 291->294)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int update(DBConnection dBConnection, Hashtable hashtable, Hashtable hashtable2) throws SQLException {
        if (dBConnection == null || hashtable == null || hashtable2 == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")))));
        }
        if (hashtable2.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable2.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable2.get(StoragePool.getColumnInfo("CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performUpdate("T_RES_STORAGE_POOL", dBConnection, hashtable, hashtable2);
    }

    public static int deletes(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
        if (dBConnection == null || hashtable == null) {
            throw new SQLException("ERROR invalid input");
        }
        if (hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) != null) {
            hashtable.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")))));
        }
        return DBQueryAssistant.performDelete("T_RES_STORAGE_POOL", dBConnection, hashtable);
    }

    protected void setFields(DBConnection dBConnection, DBResultSet dBResultSet) throws SQLException {
        this.setPoolId(dBResultSet.getInt("POOL_ID"));
        this.setTotalManagedSpace(dBResultSet.getLong("TOTAL_MANAGED_SPACE"));
        this.setRemainingManagedSpace(dBResultSet.getLong("REMAINING_MANAGED_SPACE"));
        this.setPrimordial(dBResultSet.getShort("PRIMORDIAL"));
        this.setCapacity(dBResultSet.getDouble("CAPACITY"));
        this.setExtentSize(dBResultSet.getInt("EXTENT_SIZE"));
        this.setNativeStatus(dBResultSet.getShort("NATIVE_STATUS"));
        this.setNumberOfBackendVolumes(dBResultSet.getInt("NUMBER_OF_BACKEND_VOLUMES"));
        this.setNumberOfStorageVolumes(dBResultSet.getInt("NUMBER_OF_STORAGE_VOLUMES"));
        this.setTotalAvailableSpace(dBResultSet.getLong("TOTAL_AVAILABLE_SPACE"));
        this.setElementType(dBResultSet.getShort("ELEMENT_TYPE"));
        this.setRaidLevel(dBResultSet.getString("RAID_LEVEL"));
        this.setInstanceId(dBResultSet.getString("INSTANCE_ID"));
        this.setSubsystemId(dBResultSet.getInt("SUBSYSTEM_ID"));
        this.setVolGroupType(dBResultSet.getShort("VOL_GROUP_TYPE"));
        this.setLss(dBResultSet.getInt("LSS"));
        this.setConfig(dBResultSet.getShort("CONFIG"));
        this.setDiskGroupId(dBResultSet.getInt("DISK_GROUP_ID"));
        this.setFormat(dBResultSet.getShort("FORMAT"));
        this.setSurfacedLunCap(dBResultSet.getLong("SURFACED_LUN_CAP"));
        this.setUnsurfacedLunCap(dBResultSet.getLong("UNSURFACED_LUN_CAP"));
        this.setDiscoveredTime(dBResultSet.getTimestamp("DISCOVERED_TIME"));
        this.setLastProbeTime(dBResultSet.getTimestamp("LAST_PROBE_TIME"));
        this.setDetectable(dBResultSet.getShort("DETECTABLE"));
        this.setOperationalStatus(dBResultSet.getInt("OPERATIONAL_STATUS"));
        this.setConsolidatedStatus(dBResultSet.getShort("CONSOLIDATED_STATUS"));
        this.setPropagatedStatus(dBResultSet.getShort("PROPAGATED_STATUS"));
        this.setUserAttrib1(dBResultSet.getString("USER_ATTRIB1"));
        this.setUserAttrib2(dBResultSet.getString("USER_ATTRIB2"));
        this.setUserAttrib3(dBResultSet.getString("USER_ATTRIB3"));
        this.setUpdateTimestamp(dBResultSet.getTimestamp("UPDATE_TIMESTAMP"));
        this.setName(dBResultSet.getString("NAME"));
        this.setDataRedundancyMin(dBResultSet.getInt("DATA_REDUNDANCY_MIN"));
        this.setDataRedundancyMax(dBResultSet.getInt("DATA_REDUNDANCY_MAX"));
        this.setDataRedundancyDef(dBResultSet.getInt("DATA_REDUNDANCY_DEF"));
        this.setPckRedundancyMin(dBResultSet.getInt("PCK_REDUNDANCY_MIN"));
        this.setPckRedundancyMax(dBResultSet.getInt("PCK_REDUNDANCY_MAX"));
        this.setPckRedundancyDef(dBResultSet.getInt("PCK_REDUNDANCY_DEF"));
        this.setDeltaResMin(dBResultSet.getInt("DELTA_RES_MIN"));
        this.setDeltaResMax(dBResultSet.getInt("DELTA_RES_MAX"));
        this.setDeltaResDef(dBResultSet.getInt("DELTA_RES_DEF"));
        this.setDisplayName(dBResultSet.getString("DISPLAY_NAME"));
        this.setRankGroup(dBResultSet.getShort("RANK_GROUP"));
        this.setClassNameId(dBResultSet.getShort("CLASS_NAME_ID"));
        this.setClassName(Normalizer.ClassNameGetName(dBConnection, this.m_ClassNameId));
    }

    public static class StoragePoolCursor
    extends DBCursor {
        private StoragePool element = new StoragePool();
        private DBConnection con;

        private static Hashtable normalize(DBConnection dBConnection, Hashtable hashtable) throws SQLException {
            if (hashtable == null) {
                return null;
            }
            if (hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")) != null) {
                hashtable.put(StoragePool.getColumnInfo("CLASS_NAME_ID"), String.valueOf(Normalizer.ClassNameGetID(dBConnection, (String)hashtable.get(StoragePool.getColumnInfo("CLASS_NAME_ID")))));
            }
            return hashtable;
        }

        public StoragePoolCursor(DBConnection dBConnection, Hashtable hashtable, Vector vector) throws SQLException {
            super("T_RES_STORAGE_POOL", dBConnection, StoragePoolCursor.normalize(dBConnection, hashtable), vector);
            this.con = dBConnection;
        }

        public StoragePool getObject() throws SQLException {
            StoragePool storagePool = null;
            if (this.DBrs != null) {
                storagePool = new StoragePool();
                storagePool.setFields(this.con, this.DBrs);
            }
            return storagePool;
        }

        public StoragePool getAttributes() throws SQLException {
            if (this.DBrs != null) {
                this.element.setFields(this.con, this.DBrs);
                return this.element;
            }
            return null;
        }
    }
}

