/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.Disk;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;

public class CorrelateVolume {
    public static void correlateStorageVolume(DBConnection dBConnection, short s, int n) throws SQLException {
        int n2;
        String string = CorrelateVolume.getStorageVolumeSerialNumber(dBConnection, s, n);
        if (string != null && (n2 = CorrelateVolume.getPhysicalVolumeId(dBConnection, s, string)) != -1) {
            CorrelateVolume.createCorrelation(dBConnection, n2, n);
        }
    }

    public static void correlatePhysicalVolume(DBConnection dBConnection, short s, int n) throws SQLException {
        int n2;
        String string = CorrelateVolume.getPhysicalVolumeSerialNumber(dBConnection, s, n);
        if (string != null && (n2 = CorrelateVolume.getStorageVolumeId(dBConnection, s, string)) != -1) {
            CorrelateVolume.createCorrelation(dBConnection, n, n2);
        }
    }

    private static void createCorrelation(DBConnection dBConnection, int n, int n2) throws SQLException {
        Object[] objectArray;
        int n3;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(Disk.getColumnInfo("DISK_ID"), String.valueOf(n));
        Vector<String> vector = new Vector<String>();
        vector.add("LOGICAL_DISK_ID");
        Disk.DiskCursor diskCursor = Disk.getCursor(dBConnection, hashtable, vector);
        if (diskCursor.next() && (n3 = ((Integer)(objectArray = diskCursor.getAttribute(vector))[0]).intValue()) != n2) {
            Hashtable<ColumnInfo, String> hashtable2 = new Hashtable<ColumnInfo, String>();
            hashtable2.put(Disk.getColumnInfo("LOGICAL_DISK_ID"), ((Integer)objectArray[0]).toString());
            Disk.update(dBConnection, hashtable2, hashtable);
        }
    }

    private static String getStorageVolumeSerialNumber(DBConnection dBConnection, short s, int n) throws SQLException {
        String string = null;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(StorageVolume.getColumnInfo("SVID"), String.valueOf(n));
        hashtable.put(StorageVolume.getColumnInfo("NAME_FORMAT"), "15");
        Vector<String> vector = new Vector<String>();
        vector.add("NAME");
        StorageVolume.StorageVolumeCursor storageVolumeCursor = StorageVolume.getCursor(dBConnection, hashtable, vector);
        if (storageVolumeCursor.next()) {
            Object[] objectArray = storageVolumeCursor.getAttribute(vector);
            string = (String)objectArray[0];
        }
        return string;
    }

    private static String getPhysicalVolumeSerialNumber(DBConnection dBConnection, short s, int n) throws SQLException {
        String string = null;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(PhysicalVolume.getColumnInfo("PHYSICAL_VOLUME_ID"), String.valueOf(n));
        Vector<String> vector = new Vector<String>();
        vector.add("SERIAL_NUMBER");
        PhysicalVolume.PhysicalVolumeCursor physicalVolumeCursor = PhysicalVolume.getCursor(dBConnection, hashtable, vector);
        if (physicalVolumeCursor.next()) {
            Object[] objectArray = physicalVolumeCursor.getAttribute(vector);
            string = (String)objectArray[0];
        }
        return string;
    }

    private static int getPhysicalVolumeId(DBConnection dBConnection, short s, String string) throws SQLException {
        int n = -1;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(PhysicalVolume.getColumnInfo("STORAGE_SYSTEM_TYPE"), String.valueOf(s));
        hashtable.put(PhysicalVolume.getColumnInfo("SERIAL_NUMBER"), string);
        Vector<String> vector = new Vector<String>();
        vector.add("PHYSICAL_VOLUME_ID");
        PhysicalVolume.PhysicalVolumeCursor physicalVolumeCursor = PhysicalVolume.getCursor(dBConnection, hashtable, vector);
        if (physicalVolumeCursor.next()) {
            Object[] objectArray = physicalVolumeCursor.getAttribute(vector);
            n = (Integer)objectArray[0];
        }
        return n;
    }

    private static int getStorageVolumeId(DBConnection dBConnection, short s, String string) throws SQLException {
        int n = -1;
        Hashtable<ColumnInfo, String> hashtable = new Hashtable<ColumnInfo, String>();
        hashtable.put(StorageVolume.getColumnInfo("NAME"), string);
        hashtable.put(StorageVolume.getColumnInfo("NAME_FORMAT"), "15");
        Vector<String> vector = new Vector<String>();
        vector.add("SVID");
        StorageVolume.StorageVolumeCursor storageVolumeCursor = StorageVolume.getCursor(dBConnection, hashtable, vector);
        if (storageVolumeCursor.next()) {
            Object[] objectArray = storageVolumeCursor.getAttribute(vector);
            n = (Integer)objectArray[0];
        }
        return n;
    }
}

