/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.DiskGroup;
import org.eclipse.aperi.infrastructure.database.objects.PhysicalVolume;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.SMISCIM_DiskDriveToDBMapper;

public class SMISIBMTSDS_DiskDriveToDBMapper
extends SMISCIM_DiskDriveToDBMapper {
    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "IBMTSDS_DiskDrive";
        String string2 = "1.1.0";
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SMISIBMTSDS_DiskDriveToDBMapper() {
        ColumnInfo columnInfo = PhysicalVolume.getColumnInfo("TAG");
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        this.m_htAttribToMapperInfo.put("ref_tag", mapperInfo);
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        this.logEntry(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", new Object[]{dBConnection, hashtable, string});
        String string2 = (String)hashtable.get("systemname");
        String string3 = (String)hashtable.get("location");
        if (string2 != null && string2.startsWith("IBM.") && string3 != null) {
            hashtable.put("elementname", string3);
        }
        MapperResult mapperResult = super.persist(dBConnection, hashtable, string);
        String string4 = (String)hashtable.get("ref_tag");
        String string5 = (String)hashtable.get("ref_diskgroup_id");
        if (string4 != null && string5 != null) {
            DiskGroupMapper diskGroupMapper = new DiskGroupMapper();
            mapperResult.addMapperResult(diskGroupMapper.persist(dBConnection, hashtable, string));
        }
        this.logExit(this.getClass().getName(), "persist(DBConnection pConn, Hashtable pParams, String pScanID)", mapperResult);
        return mapperResult;
    }

    private class DiskGroupMapper
    extends DBAttributeMapper {
        public DiskGroupMapper() {
            ColumnInfo columnInfo = DiskGroup.getColumnInfo("TAG");
            columnInfo.setIsPrimaryKey();
            MapperInfo mapperInfo = new MapperInfo(columnInfo);
            ColumnInfo columnInfo2 = DiskGroup.getColumnInfo("DISK_GROUP_ID");
            columnInfo2.setAutoGenerated();
            mapperInfo.setDerivedColumn(columnInfo2);
            this.m_htAttribToMapperInfo.put("ref_tag", mapperInfo);
            this.m_htAttribToMapperInfo.put("ssaloop", new MapperInfo(DiskGroup.getColumnInfo("LOOP")));
            this.m_htAttribToMapperInfo.put("dapairid", new MapperInfo(DiskGroup.getColumnInfo("DA_PAIR_ID")));
            this.m_htAttribToMapperInfo.put("ddmspeed", new MapperInfo(DiskGroup.getColumnInfo("DDM_SPEED")));
            this.m_htAttribToMapperInfo.put("DEVICE_ADAPTER1".toLowerCase(), new MapperInfo(DiskGroup.getColumnInfo("DEVICE_ADAPTER1")));
            this.m_htAttribToMapperInfo.put("DEVICE_ADAPTER2".toLowerCase(), new MapperInfo(DiskGroup.getColumnInfo("DEVICE_ADAPTER2")));
        }

        public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
            Object object;
            String string2 = (String)hashtable.get("deviceadapters");
            if (string2 != null && (object = DiskGroupMapper.processArrayvalues(string2)) != null && ((Vector)object).size() > 0) {
                String string3;
                String string4 = (String)((Vector)object).elementAt(0);
                if (string4 != null && string4.length() > 0) {
                    hashtable.put("DEVICE_ADAPTER1".toLowerCase(), string4);
                }
                if (((Vector)object).size() > 1 && (string3 = (String)((Vector)object).elementAt(1)) != null && string3.length() > 0) {
                    hashtable.put("DEVICE_ADAPTER2".toLowerCase(), string3);
                }
            }
            object = super.persist(dBConnection, hashtable, string);
            ((MapperResult)object).addKeyReference("ref_diskgroup_id", DiskGroup.getColumnInfo("DISK_GROUP_ID"));
            ((MapperResult)object).addKeyReference("ref_tag", DiskGroup.getColumnInfo("TAG"));
            return object;
        }
    }
}

