/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.infrastructure.mapping;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.infrastructure.database.ColumnInfo;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.Fabric;
import org.eclipse.aperi.infrastructure.mapping.DBAttributeMapper;
import org.eclipse.aperi.infrastructure.mapping.MapperInfo;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;

public class SanXmlToDBMapper
extends DBAttributeMapper {
    private static final String PHYSICALINFRASTRUCTURE = "PhysicalInfrastructure";
    private static final String ZONECAP = "Zone Capability";
    private static final String ACTIVE = "Active";
    private static final String SANWWN = "San WWN";
    private static final String NAME = "Name";
    private static final String OP_STATUS = "State";
    private static final String CON_STATUS = "Con Status";

    public static DBAttributeMapper.RegistrationData[] getRegistrationData() {
        String string = "SanXml";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        DBAttributeMapper.RegistrationData registrationData = new DBAttributeMapper.RegistrationData(string, string2, string3, string4);
        return new DBAttributeMapper.RegistrationData[]{registrationData};
    }

    public SanXmlToDBMapper() {
        this.m_dataConverter.addComplexDataConversion("UniqueIdXml", ":", 2);
        this.m_dataConverter.addSimpleDataConversion(PHYSICALINFRASTRUCTURE.toLowerCase(), "Boolean");
        this.m_dataConverter.addSimpleDataConversion(ZONECAP.toLowerCase(), "SAN_Zone_Capabilities");
        this.m_dataConverter.addSimpleDataConversion(ACTIVE.toLowerCase(), "Boolean");
        this.m_htAttribToMapperInfo.put(SANWWN.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("SAN_WWN")));
        this.m_htAttribToMapperInfo.put(ZONECAP.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("SUPPORTS_ZONING")));
        this.m_htAttribToMapperInfo.put(ACTIVE.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("ACTIVE")));
        this.m_htAttribToMapperInfo.put(PHYSICALINFRASTRUCTURE.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("IS_PHYSICAL")));
        this.m_htAttribToMapperInfo.put(NAME.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("NAME")));
        this.m_htAttribToMapperInfo.put(OP_STATUS.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("OPERATIONAL_STATUS")));
        this.m_htAttribToMapperInfo.put(CON_STATUS.toLowerCase(), new MapperInfo(Fabric.getColumnInfo("CONSOLIDATED_STATUS")));
        ColumnInfo columnInfo = Fabric.getColumnInfo("FABRIC_WWN");
        columnInfo.setIsPrimaryKey();
        MapperInfo mapperInfo = new MapperInfo(columnInfo);
        ColumnInfo columnInfo2 = Fabric.getColumnInfo("FABRIC_ID");
        columnInfo2.setAutoGenerated();
        mapperInfo.setDerivedColumn(columnInfo2);
        this.m_htAttribToMapperInfo.put("UniqueIdXml".toLowerCase(), mapperInfo);
    }

    public MapperResult persist(DBConnection dBConnection, Hashtable hashtable, String string) throws SQLException {
        Object object;
        String string2 = "persist(DBConnection conn, Hashtable htValues, String scanID)";
        this.logEntry(this.myClassname, string2, new Object[]{dBConnection, hashtable, string});
        String string3 = (String)hashtable.get(OP_STATUS);
        if (string3 != null) {
            object = this.convertSNIAOPStatToBitArrValue(string3);
            hashtable.put(OP_STATUS, object[0]);
            Vector<String> vector = new Vector<String>();
            vector.add(object[1]);
            String string4 = DBConstants.convertOperationalstatusArrayToConsolidatedValue(vector);
            if (string4 != null) {
                hashtable.put(CON_STATUS, string4);
            }
        }
        object = super.persist(dBConnection, hashtable, string);
        this.logExit(this.myClassname, string2, object);
        return object;
    }
}

