/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.logging;

import com.ibm.log.FileHandler;
import com.ibm.log.LogComponent;
import com.ibm.log.LogEventListener;
import com.ibm.log.mgr.DataStore;
import com.ibm.log.mgr.LogManager;
import com.ibm.log.mgr.PropertyFileDataStore;
import com.ibm.log.util.LogException;
import java.io.File;
import java.io.IOException;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.logging.DisabledLogger;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.JLogObjectPool;

public class LogManagerFactory {
    public static final String JOB_CONTROL = "control";
    private static final String MAIN_LOGGER = "aperi.logger.message";
    private static final String JOB_LOGGER = "aperi.logger.message.JobLogger";
    private static final String JOB_LOGGER_HANDLER = "aperi.handler.file.JobLoggerHandler";
    public static final String JOB_LOG_NAME_EXT = ".log";
    public static final String HANDLER_TAG = "Pooled handler";
    private static JLogObjectPool loggerPool = null;
    private static JLogObjectPool handlerPool = null;
    private static LogManager lm = null;
    private static LogManagerFactory lmf = null;
    private static final String DISABLE_LOGGING_KEY = "org.eclipse.aperi.sanmgmt.logging.disable";
    private static final boolean loggingDisabled = System.getProperty("org.eclipse.aperi.sanmgmt.logging.disable", "").equals("true");

    private LogManagerFactory() {
        if (!loggingDisabled) {
            try {
                PropertyFileDataStore propertyFileDataStore = null;
                String string = String.valueOf(Variables.getConfigurationDirectory()) + File.separator + "logging.properties";
                propertyFileDataStore = new PropertyFileDataStore(string);
                this.init(propertyFileDataStore);
            }
            catch (LogException logException) {
                logException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static ILogger getMessageLogger(String string) {
        ILogger iLogger = null;
        if (!loggingDisabled) {
            if (lmf == null) {
                lmf = new LogManagerFactory();
            }
            iLogger = (ILogger)lm.getLogger(string);
        } else {
            iLogger = new DisabledLogger();
        }
        return iLogger;
    }

    public static String getLogFileName(ILogger iLogger) {
        return String.valueOf(((FileHandler)iLogger.getLogEventListeners()[0]).getFileDir()) + File.separator + ((FileHandler)iLogger.getLogEventListeners()[0]).getFileName();
    }

    public static ILogger getTraceLogger(String string) {
        ILogger iLogger = null;
        if (!loggingDisabled) {
            if (lmf == null) {
                lmf = new LogManagerFactory();
            }
            iLogger = (ILogger)lm.getLogger(string);
        } else {
            iLogger = new DisabledLogger();
        }
        return iLogger;
    }

    public void init(PropertyFileDataStore propertyFileDataStore) {
        lm = LogManager.getManagerWithMergedDataStore((DataStore)propertyFileDataStore, (boolean)false);
        loggerPool = new JLogObjectPool(lm, JOB_LOGGER);
        handlerPool = new JLogObjectPool(lm, JOB_LOGGER_HANDLER);
    }

    public static ILogger getJobLogger(String string, String string2, String string3) throws LogException, IOException {
        return LogManagerFactory.getJobLogger("msg", string, string2, string3);
    }

    public static ILogger getJobLogger(String string, String string2, String string3, String string4) throws LogException, IOException {
        if (lmf == null) {
            lmf = new LogManagerFactory();
        }
        FileHandler fileHandler = (FileHandler)handlerPool.getLogComponent();
        String string5 = String.valueOf(string) + "." + string2 + "." + string3 + "." + string4 + JOB_LOG_NAME_EXT;
        string5 = string5.replace('\\', '_');
        string5 = string5.replace('/', '_');
        string5 = string5.replace(':', '_');
        string5 = string5.replace('*', '_');
        string5 = string5.replace('?', '_');
        string5 = string5.replace('\"', '_');
        string5 = string5.replace('<', '_');
        string5 = string5.replace('>', '_');
        string5 = string5.replace('|', '_');
        fileHandler.setFileName(string5);
        fileHandler.setDescription(HANDLER_TAG);
        ILogger iLogger = (ILogger)loggerPool.getLogComponent();
        iLogger.addLogEventListener((LogEventListener)fileHandler);
        return iLogger;
    }

    public static void returnJobLogger(ILogger iLogger) {
        LogEventListener[] logEventListenerArray = iLogger.getLogEventListeners();
        int n = 0;
        while (n < logEventListenerArray.length) {
            if (logEventListenerArray[n] instanceof FileHandler && logEventListenerArray[n].getDescription().equals(HANDLER_TAG)) {
                iLogger.removeLogEventListener(logEventListenerArray[n]);
                FileHandler fileHandler = (FileHandler)logEventListenerArray[n];
                fileHandler.close();
                handlerPool.returnLogComponent((LogComponent)fileHandler);
            }
            ++n;
        }
        loggerPool.returnLogComponent((LogComponent)iLogger);
    }
}

