/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.internal.server.device;

import java.io.File;
import java.io.FileInputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.dbconnparms.ConfigService;
import org.eclipse.aperi.sanmgmt.middleware.DeviceServiceManager;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class DeviceServerActivator
implements BundleActivator,
ServiceListener {
    private static BundleContext _bundleContext = null;
    public static ServiceHelper _serviceHelper;
    protected ServiceRegistration cServiceManagerRegistration;
    protected ServiceRegistration cConfigServiceRegistration;
    protected ConfigService cConfigService = null;

    public synchronized void start(BundleContext bundleContext) throws Exception {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        _bundleContext = bundleContext;
        _bundleContext.addServiceListener((ServiceListener)this);
        _serviceHelper = new ServiceHelper(_bundleContext);
        this.initializeDBPoolConnection();
        String[] stringArray = new String[2];
        try {
            clazz3 = Class.forName("org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[0] = clazz3.getName();
        try {
            clazz2 = Class.forName("org.eclipse.aperi.sanmgmt.middleware.interfaces.IService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray[1] = clazz2.getName();
        String[] stringArray2 = stringArray;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ((Dictionary)hashtable).put("org.eclipse.aperi.webservice.name", "ConfigService");
        this.cConfigService = new ConfigService();
        this.cConfigService.startup();
        this.cConfigServiceRegistration = _bundleContext.registerService(stringArray2, (Object)this.cConfigService, hashtable);
        String[] stringArray3 = new String[1];
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.middleware.interfaces.IDeviceServiceManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        stringArray3[0] = clazz.getName();
        String[] stringArray4 = stringArray3;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        ((Dictionary)hashtable2).put("org.eclipse.aperi.webservice.name", "DeviceServiceManager");
        DeviceServiceManager.getInstance().startup();
        this.cServiceManagerRegistration = bundleContext.registerService(stringArray4, (Object)DeviceServiceManager.getInstance(), hashtable2);
    }

    public synchronized void stop(BundleContext bundleContext) throws Exception {
        if (this.cServiceManagerRegistration != null) {
            this.cServiceManagerRegistration.unregister();
        }
        DeviceServiceManager.getInstance().shutdown();
        if (this.cConfigServiceRegistration != null) {
            this.cConfigServiceRegistration.unregister();
        }
        if (this.cConfigService != null) {
            this.cConfigService.shutdown();
            this.cConfigService = null;
        }
        _serviceHelper.dispose();
        _serviceHelper = null;
        _bundleContext.removeServiceListener((ServiceListener)this);
        _bundleContext = null;
    }

    public synchronized void serviceChanged(ServiceEvent serviceEvent) {
        if (_bundleContext != null) {
            ServiceReference serviceReference = serviceEvent.getServiceReference();
            _bundleContext.getService(serviceReference);
        }
    }

    public static BundleContext getContext() {
        return _bundleContext;
    }

    public void initializeDBPoolConnection() {
        try {
            String string = Variables.getConfigurationDirectory();
            String string2 = String.valueOf(string) + File.separator + "setup.properties";
            if (new File(string2).exists()) {
                FileInputStream fileInputStream = new FileInputStream(string2);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                String string3 = properties.getProperty("tsnm.type");
                if ("manager".equals(string3)) {
                    this.testDBConnection();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean testDBConnection() {
        DBConnection dBConnection;
        block13: {
            int n;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            block12: {
                String string6 = String.valueOf(Variables.getConfigurationDirectory()) + File.separator + "tsnmdbparms.properties";
                FileInputStream fileInputStream = new FileInputStream(string6);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                string5 = properties.getProperty("tivoli.sanmgmt.jdbc.dbDriver");
                string4 = properties.getProperty("tivoli.sanmgmt.jdbc.dbURL");
                string3 = properties.getProperty("tivoli.sanmgmt.jdbc.dbSchema");
                string2 = properties.getProperty("tivoli.sanmgmt.jdbc.dbUser");
                string = properties.getProperty("tivoli.sanmgmt.jdbc.dbPassword");
                int n2 = Integer.parseInt(properties.getProperty("tivoli.sanmgmt.jdbc.conpool.min", "1"));
                n = Integer.parseInt(properties.getProperty("tivoli.sanmgmt.jdbc.conpool.max", "10"));
                if (string5 != null && string4 != null && string3 != null && string2 != null && string != null) break block12;
                System.err.println("Incomplete database connection properties");
                System.err.println("Driver = " + string5 + "\n" + "URL = " + string4 + "\n" + "Schema = " + string3 + "\n" + "User = " + string2 + "\n" + "Password = " + string + "\n" + "Pool Min = " + n2 + "\n" + "Pool Max = " + n + "\n");
                return false;
            }
            try {
                string = SRMCrypto.decrypt((String)string);
                DBConnPoolDataSource.initialize((String)string5, (String)string4, (String)string3, (String)string2, (String)string, (int)n);
                DBConnPoolDataSource dBConnPoolDataSource = DBConnPoolDataSource.getInstance();
                dBConnection = null;
                int n3 = 0;
                while (n3 < 60) {
                    try {
                        dBConnection = (DBConnection)dBConnPoolDataSource.getPooledConnection();
                        break;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        if (n3 < 59) {
                            System.err.println("Connection failed ... waiting for 30 seconds to retry");
                            try {
                                Thread.sleep(30000L);
                            }
                            catch (Exception exception2) {}
                        }
                        ++n3;
                    }
                }
                if (dBConnection != null) break block13;
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        try {
            dBConnection.close();
        }
        catch (Exception exception) {}
        return true;
    }
}

