/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.fabric;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TopicSubscriber;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.api.SRMVersion;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.control.ControlRouter;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.control.interfaces.LockedException;
import org.eclipse.aperi.control.interfaces.NotAvailableException;
import org.eclipse.aperi.control.interfaces.fabric.IZoneControl;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.RemoveMissingProcessor;
import org.eclipse.aperi.discovery.snmp.scanner.SNMPConfig;
import org.eclipse.aperi.discovery.snmp.scanner.SensorEventScanner;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ParameterChecker;
import org.eclipse.aperi.fabric.DiscoverMonitor;
import org.eclipse.aperi.fabric.FabricActivator;
import org.eclipse.aperi.fabric.FabricMsgConsts;
import org.eclipse.aperi.fabric.api.DataAgent;
import org.eclipse.aperi.fabric.api.DataPath;
import org.eclipse.aperi.fabric.api.DeviceAgent;
import org.eclipse.aperi.fabric.api.FabricManagerConstants;
import org.eclipse.aperi.fabric.api.FabricScanner;
import org.eclipse.aperi.fabric.api.FabricVersion;
import org.eclipse.aperi.fabric.api.SNMPAgent;
import org.eclipse.aperi.fabric.api.TransactionExpiredException;
import org.eclipse.aperi.fabric.api.TransactionInProgressException;
import org.eclipse.aperi.fabric.discovery.Discover;
import org.eclipse.aperi.fabric.interfaces.IFabricInternalService;
import org.eclipse.aperi.fabric.interfaces.InvalidTokenException;
import org.eclipse.aperi.fabric.interfaces.JobInProgressException;
import org.eclipse.aperi.fabric.interfaces.ResourceLockedException;
import org.eclipse.aperi.fabric.interfaces.ResourceNotAvailableException;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.IpTarget;
import org.eclipse.aperi.infrastructure.database.objects.Scanner;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.monitor.eventcorrelator.data.AgentEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMOMEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.DiskMgrAgentEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.ExternalEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.IPTargetEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.InbandEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SNMPTrapEvent;
import org.eclipse.aperi.monitor.eventcorrelator.data.SRMEvent;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.MessagingService.jms.MSObjectMessage;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.sanmgmt.middleware.messaging.Factory;
import org.eclipse.aperi.sanmgmt.middleware.messaging.FactoryFactory;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmpagent.manager.interfaces.ISNMPAgentManager;
import org.eclipse.aperi.util.SRMCrypto;
import org.sblim.wbem.cim.CIMObjectPath;

public class FabricManagerService
implements IService,
IFabricInternalService,
ICliDispatcher,
MessageListener {
    public static Status status;
    private static IDiscover discoverServiceProxy;
    private static ISNMPAgentManager SNMPAgentManagerProxy;
    private static IZoneControl zoneControllerProxy;
    static final String TRACE_NAME = "aperi.logger.trace.FabricManager";
    static final String MESSAGE_NAME = "aperi.logger.message.FabricManager";
    static final String MSG_FILE;
    private static ILogger msgLogger;
    private static ILogger traceLogger;
    static final String className;
    private static Factory factory;
    private static TopicSubscriber agentEventSubscriber;
    private static TopicSubscriber externalEventSubscriber;
    private static Hashtable reservedTokens;

    static {
        Class<?> clazz;
        status = new Status(5, 6);
        discoverServiceProxy = null;
        SNMPAgentManagerProxy = null;
        zoneControllerProxy = null;
        MSG_FILE = FabricManagerConstants.MSG_FILE;
        msgLogger = null;
        traceLogger = null;
        try {
            clazz = Class.forName("org.eclipse.aperi.fabric.FabricManagerService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        factory = null;
        reservedTokens = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FabricManagerService() {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"FabricManagerService", null);
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.FabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            logTraceHelper.objectCreation(clazz.getName());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit(null);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit(null);
    }

    public String getDescription() {
        return "Service that performs fabric management functions";
    }

    public String getName() {
        return "FabricManagerService";
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("FabricManagerService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return resourceBundle.getString("FabricManagerService_Description");
    }

    public Status getStatus() {
        return status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public boolean startup() {
        block10: {
            String string = "startup";
            status.setRunStatus(9);
            try {
                Class<?> clazz;
                if (factory == null) {
                    factory = FactoryFactory.createFactory((int)2, null);
                }
                if (agentEventSubscriber == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.AgentEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    agentEventSubscriber = factory.createSubscriber(clazz2.getName(), null, null, (MessageListener)this);
                }
                if (externalEventSubscriber != null) break block10;
                try {
                    clazz = Class.forName("org.eclipse.aperi.monitor.eventcorrelator.data.ExternalEvent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                externalEventSubscriber = factory.createSubscriber(clazz.getName(), null, null, (MessageListener)this);
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Exception while subscribing to events");
                }
                if (traceLogger == null || !traceLogger.isLogging()) break block10;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        status.setRunStatus(8);
        return true;
    }

    public void onMessage(Message message) {
        String string;
        block18: {
            string = "onMessage";
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
            }
            ObjectMessage objectMessage = (ObjectMessage)message;
            try {
                SRMEvent sRMEvent = (SRMEvent)objectMessage.getObject();
                if (sRMEvent instanceof AgentEvent) {
                    if (sRMEvent instanceof IPTargetEvent) {
                        IPTargetEvent iPTargetEvent = (IPTargetEvent)sRMEvent;
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Received an IPTargetEvent " + iPTargetEvent.toString());
                        }
                        String string2 = iPTargetEvent.geAddress();
                        String[] stringArray = new String[]{string2};
                        int[] nArray = new int[]{FabricManagerConstants.SNMPType};
                        AsyncResult asyncResult = this.discoverFabrics(stringArray, nArray);
                        DiscoverMonitor.getDiscoverMonitor().monitor(asyncResult.getJobId());
                    } else if (sRMEvent instanceof DiskMgrAgentEvent) {
                        DiskMgrAgentEvent diskMgrAgentEvent = (DiskMgrAgentEvent)sRMEvent;
                        AsyncResult asyncResult = this.discoverFabrics(new String[]{diskMgrAgentEvent.getGUID()}, new int[]{FabricManagerConstants.deviceServerType});
                        DiscoverMonitor.getDiscoverMonitor().monitor(asyncResult.getJobId());
                    } else {
                        boolean cfr_ignored_0 = sRMEvent instanceof CIMOMEvent;
                    }
                } else if (sRMEvent instanceof ExternalEvent) {
                    if (sRMEvent instanceof SNMPTrapEvent || sRMEvent instanceof InbandEvent) {
                        if (traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, string, "Received an SNMPTrapEvent or InbandEvent " + sRMEvent.toString() + " from " + ((ExternalEvent)sRMEvent).getSource() + " of type " + ((ExternalEvent)sRMEvent).getType());
                        }
                        String string3 = ((ExternalEvent)sRMEvent).getSource();
                        String[] stringArray = null;
                        if (string3 != null) {
                            stringArray = FabricDbAccess.getFabricsForIPAddress((String)string3);
                        }
                        if (stringArray != null && stringArray.length > 0) {
                            AsyncResult asyncResult = this.probeFabrics(stringArray);
                            DiscoverMonitor.getDiscoverMonitor().monitor(asyncResult.getJobId());
                        } else {
                            AsyncResult asyncResult = this.discoverFabrics(null, null);
                            DiscoverMonitor.getDiscoverMonitor().monitor(asyncResult.getJobId());
                        }
                    } else {
                        boolean cfr_ignored_1 = sRMEvent instanceof CIMIndicationEvent;
                    }
                }
            }
            catch (Exception exception) {
                if (!traceLogger.isLogging()) break block18;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shutdown() {
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, "shutdown");
        }
        status.setRunStatus(11);
        try {
            try {
                agentEventSubscriber.close();
                externalEventSubscriber.close();
                factory.close();
                DiscoverMonitor.getDiscoverMonitor().shutdown();
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "shutdown", (Throwable)exception);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, "shutdown", "Exception while closing subscribers");
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "shutdown", (Throwable)exception);
                }
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            status.setRunStatus(10);
            if (traceLogger == null) throw throwable;
            if (!traceLogger.isLogging()) throw throwable;
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "shutdown");
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        status.setRunStatus(10);
        if (traceLogger == null) return true;
        if (!traceLogger.isLogging()) return true;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, "shutdown");
        return true;
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put("getFabrics", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getFabricAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getComputers", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getComputerAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getPortsForComputer", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getSwitches", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getSwitchAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getPortsForSwitch", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getPortAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getZoneSets", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getZones", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("verifyZoneSet", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("verifyZone", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getPortsInZone", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getZoneMembers", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getZoneMembersInZoneAlias", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getComputerToSubsystemDataPaths", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getComputerExtAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getComputerInFabric", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getComputerToSwitch", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getHBAsForComputer", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getNodeNameFromID", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getSubsystemInFabric", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getSubsystemToSwitch", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getZoneAliases", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getZoneAliasAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getZoneAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getZoneSetAttributes", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("hasNeverComputerId", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("createZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("createZone", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("createZoneAlias", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("addZoneToZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("addZoneMembersToZone", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("addZoneMembersToZoneAlias", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("removeZoneFromZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("removeZoneMembersFromZone", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("removeZoneMembersFromZoneAlias", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("removePortsFromZone", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("deleteZone", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("deleteZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("deleteZoneAlias", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("activateZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("deactivateZoneSet", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("discoverSNMPAgents", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("addSNMPAgents", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("deleteSNMPAgents", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("getSNMPAgents", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getSNMPAgentIDs", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("modifySNMPAgents", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("testSNMPAgentConnection", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("getDeviceServerAgents", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("discoverCIMOMs", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("addCIMOMs", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("deleteCIMOMs", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("getCIMOMs", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getCIMOMIDs", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("modifyCIMOMs", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("testCIMOMConnection", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("dispatch", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("cancelJob", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("deleteMissingDevices", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("discoverDevicesFromCIMOM", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("discoverFabrics", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("getAPIVersion", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getDescription", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getDiscoverMonitor", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getDiscoverServiceProxy", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getJobStatus", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getLocalizedDescription", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getLocalizedName", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getLog", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getName", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getPortsConnectedTo", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getSNMPAgentIds", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getSNMPAgentManagerProxy", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getScannersForAgent", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getStatus", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getVersion", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("getZoneControllerProxy", new Integer(RoleChecker.FABRIC_VIEWER));
        hashtable.put("monitor", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("onMessage", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("probeFabrics", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("probeSwitchSensorAndEventData", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("startTransaction", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("commitTransaction", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("rollbackTransaction", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("release", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("reserve", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("setZoneInfo", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("testBrocadeAgentUserPassword", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("testZoneControlCapabilities", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("waitForJobToComplete", new Integer(RoleChecker.FABRIC_ADMIN));
        hashtable.put("readCurrentZoneDefinition ", new Integer(RoleChecker.FABRIC_ADMIN));
        return hashtable;
    }

    public String dispatch(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.equals("getFabrics")) {
            try {
                String[] stringArray2 = this.getFabrics(new HashMap());
                int n = 0;
                while (n < stringArray2.length) {
                    stringBuffer.append(String.valueOf(stringArray2[n]) + "\n");
                    ++n;
                }
            }
            catch (Exception exception) {
                stringBuffer.append(exception);
                exception.printStackTrace();
            }
        } else if (string.equals("getSwitches")) {
            if (stringArray.length < 1) {
                stringBuffer.append("Missing parameter - need to specify the fabric");
            } else {
                try {
                    String[] stringArray3 = this.getSwitches(stringArray[0], new HashMap());
                    int n = 0;
                    while (n < stringArray3.length) {
                        stringBuffer.append(String.valueOf(stringArray3[n]) + "\n");
                        ++n;
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else if (string.equals("getPortsForSwitch")) {
            if (stringArray.length < 1) {
                stringBuffer.append("Missing parameter - need to specify the switch");
            } else {
                try {
                    String[] stringArray4 = this.getPortsForSwitch(stringArray[0], new HashMap());
                    int n = 0;
                    while (n < stringArray4.length) {
                        stringBuffer.append(String.valueOf(stringArray4[n]) + "\n");
                        ++n;
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else if (string.equals("getComputerToSubsystemDataPath")) {
            if (stringArray.length < 2) {
                stringBuffer.append("Missing parameter - need to specify the computer name and subsystem name");
            } else {
                try {
                    DataPath[] dataPathArray = this.getComputerToSubsystemDataPaths(stringArray[0], stringArray[1]);
                    int n = 0;
                    while (n < dataPathArray.length) {
                        stringBuffer.append("CP " + dataPathArray[n].getComputerPortWWN() + " to SP " + dataPathArray[n].getSubsystemPortWWN() + " through Fabric " + dataPathArray[n].getFabricWWN() + ".\n");
                        ++n;
                    }
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else if (string.equals("addAgent")) {
            if (stringArray.length < 5) {
                stringBuffer.append("Missing parameter - need to specify the IP address, dns name, community name, userid, password");
            } else {
                try {
                    SNMPAgent[] sNMPAgentArray = new SNMPAgent[]{new SNMPAgent(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4])};
                    this.addSNMPAgents(sNMPAgentArray);
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else if (string.equals("deleteAgent")) {
            if (stringArray.length < 1) {
                stringBuffer.append("Missing parameter - need to specify the IP address");
            } else {
                try {
                    this.deleteSNMPAgents(stringArray);
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else if (string.equals("discoverFabric")) {
            if (stringArray.length < 1) {
                stringBuffer.append("Missing parameter - need to specify the agent address");
            } else {
                try {
                    this.discoverFabrics(stringArray, null);
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else if (string.equals("probeFabric")) {
            if (stringArray.length < 1) {
                stringBuffer.append("Missing parameter - need to specify the fabric WWN");
            } else {
                try {
                    this.probeFabrics(stringArray);
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else if (string.equals("addCIMOM")) {
            if (stringArray.length < 4) {
                stringBuffer.append("Missing parameter - need to specify the URL, namespace, userid and password.");
            } else {
                try {
                    CIMOM cIMOM = new CIMOM();
                    cIMOM.setServiceUrl(stringArray[0]);
                    cIMOM.setInteropSchemaNamespace(stringArray[1]);
                    cIMOM.setUserId(stringArray[2]);
                    cIMOM.setPassword(stringArray[3]);
                    this.addCIMOMs(new CIMOM[]{cIMOM});
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else if (string.equals("discoverFabricViaSMIS")) {
            if (stringArray.length < 1) {
                stringBuffer.append("Missing parameter - need to specify the agent address");
            } else {
                try {
                    this.discoverFabrics(stringArray, new int[]{FabricManagerConstants.CIMType});
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else if (string.equals("generateEvent")) {
            if (stringArray.length < 2) {
                stringBuffer.append("Missing parameter - need to specify the IP of event source and type");
            } else {
                try {
                    this.onMessage((Message)new MSObjectMessage((Serializable)new SNMPTrapEvent(stringArray[0], stringArray[1], new SnmpTrap())));
                }
                catch (Exception exception) {
                    stringBuffer.append(exception);
                    exception.printStackTrace();
                }
            }
        } else {
            stringBuffer.append("\nFormat is:\ngetFabrics\ngetSwitches <Fabric>\ngetPortsForSwitch <Switch>\n");
        }
        return stringBuffer.toString();
    }

    public SRMVersion getAPIVersion() {
        return new FabricVersion();
    }

    public AsyncResult getJobStatus(String string) {
        return ServiceUtils.getJobStatus((String)string);
    }

    public AsyncResult waitForJobToComplete(String string) {
        return DiscoverUtils.waitForJobToComplete((String)string);
    }

    public void cancelJob(String string) {
        DiscoverUtils.cancelJob((String)string);
    }

    /*
     * Exception decompiling
     */
    public ReadLogResponse getLog(String var1_1, byte var2_2, LogFilePos var3_3, int var4_4) throws ServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 123->126)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ReadLogResponse getLog(String var1_1, byte var2_2, LogFilePos var3_3, String var4_4, int var5_5) throws ServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 125->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ReadLogResponse getLog(int var1_1, String var2_2, byte var3_3, LogFilePos var4_4, int var5_5) throws ServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 125->128)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public ReadLogResponse getLog(int var1_1, String var2_2, byte var3_3, LogFilePos var4_4, String var5_5, int var6_6) throws ServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 127->130)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public AsyncResult discoverSNMPAgents(String[] var1_1, String var2_2, String var3_3, String var4_4) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 246->249)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] addSNMPAgents(SNMPAgent[] var1_1) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 269->272)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteSNMPAgents(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        String string = "deleteSNMPAgents";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        DBConnection dBConnection = ServiceUtils.getConnection();
        IpTarget ipTarget = new IpTarget();
        new Scanner();
        Object[] objectArray = new String[]{""};
        boolean bl = false;
        this.checkMandatoryParam(stringArray, "SNMPAgent", 1, string);
        try {
            try {
                int n = 0;
                while (true) {
                    block13: {
                        if (n < stringArray.length) break block13;
                        dBConnection.commit();
                        break;
                    }
                    ipTarget.clear();
                    ipTarget.setIpAddress(stringArray[n]);
                    if (ipTarget.delete(dBConnection) != 1) {
                        ipTarget.clear();
                        String string2 = InetAddress.getByName(stringArray[n]).getHostAddress();
                        ipTarget.setIpAddress(string2);
                        if (ipTarget.delete(dBConnection) != 1) {
                            objectArray[0] = stringArray[n];
                            bl = true;
                            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.AGENT_NOT_FOUND, objectArray);
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, string, (Throwable)exception);
                String[] stringArray2 = new String[]{string};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray2));
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, string, (Throwable)exception);
                String[] stringArray3 = new String[]{string};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray3));
            }
        }
        {
            Object var9_13 = null;
        }
        try {}
        catch (Exception exception) {
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)this, string, (Throwable)exception);
            String[] stringArray4 = new String[]{string};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray4));
        }
        if (dBConnection != null) {
            dBConnection.close();
        }
        this.discoverFabrics(null, new int[]{FabricManagerConstants.ScannerProcessMissing});
        if (!bl) return;
        throw new ServerException(new SRMMessage(FabricMsgConsts.AGENT_NOT_FOUND, (String[])objectArray));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SNMPAgent[] getSNMPAgents() throws ServerException {
        String string = "getSNMPAgents";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        ArrayList<SNMPAgent> arrayList = new ArrayList<SNMPAgent>();
        DBConnection dBConnection = ServiceUtils.getConnection();
        IpTarget.IpTargetCursor ipTargetCursor = null;
        try {
            try {
                ipTargetCursor = IpTarget.getCursor((DBConnection)dBConnection, null, null);
                while (true) {
                    block13: {
                        if (ipTargetCursor.next()) break block13;
                        dBConnection.commit();
                        break;
                    }
                    IpTarget ipTarget = ipTargetCursor.getObject();
                    arrayList.add(new SNMPAgent(ipTarget.getIpAddress(), ipTarget.getHostName(), ipTarget.getReadCommunityName(), ipTarget.getRwCommunityName(), ipTarget.getUserId(), ipTarget.getPassword()));
                }
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
                }
                String[] stringArray = new String[]{string};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray));
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (ipTargetCursor != null) {
                    ipTargetCursor.close();
                }
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            }
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        try {}
        catch (Exception exception) {
            if (!traceLogger.isLogging()) return arrayList.toArray(new SNMPAgent[0]);
            traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            return arrayList.toArray(new SNMPAgent[0]);
        }
        if (ipTargetCursor != null) {
            ipTargetCursor.close();
        }
        if (dBConnection == null) return arrayList.toArray(new SNMPAgent[0]);
        dBConnection.close();
        return arrayList.toArray(new SNMPAgent[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getSNMPAgentIds() throws ServerException {
        block16: {
            var1_1 = "getSNMPAgents";
            if (FabricManagerService.traceLogger != null && FabricManagerService.traceLogger.isLogging()) {
                FabricManagerService.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)FabricManagerService.className, var1_1);
            }
            var2_2 = new ArrayList<String>();
            var3_3 = ServiceUtils.getConnection();
            var4_4 = null;
            try {
                try {
                    var4_4 = IpTarget.getCursor((DBConnection)var3_3, null, null);
                    while (true) {
                        block17: {
                            if (var4_4.next()) break block17;
                            var3_3.commit();
                            break;
                        }
                        var2_2.add(var4_4.getObject().getIpAddress());
                    }
                }
                catch (Exception var5_5) {
                    if (FabricManagerService.traceLogger.isLogging()) {
                        FabricManagerService.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)FabricManagerService.className, var1_1, (Throwable)var5_5);
                    }
                    var6_6 = new String[]{var1_1};
                    throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, var6_6));
                }
            }
            catch (Throwable var8_7) {
                block15: {
                    var7_8 = null;
                    try {
                        if (var4_4 != null) {
                            var4_4.close();
                        }
                        if (var3_3 != null) {
                            var3_3.close();
                        }
                    }
                    catch (Exception var9_10) {
                        if (!FabricManagerService.traceLogger.isLogging()) break block15;
                        FabricManagerService.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)FabricManagerService.className, var1_1, (Throwable)var9_10);
                    }
                }
                if (FabricManagerService.traceLogger == null) throw var8_7;
                if (FabricManagerService.traceLogger.isLogging() == false) throw var8_7;
                FabricManagerService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)FabricManagerService.className, var1_1);
                throw var8_7;
            }
            {
                var7_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 160->181)] { 
lbl42:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
            }
            if (var3_3 != null) {
                var3_3.close();
            }
            break block16;
lbl47:
            // 1 sources

            catch (Exception var9_11) {
                if (!FabricManagerService.traceLogger.isLogging()) break block16;
                FabricManagerService.traceLogger.exception(IRecordType.TYPE_ERROR, (Object)FabricManagerService.className, var1_1, (Throwable)var9_11);
            }
        }
        if (FabricManagerService.traceLogger == null) return var2_2.toArray(new String[0]);
        if (FabricManagerService.traceLogger.isLogging() == false) return var2_2.toArray(new String[0]);
        FabricManagerService.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)FabricManagerService.className, var1_1);
        return var2_2.toArray(new String[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifySNMPAgents(SNMPAgent[] sNMPAgentArray) throws ServerException, InvalidParameterException, MissingParameterException {
        String string = "modifySNMPAgents";
        this.checkMandatoryParam(sNMPAgentArray, "SNMPAgent", 1, string);
        DBConnection dBConnection = ServiceUtils.getConnection();
        IpTarget ipTarget = new IpTarget();
        try {
            try {
                String string2 = null;
                int n = 0;
                while (true) {
                    SNMPConfig sNMPConfig;
                    block13: {
                        if (n < sNMPAgentArray.length) break block13;
                        dBConnection.commit();
                        break;
                    }
                    ipTarget.clear();
                    ipTarget.setHostName(sNMPAgentArray[n].getDnsName());
                    ipTarget.setIpAddress(sNMPAgentArray[n].getIpAddress());
                    ipTarget.setUserId(sNMPAgentArray[n].getUserName());
                    string2 = sNMPAgentArray[n].getPassword();
                    if (string2 != null) {
                        string2 = SRMCrypto.encrypt((String)string2);
                    }
                    ipTarget.setPassword(string2);
                    sNMPAgentArray[n] = this.checkSNMPAgentCommunity(sNMPAgentArray[n]);
                    ipTarget.setReadCommunityName(sNMPAgentArray[n].getCommunityName());
                    ipTarget.setRwCommunityName(sNMPAgentArray[n].getRWCommunityName());
                    if (ipTarget.update(dBConnection) != 1) {
                        System.out.println("Error updating " + sNMPAgentArray[n].getIpAddress());
                    }
                    if ((sNMPConfig = (SNMPConfig)SnmpV1API.getConfig()) != null) {
                        sNMPConfig.setSnmpCommunityName(sNMPAgentArray[n].getIpAddress(), sNMPAgentArray[n].getCommunityName());
                        sNMPConfig.setSnmpWriteCommunityName(sNMPAgentArray[n].getIpAddress(), sNMPAgentArray[n].getRWCommunityName());
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
                }
                String[] stringArray = new String[]{string};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray));
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                if (dBConnection == null) throw throwable;
                dBConnection.close();
                throw throwable;
            }
            catch (Exception exception) {
                if (!traceLogger.isLogging()) throw throwable;
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            }
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        try {}
        catch (Exception exception) {
            if (!traceLogger.isLogging()) return;
            traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            return;
        }
        if (dBConnection == null) return;
        dBConnection.close();
    }

    /*
     * Exception decompiling
     */
    public int[] testSNMPAgentConnection(SNMPAgent[] var1_1) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 279->282)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public DeviceAgent[] getDeviceServerAgents() throws RemoteException, ServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 184->187)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public DataAgent[] getDataServerAgents() throws RemoteException, ServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 184->187)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public FabricScanner[] getScannersForAgent(String var1_1) throws RemoteException, ServerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 209->212)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SNMPAgent checkSNMPAgentCommunity(SNMPAgent sNMPAgent) {
        if (sNMPAgent.getCommunityName() == null || sNMPAgent.getCommunityName().trim().length() == 0) {
            sNMPAgent.setCommunityName("public");
        }
        if (sNMPAgent.getRWCommunityName() == null || sNMPAgent.getRWCommunityName().trim().length() == 0) {
            sNMPAgent.setRWCommunityName("private");
        }
        return sNMPAgent;
    }

    private void checkIP(String string) throws InvalidParameterException {
        boolean bl = false;
        bl = string == null ? false : (string.trim().length() == 0 ? false : this.isIPFormatValid(string));
        if (!bl) {
            String[] stringArray = new String[]{string};
            SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.INVALID_PARAMETER, stringArray);
            throw new InvalidParameterException(1, sRMMessage);
        }
    }

    private boolean isIPFormatValid(String string) {
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            String[] stringArray = new String[4];
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while ((n2 = string.indexOf(46, n2)) != -1 && n < 4) {
                stringArray[n++] = string.substring(n3, n2);
                n3 = ++n2;
            }
            if (n == 3) {
                stringArray[n] = string.substring(n3);
                bl = true;
                while (n >= 0) {
                    block7: {
                        try {
                            if (Integer.parseInt(stringArray[n]) < 0 || Integer.parseInt(stringArray[n]) > 255) {
                                bl = false;
                            }
                            break block7;
                        }
                        catch (NumberFormatException numberFormatException) {
                            bl = false;
                        }
                        break;
                    }
                    --n;
                }
            }
        }
        return bl;
    }

    public Result probeSwitchSensorAndEventData(String string) throws ServerException, InvalidParameterException, MissingParameterException {
        String string2 = "probeSwitchSensorAndEventData";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        Result result = new Result();
        Object[] objectArray = new String[2];
        new Hashtable();
        if (string == null) {
            objectArray[0] = "switchId";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.MISSING_PARAM, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Parameter error.  Missing a switch Id.");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
        String[] stringArray = new String[1];
        String string3 = null;
        String[] stringArray2 = new String[]{string};
        String[] stringArray3 = new String[]{"IP_ADDRESS"};
        try {
            stringArray[0] = string3 = (String)FabricDbAccess.getSwitchAttributes((String[])stringArray2, (String[])stringArray3)[0].get("IP_ADDRESS");
        }
        catch (Exception exception) {
            objectArray[0] = "dbAccessor.getSwitchAttributes";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Error getting IP addresss for the switch id.");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        try {
            SensorEventScanner sensorEventScanner = new SensorEventScanner();
            Object[] objectArray2 = new Object[1];
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Calling SensorEventScanner with IP = " + stringArray[0]);
            }
            objectArray2[0] = sensorEventScanner.invoke("Sensor Event Scanner", stringArray).getData();
            result.setResults(objectArray2);
            result.setRc(0);
        }
        catch (Exception exception) {
            objectArray[0] = "sensorEventScanner.invoke";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Error getting Sensor and Event data for IP addresss." + stringArray[0]);
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return result;
    }

    public AsyncResult discoverFabrics(String[] stringArray, int[] nArray) throws ServerException, InvalidParameterException {
        int n;
        String string = "discoverFabrics";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        String[] cfr_ignored_0 = new String[2];
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                arrayList.add(stringArray[n]);
                ++n;
            }
        }
        if (nArray != null) {
            n = 0;
            while (n < nArray.length) {
                arrayList2.add(new Integer(nArray[n]));
                ++n;
            }
        }
        Hashtable<String, ArrayList<Object>> hashtable = new Hashtable<String, ArrayList<Object>>();
        hashtable.put("AGENTS", arrayList);
        hashtable.put("AGENT_TYPES", arrayList2);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Attempting discover of agents.");
        }
        String string2 = FabricManagerService.getDiscoverServiceProxy().discover(Discover.probeFabricAgents, hashtable);
        AsyncResult asyncResult = FabricManagerService.getDiscoverServiceProxy().getJobStatus(string2);
        String string3 = DiskMessageHelper.toMsgString((Object)new Object[]{stringArray, nArray});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string, (String)string3, (AsyncResult)asyncResult);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string, (Object)asyncResult);
        }
        return asyncResult;
    }

    public AsyncResult probeFabrics(String[] stringArray) throws ServerException, InvalidParameterException {
        String string;
        String string2 = "probeFabrics";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        AsyncResult asyncResult = null;
        Object[] objectArray = new String[2];
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        hashtable.put("FABRICS", stringArray);
        try {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Attempting probe Fabric with Id = " + stringArray);
            }
            string = FabricManagerService.getDiscoverServiceProxy().discover("ProbeFabrics", hashtable);
            asyncResult = FabricManagerService.getDiscoverServiceProxy().getJobStatus(string);
        }
        catch (Exception exception) {
            objectArray[0] = "ProbeFabrics";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Error during discover(ProbeFabrics) on fabric " + stringArray + ".");
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        string = DiskMessageHelper.toMsgString((Object)new Object[]{stringArray});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string2, (String)string, (AsyncResult)asyncResult);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return asyncResult;
    }

    public static IDiscover getDiscoverServiceProxy() {
        if (discoverServiceProxy == null) {
            discoverServiceProxy = (IDiscover)FabricActivator._serviceHelper.bindLocal("DiscoverService");
        }
        return discoverServiceProxy;
    }

    public static ISNMPAgentManager getSNMPAgentManagerProxy() {
        if (SNMPAgentManagerProxy == null) {
            SNMPAgentManagerProxy = (ISNMPAgentManager)FabricActivator._serviceHelper.bindLocal("SNMPAgentManager");
        }
        return SNMPAgentManagerProxy;
    }

    /*
     * Exception decompiling
     */
    public String[] getFabrics(HashMap var1_1) throws ServerException, InvalidParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 144->147)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public HashMap[] getFabricAttributes(String[] var1_1, String[] var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 166->169)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getComputers(HashMap var1_1) throws ServerException, InvalidParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 144->147)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public HashMap[] getComputerAttributes(String[] var1_1, String[] var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 166->169)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getPortsForComputer(String var1_1, HashMap var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 185->188)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getSwitches(String var1_1, HashMap var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 185->188)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public HashMap[] getSwitchAttributes(String[] var1_1, String[] var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 184->187)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getPortsForSwitch(String var1_1, HashMap var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 185->188)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public HashMap[] getPortAttributes(String[] var1_1, String[] var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 199->202)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getZoneSets(String var1_1, boolean var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 146->149)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getZones(String var1_1, String var2_2, boolean var3_3) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 205->208)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getPortsInZone(String var1_1, String var2_2, boolean var3_3) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 148->151)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public HashMap[] getZoneMembers(String var1_1, String var2_2, boolean var3_3) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 148->151)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public HashMap[] getZoneMembersInZoneAlias(String var1_1, String var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 193->196)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getZoneAliases(String var1_1, String var2_2, boolean var3_3) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 205->208)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public HashMap[] getZoneAliasAttributes(String var1_1, String[] var2_2, String[] var3_3) throws RemoteException, ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 252->255)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public HashMap[] getZoneAttributes(String var1_1, String[] var2_2, boolean var3_3, String[] var4_4) throws RemoteException, ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 258->261)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public HashMap[] getZoneSetAttributes(String var1_1, String[] var2_2, boolean var3_3, String[] var4_4) throws RemoteException, ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 258->261)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean verifyZoneSet(String var1_1, String var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 153->156)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean verifyZone(String var1_1, String var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 153->156)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public DataPath[] getComputerToSubsystemDataPaths(String var1_1, String var2_2) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 184->187)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getPortsConnectedTo(String var1_1) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 110->113)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateParam(String[] stringArray, String[] stringArray2, int n, String string, String string2) throws InvalidParameterException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            arrayList.add(stringArray2[n2]);
            ++n2;
        }
        n2 = 0;
        while (n2 < stringArray.length) {
            if (!arrayList.contains(stringArray[n2])) {
                Object[] objectArray = new String[]{stringArray[n2]};
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, string, objectArray);
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Invalid parameter " + (String)objectArray[0]);
                }
                throw new InvalidParameterException(n, n2, new SRMMessage(string, (String[])objectArray));
            }
            ++n2;
        }
    }

    private void checkMandatoryParam(String string, String string2, int n, String string3) throws MissingParameterException {
        if (string == null || string.equals("")) {
            Object[] objectArray = new String[]{string2};
            if (msgLogger != null) {
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.MISSING_PARAM, objectArray);
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Missing parameter " + string2);
            }
            throw new MissingParameterException(n, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
    }

    private void checkMandatoryParam(String[] stringArray, String string, int n, String string2) throws MissingParameterException {
        if (stringArray == null || stringArray.length == 0) {
            Object[] objectArray = new String[]{string};
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.MISSING_PARAM, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Missing parameter " + string);
            }
            throw new MissingParameterException(n, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
    }

    private void checkMandatoryParam(Object[] objectArray, String string, int n, String string2) throws MissingParameterException {
        if (objectArray == null || objectArray.length == 0) {
            Object[] objectArray2 = new String[]{string};
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.MISSING_PARAM, objectArray2);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Missing parameter " + string);
            }
            throw new MissingParameterException(n, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray2));
        }
    }

    private void throwInvalidParameterException(String string, int n, String string2, String string3) throws InvalidParameterException {
        Object[] objectArray = new String[]{string};
        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, string2, objectArray);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Invalid parameter " + (String)objectArray[0]);
        }
        throw new InvalidParameterException(n, new SRMMessage(string2, (String[])objectArray));
    }

    private void throwServerException(Exception exception, String string) throws ServerException {
        Object[] objectArray = new String[]{exception.getMessage()};
        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.READ_INTERNAL_ERROR, objectArray);
        throw new ServerException(new SRMMessage(FabricMsgConsts.READ_INTERNAL_ERROR, (String[])objectArray), (Throwable)exception);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int startTransaction(String string) throws ServerException, InvalidParameterException, MissingParameterException {
        String string2 = "startTransaction";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "fabricID = " + string);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string2);
        try {
            try {
                if (!FabricDbAccess.verifyFabric((String)string)) {
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.FABRIC_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "Fabric not found with ID " + string);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(1, sRMMessage);
                }
                Token token = FabricManagerService.getZoneControllerProxy().reserve(string, "E4", className, 1, "");
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "token = " + token.toString());
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "tokenId = " + token.getTokenId());
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "jobId = " + token.getJobId());
                }
                if (reservedTokens == null) {
                    reservedTokens = new Hashtable();
                }
                reservedTokens.put(string, token);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Reserved Tokens = " + reservedTokens.toString());
                }
                n = FabricManagerService.getZoneControllerProxy().startTransaction(token);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Return Code = " + n);
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (NotAvailableException notAvailableException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.AGENT_UNAVAILABLE, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "Unable to find an Agent to zone the fabric with WWN = " + string);
                }
                throw new ServerException(new SRMMessage(FabricMsgConsts.AGENT_UNAVAILABLE, new String[]{string}));
            }
            catch (LockedException lockedException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.FABRIC_LOCKED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "The Fabric is currently locked for zone configuration by another client, fabric WWN = " + string);
                }
                throw new ServerException(new SRMMessage(FabricMsgConsts.FABRIC_LOCKED, new String[]{string}));
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "Another Transaction is currently in progress for the Fabric with Name = " + string);
                }
                throw new ServerException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "A Fabric Internal Error Occurred, " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)exception);
                }
                String[] stringArray = new String[]{string2};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray));
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            throw throwable;
        }
        {
            Object var6_12 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string2, (String)string, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AsyncResult commitTransaction(String string) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String string2 = "commitTransaction";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "fabricID = " + string);
        }
        this.checkMandatoryParam(string, "fabricID", 1, string2);
        AsyncResult asyncResult = null;
        try {
            try {
                if (!FabricDbAccess.verifyFabric((String)string)) {
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.FABRIC_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "Invalid Parameter.  Fabric not found with ID " + string);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(1, sRMMessage);
                }
                Token token = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    token = (Token)reservedTokens.get(string);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Reserved token found...");
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "token = " + token.toString());
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "tokenId = " + token.getTokenId());
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "jobId = " + token.getJobId());
                    }
                }
                if (token == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                asyncResult = FabricManagerService.getZoneControllerProxy().commitTransaction(token);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Return Code (commitTransaction) = " + asyncResult.getRc());
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Status (commitTransaction) = " + asyncResult.getStatus());
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "toString (commitTransaction) = " + asyncResult.toString());
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Token " + token.getTokenId() + "successfuly remove from list of reserved tokens.");
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)exception);
                }
                String[] stringArray = new String[]{string2};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray));
            }
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            throw throwable;
        }
        {
            Object var7_15 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string2, (String)string, (AsyncResult)asyncResult);
        return asyncResult;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int release(String string) throws ServerException, MissingParameterException {
        String string2 = "release";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "fabricID = " + string);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string2);
        this.checkFabric(string, string2);
        try {
            try {
                if (reservedTokens != null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, string2, "calling release for reserved token");
                    }
                    Token token = (Token)reservedTokens.get(string);
                    n = this.release(token);
                }
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)exception);
                }
                String[] stringArray = new String[]{string2};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string2, (String)string, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int rollbackTransaction(String string) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        String string2 = "rollbackTransaction";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
            traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, string2, string);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string2);
        this.checkFabric(string, string2);
        try {
            try {
                Token token = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    token = (Token)reservedTokens.get(string);
                }
                if (token == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().rollbackTransaction(token);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Return Code (rollbackTransaction) = " + n);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Removing token " + token.getTokenId() + "from list of reserved tokens...");
                }
                n = FabricManagerService.getZoneControllerProxy().release(token);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Return Code (releaseToken) = " + n);
                }
                reservedTokens.remove(string);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, "Token " + token.getTokenId() + "successfuly remove from list of reserved tokens.");
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string2, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)exception);
                }
                String[] stringArray = new String[]{string2};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray));
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
            }
            throw throwable;
        }
        {
            Object var7_13 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string2, (String)string, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createZoneSet(String string, String string2) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "createZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkFabric(string, string3);
        try {
            try {
                if (FabricDbAccess.verifyZoneSet((String)string, (String)string2)) {
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONESET_EXISTS, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone Set already exist with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONESET_EXISTS, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().createZoneSet((Token)object, string2);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray));
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var8_16 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createZone(String string, String string2, short s, short s2) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "createZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "fabricID = " + string);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "zoneName = " + string2);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "zoneType = " + s);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "zoneSubtype = " + s2);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneName", 2, string3);
        this.checkFabric(string, string3);
        try {
            try {
                if (FabricDbAccess.verifyZone((String)string, (String)string2)) {
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONE_EXISTS, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone already exists with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONE_EXISTS, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().createZone((Token)object, string2, s, s2);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var10_18 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2, Short.toString(s), Short.toString(s2)});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addZoneToZoneSet(String string, String string2, String string3) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string4 = "addZoneToZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string4);
        this.checkMandatoryParam(string2, "zoneSetName", 2, string4);
        this.checkMandatoryParam(string3, "zoneName", 3, string4);
        this.checkFabric(string, string4);
        try {
            try {
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string4, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().addZoneToZoneSet((Token)object, string2, string3);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string4, (Throwable)exception);
                }
                String[] stringArray = new String[]{string4};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
            }
            throw throwable;
        }
        {
            Object var9_15 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2, string3});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string4, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addZoneMembersToZone(String string, String string2, String[] stringArray, short[] sArray) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "addZoneMembersToZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "fabricID = " + string);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "zoneName = " + string2);
        }
        int n = -999;
        boolean bl = true;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneName", 2, string3);
        this.checkMandatoryParam(stringArray, "zoneMemberNames", 3, string3);
        this.checkFabric(string, string3);
        try {
            try {
                if (!FabricDbAccess.verifyZone((String)string, (String)string2)) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_WARN, (Object)className, string3, "zone  not found, but continue transaction");
                    }
                    bl = false;
                }
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Reserved token found...");
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "token = " + object.toString());
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "tokenId = " + object.getTokenId());
                    }
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                HashMap[] hashMapArray = null;
                if (bl) {
                    hashMapArray = this.getZoneMembers(string, string2, false);
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    block34: {
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "zoneMemberName = " + stringArray[n2]);
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "zoneMemberType = " + sArray[n2]);
                        }
                        if (!bl || hashMapArray != null && !this.zoneMemberExists(stringArray[n2], sArray[n2], hashMapArray)) {
                            n = FabricManagerService.getZoneControllerProxy().createZoneMemberSettingData((Token)object, sArray[n2], stringArray[n2], (short)0, string2);
                            if (traceLogger != null && traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "rc (createZoneMemberSettingData) = " + n);
                            }
                        }
                        n = FabricManagerService.getZoneControllerProxy().addZoneMemberToZone((Token)object, string2, stringArray[n2], sArray[n2]);
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "rc (addZoneMemberToZone) = " + n);
                        }
                        if (n == 0) break block34;
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Failed to add zone member " + stringArray[n2] + " to zone " + string2);
                        }
                        break;
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Zone member " + stringArray[n2] + " successfuly added to zone " + string2);
                    }
                    ++n2;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray2 = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray2), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var11_19 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2, stringArray, sArray});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    private boolean zoneMemberExists(String string, short s, HashMap[] hashMapArray) {
        String string2 = "addZoneMembersToZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        boolean bl = false;
        int n = 0;
        while (n < hashMapArray.length) {
            if (hashMapArray[n].containsKey(string)) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, string2, "Found zone member type " + string + " in database");
                }
                Integer n2 = (Integer)hashMapArray[n].get(string);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ENTRY, (Object)className, string2, "Comparing zone member type " + s + " to existing zone member type " + n2);
                }
                if (s == n2.shortValue()) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, " Found zone member " + string + " with type " + n2 + " in database");
                    }
                    bl = true;
                    break;
                }
            }
            ++n;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int addZoneMembersToZoneAlias(String string, String string2, String[] stringArray, short[] sArray) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "addZoneMembersToZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneAliasName", 2, string3);
        this.checkMandatoryParam(stringArray, "zoneMemberNames", 3, string3);
        this.checkFabric(string, string3);
        try {
            try {
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    n = FabricManagerService.getZoneControllerProxy().addZoneMemberToZoneAlias((Token)object, string2, stringArray[n2], sArray[n2]);
                    ++n2;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray2 = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray2), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var10_17 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2, stringArray, sArray});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int removeZoneFromZoneSet(String string, String string2, String string3) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string4 = "removeZoneFromZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string4);
        this.checkMandatoryParam(string, "zoneSetName", 2, string4);
        this.checkMandatoryParam(string, "zoneName", 3, string4);
        this.checkFabric(string, string4);
        try {
            try {
                if (!FabricDbAccess.verifyZoneSet((String)string, (String)string2)) {
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.ZONESET_NOT_FOUND, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "Invalid Parameter.  Zone Set not found with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONESET_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                if (!FabricDbAccess.verifyZone((String)string, (String)string3)) {
                    Object[] objectArray = new String[]{string3};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.ZONE_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging() && traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "Invalid Parameter.  Zone not found with Name = " + string3);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONE_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(3, sRMMessage);
                }
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string4, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().removeZoneFromZoneSet((Token)object, string2, string3);
                if (n == 0) {
                    n = this.checkLastZoneInZoneSet((Token)object, string, string3);
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string4, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string4, (Throwable)exception);
                }
                String[] stringArray = new String[]{string4};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
            }
            throw throwable;
        }
        {
            Object var9_19 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2, string3});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string4, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int removeZoneMembersFromZone(String string, String string2, String[] stringArray, short[] sArray) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "removeZoneMembersFromZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "fabricID = " + string);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "zoneName = " + string2);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneName", 2, string3);
        this.checkMandatoryParam(stringArray, "zoneMemberNames", 3, string3);
        this.checkFabric(string, string3);
        try {
            try {
                int n2;
                boolean bl;
                if (!FabricDbAccess.verifyZone((String)string, (String)string2)) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Zone not found... throwing InvalidParameterExcetpion");
                    }
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONE_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone not found with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONE_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                object = FabricDbAccess.getZoneMembers((String)string, (String)string2, (boolean)false);
                Token token = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    token = (Token)reservedTokens.get(string);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Reserved token found...");
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "token = " + token.toString());
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "tokenId = " + token.getTokenId());
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "jobId = " + token.getJobId());
                    }
                }
                if (token == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                int n3 = 0;
                ArrayList<String> arrayList = new ArrayList<String>();
                while (true) {
                    if (n3 >= stringArray.length) {
                        bl = true;
                        n2 = 0;
                        break;
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Removing zone member " + stringArray[n3]);
                    }
                    if ((n = FabricManagerService.getZoneControllerProxy().removeZoneMemberFromZone(token, string2, stringArray[n3], sArray[n3])) == 0) {
                        if (traceLogger != null && traceLogger.isLogging()) {
                            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Successfully removed zone member " + stringArray[n3]);
                        }
                        arrayList.add(stringArray[n3]);
                    }
                    ++n3;
                }
                while (n2 < ((HashMap[])object).length) {
                    if (!arrayList.contains(object[n2].get("NAME"))) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Still have members in the zone");
                }
                if (bl) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "All zone members removed");
                    }
                    n = this.checkLastZoneInZoneSet(token, string, string2);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "rc ( checkLastZoneInZoneSet) = " + n);
                    }
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray2 = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray2), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var13_22 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var13_23 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2, stringArray, sArray});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int removeZoneMembersFromZoneAlias(String string, String string2, String[] stringArray, short[] sArray) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "removeZoneMembersFromZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneAliasName", 2, string3);
        this.checkMandatoryParam(stringArray, "zoneMemberNames", 3, string3);
        this.checkFabric(string, string3);
        try {
            try {
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    n = FabricManagerService.getZoneControllerProxy().removeZoneMemberFromZoneAlias((Token)object, string2, stringArray[n2], sArray[n2]);
                    ++n2;
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray2 = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray2), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var10_17 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2, stringArray, sArray});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteZoneSet(String string, String string2) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "deleteZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneSetName", 2, string3);
        this.checkFabric(string, string3);
        try {
            try {
                if (!FabricDbAccess.verifyZoneSet((String)string, (String)string2)) {
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONESET_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone Set not found with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONESET_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().deleteZoneSet((Token)object, string2);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var8_16 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteZone(String string, String string2) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "deleteZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "fabricID = " + string);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "zoneName = " + string2);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneName", 2, string3);
        this.checkFabric(string, string3);
        try {
            try {
                if (!FabricDbAccess.verifyZone((String)string, (String)string2)) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Zone not found... throwing InvalidParameterExcetpion");
                    }
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONE_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone not found with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONE_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Reserved token found... " + object.toString());
                    }
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().deleteZone((Token)object, string2);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "rc(deleteZone) = " + n);
                }
                if (n == 0) {
                    n = this.checkLastZoneInZoneSet((Token)object, string, string2);
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "rc(checkLastZoneInZoneSet) = " + n);
                    }
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var8_16 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deleteZoneAlias(String string, String string2) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "deleteZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneAliasName", 2, string3);
        this.checkFabric(string, string3);
        try {
            try {
                if (!FabricDbAccess.verifyZoneAlias((String)string, (String)string2)) {
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONEALIAS_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone Alias not found with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONEALIAS_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().deleteZoneAlias((Token)object, string2);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var8_16 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int activateZoneSet(String string, String string2) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "activateZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneSetName", 2, string3);
        this.checkFabric(string, string3);
        try {
            try {
                if (!FabricDbAccess.verifyZoneSet((String)string, (String)string2)) {
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONESET_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone Set not found with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONESET_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().activateZoneSet((Token)object, string2);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var8_16 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2, string2});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int deactivateZoneSet(String string, String string2) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "activateZoneSet";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneSetName", 2, string3);
        this.checkFabric(string, string3);
        try {
            try {
                if (!FabricDbAccess.verifyZoneSet((String)string, (String)string2)) {
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONESET_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone Set not found with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONESET_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(1, sRMMessage);
                }
                object = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    object = (Token)reservedTokens.get(string);
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                n = FabricManagerService.getZoneControllerProxy().deactivateZoneSet((Token)object, string2);
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var8_16 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int createZoneAlias(String string, String string2) throws ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        String string3 = "createZoneAlias";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "fabricID = " + string);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "zoneAliasName = " + string2);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneAliasName", 2, string3);
        this.checkFabric(string, string3);
        try {
            try {
                if (FabricDbAccess.verifyZoneAlias((String)string, (String)string2)) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Zone Alias already exist... throwing InvalidParameterExcetpion");
                    }
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONEALIAS_EXISTS, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone Alias already exists with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONEALIAS_EXISTS, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                object = null;
                if (reservedTokens != null) {
                    if (reservedTokens.containsKey(string)) {
                        object = (Token)reservedTokens.get(string);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Reserved token found... " + object.toString());
                    }
                }
                if (object == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Creating Zone Alias...");
                }
                n = FabricManagerService.getZoneControllerProxy().createZoneAlias((Token)object, string2);
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string3, "Return Code = " + n);
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var8_16 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (int)n);
        return n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result removePortsFromZone(String string, String string2, String[] stringArray) throws RemoteException, ServerException, InvalidParameterException, MissingParameterException, TransactionExpiredException, TransactionInProgressException {
        Object object;
        Result result;
        String string3 = "removePortsInZone";
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string3);
        }
        int n = -999;
        this.checkMandatoryParam(string, "fabricID", 1, string3);
        this.checkMandatoryParam(string2, "zoneName", 2, string3);
        this.checkFabric(string, string3);
        ArrayList arrayList = new ArrayList();
        try {
            try {
                int n2;
                if (!FabricDbAccess.verifyZone((String)string, (String)string2)) {
                    Object[] objectArray = new String[]{string2};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.ZONE_NOT_FOUND, objectArray);
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INVALID_PARAMETER, objectArray);
                    }
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Zone not found with Name = " + string2);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONE_NOT_FOUND, (String[])objectArray);
                    throw new InvalidParameterException(2, sRMMessage);
                }
                result = FabricDbAccess.getZoneMembers((String)string, (String)string2, (boolean)false);
                object = FabricDbAccess.getPortsWithMembersInZone((String)string, (String)string2, (boolean)false);
                Token token = null;
                if (reservedTokens != null && reservedTokens.containsKey(string)) {
                    token = (Token)reservedTokens.get(string);
                }
                if (token == null) {
                    if (traceLogger != null && traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string3, "Reserved token not found for fabric " + string + ", throwing TransactionExpiredException");
                    }
                    Object[] objectArray = new String[]{string};
                    if (msgLogger != null) {
                        msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, objectArray);
                    }
                    SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, (String[])objectArray);
                    throw new TransactionExpiredException(sRMMessage);
                }
                ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
                int n3 = 0;
                while (true) {
                    block37: {
                        String string4;
                        block36: {
                            String[] stringArray2;
                            if (n3 >= stringArray.length) {
                                n3 = 1;
                                n2 = 0;
                                break;
                            }
                            string4 = stringArray[n3];
                            HashMap hashMap = (HashMap)object.get(string4);
                            if (hashMap == null || hashMap.isEmpty()) {
                                stringArray2 = new String[]{stringArray[n3]};
                                SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.ZONEMEMBER_NOT_FOUND, stringArray2);
                                throw new InvalidParameterException(3, n3, sRMMessage);
                            }
                            stringArray2 = (String[])hashMap.get("NAME");
                            int n4 = (Integer)hashMap.get("TYPE");
                            ArrayList arrayList3 = (ArrayList)hashMap.get("AllPorts");
                            if (arrayList2.contains(stringArray2)) break block36;
                            n = FabricManagerService.getZoneControllerProxy().removeZoneMemberFromZone(token, string2, (String)stringArray2, (short)n4);
                            if (n == 0) {
                                arrayList2.add(stringArray2);
                                arrayList3.remove(string4);
                                if (!arrayList3.isEmpty()) {
                                    arrayList.addAll(arrayList3);
                                }
                            }
                            break block37;
                        }
                        if (arrayList.contains(string4)) {
                            arrayList.remove(string4);
                        }
                    }
                    ++n3;
                }
                while (n2 < ((HashMap[])result).length) {
                    if (!arrayList2.contains(result[n2].get("NAME"))) {
                        n3 = 0;
                        break;
                    }
                    ++n2;
                }
                if (n3 != 0) {
                    n = this.checkLastZoneInZoneSet(token, string, string2);
                }
            }
            catch (InvalidParameterException invalidParameterException) {
                throw invalidParameterException;
            }
            catch (TransactionExpiredException transactionExpiredException) {
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Transaction Expired.  Fabric with Name = " + string);
                }
                throw transactionExpiredException;
            }
            catch (JobInProgressException jobInProgressException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_IN_PROGRESS, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Zone Control Job is already in progress for Fabric with Name = " + string);
                }
                throw new TransactionInProgressException(new SRMMessage(FabricMsgConsts.TRANSACTION_IN_PROGRESS, new String[]{string}));
            }
            catch (InvalidTokenException invalidTokenException) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.TRANSACTION_EXPIRED, (Object[])new String[]{string});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "The Transaction Expired or was not started for Fabric with Name = " + string);
                }
                throw new TransactionExpiredException(new SRMMessage(FabricMsgConsts.TRANSACTION_EXPIRED, new String[]{string}));
            }
            catch (Exception exception) {
                if (msgLogger != null) {
                    msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
                }
                if (traceLogger != null && traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
                }
                String[] stringArray3 = new String[]{string3};
                throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray3), (Throwable)exception);
            }
        }
        catch (Throwable throwable) {
            Object var17_28 = null;
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
            }
            throw throwable;
        }
        {
            Object var17_29 = null;
        }
        if (traceLogger != null && traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string3);
        }
        result = new Result();
        result.setRc(n);
        if (!arrayList.isEmpty()) {
            object = arrayList.toArray(new String[0]);
            result.setResults(object);
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2, stringArray});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string3, (String)object, (String)result.toString());
        return result;
    }

    private int checkLastZoneInZoneSet(Token token, String string, String string2) throws Exception {
        int n = 0;
        String[] stringArray = FabricDbAccess.getZoneSets((String)string, (boolean)true);
        if (stringArray != null && stringArray.length == 1) {
            String string3 = stringArray[0];
            String[] stringArray2 = FabricDbAccess.getZones((String)string, (String)string3, (boolean)true);
            if (stringArray2.length == 1 && stringArray2[0].equals(string2)) {
                n = FabricManagerService.getZoneControllerProxy().deactivateZoneSet(token, string3);
            }
            if (n == 0) {
                n = 1;
            }
        }
        return n;
    }

    private void checkFabric(String string, String string2) throws InvalidParameterException, ServerException {
        String string3 = "checkFabric";
        boolean bl = false;
        try {
            bl = FabricDbAccess.verifyFabric((String)string);
        }
        catch (Exception exception) {
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "A Fabric Internal Error occurred.  Fabric with Name = " + string + " Error = " + exception.getMessage());
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string3, (Throwable)exception);
            }
            if (msgLogger != null) {
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string3, FabricMsgConsts.INTERNAL_ERROR, (Object[])new String[]{exception.getMessage()});
            }
            String[] stringArray = new String[]{string2};
            throw new ServerException(new SRMMessage(FabricMsgConsts.INTERNAL_ERROR, stringArray), (Throwable)exception);
        }
        if (!bl) {
            Object[] objectArray = new String[]{string};
            if (msgLogger != null) {
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.FABRIC_NOT_FOUND, objectArray);
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.INVALID_PARAMETER, objectArray);
            }
            if (traceLogger != null && traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)this, string3, "Invalid Parameter.  Fabric not found with Name = " + string);
            }
            SRMMessage sRMMessage = new SRMMessage(FabricMsgConsts.FABRIC_NOT_FOUND, (String[])objectArray);
            throw new InvalidParameterException(1, sRMMessage);
        }
    }

    public static IZoneControl getZoneControllerProxy() {
        if (zoneControllerProxy == null) {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.control.interfaces.fabric.IZoneControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.FabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            zoneControllerProxy = (IZoneControl)ControlRouter.getControllerProxy(clazz2, (ClassLoader)clazz.getClassLoader());
        }
        return zoneControllerProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMissingDevices(String[] stringArray) throws ServerException, InvalidParameterException {
        String string = "deleteMissingDevices";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        Object[] objectArray = new String[2];
        FabricManagerService fabricManagerService = this;
        synchronized (fabricManagerService) {
            Object object;
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Calling Device Server delete missing.");
                }
                object = new RemoveMissingProcessor();
                object.performDeletionForSelectedMissingEntities(stringArray);
            }
            catch (Exception exception) {
                objectArray[0] = "FabricManagerService.deleteMissingDevices";
                msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.OPERATION_FAILED, objectArray);
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
                }
                throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
            }
            object = DiskMessageHelper.toMsgString((Object)new Object[]{stringArray});
            ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string, (String)object, (String)"");
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
            }
            return;
        }
    }

    public Token reserve(String string, String string2, String string3) throws ResourceLockedException, ResourceNotAvailableException, ServerException {
        Object object;
        String string4 = "reserve";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string4);
        }
        Token token = null;
        Object[] objectArray = new String[2];
        if (string == null) {
            objectArray[0] = "fabricId";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string4, "Missing parameter " + (String)objectArray[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
        if (string2 == null) {
            objectArray[0] = "clientId";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string4, "Missing parameter " + (String)objectArray[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
        try {
            object = FabricManagerService.getZoneControllerProxy();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, "Obtained ZC proxy with id " + object.toString());
            }
            token = object.reserve(string, "E4", string2, 1, string3);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string4, "Reserve finished, token = " + token.toString());
            }
        }
        catch (LockedException lockedException) {
            objectArray[0] = string;
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.FABRIC_LOCKED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string4, (Throwable)lockedException);
            }
            throw new ResourceLockedException(new SRMMessage(FabricMsgConsts.FABRIC_LOCKED, (String[])objectArray), lockedException.getUserName(), lockedException.getLockMoment());
        }
        catch (NotAvailableException notAvailableException) {
            objectArray[0] = string;
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.AGENT_UNAVAILABLE, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string4, (Throwable)notAvailableException);
            }
            throw new ResourceNotAvailableException(new SRMMessage(FabricMsgConsts.AGENT_UNAVAILABLE, (String[])objectArray));
        }
        catch (Exception exception) {
            objectArray[0] = "FabricManagerService.reserve";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string4, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string4, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        object = DiskMessageHelper.toMsgString((Object)new Object[]{string, string2});
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string4, (String)object, (String)token.toString());
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string4);
        }
        return token;
    }

    public int updateTokenTimestamp(Token token) {
        String string = "updateTokenTimestamp";
        int n = 0;
        IZoneControl iZoneControl = FabricManagerService.getZoneControllerProxy();
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Obtained ZC proxy with id " + iZoneControl.toString());
        }
        n = iZoneControl.updateTokenTimestamp(token);
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "refresh finished, for token = " + token.toString() + " returned rc:" + n);
        }
        return n;
    }

    public AsyncResult readCurrentZoneDefinition(Token token, String string) throws ResourceNotAvailableException, ResourceLockedException, InvalidTokenException, JobInProgressException, ServerException, InvalidParameterException, MissingParameterException {
        String string2 = "readCurrentZoneDefinition";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        AsyncResult asyncResult = null;
        Object[] objectArray = new String[2];
        if (token == null) {
            objectArray[0] = "token";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Missing parameter " + (String)objectArray[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
        if (string == null) {
            objectArray[0] = "sanWWN";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string2, "Missing parameter " + (String)objectArray[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
        try {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.aperi.control.interfaces.fabric.IZoneControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            try {
                clazz = Class.forName("org.eclipse.aperi.fabric.FabricManagerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IZoneControl iZoneControl = (IZoneControl)ControlRouter.getControllerProxy(clazz2, (ClassLoader)clazz.getClassLoader());
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "Obtained ZC proxy with id " + iZoneControl.toString());
            }
            asyncResult = iZoneControl.readCurrentZoneDefinition(token, string);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string2, "readCurrentZoneDefinition finished, Result = " + asyncResult.toString());
            }
        }
        catch (InvalidTokenException invalidTokenException) {
            objectArray[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.TOKEN_EXPIRED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)invalidTokenException);
            }
            throw new InvalidTokenException(new SRMMessage(FabricMsgConsts.TOKEN_EXPIRED, (String[])objectArray));
        }
        catch (JobInProgressException jobInProgressException) {
            objectArray[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.JOB_IN_PROGRESS, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)jobInProgressException);
            }
            throw new JobInProgressException(new SRMMessage(FabricMsgConsts.JOB_IN_PROGRESS, (String[])objectArray));
        }
        catch (Exception exception) {
            objectArray[0] = "FabricManagerService.readCurrentZoneDefinition";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string2, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string2, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string2, (String)"", (AsyncResult)asyncResult);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        }
        return asyncResult;
    }

    public AsyncResult setZoneInfo(Token token, ZoneDefinition zoneDefinition, int n) throws ResourceNotAvailableException, ResourceLockedException, InvalidTokenException, JobInProgressException, ServerException, InvalidParameterException, MissingParameterException {
        String string = "setZoneInfo";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        AsyncResult asyncResult = null;
        Object[] objectArray = new String[2];
        if (token == null) {
            objectArray[0] = "token";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Missing parameter " + (String)objectArray[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
        if (zoneDefinition == null) {
            objectArray[0] = "definition";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Missing parameter " + (String)objectArray[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
        try {
            IZoneControl iZoneControl = FabricManagerService.getZoneControllerProxy();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Obtained ZC proxy with id " + iZoneControl.toString());
            }
            asyncResult = iZoneControl.setZoneInfo(token, zoneDefinition, n);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "setZoneInfo finished, Result = " + asyncResult.toString());
            }
        }
        catch (org.eclipse.aperi.control.interfaces.InvalidTokenException invalidTokenException) {
            objectArray[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.TOKEN_EXPIRED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)invalidTokenException);
            }
            throw new InvalidTokenException(new SRMMessage(FabricMsgConsts.TOKEN_EXPIRED, (String[])objectArray));
        }
        catch (org.eclipse.aperi.control.interfaces.JobInProgressException jobInProgressException) {
            objectArray[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.JOB_IN_PROGRESS, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)jobInProgressException);
            }
            throw new JobInProgressException(new SRMMessage(FabricMsgConsts.JOB_IN_PROGRESS, (String[])objectArray));
        }
        catch (Exception exception) {
            objectArray[0] = "FabricManagerService.setZoneInfo";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string, (String)"", (AsyncResult)asyncResult);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return asyncResult;
    }

    public int release(Token token) {
        String string = "setZoneInfo";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        int n = 0;
        Object[] objectArray = new String[2];
        if (token == null) {
            objectArray[0] = "token";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Missing parameter " + (String)objectArray[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
        try {
            IZoneControl iZoneControl = FabricManagerService.getZoneControllerProxy();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Obtained ZC proxy with id " + iZoneControl.toString());
            }
            n = iZoneControl.release(token);
            if (reservedTokens != null) {
                Enumeration enumeration = reservedTokens.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Token token2 = (Token)reservedTokens.get(string2);
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Comparing release token " + token.toString() + " to reserved token (" + string2 + ") " + token2.toString());
                    }
                    if (!token.equals((Object)token2)) continue;
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Removing token " + token.toString() + " for fabric " + string2 + " from list of reserved tokens.");
                    }
                    reservedTokens.remove(string2);
                    break;
                }
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "release finished, result = " + n);
            }
        }
        catch (Exception exception) {
            objectArray[0] = "FabricManagerService.release";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string, (String)token.toString(), (int)n);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return n;
    }

    public AsyncResult testZoneControlCapabilities(Token token) throws ResourceNotAvailableException, ResourceLockedException, InvalidTokenException, JobInProgressException, ServerException, InvalidParameterException, MissingParameterException {
        String string = "testZoneControlCapabilities";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        AsyncResult asyncResult = null;
        Object[] objectArray = new String[2];
        if (token == null) {
            objectArray[0] = "token";
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, string, "Missing parameter " + (String)objectArray[0] + ".");
            }
            throw new MissingParameterException(1, new SRMMessage(FabricMsgConsts.MISSING_PARAM, (String[])objectArray));
        }
        try {
            IZoneControl iZoneControl = FabricManagerService.getZoneControllerProxy();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "Obtained ZC proxy with id " + iZoneControl.toString());
            }
            asyncResult = iZoneControl.ping(token);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, string, "release finished, result = " + asyncResult);
            }
        }
        catch (NotAvailableException notAvailableException) {
            objectArray[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.AGENT_UNAVAILABLE, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)notAvailableException);
            }
            throw new ResourceNotAvailableException(new SRMMessage(FabricMsgConsts.AGENT_UNAVAILABLE, (String[])objectArray));
        }
        catch (org.eclipse.aperi.control.interfaces.InvalidTokenException invalidTokenException) {
            objectArray[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.TOKEN_EXPIRED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)invalidTokenException);
            }
            throw new InvalidTokenException(new SRMMessage(FabricMsgConsts.TOKEN_EXPIRED, (String[])objectArray));
        }
        catch (org.eclipse.aperi.control.interfaces.JobInProgressException jobInProgressException) {
            objectArray[0] = token.getResource();
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.JOB_IN_PROGRESS, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)jobInProgressException);
            }
            throw new JobInProgressException(new SRMMessage(FabricMsgConsts.JOB_IN_PROGRESS, (String[])objectArray));
        }
        catch (Exception exception) {
            objectArray[0] = "FabricManagerService.testZoneControlCapabilities";
            msgLogger.message(IRecordType.TYPE_ERROR, (Object)this, string, FabricMsgConsts.OPERATION_FAILED, objectArray);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR, (Object)className, string, (Throwable)exception);
            }
            throw new ServerException(new SRMMessage(FabricMsgConsts.OPERATION_FAILED, (String[])objectArray));
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return asyncResult;
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, Boolean bl) throws RemoteException, ServerException {
        return this.discoverCIMOMs(stringArray, (boolean)bl);
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, boolean bl) throws RemoteException, ServerException {
        String string = "discoverCIMOMS";
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        AsyncResult asyncResult = cIMOMManager.discoverCIMOMs(stringArray, bl);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (n == 0) {
                    stringBuffer.append(stringArray[n]);
                } else {
                    stringBuffer.append("," + stringArray[n]);
                }
                ++n;
            }
            hashMap.put("DAs", stringBuffer.toString());
        }
        hashMap.put("Local", new Boolean(bl).toString());
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string, (String)hashMap.toString(), (AsyncResult)asyncResult);
        return asyncResult;
    }

    public CIMOM[] getCIMOMs() throws RemoteException, ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.getCIMOMsWithoutPW();
    }

    public String[] getCIMOMIDs() throws RemoteException, ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.getCIMOMIDs();
    }

    public void modifyCIMOMs(CIMOM[] cIMOMArray) throws RemoteException, ServerException {
        String string = "modifyCIMOMs";
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        cIMOMManager.modifyCIMOMs(cIMOMArray);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (cIMOMArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < cIMOMArray.length) {
                if (n == 0) {
                    stringBuffer.append(cIMOMArray[n]);
                } else {
                    stringBuffer.append("," + cIMOMArray[n]);
                }
                ++n;
            }
            hashMap.put("cimoms", stringBuffer.toString());
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string, (String)hashMap.toString(), (String)"");
    }

    public String[] addCIMOMs(CIMOM[] cIMOMArray) throws RemoteException, ServerException {
        String string = "addCIMOMs";
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (cIMOMArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < cIMOMArray.length) {
                if (n == 0) {
                    stringBuffer.append(cIMOMArray[n]);
                } else {
                    stringBuffer.append("," + cIMOMArray[n]);
                }
                ++n;
            }
            hashMap.put("cimoms", stringBuffer.toString());
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string, (String)hashMap.toString(), (String)"");
        return cIMOMManager.addCIMOMs(cIMOMArray);
    }

    public void deleteCIMOMs(String[] stringArray) throws RemoteException, ServerException {
        String string = "deleteCIMOMs";
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        cIMOMManager.deleteCIMOMs(stringArray);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (n == 0) {
                    stringBuffer.append(stringArray[n]);
                } else {
                    stringBuffer.append("," + stringArray[n]);
                }
                ++n;
            }
            hashMap.put("cimoms", stringBuffer.toString());
        }
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string, (String)hashMap.toString(), (String)"");
    }

    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cIMOMArray) throws RemoteException, ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.testCIMOMConnection(cIMOMArray);
    }

    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] cIMOMArray, CIMObjectPath cIMObjectPath) throws RemoteException, ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.testCIMOMConnection(cIMOMArray, cIMObjectPath);
    }

    public AsyncResult discoverDevicesFromCIMOM(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        StringBuffer stringBuffer;
        String string = "discoverDevicesFromCIMOM";
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (stringArray != null) {
            stringBuffer = new StringBuffer();
            int n = 0;
            while (n < stringArray.length) {
                if (n == 0) {
                    stringBuffer.append(stringArray[n]);
                } else {
                    stringBuffer.append("," + stringArray[n]);
                }
                ++n;
            }
            hashMap.put("cimoms", stringBuffer.toString());
        }
        stringBuffer = cIMOMManager.discoverDevicesFromCIMOM(stringArray);
        ServiceUtils.recordInAuditLog((String)"FabricManagerService", (String)string, (String)hashMap.toString(), (AsyncResult)stringBuffer);
        return stringBuffer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getCIMOMtoDevices(String string) throws RemoteException, ServerException {
        ArrayList arrayList;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getCIMOMtoDevices", (Object[])new Object[]{string});
        ArrayList arrayList2 = null;
        try {
            try {
                logTraceHelper.traceDMInvokation(new Object[]{string});
                CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
                arrayList = arrayList2 = cIMOMManager.getCIMOMtoDevices(string);
                Object var5_8 = null;
            }
            catch (SRMRuntimeException sRMRuntimeException) {
                logTraceHelper.traceError("SRMRuntimeException during Fabric Manager service method execution.", (Throwable)sRMRuntimeException);
                throw sRMRuntimeException;
            }
            catch (RuntimeException runtimeException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)runtimeException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            logTraceHelper.traceDMReturn(arrayList2);
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        logTraceHelper.traceDMReturn((Object)arrayList2);
        logTraceHelper.exit((Object)arrayList2);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getNodeNameFromID(int n) throws RemoteException, ServerException {
        String string;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getNodenameFromID", (Object[])new Object[]{new Integer(n)});
        String string2 = null;
        try {
            try {
                string = string2 = FabricDbAccess.getNodeNameFromID((int)n);
                Object var5_5 = null;
            }
            catch (SRMRuntimeException sRMRuntimeException) {
                logTraceHelper.traceError("SRMRuntimeException during Fabric Manager service method execution.", (Throwable)sRMRuntimeException);
                throw sRMRuntimeException;
            }
            catch (RuntimeException runtimeException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)runtimeException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            logTraceHelper.traceDMReturn((Object)string2);
            logTraceHelper.exit((Object)string2);
            throw throwable;
        }
        logTraceHelper.traceDMReturn((Object)string2);
        logTraceHelper.exit((Object)string2);
        return string;
    }

    /*
     * Exception decompiling
     */
    public String[] getHBAsForComputer(String var1_1) throws ServerException, InvalidParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 141->144)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getSubsystemToSwitch(String var1_1) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 117->120)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getComputerToSwitch(String var1_1) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 143->146)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getComputerInFabric(String var1_1) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 143->146)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public String[] getSubsystemInFabric(String var1_1) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 143->146)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getHBAAttributes(String[] stringArray, String[] stringArray2) throws RemoteException, ServerException {
        HashMap[] hashMapArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getHBAAttributes", (Object[])new Object[]{stringArray, stringArray2});
        HashMap[] hashMapArray2 = null;
        ParameterChecker.assertMandatoryParameter((int)1, (String)"HBAIDs", (Object)stringArray, (LogTraceHelper)logTraceHelper);
        if (stringArray2 != null && stringArray2.length > 0) {
            this.validateParam(stringArray2, FabricManagerConstants.HBA_ATTRS, 2, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, "getHBAAttributes");
        } else {
            stringArray2 = FabricManagerConstants.HBA_ATTRS;
        }
        try {
            try {
                hashMapArray = hashMapArray2 = FabricDbAccess.getHBAAttributes((String[])stringArray, (String[])stringArray2);
                Object var6_6 = null;
            }
            catch (SRMRuntimeException sRMRuntimeException) {
                logTraceHelper.traceError("SRMRuntimeException during Fabric Manager service method execution.", (Throwable)sRMRuntimeException);
                throw sRMRuntimeException;
            }
            catch (Exception exception) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)exception, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logTraceHelper.traceDMReturn((Object)hashMapArray2);
            logTraceHelper.exit((Object)hashMapArray2);
            throw throwable;
        }
        logTraceHelper.traceDMReturn((Object)hashMapArray2);
        logTraceHelper.exit((Object)hashMapArray2);
        return hashMapArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HashMap[] getComputerExtAttributes(int[] nArray, String[] stringArray) throws RemoteException, ServerException {
        HashMap[] hashMapArray;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getComputerExtAttributes", (Object[])new Object[]{nArray, stringArray});
        HashMap[] hashMapArray2 = null;
        ParameterChecker.assertMandatoryParameter((int)1, (String)"ComputerIDs", (Object)nArray, (LogTraceHelper)logTraceHelper);
        if (stringArray != null && stringArray.length > 0) {
            this.validateParam(stringArray, FabricManagerConstants.COMPUTER_STAT_ATTRS, 2, FabricMsgConsts.ATTRIBUTE_NOT_FOUND, "getComputerExtAttributes");
        } else {
            stringArray = FabricManagerConstants.COMPUTER_STAT_ATTRS;
        }
        try {
            try {
                hashMapArray = hashMapArray2 = FabricDbAccess.getComputerExtAttributes((int[])nArray, (String[])stringArray);
                Object var6_6 = null;
            }
            catch (SRMRuntimeException sRMRuntimeException) {
                logTraceHelper.traceError("SRMRuntimeException during Fabric Manager service method execution.", (Throwable)sRMRuntimeException);
                throw sRMRuntimeException;
            }
            catch (Exception exception) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)exception, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logTraceHelper.traceDMReturn((Object)hashMapArray2);
            logTraceHelper.exit((Object)hashMapArray2);
            throw throwable;
        }
        logTraceHelper.traceDMReturn((Object)hashMapArray2);
        logTraceHelper.exit((Object)hashMapArray2);
        return hashMapArray;
    }

    /*
     * Exception decompiling
     */
    public HashMap[] hasNewComputerId(String[] var1_1) throws ServerException, InvalidParameterException, MissingParameterException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 115->118)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

