/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.sanmgmt.event;

import java.util.Vector;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.snmp.SnmpTrap;
import org.eclipse.aperi.snmp.SnmpTrapSession;

public class SnmpTrapProcessor
implements Runnable {
    public static ILogger msgLogger;
    public static ILogger traceLogger;
    static final String className;
    private Vector eventQueue = new Vector();
    private Thread workerThread = null;
    private static SnmpTrapProcessor myThread;
    private static long MAXNUMBEROFTRAP;
    private SnmpTrapSession session = null;

    static {
        Class<?> clazz;
        msgLogger = LogManagerFactory.getMessageLogger((String)"aperi.logger.message.event");
        traceLogger = LogManagerFactory.getTraceLogger((String)"aperi.logger.trace.event");
        msgLogger.setMessageFile("org.eclipse.aperi.sanmgmt.event.resources.SANEventService");
        try {
            clazz = Class.forName("org.eclipse.aperi.sanmgmt.event.SnmpTrapProcessor");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        myThread = null;
        MAXNUMBEROFTRAP = 1000L;
    }

    public SnmpTrapProcessor(SnmpTrapSession snmpTrapSession) {
        this.session = snmpTrapSession;
    }

    public void start() {
        String string = "start";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        if (this.workerThread == null) {
            this.workerThread = new Thread(this);
            this.workerThread.start();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String string = "stop";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
        }
        this.workerThread = null;
        SnmpTrapProcessor snmpTrapProcessor = this;
        synchronized (snmpTrapProcessor) {
            this.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string;
        block15: {
            string = "run";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string);
            }
            try {
                Thread thread = Thread.currentThread();
                while (this.workerThread == thread) {
                    String string2;
                    try {
                        SnmpTrapProcessor snmpTrapProcessor;
                        while (this.eventQueue.isEmpty()) {
                            snmpTrapProcessor = this;
                            synchronized (snmpTrapProcessor) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                                if (this.workerThread == null) {
                                    this.session.close();
                                    if (traceLogger.isLogging()) {
                                        string2 = "SnmpTrapProcessor was shutdown";
                                        traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string, string2);
                                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
                                    }
                                    return;
                                }
                            }
                        }
                        snmpTrapProcessor = (SnmpTrap)this.eventQueue.firstElement();
                        this.eventQueue.remove(0);
                        this.sendSnmpTrap((SnmpTrap)snmpTrapProcessor);
                    }
                    catch (Exception exception) {
                        string2 = "Failed to send snmp trap";
                        if (!traceLogger.isLogging()) continue;
                        traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string, string2);
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                    }
                }
            }
            catch (Exception exception) {
                String string3 = "Failed to start SnmpTrapProcessor.";
                if (!traceLogger.isLogging()) break block15;
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string, string3);
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSnmpTrap(SnmpTrap snmpTrap) {
        String string = "addSnmpTrap";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)new String("SnmpTrap"));
        }
        if ((long)this.eventQueue.size() < MAXNUMBEROFTRAP) {
            this.eventQueue.addElement(snmpTrap);
        } else {
            if (!this.eventQueue.isEmpty()) {
                this.eventQueue.remove(0);
            }
            this.eventQueue.addElement(snmpTrap);
            traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string, "Trap queue is full, so delete the oldest and add the new one.");
        }
        SnmpTrapProcessor snmpTrapProcessor = this;
        synchronized (snmpTrapProcessor) {
            this.notifyAll();
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }

    private void sendSnmpTrap(SnmpTrap snmpTrap) {
        String string;
        block6: {
            string = "sendSnmpTrap";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, string, (Object)new String("SnmpTrap"));
            }
            try {
                if (this.session != null) {
                    this.session.send(snmpTrap);
                }
                if (traceLogger.isLogging()) {
                    String string2 = "Snmp trap was sent successfully";
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this, string, string2);
                }
            }
            catch (Exception exception) {
                String string3 = "Failed to send snmp trap";
                if (!traceLogger.isLogging()) break block6;
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, string, string3);
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
    }
}

