/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Vector;
import org.eclipse.aperi.download.ConfigurationException;
import org.eclipse.aperi.download.EclipseMirrorList;
import org.eclipse.aperi.download.Util;
import org.eclipse.aperi.download.interfaces.IDownload;
import org.eclipse.aperi.download.interfaces.IDownloadTarget;
import org.eclipse.aperi.download.interfaces.IMirror;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 46.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Download
implements IDownload {
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_FILE_URL = "url";
    public static final String ATTR_MIRROR_URL = "mirrorxml";
    private String _description = null;
    private String _fileUrl = null;
    private String _mirrorUrl = null;
    private boolean _mirrored = false;

    public Download(Node node) throws ConfigurationException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        this._description = Util.getNamedAttribute(namedNodeMap, ATTR_DESCRIPTION, true);
        this._fileUrl = Util.getNamedAttribute(namedNodeMap, ATTR_FILE_URL, false);
        this._mirrorUrl = Util.getNamedAttribute(namedNodeMap, ATTR_MIRROR_URL, false);
        if (this._mirrorUrl != null) {
            this._mirrored = true;
        }
        if (this._fileUrl == null && this._mirrorUrl == null) {
            throw new ConfigurationException("A download must have either a url or a mirrorxml\ndefined in the download configuration.");
        }
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public String getFileUrl() {
        return this._fileUrl;
    }

    @Override
    public boolean isMirrored() {
        return this._mirrored;
    }

    @Override
    public Vector<IMirror> getMirrors() throws IOException, SAXException {
        EclipseMirrorList eclipseMirrorList = new EclipseMirrorList(this._mirrorUrl);
        return eclipseMirrorList.getMirrors();
    }

    @Override
    public void setFileUrl(String string) {
        this._fileUrl = string;
    }

    @Override
    public abstract void downloadFile(String var1, String var2) throws Exception;

    public void fileCopy(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
        fileChannel.close();
        fileChannel2.close();
    }

    public void streamCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void createPlaceholders(Vector<IDownloadTarget> var1_1, String var2_2) throws IOException {
        block4: {
            var3_3 = var1_1.iterator();
            var4_4 = null;
            try {
                while (var3_3.hasNext()) {
                    var5_5 = var3_3.next();
                    var4_4 = new File(new StringBuffer(String.valueOf(var2_2)).append(File.separator).append(var5_5.getTargetPath()).toString());
                    var4_4.getParentFile().mkdirs();
                    var4_4.createNewFile();
                    var4_4.setLastModified(0L);
                }
                break block4;
            }
            catch (IOException var5_6) {
                System.out.println(new StringBuffer("File creation failed: ").append(var4_4.getAbsolutePath()).toString());
                ** for (var6_7 : var1_1)
            }
lbl-1000:
            // 1 sources

            {
                var4_4 = new File(var6_7.getTargetPath());
                if (!var4_4.exists() || var4_4.lastModified() != 0L) continue;
                var4_4.delete();
                continue;
            }
lbl23:
            // 1 sources

            throw var5_6;
        }
    }

    public boolean prepTargets(long l, Vector<IDownloadTarget> vector, String string) throws IOException {
        File file;
        boolean bl = false;
        int n = vector.size();
        int n2 = 0;
        int n3 = 0;
        for (IDownloadTarget iDownloadTarget : vector) {
            file = new File(new StringBuffer(String.valueOf(string)).append(File.separator).append(iDownloadTarget.getTargetPath()).toString());
            if (!file.exists()) continue;
            if (file.lastModified() == l) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (n2 == n) {
            bl = true;
        } else if (n3 > 0) {
            for (IDownloadTarget iDownloadTarget : vector) {
                file = new File(new StringBuffer(String.valueOf(string)).append(File.separator).append(iDownloadTarget.getTargetPath()).toString());
                if (!file.exists() || file.delete()) continue;
                throw new IOException(new StringBuffer("Failed to delete file: ").append(file.getAbsolutePath()).toString());
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public void copyToTargets(File var1_1, Vector<IDownloadTarget> var2_2, String var3_3, long var4_4) throws IOException {
        block5: {
            try {
                for (IDownloadTarget var7_7 : var2_2) {
                    var8_9 = new File(new StringBuffer(String.valueOf(var3_3)).append(File.separator).append(var7_7.getTargetPath()).toString());
                    if (var8_9.lastModified() != 0L) {
                        throw new IOException(new StringBuffer("Concurrent modification detected: ").append(var8_9.getAbsolutePath()).toString());
                    }
                    this.fileCopy(var1_1, var8_9);
                    var8_9.setLastModified(var4_4);
                }
                var1_1.delete();
                break block5;
            }
            catch (IOException var6_6) {
                ** for (var8_10 : var2_2)
            }
lbl-1000:
            // 1 sources

            {
                var9_11 = new File(var8_10.getTargetPath());
                if (!var9_11.exists()) continue;
                var9_11.delete();
                continue;
            }
lbl20:
            // 1 sources

            var1_1.delete();
            throw var6_6;
        }
    }
}

