/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TAggregator
extends StorageRepositoryAccessor {
    private Timestamp tsWeekly = new Timestamp(0L);
    private Timestamp tsMonthly = new Timestamp(0L);
    private long lastWeekly = -1L;
    private long lastMonthly = -1L;
    private static final String FETCH = "select last_weekly, last_monthly from t_aggregator";
    private static final String INSERT = "insert into t_aggregator (last_weekly, last_monthly) values (?,?)";
    private static final String UPDATE = "update t_aggregator set last_weekly = ?, last_monthly = ?";

    public TAggregator(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TAggregator", (String)"dbc");
        }
        this.tableName = "T_AGGREGATOR";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TAggregator");
        }
    }

    public long getLastWeekly() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLastWeekly", (String)"");
        }
        if (this.lastWeekly <= 0L) {
            this.fetch();
        }
        long l = this.lastWeekly;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLastWeekly", (long)l);
        }
        return l;
    }

    public long getLastMonthly() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"getLastMonthly", (String)"");
        }
        if (this.lastMonthly <= 0L) {
            this.fetch();
        }
        long l = this.lastMonthly;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"getLastMonthly", (long)l);
        }
        return l;
    }

    private void fetch() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetch", (String)"");
        }
        try {
            this.selectStmt = this.prepareStmt(FETCH);
            this.stmtType = 0;
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                this.colIndex = 1;
                this.lastWeekly = this.getTimestamp(this.resultSet);
                this.lastMonthly = this.getTimestamp(this.resultSet);
            } else {
                try {
                    this.lastWeekly = SQLUtil.getTimestamp(this.dbc).getTime();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (TraceLogger.enableTrace) {
                        Class<?> clazz;
                        try {
                            clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        TraceLogger.exception((String)clazz.getName(), (String)"fetch", (Throwable)exception);
                    }
                    return;
                }
                this.lastMonthly = this.lastWeekly;
                this.insertStmt = this.prepareStmt(INSERT);
                this.stmtType = 1;
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setTimestamp(this.insertStmt, this.lastWeekly, this.tsWeekly);
                this.setTimestamp(this.insertStmt, this.lastMonthly, this.tsMonthly);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
            }
            this.closeSelect();
            this.closeInsert();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetch", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetch");
        }
    }

    public void update(long l, long l2) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"lastWeekly, lastMonthly");
        }
        try {
            this.lastWeekly = l;
            this.lastMonthly = l2;
            this.updateStmt = this.prepareStmt(UPDATE);
            this.stmtType = 2;
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.updateStmt, l, this.tsWeekly);
            this.setTimestamp(this.updateStmt, l2, this.tsMonthly);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
            this.closeUpdate();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"update", (Throwable)sQLException);
            }
            this.sqlError(sQLException);
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TAggregator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update");
        }
    }
}

