/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;

public class TFoundComputer
extends RepositoryAccessor {
    private static final String SELECT_ALL = "SELECT found_computer_id, name, domain_name, ip_address, os_type, discovery_method, name_is_local, when_discovered, times_missing FROM t_found_computer";
    private static final String JOIN_NETWORK = "SELECT c.computer_id FROM t_found_computer f, t_res_host c WHERE f.found_computer_id = ? AND UPPER(c.network_name) = UPPER(f.name) AND (UPPER(c.domain_name) = UPPER(f.domain_name) OR c.ip_address = f.ip_address)";
    private static final String JOIN_WINDOWS = "SELECT c.computer_id FROM t_found_computer f, t_res_host c, t_stat_computer s, t_res_domain d WHERE f.found_computer_id = ? and UPPER(c.host_url) = UPPER(f.name) AND UPPER(d.name) = UPPER(f.domain_name) AND s.domain_id = d.domain_id AND s.computer_id = c.computer_id";
    private static final String INSERT = "INSERT INTO t_found_computer (found_computer_id, name, domain_name, ip_address, os_type, discovery_method, name_is_local, when_discovered, times_missing) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String UPDATE = "UPDATE t_found_computer SET ip_address = ?, os_type = ?, name_is_local = ?, times_missing = ? WHERE found_computer_id = ?";

    public TFoundComputer(Connection connection) {
        super(connection);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"TFoundComputer", (String)"dbc");
        }
        this.tableName = "T_FOUND_COMPUTER";
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"TFoundComputer");
        }
    }

    private void fetch(FoundComputer foundComputer) throws SQLException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetch", (String)"fc");
        }
        foundComputer.fcID = this.getInt(this.resultSet);
        foundComputer.fcName = this.getString(this.resultSet);
        foundComputer.fcDomain = this.getString(this.resultSet);
        foundComputer.fcIPAddress = this.getString(this.resultSet);
        foundComputer.fcOSType = this.getShort(this.resultSet);
        foundComputer.fcDiscoveryMethod = this.getShort(this.resultSet);
        foundComputer.fcNameIsLocal = this.getBoolean(this.resultSet);
        foundComputer.fcWhenDiscovered = this.getTimestamp(this.resultSet);
        foundComputer.fcTimesMissing = this.getShort(this.resultSet);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetch");
        }
    }

    private FoundComputer select(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"select", (String)"sqlText");
        }
        FoundComputer foundComputer = null;
        this.selectStmt = this.prepareStmt(string);
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                FoundComputer foundComputer2 = new FoundComputer();
                this.colIndex = 1;
                this.fetch(foundComputer2);
                foundComputer2.fcNext = foundComputer;
                foundComputer = foundComputer2;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"select", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeSelect();
        FoundComputer foundComputer3 = foundComputer;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"select", foundComputer3);
        }
        return foundComputer3;
    }

    public FoundComputer selectAll() throws GeneralException {
        return this.select(SELECT_ALL);
    }

    public FoundComputer selectByDomain(String string) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectByDomain", (String)"domain");
        }
        StringBuffer stringBuffer = new StringBuffer(SELECT_ALL);
        stringBuffer.append(" WHERE domain_name = '");
        stringBuffer.append(string);
        stringBuffer.append('\'');
        String string2 = stringBuffer.toString();
        stringBuffer = null;
        FoundComputer foundComputer = this.select(string2);
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectByDomain", (Object)foundComputer);
        }
        return foundComputer;
    }

    public void prepWindowsMatch() throws GeneralException {
        this.selectStmt = this.prepareStmt(JOIN_WINDOWS);
    }

    public void prepNetworkMatch() throws GeneralException {
        this.selectStmt = this.prepareStmt(JOIN_NETWORK);
    }

    public boolean selectMatch(int n) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"selectMatch", (String)"fcID");
        }
        boolean bl = false;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, n);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            bl = this.nextResult();
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"selectMatch", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        boolean bl2 = bl;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"selectMatch", (boolean)bl2);
        }
        return bl2;
    }

    public void prepSelectByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"prepSelectByID", (String)"");
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(SELECT_ALL);
        stringBuffer.append(" WHERE found_computer_id = ?");
        this.selectStmt = this.prepareStmt(stringBuffer.toString());
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"prepSelectByID");
        }
    }

    public void fetchByID(FoundComputer foundComputer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"fetchByID", (String)"fc");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, foundComputer.fcID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                this.fetch(foundComputer);
            } else {
                foundComputer.fcName = null;
                foundComputer.fcDomain = null;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"fetchByID", (Throwable)sQLException);
            }
            this.stmtType = 0;
            this.sqlError(sQLException);
        }
        this.closeResultSet();
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"fetchByID");
        }
    }

    public void insert(FoundComputer foundComputer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"insert", (String)"computers");
        }
        int n = 0;
        this.insertStmt = this.prepareStmt(INSERT);
        try {
            while (foundComputer != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.insertStmt, foundComputer.fcID);
                this.setString(this.insertStmt, foundComputer.fcName);
                this.setString(this.insertStmt, foundComputer.fcDomain);
                this.setString(this.insertStmt, foundComputer.fcIPAddress);
                this.setShort(this.insertStmt, foundComputer.fcOSType);
                this.setShort(this.insertStmt, foundComputer.fcDiscoveryMethod);
                this.setBoolean(this.insertStmt, foundComputer.fcNameIsLocal);
                this.setTimestamp(this.insertStmt, foundComputer.fcWhenDiscovered);
                this.setShort(this.insertStmt, foundComputer.fcTimesMissing);
                this.executeUpdate(this.insertStmt);
                if (++n >= 10) {
                    this.commit();
                    n = 0;
                }
                foundComputer = foundComputer.fcNext;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"insert", (Throwable)sQLException);
            }
            this.stmtType = 1;
            this.sqlError(sQLException);
        }
        this.closeInsert();
        if (n > 0) {
            this.stmtType = 1;
            this.commit();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"insert");
        }
    }

    public void update(FoundComputer foundComputer) throws GeneralException {
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"update", (String)"computers");
        }
        int n = 0;
        this.updateStmt = this.prepareStmt(UPDATE);
        try {
            while (foundComputer != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setString(this.updateStmt, foundComputer.fcIPAddress);
                this.setShort(this.updateStmt, foundComputer.fcOSType);
                this.setBoolean(this.updateStmt, foundComputer.fcNameIsLocal);
                this.setShort(this.updateStmt, foundComputer.fcTimesMissing);
                this.setInt(this.updateStmt, foundComputer.fcID);
                this.executeUpdate(this.updateStmt);
                if (++n >= 10) {
                    this.commit();
                    n = 0;
                }
                foundComputer = foundComputer.fcNext;
            }
        }
        catch (SQLException sQLException) {
            if (TraceLogger.enableTrace) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                TraceLogger.exception((String)clazz.getName(), (String)"update", (Throwable)sQLException);
            }
            this.stmtType = 2;
            this.sqlError(sQLException);
        }
        this.closeUpdate();
        if (n > 0) {
            this.stmtType = 2;
            this.commit();
        }
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"update");
        }
    }

    public static String canonicalName(FoundComputer foundComputer) {
        CharSequence charSequence;
        String string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.entry((String)clazz.getName(), (String)"canonicalName", (String)"fc");
        }
        if (Util.isEmpty((String)foundComputer.fcDomain)) {
            string = foundComputer.fcName;
        } else {
            charSequence = new StringBuffer(100);
            if (foundComputer.fcNameIsLocal) {
                ((StringBuffer)charSequence).append(foundComputer.fcDomain);
                ((StringBuffer)charSequence).append('\\');
                ((StringBuffer)charSequence).append(foundComputer.fcName);
            } else {
                ((StringBuffer)charSequence).append(foundComputer.fcName);
                ((StringBuffer)charSequence).append('.');
                ((StringBuffer)charSequence).append(foundComputer.fcDomain);
            }
            string = ((StringBuffer)charSequence).toString();
        }
        charSequence = string;
        if (TraceLogger.enableTrace) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.repository.table.TFoundComputer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            TraceLogger.exit((String)clazz.getName(), (String)"canonicalName", (Object)charSequence);
        }
        return charSequence;
    }
}

